/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a ListWorkspaces operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWorkspacesResponse extends AmpResponse implements
        ToCopyableBuilder<ListWorkspacesResponse.Builder, ListWorkspacesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListWorkspacesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<WorkspaceSummary>> WORKSPACES_FIELD = SdkField
            .<List<WorkspaceSummary>> builder(MarshallingType.LIST)
            .memberName("workspaces")
            .getter(getter(ListWorkspacesResponse::workspaces))
            .setter(setter(Builder::workspaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkspaceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkspaceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            WORKSPACES_FIELD));

    private final String nextToken;

    private final List<WorkspaceSummary> workspaces;

    private ListWorkspacesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.workspaces = builder.workspaces;
    }

    /**
     * <p>
     * Pagination token to use when requesting the next page in this list.
     * </p>
     * 
     * @return Pagination token to use when requesting the next page in this list.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Workspaces property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWorkspaces() {
        return workspaces != null && !(workspaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of existing workspaces, including those undergoing creation or deletion.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkspaces} method.
     * </p>
     * 
     * @return The list of existing workspaces, including those undergoing creation or deletion.
     */
    public final List<WorkspaceSummary> workspaces() {
        return workspaces;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkspaces() ? workspaces() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkspacesResponse)) {
            return false;
        }
        ListWorkspacesResponse other = (ListWorkspacesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasWorkspaces() == other.hasWorkspaces()
                && Objects.equals(workspaces(), other.workspaces());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWorkspacesResponse").add("NextToken", nextToken())
                .add("Workspaces", hasWorkspaces() ? workspaces() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "workspaces":
            return Optional.ofNullable(clazz.cast(workspaces()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkspacesResponse, T> g) {
        return obj -> g.apply((ListWorkspacesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmpResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListWorkspacesResponse> {
        /**
         * <p>
         * Pagination token to use when requesting the next page in this list.
         * </p>
         * 
         * @param nextToken
         *        Pagination token to use when requesting the next page in this list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of existing workspaces, including those undergoing creation or deletion.
         * </p>
         * 
         * @param workspaces
         *        The list of existing workspaces, including those undergoing creation or deletion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaces(Collection<WorkspaceSummary> workspaces);

        /**
         * <p>
         * The list of existing workspaces, including those undergoing creation or deletion.
         * </p>
         * 
         * @param workspaces
         *        The list of existing workspaces, including those undergoing creation or deletion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaces(WorkspaceSummary... workspaces);

        /**
         * <p>
         * The list of existing workspaces, including those undergoing creation or deletion.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<WorkspaceSummary>.Builder} avoiding
         * the need to create one manually via {@link List<WorkspaceSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<WorkspaceSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #workspaces(List<WorkspaceSummary>)}.
         * 
         * @param workspaces
         *        a consumer that will call methods on {@link List<WorkspaceSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workspaces(List<WorkspaceSummary>)
         */
        Builder workspaces(Consumer<WorkspaceSummary.Builder>... workspaces);
    }

    static final class BuilderImpl extends AmpResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<WorkspaceSummary> workspaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkspacesResponse model) {
            super(model);
            nextToken(model.nextToken);
            workspaces(model.workspaces);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<WorkspaceSummary.Builder> getWorkspaces() {
            List<WorkspaceSummary.Builder> result = WorkspaceSummaryListCopier.copyToBuilder(this.workspaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkspaces(Collection<WorkspaceSummary.BuilderImpl> workspaces) {
            this.workspaces = WorkspaceSummaryListCopier.copyFromBuilder(workspaces);
        }

        @Override
        public final Builder workspaces(Collection<WorkspaceSummary> workspaces) {
            this.workspaces = WorkspaceSummaryListCopier.copy(workspaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaces(WorkspaceSummary... workspaces) {
            workspaces(Arrays.asList(workspaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaces(Consumer<WorkspaceSummary.Builder>... workspaces) {
            workspaces(Stream.of(workspaces).map(c -> WorkspaceSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWorkspacesResponse build() {
            return new ListWorkspacesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
