/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the properties of an alert manager definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlertManagerDefinitionDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<AlertManagerDefinitionDescription.Builder, AlertManagerDefinitionDescription> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(AlertManagerDefinitionDescription::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<SdkBytes> DATA_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("data").getter(getter(AlertManagerDefinitionDescription::data)).setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedAt").getter(getter(AlertManagerDefinitionDescription::modifiedAt))
            .setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()).build();

    private static final SdkField<AlertManagerDefinitionStatus> STATUS_FIELD = SdkField
            .<AlertManagerDefinitionStatus> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(AlertManagerDefinitionDescription::status)).setter(setter(Builder::status))
            .constructor(AlertManagerDefinitionStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, DATA_FIELD,
            MODIFIED_AT_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final SdkBytes data;

    private final Instant modifiedAt;

    private final AlertManagerDefinitionStatus status;

    private AlertManagerDefinitionDescription(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.data = builder.data;
        this.modifiedAt = builder.modifiedAt;
        this.status = builder.status;
    }

    /**
     * <p>
     * The time when the alert manager definition was created.
     * </p>
     * 
     * @return The time when the alert manager definition was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The alert manager definition.
     * </p>
     * 
     * @return The alert manager definition.
     */
    public final SdkBytes data() {
        return data;
    }

    /**
     * <p>
     * The time when the alert manager definition was modified.
     * </p>
     * 
     * @return The time when the alert manager definition was modified.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * <p>
     * The status of alert manager definition.
     * </p>
     * 
     * @return The status of alert manager definition.
     */
    public final AlertManagerDefinitionStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(data());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlertManagerDefinitionDescription)) {
            return false;
        }
        AlertManagerDefinitionDescription other = (AlertManagerDefinitionDescription) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(data(), other.data())
                && Objects.equals(modifiedAt(), other.modifiedAt()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AlertManagerDefinitionDescription").add("CreatedAt", createdAt()).add("Data", data())
                .add("ModifiedAt", modifiedAt()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "data":
            return Optional.ofNullable(clazz.cast(data()));
        case "modifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlertManagerDefinitionDescription, T> g) {
        return obj -> g.apply((AlertManagerDefinitionDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AlertManagerDefinitionDescription> {
        /**
         * <p>
         * The time when the alert manager definition was created.
         * </p>
         * 
         * @param createdAt
         *        The time when the alert manager definition was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The alert manager definition.
         * </p>
         * 
         * @param data
         *        The alert manager definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(SdkBytes data);

        /**
         * <p>
         * The time when the alert manager definition was modified.
         * </p>
         * 
         * @param modifiedAt
         *        The time when the alert manager definition was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * <p>
         * The status of alert manager definition.
         * </p>
         * 
         * @param status
         *        The status of alert manager definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(AlertManagerDefinitionStatus status);

        /**
         * <p>
         * The status of alert manager definition.
         * </p>
         * This is a convenience method that creates an instance of the {@link AlertManagerDefinitionStatus.Builder}
         * avoiding the need to create one manually via {@link AlertManagerDefinitionStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link AlertManagerDefinitionStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #status(AlertManagerDefinitionStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link AlertManagerDefinitionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(AlertManagerDefinitionStatus)
         */
        default Builder status(Consumer<AlertManagerDefinitionStatus.Builder> status) {
            return status(AlertManagerDefinitionStatus.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private SdkBytes data;

        private Instant modifiedAt;

        private AlertManagerDefinitionStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(AlertManagerDefinitionDescription model) {
            createdAt(model.createdAt);
            data(model.data);
            modifiedAt(model.modifiedAt);
            status(model.status);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final ByteBuffer getData() {
            return data == null ? null : data.asByteBuffer();
        }

        public final void setData(ByteBuffer data) {
            data(data == null ? null : SdkBytes.fromByteBuffer(data));
        }

        @Override
        public final Builder data(SdkBytes data) {
            this.data = data;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final AlertManagerDefinitionStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(AlertManagerDefinitionStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(AlertManagerDefinitionStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public AlertManagerDefinitionDescription build() {
            return new AlertManagerDefinitionDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
