/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a summary of the properties of a workspace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkspaceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkspaceSummary.Builder, WorkspaceSummary> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("alias")
            .getter(getter(WorkspaceSummary::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(WorkspaceSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(WorkspaceSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<WorkspaceStatus> STATUS_FIELD = SdkField.<WorkspaceStatus> builder(MarshallingType.SDK_POJO)
            .memberName("status").getter(getter(WorkspaceSummary::status)).setter(setter(Builder::status))
            .constructor(WorkspaceStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(WorkspaceSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(WorkspaceSummary::workspaceId)).setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD, ARN_FIELD,
            CREATED_AT_FIELD, STATUS_FIELD, TAGS_FIELD, WORKSPACE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String alias;

    private final String arn;

    private final Instant createdAt;

    private final WorkspaceStatus status;

    private final Map<String, String> tags;

    private final String workspaceId;

    private WorkspaceSummary(BuilderImpl builder) {
        this.alias = builder.alias;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
        this.tags = builder.tags;
        this.workspaceId = builder.workspaceId;
    }

    /**
     * <p>
     * Alias of this workspace.
     * </p>
     * 
     * @return Alias of this workspace.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The AmazonResourceName of this workspace.
     * </p>
     * 
     * @return The AmazonResourceName of this workspace.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The time when the workspace was created.
     * </p>
     * 
     * @return The time when the workspace was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The status of this workspace.
     * </p>
     * 
     * @return The status of this workspace.
     */
    public final WorkspaceStatus status() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags of this workspace.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags of this workspace.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Unique string identifying this workspace.
     * </p>
     * 
     * @return Unique string identifying this workspace.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceSummary)) {
            return false;
        }
        WorkspaceSummary other = (WorkspaceSummary) obj;
        return Objects.equals(alias(), other.alias()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(status(), other.status())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(workspaceId(), other.workspaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkspaceSummary").add("Alias", alias()).add("Arn", arn()).add("CreatedAt", createdAt())
                .add("Status", status()).add("Tags", hasTags() ? tags() : null).add("WorkspaceId", workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceSummary, T> g) {
        return obj -> g.apply((WorkspaceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkspaceSummary> {
        /**
         * <p>
         * Alias of this workspace.
         * </p>
         * 
         * @param alias
         *        Alias of this workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The AmazonResourceName of this workspace.
         * </p>
         * 
         * @param arn
         *        The AmazonResourceName of this workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time when the workspace was created.
         * </p>
         * 
         * @param createdAt
         *        The time when the workspace was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The status of this workspace.
         * </p>
         * 
         * @param status
         *        The status of this workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(WorkspaceStatus status);

        /**
         * <p>
         * The status of this workspace.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkspaceStatus.Builder} avoiding the need to
         * create one manually via {@link WorkspaceStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkspaceStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(WorkspaceStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link WorkspaceStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(WorkspaceStatus)
         */
        default Builder status(Consumer<WorkspaceStatus.Builder> status) {
            return status(WorkspaceStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The tags of this workspace.
         * </p>
         * 
         * @param tags
         *        The tags of this workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Unique string identifying this workspace.
         * </p>
         * 
         * @param workspaceId
         *        Unique string identifying this workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);
    }

    static final class BuilderImpl implements Builder {
        private String alias;

        private String arn;

        private Instant createdAt;

        private WorkspaceStatus status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceSummary model) {
            alias(model.alias);
            arn(model.arn);
            createdAt(model.createdAt);
            status(model.status);
            tags(model.tags);
            workspaceId(model.workspaceId);
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        @Transient
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final WorkspaceStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(WorkspaceStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        @Transient
        public final Builder status(WorkspaceStatus status) {
            this.status = status;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        @Transient
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public WorkspaceSummary build() {
            return new WorkspaceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
