/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the status of a workspace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkspaceStatus implements SdkPojo, Serializable, ToCopyableBuilder<WorkspaceStatus.Builder, WorkspaceStatus> {
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusCode").getter(getter(WorkspaceStatus::statusCodeAsString)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String statusCodeValue;

    private WorkspaceStatus(BuilderImpl builder) {
        this.statusCodeValue = builder.statusCodeValue;
    }

    /**
     * <p>
     * Status code of this workspace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link WorkspaceStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return Status code of this workspace.
     * @see WorkspaceStatusCode
     */
    public final WorkspaceStatusCode statusCode() {
        return WorkspaceStatusCode.fromValue(statusCodeValue);
    }

    /**
     * <p>
     * Status code of this workspace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link WorkspaceStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return Status code of this workspace.
     * @see WorkspaceStatusCode
     */
    public final String statusCodeAsString() {
        return statusCodeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusCodeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceStatus)) {
            return false;
        }
        WorkspaceStatus other = (WorkspaceStatus) obj;
        return Objects.equals(statusCodeAsString(), other.statusCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkspaceStatus").add("StatusCode", statusCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceStatus, T> g) {
        return obj -> g.apply((WorkspaceStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkspaceStatus> {
        /**
         * <p>
         * Status code of this workspace.
         * </p>
         * 
         * @param statusCodeValue
         *        Status code of this workspace.
         * @see WorkspaceStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspaceStatusCode
         */
        Builder statusCode(String statusCodeValue);

        /**
         * <p>
         * Status code of this workspace.
         * </p>
         * 
         * @param statusCodeValue
         *        Status code of this workspace.
         * @see WorkspaceStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspaceStatusCode
         */
        Builder statusCode(WorkspaceStatusCode statusCodeValue);
    }

    static final class BuilderImpl implements Builder {
        private String statusCodeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceStatus model) {
            statusCode(model.statusCodeValue);
        }

        public final String getStatusCode() {
            return statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        @Transient
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        @Override
        @Transient
        public final Builder statusCode(WorkspaceStatusCode statusCodeValue) {
            this.statusCode(statusCodeValue == null ? null : statusCodeValue.toString());
            return this;
        }

        @Override
        public WorkspaceStatus build() {
            return new WorkspaceStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
