/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.amp.model.CreateAlertManagerDefinitionRequest;
import software.amazon.awssdk.services.amp.model.CreateAlertManagerDefinitionResponse;
import software.amazon.awssdk.services.amp.model.CreateLoggingConfigurationRequest;
import software.amazon.awssdk.services.amp.model.CreateLoggingConfigurationResponse;
import software.amazon.awssdk.services.amp.model.CreateRuleGroupsNamespaceRequest;
import software.amazon.awssdk.services.amp.model.CreateRuleGroupsNamespaceResponse;
import software.amazon.awssdk.services.amp.model.CreateWorkspaceRequest;
import software.amazon.awssdk.services.amp.model.CreateWorkspaceResponse;
import software.amazon.awssdk.services.amp.model.DeleteAlertManagerDefinitionRequest;
import software.amazon.awssdk.services.amp.model.DeleteAlertManagerDefinitionResponse;
import software.amazon.awssdk.services.amp.model.DeleteLoggingConfigurationRequest;
import software.amazon.awssdk.services.amp.model.DeleteLoggingConfigurationResponse;
import software.amazon.awssdk.services.amp.model.DeleteRuleGroupsNamespaceRequest;
import software.amazon.awssdk.services.amp.model.DeleteRuleGroupsNamespaceResponse;
import software.amazon.awssdk.services.amp.model.DeleteWorkspaceRequest;
import software.amazon.awssdk.services.amp.model.DeleteWorkspaceResponse;
import software.amazon.awssdk.services.amp.model.DescribeAlertManagerDefinitionRequest;
import software.amazon.awssdk.services.amp.model.DescribeAlertManagerDefinitionResponse;
import software.amazon.awssdk.services.amp.model.DescribeLoggingConfigurationRequest;
import software.amazon.awssdk.services.amp.model.DescribeLoggingConfigurationResponse;
import software.amazon.awssdk.services.amp.model.DescribeRuleGroupsNamespaceRequest;
import software.amazon.awssdk.services.amp.model.DescribeRuleGroupsNamespaceResponse;
import software.amazon.awssdk.services.amp.model.DescribeWorkspaceRequest;
import software.amazon.awssdk.services.amp.model.DescribeWorkspaceResponse;
import software.amazon.awssdk.services.amp.model.ListRuleGroupsNamespacesRequest;
import software.amazon.awssdk.services.amp.model.ListRuleGroupsNamespacesResponse;
import software.amazon.awssdk.services.amp.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.amp.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.amp.model.ListWorkspacesRequest;
import software.amazon.awssdk.services.amp.model.ListWorkspacesResponse;
import software.amazon.awssdk.services.amp.model.PutAlertManagerDefinitionRequest;
import software.amazon.awssdk.services.amp.model.PutAlertManagerDefinitionResponse;
import software.amazon.awssdk.services.amp.model.PutRuleGroupsNamespaceRequest;
import software.amazon.awssdk.services.amp.model.PutRuleGroupsNamespaceResponse;
import software.amazon.awssdk.services.amp.model.TagResourceRequest;
import software.amazon.awssdk.services.amp.model.TagResourceResponse;
import software.amazon.awssdk.services.amp.model.UntagResourceRequest;
import software.amazon.awssdk.services.amp.model.UntagResourceResponse;
import software.amazon.awssdk.services.amp.model.UpdateLoggingConfigurationRequest;
import software.amazon.awssdk.services.amp.model.UpdateLoggingConfigurationResponse;
import software.amazon.awssdk.services.amp.model.UpdateWorkspaceAliasRequest;
import software.amazon.awssdk.services.amp.model.UpdateWorkspaceAliasResponse;
import software.amazon.awssdk.services.amp.paginators.ListRuleGroupsNamespacesPublisher;
import software.amazon.awssdk.services.amp.paginators.ListWorkspacesPublisher;
import software.amazon.awssdk.services.amp.waiters.AmpAsyncWaiter;

/**
 * Service client for accessing Amazon Prometheus Service asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Amazon Managed Service for Prometheus
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AmpAsyncClient extends SdkClient {
    String SERVICE_NAME = "aps";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "aps";

    /**
     * Create a {@link AmpAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AmpAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AmpAsyncClient}.
     */
    static AmpAsyncClientBuilder builder() {
        return new DefaultAmpAsyncClientBuilder();
    }

    /**
     * <p>
     * Create an alert manager definition.
     * </p>
     *
     * @param createAlertManagerDefinitionRequest
     *        Represents the input of a CreateAlertManagerDefinition operation.
     * @return A Java Future containing the result of the CreateAlertManagerDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.CreateAlertManagerDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/CreateAlertManagerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAlertManagerDefinitionResponse> createAlertManagerDefinition(
            CreateAlertManagerDefinitionRequest createAlertManagerDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an alert manager definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAlertManagerDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateAlertManagerDefinitionRequest#builder()}
     * </p>
     *
     * @param createAlertManagerDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link CreateAlertManagerDefinitionRequest.Builder} to create
     *        a request. Represents the input of a CreateAlertManagerDefinition operation.
     * @return A Java Future containing the result of the CreateAlertManagerDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.CreateAlertManagerDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/CreateAlertManagerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAlertManagerDefinitionResponse> createAlertManagerDefinition(
            Consumer<CreateAlertManagerDefinitionRequest.Builder> createAlertManagerDefinitionRequest) {
        return createAlertManagerDefinition(CreateAlertManagerDefinitionRequest.builder()
                .applyMutation(createAlertManagerDefinitionRequest).build());
    }

    /**
     * <p>
     * Create logging configuration.
     * </p>
     *
     * @param createLoggingConfigurationRequest
     *        Represents the input of a CreateLoggingConfiguration operation.
     * @return A Java Future containing the result of the CreateLoggingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.CreateLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/CreateLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLoggingConfigurationResponse> createLoggingConfiguration(
            CreateLoggingConfigurationRequest createLoggingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create logging configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLoggingConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param createLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateLoggingConfigurationRequest.Builder} to create a
     *        request. Represents the input of a CreateLoggingConfiguration operation.
     * @return A Java Future containing the result of the CreateLoggingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.CreateLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/CreateLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLoggingConfigurationResponse> createLoggingConfiguration(
            Consumer<CreateLoggingConfigurationRequest.Builder> createLoggingConfigurationRequest) {
        return createLoggingConfiguration(CreateLoggingConfigurationRequest.builder()
                .applyMutation(createLoggingConfigurationRequest).build());
    }

    /**
     * <p>
     * Create a rule group namespace.
     * </p>
     *
     * @param createRuleGroupsNamespaceRequest
     *        Represents the input of a CreateRuleGroupsNamespace operation.
     * @return A Java Future containing the result of the CreateRuleGroupsNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.CreateRuleGroupsNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/CreateRuleGroupsNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateRuleGroupsNamespaceResponse> createRuleGroupsNamespace(
            CreateRuleGroupsNamespaceRequest createRuleGroupsNamespaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a rule group namespace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRuleGroupsNamespaceRequest.Builder} avoiding
     * the need to create one manually via {@link CreateRuleGroupsNamespaceRequest#builder()}
     * </p>
     *
     * @param createRuleGroupsNamespaceRequest
     *        A {@link Consumer} that will call methods on {@link CreateRuleGroupsNamespaceRequest.Builder} to create a
     *        request. Represents the input of a CreateRuleGroupsNamespace operation.
     * @return A Java Future containing the result of the CreateRuleGroupsNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.CreateRuleGroupsNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/CreateRuleGroupsNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateRuleGroupsNamespaceResponse> createRuleGroupsNamespace(
            Consumer<CreateRuleGroupsNamespaceRequest.Builder> createRuleGroupsNamespaceRequest) {
        return createRuleGroupsNamespace(CreateRuleGroupsNamespaceRequest.builder()
                .applyMutation(createRuleGroupsNamespaceRequest).build());
    }

    /**
     * <p>
     * Creates a new AMP workspace.
     * </p>
     *
     * @param createWorkspaceRequest
     *        Represents the input of a CreateWorkspace operation.
     * @return A Java Future containing the result of the CreateWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.CreateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/CreateWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWorkspaceResponse> createWorkspace(CreateWorkspaceRequest createWorkspaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new AMP workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkspaceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateWorkspaceRequest#builder()}
     * </p>
     *
     * @param createWorkspaceRequest
     *        A {@link Consumer} that will call methods on {@link CreateWorkspaceRequest.Builder} to create a request.
     *        Represents the input of a CreateWorkspace operation.
     * @return A Java Future containing the result of the CreateWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.CreateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/CreateWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWorkspaceResponse> createWorkspace(
            Consumer<CreateWorkspaceRequest.Builder> createWorkspaceRequest) {
        return createWorkspace(CreateWorkspaceRequest.builder().applyMutation(createWorkspaceRequest).build());
    }

    /**
     * <p>
     * Deletes an alert manager definition.
     * </p>
     *
     * @param deleteAlertManagerDefinitionRequest
     *        Represents the input of a DeleteAlertManagerDefinition operation.
     * @return A Java Future containing the result of the DeleteAlertManagerDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.DeleteAlertManagerDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DeleteAlertManagerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAlertManagerDefinitionResponse> deleteAlertManagerDefinition(
            DeleteAlertManagerDefinitionRequest deleteAlertManagerDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an alert manager definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAlertManagerDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAlertManagerDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteAlertManagerDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAlertManagerDefinitionRequest.Builder} to create
     *        a request. Represents the input of a DeleteAlertManagerDefinition operation.
     * @return A Java Future containing the result of the DeleteAlertManagerDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.DeleteAlertManagerDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DeleteAlertManagerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAlertManagerDefinitionResponse> deleteAlertManagerDefinition(
            Consumer<DeleteAlertManagerDefinitionRequest.Builder> deleteAlertManagerDefinitionRequest) {
        return deleteAlertManagerDefinition(DeleteAlertManagerDefinitionRequest.builder()
                .applyMutation(deleteAlertManagerDefinitionRequest).build());
    }

    /**
     * <p>
     * Delete logging configuration.
     * </p>
     *
     * @param deleteLoggingConfigurationRequest
     *        Represents the input of a DeleteLoggingConfiguration operation.
     * @return A Java Future containing the result of the DeleteLoggingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.DeleteLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DeleteLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLoggingConfigurationResponse> deleteLoggingConfiguration(
            DeleteLoggingConfigurationRequest deleteLoggingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete logging configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLoggingConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLoggingConfigurationRequest.Builder} to create a
     *        request. Represents the input of a DeleteLoggingConfiguration operation.
     * @return A Java Future containing the result of the DeleteLoggingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.DeleteLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DeleteLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLoggingConfigurationResponse> deleteLoggingConfiguration(
            Consumer<DeleteLoggingConfigurationRequest.Builder> deleteLoggingConfigurationRequest) {
        return deleteLoggingConfiguration(DeleteLoggingConfigurationRequest.builder()
                .applyMutation(deleteLoggingConfigurationRequest).build());
    }

    /**
     * <p>
     * Delete a rule groups namespace.
     * </p>
     *
     * @param deleteRuleGroupsNamespaceRequest
     *        Represents the input of a DeleteRuleGroupsNamespace operation.
     * @return A Java Future containing the result of the DeleteRuleGroupsNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.DeleteRuleGroupsNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DeleteRuleGroupsNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteRuleGroupsNamespaceResponse> deleteRuleGroupsNamespace(
            DeleteRuleGroupsNamespaceRequest deleteRuleGroupsNamespaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a rule groups namespace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRuleGroupsNamespaceRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteRuleGroupsNamespaceRequest#builder()}
     * </p>
     *
     * @param deleteRuleGroupsNamespaceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRuleGroupsNamespaceRequest.Builder} to create a
     *        request. Represents the input of a DeleteRuleGroupsNamespace operation.
     * @return A Java Future containing the result of the DeleteRuleGroupsNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.DeleteRuleGroupsNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DeleteRuleGroupsNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteRuleGroupsNamespaceResponse> deleteRuleGroupsNamespace(
            Consumer<DeleteRuleGroupsNamespaceRequest.Builder> deleteRuleGroupsNamespaceRequest) {
        return deleteRuleGroupsNamespace(DeleteRuleGroupsNamespaceRequest.builder()
                .applyMutation(deleteRuleGroupsNamespaceRequest).build());
    }

    /**
     * <p>
     * Deletes an AMP workspace.
     * </p>
     *
     * @param deleteWorkspaceRequest
     *        Represents the input of a DeleteWorkspace operation.
     * @return A Java Future containing the result of the DeleteWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.DeleteWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DeleteWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWorkspaceResponse> deleteWorkspace(DeleteWorkspaceRequest deleteWorkspaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an AMP workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkspaceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteWorkspaceRequest#builder()}
     * </p>
     *
     * @param deleteWorkspaceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWorkspaceRequest.Builder} to create a request.
     *        Represents the input of a DeleteWorkspace operation.
     * @return A Java Future containing the result of the DeleteWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.DeleteWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DeleteWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWorkspaceResponse> deleteWorkspace(
            Consumer<DeleteWorkspaceRequest.Builder> deleteWorkspaceRequest) {
        return deleteWorkspace(DeleteWorkspaceRequest.builder().applyMutation(deleteWorkspaceRequest).build());
    }

    /**
     * <p>
     * Describes an alert manager definition.
     * </p>
     *
     * @param describeAlertManagerDefinitionRequest
     *        Represents the input of a DescribeAlertManagerDefinition operation.
     * @return A Java Future containing the result of the DescribeAlertManagerDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.DescribeAlertManagerDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DescribeAlertManagerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAlertManagerDefinitionResponse> describeAlertManagerDefinition(
            DescribeAlertManagerDefinitionRequest describeAlertManagerDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an alert manager definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAlertManagerDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAlertManagerDefinitionRequest#builder()}
     * </p>
     *
     * @param describeAlertManagerDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAlertManagerDefinitionRequest.Builder} to
     *        create a request. Represents the input of a DescribeAlertManagerDefinition operation.
     * @return A Java Future containing the result of the DescribeAlertManagerDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.DescribeAlertManagerDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DescribeAlertManagerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAlertManagerDefinitionResponse> describeAlertManagerDefinition(
            Consumer<DescribeAlertManagerDefinitionRequest.Builder> describeAlertManagerDefinitionRequest) {
        return describeAlertManagerDefinition(DescribeAlertManagerDefinitionRequest.builder()
                .applyMutation(describeAlertManagerDefinitionRequest).build());
    }

    /**
     * <p>
     * Describes logging configuration.
     * </p>
     *
     * @param describeLoggingConfigurationRequest
     *        Represents the input of a DescribeLoggingConfiguration operation.
     * @return A Java Future containing the result of the DescribeLoggingConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.DescribeLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DescribeLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLoggingConfigurationResponse> describeLoggingConfiguration(
            DescribeLoggingConfigurationRequest describeLoggingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes logging configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoggingConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param describeLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeLoggingConfigurationRequest.Builder} to create
     *        a request. Represents the input of a DescribeLoggingConfiguration operation.
     * @return A Java Future containing the result of the DescribeLoggingConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.DescribeLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DescribeLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLoggingConfigurationResponse> describeLoggingConfiguration(
            Consumer<DescribeLoggingConfigurationRequest.Builder> describeLoggingConfigurationRequest) {
        return describeLoggingConfiguration(DescribeLoggingConfigurationRequest.builder()
                .applyMutation(describeLoggingConfigurationRequest).build());
    }

    /**
     * <p>
     * Describe a rule groups namespace.
     * </p>
     *
     * @param describeRuleGroupsNamespaceRequest
     *        Represents the input of a DescribeRuleGroupsNamespace operation.
     * @return A Java Future containing the result of the DescribeRuleGroupsNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.DescribeRuleGroupsNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DescribeRuleGroupsNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRuleGroupsNamespaceResponse> describeRuleGroupsNamespace(
            DescribeRuleGroupsNamespaceRequest describeRuleGroupsNamespaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe a rule groups namespace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRuleGroupsNamespaceRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRuleGroupsNamespaceRequest#builder()}
     * </p>
     *
     * @param describeRuleGroupsNamespaceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRuleGroupsNamespaceRequest.Builder} to create
     *        a request. Represents the input of a DescribeRuleGroupsNamespace operation.
     * @return A Java Future containing the result of the DescribeRuleGroupsNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.DescribeRuleGroupsNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DescribeRuleGroupsNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRuleGroupsNamespaceResponse> describeRuleGroupsNamespace(
            Consumer<DescribeRuleGroupsNamespaceRequest.Builder> describeRuleGroupsNamespaceRequest) {
        return describeRuleGroupsNamespace(DescribeRuleGroupsNamespaceRequest.builder()
                .applyMutation(describeRuleGroupsNamespaceRequest).build());
    }

    /**
     * <p>
     * Describes an existing AMP workspace.
     * </p>
     *
     * @param describeWorkspaceRequest
     *        Represents the input of a DescribeWorkspace operation.
     * @return A Java Future containing the result of the DescribeWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.DescribeWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DescribeWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeWorkspaceResponse> describeWorkspace(DescribeWorkspaceRequest describeWorkspaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an existing AMP workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeWorkspaceRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorkspaceRequest.Builder} to create a request.
     *        Represents the input of a DescribeWorkspace operation.
     * @return A Java Future containing the result of the DescribeWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.DescribeWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DescribeWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeWorkspaceResponse> describeWorkspace(
            Consumer<DescribeWorkspaceRequest.Builder> describeWorkspaceRequest) {
        return describeWorkspace(DescribeWorkspaceRequest.builder().applyMutation(describeWorkspaceRequest).build());
    }

    /**
     * <p>
     * Lists rule groups namespaces.
     * </p>
     *
     * @param listRuleGroupsNamespacesRequest
     *        Represents the input of a ListRuleGroupsNamespaces operation.
     * @return A Java Future containing the result of the ListRuleGroupsNamespaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.ListRuleGroupsNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/ListRuleGroupsNamespaces" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListRuleGroupsNamespacesResponse> listRuleGroupsNamespaces(
            ListRuleGroupsNamespacesRequest listRuleGroupsNamespacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists rule groups namespaces.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRuleGroupsNamespacesRequest.Builder} avoiding
     * the need to create one manually via {@link ListRuleGroupsNamespacesRequest#builder()}
     * </p>
     *
     * @param listRuleGroupsNamespacesRequest
     *        A {@link Consumer} that will call methods on {@link ListRuleGroupsNamespacesRequest.Builder} to create a
     *        request. Represents the input of a ListRuleGroupsNamespaces operation.
     * @return A Java Future containing the result of the ListRuleGroupsNamespaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.ListRuleGroupsNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/ListRuleGroupsNamespaces" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListRuleGroupsNamespacesResponse> listRuleGroupsNamespaces(
            Consumer<ListRuleGroupsNamespacesRequest.Builder> listRuleGroupsNamespacesRequest) {
        return listRuleGroupsNamespaces(ListRuleGroupsNamespacesRequest.builder().applyMutation(listRuleGroupsNamespacesRequest)
                .build());
    }

    /**
     * <p>
     * Lists rule groups namespaces.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRuleGroupsNamespaces(software.amazon.awssdk.services.amp.model.ListRuleGroupsNamespacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amp.paginators.ListRuleGroupsNamespacesPublisher publisher = client.listRuleGroupsNamespacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amp.paginators.ListRuleGroupsNamespacesPublisher publisher = client.listRuleGroupsNamespacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.amp.model.ListRuleGroupsNamespacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.amp.model.ListRuleGroupsNamespacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRuleGroupsNamespaces(software.amazon.awssdk.services.amp.model.ListRuleGroupsNamespacesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRuleGroupsNamespacesRequest
     *        Represents the input of a ListRuleGroupsNamespaces operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.ListRuleGroupsNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/ListRuleGroupsNamespaces" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRuleGroupsNamespacesPublisher listRuleGroupsNamespacesPaginator(
            ListRuleGroupsNamespacesRequest listRuleGroupsNamespacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists rule groups namespaces.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRuleGroupsNamespaces(software.amazon.awssdk.services.amp.model.ListRuleGroupsNamespacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amp.paginators.ListRuleGroupsNamespacesPublisher publisher = client.listRuleGroupsNamespacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amp.paginators.ListRuleGroupsNamespacesPublisher publisher = client.listRuleGroupsNamespacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.amp.model.ListRuleGroupsNamespacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.amp.model.ListRuleGroupsNamespacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRuleGroupsNamespaces(software.amazon.awssdk.services.amp.model.ListRuleGroupsNamespacesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRuleGroupsNamespacesRequest.Builder} avoiding
     * the need to create one manually via {@link ListRuleGroupsNamespacesRequest#builder()}
     * </p>
     *
     * @param listRuleGroupsNamespacesRequest
     *        A {@link Consumer} that will call methods on {@link ListRuleGroupsNamespacesRequest.Builder} to create a
     *        request. Represents the input of a ListRuleGroupsNamespaces operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.ListRuleGroupsNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/ListRuleGroupsNamespaces" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRuleGroupsNamespacesPublisher listRuleGroupsNamespacesPaginator(
            Consumer<ListRuleGroupsNamespacesRequest.Builder> listRuleGroupsNamespacesRequest) {
        return listRuleGroupsNamespacesPaginator(ListRuleGroupsNamespacesRequest.builder()
                .applyMutation(listRuleGroupsNamespacesRequest).build());
    }

    /**
     * <p>
     * Lists the tags you have assigned to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags you have assigned to the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists all AMP workspaces, including workspaces being created or deleted.
     * </p>
     *
     * @param listWorkspacesRequest
     *        Represents the input of a ListWorkspaces operation.
     * @return A Java Future containing the result of the ListWorkspaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.ListWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/ListWorkspaces" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWorkspacesResponse> listWorkspaces(ListWorkspacesRequest listWorkspacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all AMP workspaces, including workspaces being created or deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkspacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkspacesRequest#builder()}
     * </p>
     *
     * @param listWorkspacesRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkspacesRequest.Builder} to create a request.
     *        Represents the input of a ListWorkspaces operation.
     * @return A Java Future containing the result of the ListWorkspaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.ListWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/ListWorkspaces" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWorkspacesResponse> listWorkspaces(Consumer<ListWorkspacesRequest.Builder> listWorkspacesRequest) {
        return listWorkspaces(ListWorkspacesRequest.builder().applyMutation(listWorkspacesRequest).build());
    }

    /**
     * <p>
     * Lists all AMP workspaces, including workspaces being created or deleted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listWorkspaces(software.amazon.awssdk.services.amp.model.ListWorkspacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amp.paginators.ListWorkspacesPublisher publisher = client.listWorkspacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amp.paginators.ListWorkspacesPublisher publisher = client.listWorkspacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.amp.model.ListWorkspacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.amp.model.ListWorkspacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkspaces(software.amazon.awssdk.services.amp.model.ListWorkspacesRequest)} operation.</b>
     * </p>
     *
     * @param listWorkspacesRequest
     *        Represents the input of a ListWorkspaces operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.ListWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/ListWorkspaces" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkspacesPublisher listWorkspacesPaginator(ListWorkspacesRequest listWorkspacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all AMP workspaces, including workspaces being created or deleted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listWorkspaces(software.amazon.awssdk.services.amp.model.ListWorkspacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amp.paginators.ListWorkspacesPublisher publisher = client.listWorkspacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amp.paginators.ListWorkspacesPublisher publisher = client.listWorkspacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.amp.model.ListWorkspacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.amp.model.ListWorkspacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkspaces(software.amazon.awssdk.services.amp.model.ListWorkspacesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkspacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkspacesRequest#builder()}
     * </p>
     *
     * @param listWorkspacesRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkspacesRequest.Builder} to create a request.
     *        Represents the input of a ListWorkspaces operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.ListWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/ListWorkspaces" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkspacesPublisher listWorkspacesPaginator(Consumer<ListWorkspacesRequest.Builder> listWorkspacesRequest) {
        return listWorkspacesPaginator(ListWorkspacesRequest.builder().applyMutation(listWorkspacesRequest).build());
    }

    /**
     * <p>
     * Update an alert manager definition.
     * </p>
     *
     * @param putAlertManagerDefinitionRequest
     *        Represents the input of a PutAlertManagerDefinition operation.
     * @return A Java Future containing the result of the PutAlertManagerDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.PutAlertManagerDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/PutAlertManagerDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutAlertManagerDefinitionResponse> putAlertManagerDefinition(
            PutAlertManagerDefinitionRequest putAlertManagerDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an alert manager definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAlertManagerDefinitionRequest.Builder} avoiding
     * the need to create one manually via {@link PutAlertManagerDefinitionRequest#builder()}
     * </p>
     *
     * @param putAlertManagerDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link PutAlertManagerDefinitionRequest.Builder} to create a
     *        request. Represents the input of a PutAlertManagerDefinition operation.
     * @return A Java Future containing the result of the PutAlertManagerDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.PutAlertManagerDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/PutAlertManagerDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutAlertManagerDefinitionResponse> putAlertManagerDefinition(
            Consumer<PutAlertManagerDefinitionRequest.Builder> putAlertManagerDefinitionRequest) {
        return putAlertManagerDefinition(PutAlertManagerDefinitionRequest.builder()
                .applyMutation(putAlertManagerDefinitionRequest).build());
    }

    /**
     * <p>
     * Update a rule groups namespace.
     * </p>
     *
     * @param putRuleGroupsNamespaceRequest
     *        Represents the input of a PutRuleGroupsNamespace operation.
     * @return A Java Future containing the result of the PutRuleGroupsNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.PutRuleGroupsNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/PutRuleGroupsNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutRuleGroupsNamespaceResponse> putRuleGroupsNamespace(
            PutRuleGroupsNamespaceRequest putRuleGroupsNamespaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a rule groups namespace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRuleGroupsNamespaceRequest.Builder} avoiding the
     * need to create one manually via {@link PutRuleGroupsNamespaceRequest#builder()}
     * </p>
     *
     * @param putRuleGroupsNamespaceRequest
     *        A {@link Consumer} that will call methods on {@link PutRuleGroupsNamespaceRequest.Builder} to create a
     *        request. Represents the input of a PutRuleGroupsNamespace operation.
     * @return A Java Future containing the result of the PutRuleGroupsNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.PutRuleGroupsNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/PutRuleGroupsNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutRuleGroupsNamespaceResponse> putRuleGroupsNamespace(
            Consumer<PutRuleGroupsNamespaceRequest.Builder> putRuleGroupsNamespaceRequest) {
        return putRuleGroupsNamespace(PutRuleGroupsNamespaceRequest.builder().applyMutation(putRuleGroupsNamespaceRequest)
                .build());
    }

    /**
     * <p>
     * Creates tags for the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Deletes tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Update logging configuration.
     * </p>
     *
     * @param updateLoggingConfigurationRequest
     *        Represents the input of an UpdateLoggingConfiguration operation.
     * @return A Java Future containing the result of the UpdateLoggingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.UpdateLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/UpdateLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLoggingConfigurationResponse> updateLoggingConfiguration(
            UpdateLoggingConfigurationRequest updateLoggingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update logging configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLoggingConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param updateLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLoggingConfigurationRequest.Builder} to create a
     *        request. Represents the input of an UpdateLoggingConfiguration operation.
     * @return A Java Future containing the result of the UpdateLoggingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.UpdateLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/UpdateLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLoggingConfigurationResponse> updateLoggingConfiguration(
            Consumer<UpdateLoggingConfigurationRequest.Builder> updateLoggingConfigurationRequest) {
        return updateLoggingConfiguration(UpdateLoggingConfigurationRequest.builder()
                .applyMutation(updateLoggingConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates an AMP workspace alias.
     * </p>
     *
     * @param updateWorkspaceAliasRequest
     *        Represents the input of an UpdateWorkspaceAlias operation.
     * @return A Java Future containing the result of the UpdateWorkspaceAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.UpdateWorkspaceAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/UpdateWorkspaceAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateWorkspaceAliasResponse> updateWorkspaceAlias(
            UpdateWorkspaceAliasRequest updateWorkspaceAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an AMP workspace alias.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkspaceAliasRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateWorkspaceAliasRequest#builder()}
     * </p>
     *
     * @param updateWorkspaceAliasRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWorkspaceAliasRequest.Builder} to create a
     *        request. Represents the input of an UpdateWorkspaceAlias operation.
     * @return A Java Future containing the result of the UpdateWorkspaceAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmpException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample AmpAsyncClient.UpdateWorkspaceAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/UpdateWorkspaceAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateWorkspaceAliasResponse> updateWorkspaceAlias(
            Consumer<UpdateWorkspaceAliasRequest.Builder> updateWorkspaceAliasRequest) {
        return updateWorkspaceAlias(UpdateWorkspaceAliasRequest.builder().applyMutation(updateWorkspaceAliasRequest).build());
    }

    /**
     * Create an instance of {@link AmpAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link AmpAsyncWaiter}
     */
    default AmpAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }
}
