/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a ListScrapers operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListScrapersResponse extends AmpResponse implements
        ToCopyableBuilder<ListScrapersResponse.Builder, ListScrapersResponse> {
    private static final SdkField<List<ScraperSummary>> SCRAPERS_FIELD = SdkField
            .<List<ScraperSummary>> builder(MarshallingType.LIST)
            .memberName("scrapers")
            .getter(getter(ListScrapersResponse::scrapers))
            .setter(setter(Builder::scrapers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scrapers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScraperSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScraperSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListScrapersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCRAPERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ScraperSummary> scrapers;

    private final String nextToken;

    private ListScrapersResponse(BuilderImpl builder) {
        super(builder);
        this.scrapers = builder.scrapers;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Scrapers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasScrapers() {
        return scrapers != null && !(scrapers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of scrapers, filtered down if a set of filters was provided in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScrapers} method.
     * </p>
     * 
     * @return The list of scrapers, filtered down if a set of filters was provided in the request.
     */
    public final List<ScraperSummary> scrapers() {
        return scrapers;
    }

    /**
     * <p>
     * Pagination token to use when requesting the next page in this list.
     * </p>
     * 
     * @return Pagination token to use when requesting the next page in this list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasScrapers() ? scrapers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScrapersResponse)) {
            return false;
        }
        ListScrapersResponse other = (ListScrapersResponse) obj;
        return hasScrapers() == other.hasScrapers() && Objects.equals(scrapers(), other.scrapers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListScrapersResponse").add("Scrapers", hasScrapers() ? scrapers() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scrapers":
            return Optional.ofNullable(clazz.cast(scrapers()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListScrapersResponse, T> g) {
        return obj -> g.apply((ListScrapersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmpResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListScrapersResponse> {
        /**
         * <p>
         * The list of scrapers, filtered down if a set of filters was provided in the request.
         * </p>
         * 
         * @param scrapers
         *        The list of scrapers, filtered down if a set of filters was provided in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scrapers(Collection<ScraperSummary> scrapers);

        /**
         * <p>
         * The list of scrapers, filtered down if a set of filters was provided in the request.
         * </p>
         * 
         * @param scrapers
         *        The list of scrapers, filtered down if a set of filters was provided in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scrapers(ScraperSummary... scrapers);

        /**
         * <p>
         * The list of scrapers, filtered down if a set of filters was provided in the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.amp.model.ScraperSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.amp.model.ScraperSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.amp.model.ScraperSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #scrapers(List<ScraperSummary>)}.
         * 
         * @param scrapers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.amp.model.ScraperSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scrapers(java.util.Collection<ScraperSummary>)
         */
        Builder scrapers(Consumer<ScraperSummary.Builder>... scrapers);

        /**
         * <p>
         * Pagination token to use when requesting the next page in this list.
         * </p>
         * 
         * @param nextToken
         *        Pagination token to use when requesting the next page in this list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AmpResponse.BuilderImpl implements Builder {
        private List<ScraperSummary> scrapers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListScrapersResponse model) {
            super(model);
            scrapers(model.scrapers);
            nextToken(model.nextToken);
        }

        public final List<ScraperSummary.Builder> getScrapers() {
            List<ScraperSummary.Builder> result = ScraperSummaryListCopier.copyToBuilder(this.scrapers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScrapers(Collection<ScraperSummary.BuilderImpl> scrapers) {
            this.scrapers = ScraperSummaryListCopier.copyFromBuilder(scrapers);
        }

        @Override
        public final Builder scrapers(Collection<ScraperSummary> scrapers) {
            this.scrapers = ScraperSummaryListCopier.copy(scrapers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scrapers(ScraperSummary... scrapers) {
            scrapers(Arrays.asList(scrapers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scrapers(Consumer<ScraperSummary.Builder>... scrapers) {
            scrapers(Stream.of(scrapers).map(c -> ScraperSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListScrapersResponse build() {
            return new ListScrapersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
