/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a CreateScraper operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateScraperResponse extends AmpResponse implements
        ToCopyableBuilder<CreateScraperResponse.Builder, CreateScraperResponse> {
    private static final SdkField<String> SCRAPER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scraperId").getter(getter(CreateScraperResponse::scraperId)).setter(setter(Builder::scraperId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scraperId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CreateScraperResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<ScraperStatus> STATUS_FIELD = SdkField.<ScraperStatus> builder(MarshallingType.SDK_POJO)
            .memberName("status").getter(getter(CreateScraperResponse::status)).setter(setter(Builder::status))
            .constructor(ScraperStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateScraperResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCRAPER_ID_FIELD, ARN_FIELD,
            STATUS_FIELD, TAGS_FIELD));

    private final String scraperId;

    private final String arn;

    private final ScraperStatus status;

    private final Map<String, String> tags;

    private CreateScraperResponse(BuilderImpl builder) {
        super(builder);
        this.scraperId = builder.scraperId;
        this.arn = builder.arn;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The generated ID of the scraper that was just created.
     * </p>
     * 
     * @return The generated ID of the scraper that was just created.
     */
    public final String scraperId() {
        return scraperId;
    }

    /**
     * <p>
     * The ARN of the scraper that was just created.
     * </p>
     * 
     * @return The ARN of the scraper that was just created.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of the scraper that was just created (usually CREATING).
     * </p>
     * 
     * @return The status of the scraper that was just created (usually CREATING).
     */
    public final ScraperStatus status() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags of this scraper.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags of this scraper.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scraperId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScraperResponse)) {
            return false;
        }
        CreateScraperResponse other = (CreateScraperResponse) obj;
        return Objects.equals(scraperId(), other.scraperId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(status(), other.status()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateScraperResponse").add("ScraperId", scraperId()).add("Arn", arn()).add("Status", status())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scraperId":
            return Optional.ofNullable(clazz.cast(scraperId()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateScraperResponse, T> g) {
        return obj -> g.apply((CreateScraperResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmpResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateScraperResponse> {
        /**
         * <p>
         * The generated ID of the scraper that was just created.
         * </p>
         * 
         * @param scraperId
         *        The generated ID of the scraper that was just created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scraperId(String scraperId);

        /**
         * <p>
         * The ARN of the scraper that was just created.
         * </p>
         * 
         * @param arn
         *        The ARN of the scraper that was just created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of the scraper that was just created (usually CREATING).
         * </p>
         * 
         * @param status
         *        The status of the scraper that was just created (usually CREATING).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ScraperStatus status);

        /**
         * <p>
         * The status of the scraper that was just created (usually CREATING).
         * </p>
         * This is a convenience method that creates an instance of the {@link ScraperStatus.Builder} avoiding the need
         * to create one manually via {@link ScraperStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScraperStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(ScraperStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link ScraperStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(ScraperStatus)
         */
        default Builder status(Consumer<ScraperStatus.Builder> status) {
            return status(ScraperStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The tags of this scraper.
         * </p>
         * 
         * @param tags
         *        The tags of this scraper.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends AmpResponse.BuilderImpl implements Builder {
        private String scraperId;

        private String arn;

        private ScraperStatus status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScraperResponse model) {
            super(model);
            scraperId(model.scraperId);
            arn(model.arn);
            status(model.status);
            tags(model.tags);
        }

        public final String getScraperId() {
            return scraperId;
        }

        public final void setScraperId(String scraperId) {
            this.scraperId = scraperId;
        }

        @Override
        public final Builder scraperId(String scraperId) {
            this.scraperId = scraperId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final ScraperStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(ScraperStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(ScraperStatus status) {
            this.status = status;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public CreateScraperResponse build() {
            return new CreateScraperResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
