/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>GetDefaultScraperConfiguration</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDefaultScraperConfigurationResponse extends AmpResponse implements
        ToCopyableBuilder<GetDefaultScraperConfigurationResponse.Builder, GetDefaultScraperConfigurationResponse> {
    private static final SdkField<SdkBytes> CONFIGURATION_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("configuration").getter(getter(GetDefaultScraperConfigurationResponse::configuration))
            .setter(setter(Builder::configuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD));

    private final SdkBytes configuration;

    private GetDefaultScraperConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * The configuration file. Base 64 encoded. For more information, see <a href=
     * "https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration"
     * >Scraper configuration</a>in the <i>Amazon Managed Service for Prometheus User Guide</i>.
     * </p>
     * 
     * @return The configuration file. Base 64 encoded. For more information, see <a href=
     *         "https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration"
     *         >Scraper configuration</a>in the <i>Amazon Managed Service for Prometheus User Guide</i>.
     */
    public final SdkBytes configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDefaultScraperConfigurationResponse)) {
            return false;
        }
        GetDefaultScraperConfigurationResponse other = (GetDefaultScraperConfigurationResponse) obj;
        return Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDefaultScraperConfigurationResponse").add("Configuration", configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDefaultScraperConfigurationResponse, T> g) {
        return obj -> g.apply((GetDefaultScraperConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmpResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDefaultScraperConfigurationResponse> {
        /**
         * <p>
         * The configuration file. Base 64 encoded. For more information, see <a href=
         * "https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration"
         * >Scraper configuration</a>in the <i>Amazon Managed Service for Prometheus User Guide</i>.
         * </p>
         * 
         * @param configuration
         *        The configuration file. Base 64 encoded. For more information, see <a href=
         *        "https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration"
         *        >Scraper configuration</a>in the <i>Amazon Managed Service for Prometheus User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(SdkBytes configuration);
    }

    static final class BuilderImpl extends AmpResponse.BuilderImpl implements Builder {
        private SdkBytes configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDefaultScraperConfigurationResponse model) {
            super(model);
            configuration(model.configuration);
        }

        public final ByteBuffer getConfiguration() {
            return configuration == null ? null : configuration.asByteBuffer();
        }

        public final void setConfiguration(ByteBuffer configuration) {
            configuration(configuration == null ? null : SdkBytes.fromByteBuffer(configuration));
        }

        @Override
        public final Builder configuration(SdkBytes configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public GetDefaultScraperConfigurationResponse build() {
            return new GetDefaultScraperConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
