/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>ScraperDescription</code> structure contains the full details about one scraper in your account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScraperDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ScraperDescription.Builder, ScraperDescription> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("alias")
            .getter(getter(ScraperDescription::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ScraperDescription::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(ScraperDescription::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Destination> DESTINATION_FIELD = SdkField.<Destination> builder(MarshallingType.SDK_POJO)
            .memberName("destination").getter(getter(ScraperDescription::destination)).setter(setter(Builder::destination))
            .constructor(Destination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedAt").getter(getter(ScraperDescription::lastModifiedAt))
            .setter(setter(Builder::lastModifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(ScraperDescription::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<ScrapeConfiguration> SCRAPE_CONFIGURATION_FIELD = SdkField
            .<ScrapeConfiguration> builder(MarshallingType.SDK_POJO).memberName("scrapeConfiguration")
            .getter(getter(ScraperDescription::scrapeConfiguration)).setter(setter(Builder::scrapeConfiguration))
            .constructor(ScrapeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scrapeConfiguration").build())
            .build();

    private static final SdkField<String> SCRAPER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scraperId").getter(getter(ScraperDescription::scraperId)).setter(setter(Builder::scraperId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scraperId").build()).build();

    private static final SdkField<Source> SOURCE_FIELD = SdkField.<Source> builder(MarshallingType.SDK_POJO).memberName("source")
            .getter(getter(ScraperDescription::source)).setter(setter(Builder::source)).constructor(Source::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<ScraperStatus> STATUS_FIELD = SdkField.<ScraperStatus> builder(MarshallingType.SDK_POJO)
            .memberName("status").getter(getter(ScraperDescription::status)).setter(setter(Builder::status))
            .constructor(ScraperStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(ScraperDescription::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(ScraperDescription::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD, ARN_FIELD,
            CREATED_AT_FIELD, DESTINATION_FIELD, LAST_MODIFIED_AT_FIELD, ROLE_ARN_FIELD, SCRAPE_CONFIGURATION_FIELD,
            SCRAPER_ID_FIELD, SOURCE_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String alias;

    private final String arn;

    private final Instant createdAt;

    private final Destination destination;

    private final Instant lastModifiedAt;

    private final String roleArn;

    private final ScrapeConfiguration scrapeConfiguration;

    private final String scraperId;

    private final Source source;

    private final ScraperStatus status;

    private final String statusReason;

    private final Map<String, String> tags;

    private ScraperDescription(BuilderImpl builder) {
        this.alias = builder.alias;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.destination = builder.destination;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.roleArn = builder.roleArn;
        this.scrapeConfiguration = builder.scrapeConfiguration;
        this.scraperId = builder.scraperId;
        this.source = builder.source;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * (Optional) A name associated with the scraper.
     * </p>
     * 
     * @return (Optional) A name associated with the scraper.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the scraper.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the scraper.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time that the scraper was created.
     * </p>
     * 
     * @return The date and time that the scraper was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Amazon Managed Service for Prometheus workspace the scraper sends metrics to.
     * </p>
     * 
     * @return The Amazon Managed Service for Prometheus workspace the scraper sends metrics to.
     */
    public final Destination destination() {
        return destination;
    }

    /**
     * <p>
     * The date and time that the scraper was last modified.
     * </p>
     * 
     * @return The date and time that the scraper was last modified.
     */
    public final Instant lastModifiedAt() {
        return lastModifiedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that provides permissions for the scraper to discover and collect
     * metrics on your behalf.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that provides permissions for the scraper to discover and
     *         collect metrics on your behalf.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The configuration file in use by the scraper.
     * </p>
     * 
     * @return The configuration file in use by the scraper.
     */
    public final ScrapeConfiguration scrapeConfiguration() {
        return scrapeConfiguration;
    }

    /**
     * <p>
     * The ID of the scraper.
     * </p>
     * 
     * @return The ID of the scraper.
     */
    public final String scraperId() {
        return scraperId;
    }

    /**
     * <p>
     * The Amazon EKS cluster from which the scraper collects metrics.
     * </p>
     * 
     * @return The Amazon EKS cluster from which the scraper collects metrics.
     */
    public final Source source() {
        return source;
    }

    /**
     * <p>
     * A structure that contains the current status of the scraper.
     * </p>
     * 
     * @return A structure that contains the current status of the scraper.
     */
    public final ScraperStatus status() {
        return status;
    }

    /**
     * <p>
     * If there is a failure, the reason for the failure.
     * </p>
     * 
     * @return If there is a failure, the reason for the failure.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * (Optional) The list of tag keys and values associated with the scraper.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return (Optional) The list of tag keys and values associated with the scraper.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(scrapeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(scraperId());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScraperDescription)) {
            return false;
        }
        ScraperDescription other = (ScraperDescription) obj;
        return Objects.equals(alias(), other.alias()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(destination(), other.destination())
                && Objects.equals(lastModifiedAt(), other.lastModifiedAt()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(scrapeConfiguration(), other.scrapeConfiguration())
                && Objects.equals(scraperId(), other.scraperId()) && Objects.equals(source(), other.source())
                && Objects.equals(status(), other.status()) && Objects.equals(statusReason(), other.statusReason())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScraperDescription").add("Alias", alias()).add("Arn", arn()).add("CreatedAt", createdAt())
                .add("Destination", destination()).add("LastModifiedAt", lastModifiedAt()).add("RoleArn", roleArn())
                .add("ScrapeConfiguration", scrapeConfiguration()).add("ScraperId", scraperId()).add("Source", source())
                .add("Status", status()).add("StatusReason", statusReason()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "lastModifiedAt":
            return Optional.ofNullable(clazz.cast(lastModifiedAt()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "scrapeConfiguration":
            return Optional.ofNullable(clazz.cast(scrapeConfiguration()));
        case "scraperId":
            return Optional.ofNullable(clazz.cast(scraperId()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScraperDescription, T> g) {
        return obj -> g.apply((ScraperDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScraperDescription> {
        /**
         * <p>
         * (Optional) A name associated with the scraper.
         * </p>
         * 
         * @param alias
         *        (Optional) A name associated with the scraper.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the scraper.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the scraper.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time that the scraper was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the scraper was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Amazon Managed Service for Prometheus workspace the scraper sends metrics to.
         * </p>
         * 
         * @param destination
         *        The Amazon Managed Service for Prometheus workspace the scraper sends metrics to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(Destination destination);

        /**
         * <p>
         * The Amazon Managed Service for Prometheus workspace the scraper sends metrics to.
         * </p>
         * This is a convenience method that creates an instance of the {@link Destination.Builder} avoiding the need to
         * create one manually via {@link Destination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Destination.Builder#build()} is called immediately and its result
         * is passed to {@link #destination(Destination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(Destination)
         */
        default Builder destination(Consumer<Destination.Builder> destination) {
            return destination(Destination.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * The date and time that the scraper was last modified.
         * </p>
         * 
         * @param lastModifiedAt
         *        The date and time that the scraper was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedAt(Instant lastModifiedAt);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that provides permissions for the scraper to discover and
         * collect metrics on your behalf.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that provides permissions for the scraper to discover
         *        and collect metrics on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The configuration file in use by the scraper.
         * </p>
         * 
         * @param scrapeConfiguration
         *        The configuration file in use by the scraper.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scrapeConfiguration(ScrapeConfiguration scrapeConfiguration);

        /**
         * <p>
         * The configuration file in use by the scraper.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScrapeConfiguration.Builder} avoiding the
         * need to create one manually via {@link ScrapeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScrapeConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #scrapeConfiguration(ScrapeConfiguration)}.
         * 
         * @param scrapeConfiguration
         *        a consumer that will call methods on {@link ScrapeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scrapeConfiguration(ScrapeConfiguration)
         */
        default Builder scrapeConfiguration(Consumer<ScrapeConfiguration.Builder> scrapeConfiguration) {
            return scrapeConfiguration(ScrapeConfiguration.builder().applyMutation(scrapeConfiguration).build());
        }

        /**
         * <p>
         * The ID of the scraper.
         * </p>
         * 
         * @param scraperId
         *        The ID of the scraper.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scraperId(String scraperId);

        /**
         * <p>
         * The Amazon EKS cluster from which the scraper collects metrics.
         * </p>
         * 
         * @param source
         *        The Amazon EKS cluster from which the scraper collects metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(Source source);

        /**
         * <p>
         * The Amazon EKS cluster from which the scraper collects metrics.
         * </p>
         * This is a convenience method that creates an instance of the {@link Source.Builder} avoiding the need to
         * create one manually via {@link Source#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Source.Builder#build()} is called immediately and its result is
         * passed to {@link #source(Source)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(Source)
         */
        default Builder source(Consumer<Source.Builder> source) {
            return source(Source.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * A structure that contains the current status of the scraper.
         * </p>
         * 
         * @param status
         *        A structure that contains the current status of the scraper.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ScraperStatus status);

        /**
         * <p>
         * A structure that contains the current status of the scraper.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScraperStatus.Builder} avoiding the need
         * to create one manually via {@link ScraperStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScraperStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(ScraperStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link ScraperStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(ScraperStatus)
         */
        default Builder status(Consumer<ScraperStatus.Builder> status) {
            return status(ScraperStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * If there is a failure, the reason for the failure.
         * </p>
         * 
         * @param statusReason
         *        If there is a failure, the reason for the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * (Optional) The list of tag keys and values associated with the scraper.
         * </p>
         * 
         * @param tags
         *        (Optional) The list of tag keys and values associated with the scraper.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String alias;

        private String arn;

        private Instant createdAt;

        private Destination destination;

        private Instant lastModifiedAt;

        private String roleArn;

        private ScrapeConfiguration scrapeConfiguration;

        private String scraperId;

        private Source source;

        private ScraperStatus status;

        private String statusReason;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ScraperDescription model) {
            alias(model.alias);
            arn(model.arn);
            createdAt(model.createdAt);
            destination(model.destination);
            lastModifiedAt(model.lastModifiedAt);
            roleArn(model.roleArn);
            scrapeConfiguration(model.scrapeConfiguration);
            scraperId(model.scraperId);
            source(model.source);
            status(model.status);
            statusReason(model.statusReason);
            tags(model.tags);
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Destination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final ScrapeConfiguration.Builder getScrapeConfiguration() {
            return scrapeConfiguration != null ? scrapeConfiguration.toBuilder() : null;
        }

        public final void setScrapeConfiguration(ScrapeConfiguration.BuilderImpl scrapeConfiguration) {
            this.scrapeConfiguration = scrapeConfiguration != null ? scrapeConfiguration.build() : null;
        }

        @Override
        public final Builder scrapeConfiguration(ScrapeConfiguration scrapeConfiguration) {
            this.scrapeConfiguration = scrapeConfiguration;
            return this;
        }

        public final String getScraperId() {
            return scraperId;
        }

        public final void setScraperId(String scraperId) {
            this.scraperId = scraperId;
        }

        @Override
        public final Builder scraperId(String scraperId) {
            this.scraperId = scraperId;
            return this;
        }

        public final Source.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final ScraperStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(ScraperStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(ScraperStatus status) {
            this.status = status;
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public ScraperDescription build() {
            return new ScraperDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
