/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The source of collected metrics for a scraper.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Source implements SdkPojo, Serializable, ToCopyableBuilder<Source.Builder, Source> {
    private static final SdkField<EksConfiguration> EKS_CONFIGURATION_FIELD = SdkField
            .<EksConfiguration> builder(MarshallingType.SDK_POJO).memberName("eksConfiguration")
            .getter(getter(Source::eksConfiguration)).setter(setter(Builder::eksConfiguration))
            .constructor(EksConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EKS_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final EksConfiguration eksConfiguration;

    private final Type type;

    private Source(BuilderImpl builder) {
        this.eksConfiguration = builder.eksConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon EKS cluster from which a scraper collects metrics.
     * </p>
     * 
     * @return The Amazon EKS cluster from which a scraper collects metrics.
     */
    public final EksConfiguration eksConfiguration() {
        return eksConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eksConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source other = (Source) obj;
        return Objects.equals(eksConfiguration(), other.eksConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Source").add("EksConfiguration", eksConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eksConfiguration":
            return Optional.ofNullable(clazz.cast(eksConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #eksConfiguration()} initialized to the given value.
     *
     * <p>
     * The Amazon EKS cluster from which a scraper collects metrics.
     * </p>
     * 
     * @param eksConfiguration
     *        The Amazon EKS cluster from which a scraper collects metrics.
     */
    public static Source fromEksConfiguration(EksConfiguration eksConfiguration) {
        return builder().eksConfiguration(eksConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #eksConfiguration()} initialized to the given value.
     *
     * <p>
     * The Amazon EKS cluster from which a scraper collects metrics.
     * </p>
     * 
     * @param eksConfiguration
     *        The Amazon EKS cluster from which a scraper collects metrics.
     */
    public static Source fromEksConfiguration(Consumer<EksConfiguration.Builder> eksConfiguration) {
        EksConfiguration.Builder builder = EksConfiguration.builder();
        eksConfiguration.accept(builder);
        return fromEksConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Source, T> g) {
        return obj -> g.apply((Source) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Source> {
        /**
         * <p>
         * The Amazon EKS cluster from which a scraper collects metrics.
         * </p>
         * 
         * @param eksConfiguration
         *        The Amazon EKS cluster from which a scraper collects metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eksConfiguration(EksConfiguration eksConfiguration);

        /**
         * <p>
         * The Amazon EKS cluster from which a scraper collects metrics.
         * </p>
         * This is a convenience method that creates an instance of the {@link EksConfiguration.Builder} avoiding the
         * need to create one manually via {@link EksConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EksConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #eksConfiguration(EksConfiguration)}.
         * 
         * @param eksConfiguration
         *        a consumer that will call methods on {@link EksConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eksConfiguration(EksConfiguration)
         */
        default Builder eksConfiguration(Consumer<EksConfiguration.Builder> eksConfiguration) {
            return eksConfiguration(EksConfiguration.builder().applyMutation(eksConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EksConfiguration eksConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Source model) {
            eksConfiguration(model.eksConfiguration);
        }

        public final EksConfiguration.Builder getEksConfiguration() {
            return eksConfiguration != null ? eksConfiguration.toBuilder() : null;
        }

        public final void setEksConfiguration(EksConfiguration.BuilderImpl eksConfiguration) {
            Object oldValue = this.eksConfiguration;
            this.eksConfiguration = eksConfiguration != null ? eksConfiguration.build() : null;
            handleUnionValueChange(Type.EKS_CONFIGURATION, oldValue, this.eksConfiguration);
        }

        @Override
        public final Builder eksConfiguration(EksConfiguration eksConfiguration) {
            Object oldValue = this.eksConfiguration;
            this.eksConfiguration = eksConfiguration;
            handleUnionValueChange(Type.EKS_CONFIGURATION, oldValue, this.eksConfiguration);
            return this;
        }

        @Override
        public Source build() {
            return new Source(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Source#type()
     */
    public enum Type {
        EKS_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
