/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>ListRuleGroupsNamespaces</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRuleGroupsNamespacesRequest extends AmpRequest implements
        ToCopyableBuilder<ListRuleGroupsNamespacesRequest.Builder, ListRuleGroupsNamespacesRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListRuleGroupsNamespacesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ListRuleGroupsNamespacesRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRuleGroupsNamespacesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(ListRuleGroupsNamespacesRequest::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NAME_FIELD,
            NEXT_TOKEN_FIELD, WORKSPACE_ID_FIELD));

    private final Integer maxResults;

    private final String name;

    private final String nextToken;

    private final String workspaceId;

    private ListRuleGroupsNamespacesRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.name = builder.name;
        this.nextToken = builder.nextToken;
        this.workspaceId = builder.workspaceId;
    }

    /**
     * <p>
     * The maximum number of results to return. The default is 100.
     * </p>
     * 
     * @return The maximum number of results to return. The default is 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Use this parameter to filter the rule groups namespaces that are returned. Only the namespaces with names that
     * begin with the value that you specify are returned.
     * </p>
     * 
     * @return Use this parameter to filter the rule groups namespaces that are returned. Only the namespaces with names
     *         that begin with the value that you specify are returned.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The token for the next set of items to return. You receive this token from a previous call, and use it to get the
     * next page of results. The other parameters must be the same as the initial call.
     * </p>
     * <p>
     * For example, if your initial request has <code>maxResults</code> of 10, and there are 12 rule groups namespaces
     * to return, then your initial request will return 10 and a <code>nextToken</code>. Using the next token in a
     * subsequent call will return the remaining 2 namespaces.
     * </p>
     * 
     * @return The token for the next set of items to return. You receive this token from a previous call, and use it to
     *         get the next page of results. The other parameters must be the same as the initial call.</p>
     *         <p>
     *         For example, if your initial request has <code>maxResults</code> of 10, and there are 12 rule groups
     *         namespaces to return, then your initial request will return 10 and a <code>nextToken</code>. Using the
     *         next token in a subsequent call will return the remaining 2 namespaces.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The ID of the workspace containing the rule groups namespaces.
     * </p>
     * 
     * @return The ID of the workspace containing the rule groups namespaces.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRuleGroupsNamespacesRequest)) {
            return false;
        }
        ListRuleGroupsNamespacesRequest other = (ListRuleGroupsNamespacesRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(name(), other.name())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(workspaceId(), other.workspaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRuleGroupsNamespacesRequest").add("MaxResults", maxResults()).add("Name", name())
                .add("NextToken", nextToken()).add("WorkspaceId", workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRuleGroupsNamespacesRequest, T> g) {
        return obj -> g.apply((ListRuleGroupsNamespacesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmpRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListRuleGroupsNamespacesRequest> {
        /**
         * <p>
         * The maximum number of results to return. The default is 100.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return. The default is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Use this parameter to filter the rule groups namespaces that are returned. Only the namespaces with names
         * that begin with the value that you specify are returned.
         * </p>
         * 
         * @param name
         *        Use this parameter to filter the rule groups namespaces that are returned. Only the namespaces with
         *        names that begin with the value that you specify are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The token for the next set of items to return. You receive this token from a previous call, and use it to get
         * the next page of results. The other parameters must be the same as the initial call.
         * </p>
         * <p>
         * For example, if your initial request has <code>maxResults</code> of 10, and there are 12 rule groups
         * namespaces to return, then your initial request will return 10 and a <code>nextToken</code>. Using the next
         * token in a subsequent call will return the remaining 2 namespaces.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. You receive this token from a previous call, and use it
         *        to get the next page of results. The other parameters must be the same as the initial call.</p>
         *        <p>
         *        For example, if your initial request has <code>maxResults</code> of 10, and there are 12 rule groups
         *        namespaces to return, then your initial request will return 10 and a <code>nextToken</code>. Using the
         *        next token in a subsequent call will return the remaining 2 namespaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ID of the workspace containing the rule groups namespaces.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace containing the rule groups namespaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmpRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String name;

        private String nextToken;

        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRuleGroupsNamespacesRequest model) {
            super(model);
            maxResults(model.maxResults);
            name(model.name);
            nextToken(model.nextToken);
            workspaceId(model.workspaceId);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRuleGroupsNamespacesRequest build() {
            return new ListRuleGroupsNamespacesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
