/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DescribeAlertManagerDefinition</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAlertManagerDefinitionResponse extends AmpResponse implements
        ToCopyableBuilder<DescribeAlertManagerDefinitionResponse.Builder, DescribeAlertManagerDefinitionResponse> {
    private static final SdkField<AlertManagerDefinitionDescription> ALERT_MANAGER_DEFINITION_FIELD = SdkField
            .<AlertManagerDefinitionDescription> builder(MarshallingType.SDK_POJO).memberName("alertManagerDefinition")
            .getter(getter(DescribeAlertManagerDefinitionResponse::alertManagerDefinition))
            .setter(setter(Builder::alertManagerDefinition)).constructor(AlertManagerDefinitionDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alertManagerDefinition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ALERT_MANAGER_DEFINITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AlertManagerDefinitionDescription alertManagerDefinition;

    private DescribeAlertManagerDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.alertManagerDefinition = builder.alertManagerDefinition;
    }

    /**
     * <p>
     * The alert manager definition.
     * </p>
     * 
     * @return The alert manager definition.
     */
    public final AlertManagerDefinitionDescription alertManagerDefinition() {
        return alertManagerDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(alertManagerDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlertManagerDefinitionResponse)) {
            return false;
        }
        DescribeAlertManagerDefinitionResponse other = (DescribeAlertManagerDefinitionResponse) obj;
        return Objects.equals(alertManagerDefinition(), other.alertManagerDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAlertManagerDefinitionResponse").add("AlertManagerDefinition", alertManagerDefinition())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alertManagerDefinition":
            return Optional.ofNullable(clazz.cast(alertManagerDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("alertManagerDefinition", ALERT_MANAGER_DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAlertManagerDefinitionResponse, T> g) {
        return obj -> g.apply((DescribeAlertManagerDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmpResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAlertManagerDefinitionResponse> {
        /**
         * <p>
         * The alert manager definition.
         * </p>
         * 
         * @param alertManagerDefinition
         *        The alert manager definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertManagerDefinition(AlertManagerDefinitionDescription alertManagerDefinition);

        /**
         * <p>
         * The alert manager definition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AlertManagerDefinitionDescription.Builder} avoiding the need to create one manually via
         * {@link AlertManagerDefinitionDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AlertManagerDefinitionDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #alertManagerDefinition(AlertManagerDefinitionDescription)}.
         * 
         * @param alertManagerDefinition
         *        a consumer that will call methods on {@link AlertManagerDefinitionDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alertManagerDefinition(AlertManagerDefinitionDescription)
         */
        default Builder alertManagerDefinition(Consumer<AlertManagerDefinitionDescription.Builder> alertManagerDefinition) {
            return alertManagerDefinition(AlertManagerDefinitionDescription.builder().applyMutation(alertManagerDefinition)
                    .build());
        }
    }

    static final class BuilderImpl extends AmpResponse.BuilderImpl implements Builder {
        private AlertManagerDefinitionDescription alertManagerDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlertManagerDefinitionResponse model) {
            super(model);
            alertManagerDefinition(model.alertManagerDefinition);
        }

        public final AlertManagerDefinitionDescription.Builder getAlertManagerDefinition() {
            return alertManagerDefinition != null ? alertManagerDefinition.toBuilder() : null;
        }

        public final void setAlertManagerDefinition(AlertManagerDefinitionDescription.BuilderImpl alertManagerDefinition) {
            this.alertManagerDefinition = alertManagerDefinition != null ? alertManagerDefinition.build() : null;
        }

        @Override
        public final Builder alertManagerDefinition(AlertManagerDefinitionDescription alertManagerDefinition) {
            this.alertManagerDefinition = alertManagerDefinition;
            return this;
        }

        @Override
        public DescribeAlertManagerDefinitionResponse build() {
            return new DescribeAlertManagerDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
