/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>CreateRuleGroupsNamespace</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRuleGroupsNamespaceRequest extends AmpRequest implements
        ToCopyableBuilder<CreateRuleGroupsNamespaceRequest.Builder, CreateRuleGroupsNamespaceRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateRuleGroupsNamespaceRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<SdkBytes> DATA_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("data").getter(getter(CreateRuleGroupsNamespaceRequest::data)).setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateRuleGroupsNamespaceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateRuleGroupsNamespaceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(CreateRuleGroupsNamespaceRequest::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DATA_FIELD, NAME_FIELD, TAGS_FIELD, WORKSPACE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final SdkBytes data;

    private final String name;

    private final Map<String, String> tags;

    private final String workspaceId;

    private CreateRuleGroupsNamespaceRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.data = builder.data;
        this.name = builder.name;
        this.tags = builder.tags;
        this.workspaceId = builder.workspaceId;
    }

    /**
     * <p>
     * A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.
     * </p>
     * 
     * @return A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The rules file to use in the new namespace.
     * </p>
     * <p>
     * Contains the base64-encoded version of the YAML rules file.
     * </p>
     * <p>
     * For details about the rule groups namespace structure, see <a
     * href="https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-RuleGroupsNamespaceData.html"
     * >RuleGroupsNamespaceData</a>.
     * </p>
     * 
     * @return The rules file to use in the new namespace.</p>
     *         <p>
     *         Contains the base64-encoded version of the YAML rules file.
     *         </p>
     *         <p>
     *         For details about the rule groups namespace structure, see <a
     *         href="https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-RuleGroupsNamespaceData.html"
     *         >RuleGroupsNamespaceData</a>.
     */
    public final SdkBytes data() {
        return data;
    }

    /**
     * <p>
     * The name for the new rule groups namespace.
     * </p>
     * 
     * @return The name for the new rule groups namespace.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of tag keys and values to associate with the rule groups namespace.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of tag keys and values to associate with the rule groups namespace.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the workspace to add the rule groups namespace.
     * </p>
     * 
     * @return The ID of the workspace to add the rule groups namespace.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(data());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRuleGroupsNamespaceRequest)) {
            return false;
        }
        CreateRuleGroupsNamespaceRequest other = (CreateRuleGroupsNamespaceRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(data(), other.data())
                && Objects.equals(name(), other.name()) && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(workspaceId(), other.workspaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRuleGroupsNamespaceRequest").add("ClientToken", clientToken()).add("Data", data())
                .add("Name", name()).add("Tags", hasTags() ? tags() : null).add("WorkspaceId", workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "data":
            return Optional.ofNullable(clazz.cast(data()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("data", DATA_FIELD);
        map.put("name", NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRuleGroupsNamespaceRequest, T> g) {
        return obj -> g.apply((CreateRuleGroupsNamespaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmpRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRuleGroupsNamespaceRequest> {
        /**
         * <p>
         * A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.
         * </p>
         * 
         * @param clientToken
         *        A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The rules file to use in the new namespace.
         * </p>
         * <p>
         * Contains the base64-encoded version of the YAML rules file.
         * </p>
         * <p>
         * For details about the rule groups namespace structure, see <a
         * href="https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-RuleGroupsNamespaceData.html"
         * >RuleGroupsNamespaceData</a>.
         * </p>
         * 
         * @param data
         *        The rules file to use in the new namespace.</p>
         *        <p>
         *        Contains the base64-encoded version of the YAML rules file.
         *        </p>
         *        <p>
         *        For details about the rule groups namespace structure, see <a
         *        href="https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-RuleGroupsNamespaceData.html"
         *        >RuleGroupsNamespaceData</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(SdkBytes data);

        /**
         * <p>
         * The name for the new rule groups namespace.
         * </p>
         * 
         * @param name
         *        The name for the new rule groups namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The list of tag keys and values to associate with the rule groups namespace.
         * </p>
         * 
         * @param tags
         *        The list of tag keys and values to associate with the rule groups namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The ID of the workspace to add the rule groups namespace.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace to add the rule groups namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmpRequest.BuilderImpl implements Builder {
        private String clientToken;

        private SdkBytes data;

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRuleGroupsNamespaceRequest model) {
            super(model);
            clientToken(model.clientToken);
            data(model.data);
            name(model.name);
            tags(model.tags);
            workspaceId(model.workspaceId);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final ByteBuffer getData() {
            return data == null ? null : data.asByteBuffer();
        }

        public final void setData(ByteBuffer data) {
            data(data == null ? null : SdkBytes.fromByteBuffer(data));
        }

        @Override
        public final Builder data(SdkBytes data) {
            this.data = data;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRuleGroupsNamespaceRequest build() {
            return new CreateRuleGroupsNamespaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
