/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>DeleteScraper</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteScraperRequest extends AmpRequest implements
        ToCopyableBuilder<DeleteScraperRequest.Builder, DeleteScraperRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(DeleteScraperRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> SCRAPER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scraperId").getter(getter(DeleteScraperRequest::scraperId)).setter(setter(Builder::scraperId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("scraperId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            SCRAPER_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String scraperId;

    private DeleteScraperRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.scraperId = builder.scraperId;
    }

    /**
     * <p>
     * (Optional) A unique, case-sensitive identifier that you can provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return (Optional) A unique, case-sensitive identifier that you can provide to ensure the idempotency of the
     *         request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ID of the scraper to delete.
     * </p>
     * 
     * @return The ID of the scraper to delete.
     */
    public final String scraperId() {
        return scraperId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(scraperId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteScraperRequest)) {
            return false;
        }
        DeleteScraperRequest other = (DeleteScraperRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(scraperId(), other.scraperId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteScraperRequest").add("ClientToken", clientToken()).add("ScraperId", scraperId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "scraperId":
            return Optional.ofNullable(clazz.cast(scraperId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("scraperId", SCRAPER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteScraperRequest, T> g) {
        return obj -> g.apply((DeleteScraperRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmpRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteScraperRequest> {
        /**
         * <p>
         * (Optional) A unique, case-sensitive identifier that you can provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        (Optional) A unique, case-sensitive identifier that you can provide to ensure the idempotency of the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ID of the scraper to delete.
         * </p>
         * 
         * @param scraperId
         *        The ID of the scraper to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scraperId(String scraperId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmpRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String scraperId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteScraperRequest model) {
            super(model);
            clientToken(model.clientToken);
            scraperId(model.scraperId);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getScraperId() {
            return scraperId;
        }

        public final void setScraperId(String scraperId) {
            this.scraperId = scraperId;
        }

        @Override
        public final Builder scraperId(String scraperId) {
            this.scraperId = scraperId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteScraperRequest build() {
            return new DeleteScraperRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
