/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DescribeScraper</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeScraperResponse extends AmpResponse implements
        ToCopyableBuilder<DescribeScraperResponse.Builder, DescribeScraperResponse> {
    private static final SdkField<ScraperDescription> SCRAPER_FIELD = SdkField
            .<ScraperDescription> builder(MarshallingType.SDK_POJO).memberName("scraper")
            .getter(getter(DescribeScraperResponse::scraper)).setter(setter(Builder::scraper))
            .constructor(ScraperDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scraper").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCRAPER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ScraperDescription scraper;

    private DescribeScraperResponse(BuilderImpl builder) {
        super(builder);
        this.scraper = builder.scraper;
    }

    /**
     * <p>
     * Contains details about the scraper.
     * </p>
     * 
     * @return Contains details about the scraper.
     */
    public final ScraperDescription scraper() {
        return scraper;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scraper());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScraperResponse)) {
            return false;
        }
        DescribeScraperResponse other = (DescribeScraperResponse) obj;
        return Objects.equals(scraper(), other.scraper());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeScraperResponse").add("Scraper", scraper()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scraper":
            return Optional.ofNullable(clazz.cast(scraper()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scraper", SCRAPER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeScraperResponse, T> g) {
        return obj -> g.apply((DescribeScraperResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmpResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeScraperResponse> {
        /**
         * <p>
         * Contains details about the scraper.
         * </p>
         * 
         * @param scraper
         *        Contains details about the scraper.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scraper(ScraperDescription scraper);

        /**
         * <p>
         * Contains details about the scraper.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScraperDescription.Builder} avoiding the
         * need to create one manually via {@link ScraperDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScraperDescription.Builder#build()} is called immediately and its
         * result is passed to {@link #scraper(ScraperDescription)}.
         * 
         * @param scraper
         *        a consumer that will call methods on {@link ScraperDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scraper(ScraperDescription)
         */
        default Builder scraper(Consumer<ScraperDescription.Builder> scraper) {
            return scraper(ScraperDescription.builder().applyMutation(scraper).build());
        }
    }

    static final class BuilderImpl extends AmpResponse.BuilderImpl implements Builder {
        private ScraperDescription scraper;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScraperResponse model) {
            super(model);
            scraper(model.scraper);
        }

        public final ScraperDescription.Builder getScraper() {
            return scraper != null ? scraper.toBuilder() : null;
        }

        public final void setScraper(ScraperDescription.BuilderImpl scraper) {
            this.scraper = scraper != null ? scraper.build() : null;
        }

        @Override
        public final Builder scraper(ScraperDescription scraper) {
            this.scraper = scraper;
            return this;
        }

        @Override
        public DescribeScraperResponse build() {
            return new DescribeScraperResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
