/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateScraperRequest extends AmpRequest implements
        ToCopyableBuilder<UpdateScraperRequest.Builder, UpdateScraperRequest> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("alias")
            .getter(getter(UpdateScraperRequest::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateScraperRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Destination> DESTINATION_FIELD = SdkField.<Destination> builder(MarshallingType.SDK_POJO)
            .memberName("destination").getter(getter(UpdateScraperRequest::destination)).setter(setter(Builder::destination))
            .constructor(Destination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<RoleConfiguration> ROLE_CONFIGURATION_FIELD = SdkField
            .<RoleConfiguration> builder(MarshallingType.SDK_POJO).memberName("roleConfiguration")
            .getter(getter(UpdateScraperRequest::roleConfiguration)).setter(setter(Builder::roleConfiguration))
            .constructor(RoleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleConfiguration").build()).build();

    private static final SdkField<ScrapeConfiguration> SCRAPE_CONFIGURATION_FIELD = SdkField
            .<ScrapeConfiguration> builder(MarshallingType.SDK_POJO).memberName("scrapeConfiguration")
            .getter(getter(UpdateScraperRequest::scrapeConfiguration)).setter(setter(Builder::scrapeConfiguration))
            .constructor(ScrapeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scrapeConfiguration").build())
            .build();

    private static final SdkField<String> SCRAPER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scraperId").getter(getter(UpdateScraperRequest::scraperId)).setter(setter(Builder::scraperId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("scraperId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD,
            CLIENT_TOKEN_FIELD, DESTINATION_FIELD, ROLE_CONFIGURATION_FIELD, SCRAPE_CONFIGURATION_FIELD, SCRAPER_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String alias;

    private final String clientToken;

    private final Destination destination;

    private final RoleConfiguration roleConfiguration;

    private final ScrapeConfiguration scrapeConfiguration;

    private final String scraperId;

    private UpdateScraperRequest(BuilderImpl builder) {
        super(builder);
        this.alias = builder.alias;
        this.clientToken = builder.clientToken;
        this.destination = builder.destination;
        this.roleConfiguration = builder.roleConfiguration;
        this.scrapeConfiguration = builder.scrapeConfiguration;
        this.scraperId = builder.scraperId;
    }

    /**
     * <p>
     * The new alias of the scraper.
     * </p>
     * 
     * @return The new alias of the scraper.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.
     * </p>
     * 
     * @return A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The new Amazon Managed Service for Prometheus workspace to send metrics to.
     * </p>
     * 
     * @return The new Amazon Managed Service for Prometheus workspace to send metrics to.
     */
    public final Destination destination() {
        return destination;
    }

    /**
     * <p>
     * The scraper role configuration for the workspace.
     * </p>
     * 
     * @return The scraper role configuration for the workspace.
     */
    public final RoleConfiguration roleConfiguration() {
        return roleConfiguration;
    }

    /**
     * <p>
     * Contains the base-64 encoded YAML configuration for the scraper.
     * </p>
     * <note>
     * <p>
     * For more information about configuring a scraper, see <a
     * href="https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html">Using an Amazon Web
     * Services managed collector</a> in the <i>Amazon Managed Service for Prometheus User Guide</i>.
     * </p>
     * </note>
     * 
     * @return Contains the base-64 encoded YAML configuration for the scraper.</p> <note>
     *         <p>
     *         For more information about configuring a scraper, see <a
     *         href="https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html">Using an Amazon
     *         Web Services managed collector</a> in the <i>Amazon Managed Service for Prometheus User Guide</i>.
     *         </p>
     */
    public final ScrapeConfiguration scrapeConfiguration() {
        return scrapeConfiguration;
    }

    /**
     * <p>
     * The ID of the scraper to update.
     * </p>
     * 
     * @return The ID of the scraper to update.
     */
    public final String scraperId() {
        return scraperId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(roleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(scrapeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(scraperId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateScraperRequest)) {
            return false;
        }
        UpdateScraperRequest other = (UpdateScraperRequest) obj;
        return Objects.equals(alias(), other.alias()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(destination(), other.destination())
                && Objects.equals(roleConfiguration(), other.roleConfiguration())
                && Objects.equals(scrapeConfiguration(), other.scrapeConfiguration())
                && Objects.equals(scraperId(), other.scraperId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateScraperRequest").add("Alias", alias()).add("ClientToken", clientToken())
                .add("Destination", destination()).add("RoleConfiguration", roleConfiguration())
                .add("ScrapeConfiguration", scrapeConfiguration()).add("ScraperId", scraperId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "roleConfiguration":
            return Optional.ofNullable(clazz.cast(roleConfiguration()));
        case "scrapeConfiguration":
            return Optional.ofNullable(clazz.cast(scrapeConfiguration()));
        case "scraperId":
            return Optional.ofNullable(clazz.cast(scraperId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("alias", ALIAS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("destination", DESTINATION_FIELD);
        map.put("roleConfiguration", ROLE_CONFIGURATION_FIELD);
        map.put("scrapeConfiguration", SCRAPE_CONFIGURATION_FIELD);
        map.put("scraperId", SCRAPER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateScraperRequest, T> g) {
        return obj -> g.apply((UpdateScraperRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmpRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateScraperRequest> {
        /**
         * <p>
         * The new alias of the scraper.
         * </p>
         * 
         * @param alias
         *        The new alias of the scraper.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.
         * </p>
         * 
         * @param clientToken
         *        A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The new Amazon Managed Service for Prometheus workspace to send metrics to.
         * </p>
         * 
         * @param destination
         *        The new Amazon Managed Service for Prometheus workspace to send metrics to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(Destination destination);

        /**
         * <p>
         * The new Amazon Managed Service for Prometheus workspace to send metrics to.
         * </p>
         * This is a convenience method that creates an instance of the {@link Destination.Builder} avoiding the need to
         * create one manually via {@link Destination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Destination.Builder#build()} is called immediately and its result
         * is passed to {@link #destination(Destination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(Destination)
         */
        default Builder destination(Consumer<Destination.Builder> destination) {
            return destination(Destination.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * The scraper role configuration for the workspace.
         * </p>
         * 
         * @param roleConfiguration
         *        The scraper role configuration for the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleConfiguration(RoleConfiguration roleConfiguration);

        /**
         * <p>
         * The scraper role configuration for the workspace.
         * </p>
         * This is a convenience method that creates an instance of the {@link RoleConfiguration.Builder} avoiding the
         * need to create one manually via {@link RoleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoleConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #roleConfiguration(RoleConfiguration)}.
         * 
         * @param roleConfiguration
         *        a consumer that will call methods on {@link RoleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #roleConfiguration(RoleConfiguration)
         */
        default Builder roleConfiguration(Consumer<RoleConfiguration.Builder> roleConfiguration) {
            return roleConfiguration(RoleConfiguration.builder().applyMutation(roleConfiguration).build());
        }

        /**
         * <p>
         * Contains the base-64 encoded YAML configuration for the scraper.
         * </p>
         * <note>
         * <p>
         * For more information about configuring a scraper, see <a
         * href="https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html">Using an Amazon Web
         * Services managed collector</a> in the <i>Amazon Managed Service for Prometheus User Guide</i>.
         * </p>
         * </note>
         * 
         * @param scrapeConfiguration
         *        Contains the base-64 encoded YAML configuration for the scraper.</p> <note>
         *        <p>
         *        For more information about configuring a scraper, see <a
         *        href="https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html">Using an
         *        Amazon Web Services managed collector</a> in the <i>Amazon Managed Service for Prometheus User
         *        Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scrapeConfiguration(ScrapeConfiguration scrapeConfiguration);

        /**
         * <p>
         * Contains the base-64 encoded YAML configuration for the scraper.
         * </p>
         * <note>
         * <p>
         * For more information about configuring a scraper, see <a
         * href="https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html">Using an Amazon Web
         * Services managed collector</a> in the <i>Amazon Managed Service for Prometheus User Guide</i>.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link ScrapeConfiguration.Builder}
         * avoiding the need to create one manually via {@link ScrapeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScrapeConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #scrapeConfiguration(ScrapeConfiguration)}.
         * 
         * @param scrapeConfiguration
         *        a consumer that will call methods on {@link ScrapeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scrapeConfiguration(ScrapeConfiguration)
         */
        default Builder scrapeConfiguration(Consumer<ScrapeConfiguration.Builder> scrapeConfiguration) {
            return scrapeConfiguration(ScrapeConfiguration.builder().applyMutation(scrapeConfiguration).build());
        }

        /**
         * <p>
         * The ID of the scraper to update.
         * </p>
         * 
         * @param scraperId
         *        The ID of the scraper to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scraperId(String scraperId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmpRequest.BuilderImpl implements Builder {
        private String alias;

        private String clientToken;

        private Destination destination;

        private RoleConfiguration roleConfiguration;

        private ScrapeConfiguration scrapeConfiguration;

        private String scraperId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateScraperRequest model) {
            super(model);
            alias(model.alias);
            clientToken(model.clientToken);
            destination(model.destination);
            roleConfiguration(model.roleConfiguration);
            scrapeConfiguration(model.scrapeConfiguration);
            scraperId(model.scraperId);
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Destination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final RoleConfiguration.Builder getRoleConfiguration() {
            return roleConfiguration != null ? roleConfiguration.toBuilder() : null;
        }

        public final void setRoleConfiguration(RoleConfiguration.BuilderImpl roleConfiguration) {
            this.roleConfiguration = roleConfiguration != null ? roleConfiguration.build() : null;
        }

        @Override
        public final Builder roleConfiguration(RoleConfiguration roleConfiguration) {
            this.roleConfiguration = roleConfiguration;
            return this;
        }

        public final ScrapeConfiguration.Builder getScrapeConfiguration() {
            return scrapeConfiguration != null ? scrapeConfiguration.toBuilder() : null;
        }

        public final void setScrapeConfiguration(ScrapeConfiguration.BuilderImpl scrapeConfiguration) {
            this.scrapeConfiguration = scrapeConfiguration != null ? scrapeConfiguration.build() : null;
        }

        @Override
        public final Builder scrapeConfiguration(ScrapeConfiguration scrapeConfiguration) {
            this.scrapeConfiguration = scrapeConfiguration;
            return this;
        }

        public final String getScraperId() {
            return scraperId;
        }

        public final void setScraperId(String scraperId) {
            this.scraperId = scraperId;
        }

        @Override
        public final Builder scraperId(String scraperId) {
            this.scraperId = scraperId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateScraperRequest build() {
            return new UpdateScraperRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
