/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of an <code>UpdateWorkspaceAlias</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkspaceAliasRequest extends AmpRequest implements
        ToCopyableBuilder<UpdateWorkspaceAliasRequest.Builder, UpdateWorkspaceAliasRequest> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("alias")
            .getter(getter(UpdateWorkspaceAliasRequest::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateWorkspaceAliasRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(UpdateWorkspaceAliasRequest::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD,
            CLIENT_TOKEN_FIELD, WORKSPACE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String alias;

    private final String clientToken;

    private final String workspaceId;

    private UpdateWorkspaceAliasRequest(BuilderImpl builder) {
        super(builder);
        this.alias = builder.alias;
        this.clientToken = builder.clientToken;
        this.workspaceId = builder.workspaceId;
    }

    /**
     * <p>
     * The new alias for the workspace. It does not need to be unique.
     * </p>
     * <p>
     * Amazon Managed Service for Prometheus will automatically strip any blank spaces from the beginning and end of the
     * alias that you specify.
     * </p>
     * 
     * @return The new alias for the workspace. It does not need to be unique.</p>
     *         <p>
     *         Amazon Managed Service for Prometheus will automatically strip any blank spaces from the beginning and
     *         end of the alias that you specify.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.
     * </p>
     * 
     * @return A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ID of the workspace to update.
     * </p>
     * 
     * @return The ID of the workspace to update.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkspaceAliasRequest)) {
            return false;
        }
        UpdateWorkspaceAliasRequest other = (UpdateWorkspaceAliasRequest) obj;
        return Objects.equals(alias(), other.alias()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(workspaceId(), other.workspaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWorkspaceAliasRequest").add("Alias", alias()).add("ClientToken", clientToken())
                .add("WorkspaceId", workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("alias", ALIAS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkspaceAliasRequest, T> g) {
        return obj -> g.apply((UpdateWorkspaceAliasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmpRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWorkspaceAliasRequest> {
        /**
         * <p>
         * The new alias for the workspace. It does not need to be unique.
         * </p>
         * <p>
         * Amazon Managed Service for Prometheus will automatically strip any blank spaces from the beginning and end of
         * the alias that you specify.
         * </p>
         * 
         * @param alias
         *        The new alias for the workspace. It does not need to be unique.</p>
         *        <p>
         *        Amazon Managed Service for Prometheus will automatically strip any blank spaces from the beginning and
         *        end of the alias that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.
         * </p>
         * 
         * @param clientToken
         *        A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ID of the workspace to update.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmpRequest.BuilderImpl implements Builder {
        private String alias;

        private String clientToken;

        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkspaceAliasRequest model) {
            super(model);
            alias(model.alias);
            clientToken(model.clientToken);
            workspaceId(model.workspaceId);
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkspaceAliasRequest build() {
            return new UpdateWorkspaceAliasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
