/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amp.model.LabelSetCopier;
import software.amazon.awssdk.services.amp.model.LimitsPerLabelSetEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LimitsPerLabelSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LimitsPerLabelSet> {
    private static final SdkField<Map<String, String>> LABEL_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("labelSet").getter(LimitsPerLabelSet.getter(LimitsPerLabelSet::labelSet)).setter(LimitsPerLabelSet.setter(Builder::labelSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labelSet").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<LimitsPerLabelSetEntry> LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("limits").getter(LimitsPerLabelSet.getter(LimitsPerLabelSet::limits)).setter(LimitsPerLabelSet.setter(Builder::limits)).constructor(LimitsPerLabelSetEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limits").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_SET_FIELD, LIMITS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LimitsPerLabelSet.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> labelSet;
    private final LimitsPerLabelSetEntry limits;

    private LimitsPerLabelSet(BuilderImpl builder) {
        this.labelSet = builder.labelSet;
        this.limits = builder.limits;
    }

    public final boolean hasLabelSet() {
        return this.labelSet != null && !(this.labelSet instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> labelSet() {
        return this.labelSet;
    }

    public final LimitsPerLabelSetEntry limits() {
        return this.limits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabelSet() ? this.labelSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.limits());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LimitsPerLabelSet)) {
            return false;
        }
        LimitsPerLabelSet other = (LimitsPerLabelSet)obj;
        return this.hasLabelSet() == other.hasLabelSet() && Objects.equals(this.labelSet(), other.labelSet()) && Objects.equals(this.limits(), other.limits());
    }

    public final String toString() {
        return ToString.builder((String)"LimitsPerLabelSet").add("LabelSet", this.hasLabelSet() ? this.labelSet() : null).add("Limits", (Object)this.limits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "labelSet": {
                return Optional.ofNullable(clazz.cast(this.labelSet()));
            }
            case "limits": {
                return Optional.ofNullable(clazz.cast(this.limits()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("labelSet", LABEL_SET_FIELD);
        map.put("limits", LIMITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LimitsPerLabelSet, T> g) {
        return obj -> g.apply((LimitsPerLabelSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> labelSet = DefaultSdkAutoConstructMap.getInstance();
        private LimitsPerLabelSetEntry limits;

        private BuilderImpl() {
        }

        private BuilderImpl(LimitsPerLabelSet model) {
            this.labelSet(model.labelSet);
            this.limits(model.limits);
        }

        public final Map<String, String> getLabelSet() {
            if (this.labelSet instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.labelSet;
        }

        public final void setLabelSet(Map<String, String> labelSet) {
            this.labelSet = LabelSetCopier.copy(labelSet);
        }

        @Override
        public final Builder labelSet(Map<String, String> labelSet) {
            this.labelSet = LabelSetCopier.copy(labelSet);
            return this;
        }

        public final LimitsPerLabelSetEntry.Builder getLimits() {
            return this.limits != null ? this.limits.toBuilder() : null;
        }

        public final void setLimits(LimitsPerLabelSetEntry.BuilderImpl limits) {
            this.limits = limits != null ? limits.build() : null;
        }

        @Override
        public final Builder limits(LimitsPerLabelSetEntry limits) {
            this.limits = limits;
            return this;
        }

        public LimitsPerLabelSet build() {
            return new LimitsPerLabelSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LimitsPerLabelSet> {
        public Builder labelSet(Map<String, String> var1);

        public Builder limits(LimitsPerLabelSetEntry var1);

        default public Builder limits(Consumer<LimitsPerLabelSetEntry.Builder> limits) {
            return this.limits((LimitsPerLabelSetEntry)((LimitsPerLabelSetEntry.Builder)LimitsPerLabelSetEntry.builder().applyMutation(limits)).build());
        }
    }
}

