/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.amp.AmpClient;
import software.amazon.awssdk.services.amp.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.amp.model.AmpRequest;
import software.amazon.awssdk.services.amp.model.DescribeScraperRequest;
import software.amazon.awssdk.services.amp.model.DescribeScraperResponse;
import software.amazon.awssdk.services.amp.model.DescribeWorkspaceRequest;
import software.amazon.awssdk.services.amp.model.DescribeWorkspaceResponse;
import software.amazon.awssdk.services.amp.waiters.AmpWaiter;
import software.amazon.awssdk.services.amp.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultAmpWaiter
implements AmpWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final AmpClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeScraperResponse> scraperActiveWaiter;
    private final Waiter<DescribeScraperResponse> scraperDeletedWaiter;
    private final Waiter<DescribeWorkspaceResponse> workspaceActiveWaiter;
    private final Waiter<DescribeWorkspaceResponse> workspaceDeletedWaiter;

    private DefaultAmpWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (AmpClient)AmpClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.scraperActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeScraperResponse.class).acceptors(DefaultAmpWaiter.scraperActiveWaiterAcceptors())).overrideConfiguration(DefaultAmpWaiter.scraperActiveWaiterConfig(builder.overrideConfiguration))).build();
        this.scraperDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeScraperResponse.class).acceptors(DefaultAmpWaiter.scraperDeletedWaiterAcceptors())).overrideConfiguration(DefaultAmpWaiter.scraperDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.workspaceActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeWorkspaceResponse.class).acceptors(DefaultAmpWaiter.workspaceActiveWaiterAcceptors())).overrideConfiguration(DefaultAmpWaiter.workspaceActiveWaiterConfig(builder.overrideConfiguration))).build();
        this.workspaceDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeWorkspaceResponse.class).acceptors(DefaultAmpWaiter.workspaceDeletedWaiterAcceptors())).overrideConfiguration(DefaultAmpWaiter.workspaceDeletedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeScraperResponse> waitUntilScraperActive(DescribeScraperRequest describeScraperRequest) {
        return this.scraperActiveWaiter.run(() -> this.client.describeScraper(this.applyWaitersUserAgent(describeScraperRequest)));
    }

    @Override
    public WaiterResponse<DescribeScraperResponse> waitUntilScraperActive(DescribeScraperRequest describeScraperRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.scraperActiveWaiter.run(() -> this.client.describeScraper(this.applyWaitersUserAgent(describeScraperRequest)), DefaultAmpWaiter.scraperActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeScraperResponse> waitUntilScraperDeleted(DescribeScraperRequest describeScraperRequest) {
        return this.scraperDeletedWaiter.run(() -> this.client.describeScraper(this.applyWaitersUserAgent(describeScraperRequest)));
    }

    @Override
    public WaiterResponse<DescribeScraperResponse> waitUntilScraperDeleted(DescribeScraperRequest describeScraperRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.scraperDeletedWaiter.run(() -> this.client.describeScraper(this.applyWaitersUserAgent(describeScraperRequest)), DefaultAmpWaiter.scraperDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeWorkspaceResponse> waitUntilWorkspaceActive(DescribeWorkspaceRequest describeWorkspaceRequest) {
        return this.workspaceActiveWaiter.run(() -> this.client.describeWorkspace(this.applyWaitersUserAgent(describeWorkspaceRequest)));
    }

    @Override
    public WaiterResponse<DescribeWorkspaceResponse> waitUntilWorkspaceActive(DescribeWorkspaceRequest describeWorkspaceRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.workspaceActiveWaiter.run(() -> this.client.describeWorkspace(this.applyWaitersUserAgent(describeWorkspaceRequest)), DefaultAmpWaiter.workspaceActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeWorkspaceResponse> waitUntilWorkspaceDeleted(DescribeWorkspaceRequest describeWorkspaceRequest) {
        return this.workspaceDeletedWaiter.run(() -> this.client.describeWorkspace(this.applyWaitersUserAgent(describeWorkspaceRequest)));
    }

    @Override
    public WaiterResponse<DescribeWorkspaceResponse> waitUntilWorkspaceDeleted(DescribeWorkspaceRequest describeWorkspaceRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.workspaceDeletedWaiter.run(() -> this.client.describeWorkspace(this.applyWaitersUserAgent(describeWorkspaceRequest)), DefaultAmpWaiter.workspaceDeletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeScraperResponse>> scraperActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeScraperResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeScraperResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("scraper").field("status").field("statusCode").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("scraper").field("status").field("statusCode").value(), "CREATION_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (scraper.status.statusCode=CREATION_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeScraperResponse>> scraperDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeScraperResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeScraperResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultAmpWaiter.errorCode(error), "ResourceNotFoundException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("scraper").field("status").field("statusCode").value(), "DELETION_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (scraper.status.statusCode=DELETION_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeWorkspaceResponse>> workspaceActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeWorkspaceResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeWorkspaceResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("workspace").field("status").field("statusCode").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("workspace").field("status").field("statusCode").value(), "UPDATING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("workspace").field("status").field("statusCode").value(), "CREATING");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeWorkspaceResponse>> workspaceDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeWorkspaceResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeWorkspaceResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultAmpWaiter.errorCode(error), "ResourceNotFoundException")));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("workspace").field("status").field("statusCode").value(), "DELETING");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration scraperActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration scraperDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration workspaceActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration workspaceDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static AmpWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends AmpRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((AmpRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements AmpWaiter.Builder {
        private AmpClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public AmpWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public AmpWaiter.Builder client(AmpClient client) {
            this.client = client;
            return this;
        }

        @Override
        public AmpWaiter build() {
            return new DefaultAmpWaiter(this);
        }
    }
}

