/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amp.model.LimitsPerLabelSet;
import software.amazon.awssdk.services.amp.model.LimitsPerLabelSetListCopier;
import software.amazon.awssdk.services.amp.model.WorkspaceConfigurationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkspaceConfigurationDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkspaceConfigurationDescription> {
    private static final SdkField<WorkspaceConfigurationStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(WorkspaceConfigurationDescription.getter(WorkspaceConfigurationDescription::status)).setter(WorkspaceConfigurationDescription.setter(Builder::status)).constructor(WorkspaceConfigurationStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<LimitsPerLabelSet>> LIMITS_PER_LABEL_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("limitsPerLabelSet").getter(WorkspaceConfigurationDescription.getter(WorkspaceConfigurationDescription::limitsPerLabelSet)).setter(WorkspaceConfigurationDescription.setter(Builder::limitsPerLabelSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limitsPerLabelSet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LimitsPerLabelSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> RETENTION_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("retentionPeriodInDays").getter(WorkspaceConfigurationDescription.getter(WorkspaceConfigurationDescription::retentionPeriodInDays)).setter(WorkspaceConfigurationDescription.setter(Builder::retentionPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriodInDays").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, LIMITS_PER_LABEL_SET_FIELD, RETENTION_PERIOD_IN_DAYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkspaceConfigurationDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final WorkspaceConfigurationStatus status;
    private final List<LimitsPerLabelSet> limitsPerLabelSet;
    private final Integer retentionPeriodInDays;

    private WorkspaceConfigurationDescription(BuilderImpl builder) {
        this.status = builder.status;
        this.limitsPerLabelSet = builder.limitsPerLabelSet;
        this.retentionPeriodInDays = builder.retentionPeriodInDays;
    }

    public final WorkspaceConfigurationStatus status() {
        return this.status;
    }

    public final boolean hasLimitsPerLabelSet() {
        return this.limitsPerLabelSet != null && !(this.limitsPerLabelSet instanceof SdkAutoConstructList);
    }

    public final List<LimitsPerLabelSet> limitsPerLabelSet() {
        return this.limitsPerLabelSet;
    }

    public final Integer retentionPeriodInDays() {
        return this.retentionPeriodInDays;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLimitsPerLabelSet() ? this.limitsPerLabelSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriodInDays());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceConfigurationDescription)) {
            return false;
        }
        WorkspaceConfigurationDescription other = (WorkspaceConfigurationDescription)obj;
        return Objects.equals(this.status(), other.status()) && this.hasLimitsPerLabelSet() == other.hasLimitsPerLabelSet() && Objects.equals(this.limitsPerLabelSet(), other.limitsPerLabelSet()) && Objects.equals(this.retentionPeriodInDays(), other.retentionPeriodInDays());
    }

    public final String toString() {
        return ToString.builder((String)"WorkspaceConfigurationDescription").add("Status", (Object)this.status()).add("LimitsPerLabelSet", this.hasLimitsPerLabelSet() ? this.limitsPerLabelSet() : null).add("RetentionPeriodInDays", (Object)this.retentionPeriodInDays()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "limitsPerLabelSet": {
                return Optional.ofNullable(clazz.cast(this.limitsPerLabelSet()));
            }
            case "retentionPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriodInDays()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", STATUS_FIELD);
        map.put("limitsPerLabelSet", LIMITS_PER_LABEL_SET_FIELD);
        map.put("retentionPeriodInDays", RETENTION_PERIOD_IN_DAYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceConfigurationDescription, T> g) {
        return obj -> g.apply((WorkspaceConfigurationDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private WorkspaceConfigurationStatus status;
        private List<LimitsPerLabelSet> limitsPerLabelSet = DefaultSdkAutoConstructList.getInstance();
        private Integer retentionPeriodInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceConfigurationDescription model) {
            this.status(model.status);
            this.limitsPerLabelSet(model.limitsPerLabelSet);
            this.retentionPeriodInDays(model.retentionPeriodInDays);
        }

        public final WorkspaceConfigurationStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(WorkspaceConfigurationStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(WorkspaceConfigurationStatus status) {
            this.status = status;
            return this;
        }

        public final List<LimitsPerLabelSet.Builder> getLimitsPerLabelSet() {
            List<LimitsPerLabelSet.Builder> result = LimitsPerLabelSetListCopier.copyToBuilder(this.limitsPerLabelSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLimitsPerLabelSet(Collection<LimitsPerLabelSet.BuilderImpl> limitsPerLabelSet) {
            this.limitsPerLabelSet = LimitsPerLabelSetListCopier.copyFromBuilder(limitsPerLabelSet);
        }

        @Override
        public final Builder limitsPerLabelSet(Collection<LimitsPerLabelSet> limitsPerLabelSet) {
            this.limitsPerLabelSet = LimitsPerLabelSetListCopier.copy(limitsPerLabelSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limitsPerLabelSet(LimitsPerLabelSet ... limitsPerLabelSet) {
            this.limitsPerLabelSet(Arrays.asList(limitsPerLabelSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limitsPerLabelSet(Consumer<LimitsPerLabelSet.Builder> ... limitsPerLabelSet) {
            this.limitsPerLabelSet(Stream.of(limitsPerLabelSet).map(c -> (LimitsPerLabelSet)((LimitsPerLabelSet.Builder)LimitsPerLabelSet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getRetentionPeriodInDays() {
            return this.retentionPeriodInDays;
        }

        public final void setRetentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
        }

        @Override
        public final Builder retentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
            return this;
        }

        public WorkspaceConfigurationDescription build() {
            return new WorkspaceConfigurationDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkspaceConfigurationDescription> {
        public Builder status(WorkspaceConfigurationStatus var1);

        default public Builder status(Consumer<WorkspaceConfigurationStatus.Builder> status) {
            return this.status((WorkspaceConfigurationStatus)((WorkspaceConfigurationStatus.Builder)WorkspaceConfigurationStatus.builder().applyMutation(status)).build());
        }

        public Builder limitsPerLabelSet(Collection<LimitsPerLabelSet> var1);

        public Builder limitsPerLabelSet(LimitsPerLabelSet ... var1);

        public Builder limitsPerLabelSet(Consumer<LimitsPerLabelSet.Builder> ... var1);

        public Builder retentionPeriodInDays(Integer var1);
    }
}

