/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>CreateScraper</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateScraperRequest extends AmpRequest implements
        ToCopyableBuilder<CreateScraperRequest.Builder, CreateScraperRequest> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("alias")
            .getter(getter(CreateScraperRequest::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()).build();

    private static final SdkField<ScrapeConfiguration> SCRAPE_CONFIGURATION_FIELD = SdkField
            .<ScrapeConfiguration> builder(MarshallingType.SDK_POJO).memberName("scrapeConfiguration")
            .getter(getter(CreateScraperRequest::scrapeConfiguration)).setter(setter(Builder::scrapeConfiguration))
            .constructor(ScrapeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scrapeConfiguration").build())
            .build();

    private static final SdkField<Source> SOURCE_FIELD = SdkField.<Source> builder(MarshallingType.SDK_POJO).memberName("source")
            .getter(getter(CreateScraperRequest::source)).setter(setter(Builder::source)).constructor(Source::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<Destination> DESTINATION_FIELD = SdkField.<Destination> builder(MarshallingType.SDK_POJO)
            .memberName("destination").getter(getter(CreateScraperRequest::destination)).setter(setter(Builder::destination))
            .constructor(Destination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<RoleConfiguration> ROLE_CONFIGURATION_FIELD = SdkField
            .<RoleConfiguration> builder(MarshallingType.SDK_POJO).memberName("roleConfiguration")
            .getter(getter(CreateScraperRequest::roleConfiguration)).setter(setter(Builder::roleConfiguration))
            .constructor(RoleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleConfiguration").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateScraperRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateScraperRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ALIAS_FIELD, SCRAPE_CONFIGURATION_FIELD, SOURCE_FIELD, DESTINATION_FIELD, ROLE_CONFIGURATION_FIELD,
                    CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String alias;

    private final ScrapeConfiguration scrapeConfiguration;

    private final Source source;

    private final Destination destination;

    private final RoleConfiguration roleConfiguration;

    private final String clientToken;

    private final Map<String, String> tags;

    private CreateScraperRequest(BuilderImpl builder) {
        super(builder);
        this.alias = builder.alias;
        this.scrapeConfiguration = builder.scrapeConfiguration;
        this.source = builder.source;
        this.destination = builder.destination;
        this.roleConfiguration = builder.roleConfiguration;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * (optional) An alias to associate with the scraper. This is for your use, and does not need to be unique.
     * </p>
     * 
     * @return (optional) An alias to associate with the scraper. This is for your use, and does not need to be unique.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The configuration file to use in the new scraper. For more information, see <a href=
     * "https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration"
     * >Scraper configuration</a> in the <i>Amazon Managed Service for Prometheus User Guide</i>.
     * </p>
     * 
     * @return The configuration file to use in the new scraper. For more information, see <a href=
     *         "https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration"
     *         >Scraper configuration</a> in the <i>Amazon Managed Service for Prometheus User Guide</i>.
     */
    public final ScrapeConfiguration scrapeConfiguration() {
        return scrapeConfiguration;
    }

    /**
     * <p>
     * The Amazon EKS or Amazon Web Services cluster from which the scraper will collect metrics.
     * </p>
     * 
     * @return The Amazon EKS or Amazon Web Services cluster from which the scraper will collect metrics.
     */
    public final Source source() {
        return source;
    }

    /**
     * <p>
     * The Amazon Managed Service for Prometheus workspace to send metrics to.
     * </p>
     * 
     * @return The Amazon Managed Service for Prometheus workspace to send metrics to.
     */
    public final Destination destination() {
        return destination;
    }

    /**
     * <p>
     * Use this structure to enable cross-account access, so that you can use a target account to access Prometheus
     * metrics from source accounts.
     * </p>
     * 
     * @return Use this structure to enable cross-account access, so that you can use a target account to access
     *         Prometheus metrics from source accounts.
     */
    public final RoleConfiguration roleConfiguration() {
        return roleConfiguration;
    }

    /**
     * <p>
     * (Optional) A unique, case-sensitive identifier that you can provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return (Optional) A unique, case-sensitive identifier that you can provide to ensure the idempotency of the
     *         request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * (Optional) The list of tag keys and values to associate with the scraper.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return (Optional) The list of tag keys and values to associate with the scraper.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(scrapeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(roleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScraperRequest)) {
            return false;
        }
        CreateScraperRequest other = (CreateScraperRequest) obj;
        return Objects.equals(alias(), other.alias()) && Objects.equals(scrapeConfiguration(), other.scrapeConfiguration())
                && Objects.equals(source(), other.source()) && Objects.equals(destination(), other.destination())
                && Objects.equals(roleConfiguration(), other.roleConfiguration())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateScraperRequest").add("Alias", alias()).add("ScrapeConfiguration", scrapeConfiguration())
                .add("Source", source()).add("Destination", destination()).add("RoleConfiguration", roleConfiguration())
                .add("ClientToken", clientToken()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "scrapeConfiguration":
            return Optional.ofNullable(clazz.cast(scrapeConfiguration()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "roleConfiguration":
            return Optional.ofNullable(clazz.cast(roleConfiguration()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("alias", ALIAS_FIELD);
        map.put("scrapeConfiguration", SCRAPE_CONFIGURATION_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("destination", DESTINATION_FIELD);
        map.put("roleConfiguration", ROLE_CONFIGURATION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateScraperRequest, T> g) {
        return obj -> g.apply((CreateScraperRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AmpRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateScraperRequest> {
        /**
         * <p>
         * (optional) An alias to associate with the scraper. This is for your use, and does not need to be unique.
         * </p>
         * 
         * @param alias
         *        (optional) An alias to associate with the scraper. This is for your use, and does not need to be
         *        unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The configuration file to use in the new scraper. For more information, see <a href=
         * "https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration"
         * >Scraper configuration</a> in the <i>Amazon Managed Service for Prometheus User Guide</i>.
         * </p>
         * 
         * @param scrapeConfiguration
         *        The configuration file to use in the new scraper. For more information, see <a href=
         *        "https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration"
         *        >Scraper configuration</a> in the <i>Amazon Managed Service for Prometheus User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scrapeConfiguration(ScrapeConfiguration scrapeConfiguration);

        /**
         * <p>
         * The configuration file to use in the new scraper. For more information, see <a href=
         * "https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration"
         * >Scraper configuration</a> in the <i>Amazon Managed Service for Prometheus User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScrapeConfiguration.Builder} avoiding the
         * need to create one manually via {@link ScrapeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScrapeConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #scrapeConfiguration(ScrapeConfiguration)}.
         * 
         * @param scrapeConfiguration
         *        a consumer that will call methods on {@link ScrapeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scrapeConfiguration(ScrapeConfiguration)
         */
        default Builder scrapeConfiguration(Consumer<ScrapeConfiguration.Builder> scrapeConfiguration) {
            return scrapeConfiguration(ScrapeConfiguration.builder().applyMutation(scrapeConfiguration).build());
        }

        /**
         * <p>
         * The Amazon EKS or Amazon Web Services cluster from which the scraper will collect metrics.
         * </p>
         * 
         * @param source
         *        The Amazon EKS or Amazon Web Services cluster from which the scraper will collect metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(Source source);

        /**
         * <p>
         * The Amazon EKS or Amazon Web Services cluster from which the scraper will collect metrics.
         * </p>
         * This is a convenience method that creates an instance of the {@link Source.Builder} avoiding the need to
         * create one manually via {@link Source#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Source.Builder#build()} is called immediately and its result is
         * passed to {@link #source(Source)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(Source)
         */
        default Builder source(Consumer<Source.Builder> source) {
            return source(Source.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The Amazon Managed Service for Prometheus workspace to send metrics to.
         * </p>
         * 
         * @param destination
         *        The Amazon Managed Service for Prometheus workspace to send metrics to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(Destination destination);

        /**
         * <p>
         * The Amazon Managed Service for Prometheus workspace to send metrics to.
         * </p>
         * This is a convenience method that creates an instance of the {@link Destination.Builder} avoiding the need to
         * create one manually via {@link Destination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Destination.Builder#build()} is called immediately and its result
         * is passed to {@link #destination(Destination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(Destination)
         */
        default Builder destination(Consumer<Destination.Builder> destination) {
            return destination(Destination.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * Use this structure to enable cross-account access, so that you can use a target account to access Prometheus
         * metrics from source accounts.
         * </p>
         * 
         * @param roleConfiguration
         *        Use this structure to enable cross-account access, so that you can use a target account to access
         *        Prometheus metrics from source accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleConfiguration(RoleConfiguration roleConfiguration);

        /**
         * <p>
         * Use this structure to enable cross-account access, so that you can use a target account to access Prometheus
         * metrics from source accounts.
         * </p>
         * This is a convenience method that creates an instance of the {@link RoleConfiguration.Builder} avoiding the
         * need to create one manually via {@link RoleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoleConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #roleConfiguration(RoleConfiguration)}.
         * 
         * @param roleConfiguration
         *        a consumer that will call methods on {@link RoleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #roleConfiguration(RoleConfiguration)
         */
        default Builder roleConfiguration(Consumer<RoleConfiguration.Builder> roleConfiguration) {
            return roleConfiguration(RoleConfiguration.builder().applyMutation(roleConfiguration).build());
        }

        /**
         * <p>
         * (Optional) A unique, case-sensitive identifier that you can provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        (Optional) A unique, case-sensitive identifier that you can provide to ensure the idempotency of the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * (Optional) The list of tag keys and values to associate with the scraper.
         * </p>
         * 
         * @param tags
         *        (Optional) The list of tag keys and values to associate with the scraper.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmpRequest.BuilderImpl implements Builder {
        private String alias;

        private ScrapeConfiguration scrapeConfiguration;

        private Source source;

        private Destination destination;

        private RoleConfiguration roleConfiguration;

        private String clientToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScraperRequest model) {
            super(model);
            alias(model.alias);
            scrapeConfiguration(model.scrapeConfiguration);
            source(model.source);
            destination(model.destination);
            roleConfiguration(model.roleConfiguration);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final ScrapeConfiguration.Builder getScrapeConfiguration() {
            return scrapeConfiguration != null ? scrapeConfiguration.toBuilder() : null;
        }

        public final void setScrapeConfiguration(ScrapeConfiguration.BuilderImpl scrapeConfiguration) {
            this.scrapeConfiguration = scrapeConfiguration != null ? scrapeConfiguration.build() : null;
        }

        @Override
        public final Builder scrapeConfiguration(ScrapeConfiguration scrapeConfiguration) {
            this.scrapeConfiguration = scrapeConfiguration;
            return this;
        }

        public final Source.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final Destination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final RoleConfiguration.Builder getRoleConfiguration() {
            return roleConfiguration != null ? roleConfiguration.toBuilder() : null;
        }

        public final void setRoleConfiguration(RoleConfiguration.BuilderImpl roleConfiguration) {
            this.roleConfiguration = roleConfiguration != null ? roleConfiguration.build() : null;
        }

        @Override
        public final Builder roleConfiguration(RoleConfiguration roleConfiguration) {
            this.roleConfiguration = roleConfiguration;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateScraperRequest build() {
            return new CreateScraperRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
