/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAnomalyDetectorResponse extends AmpResponse implements
        ToCopyableBuilder<DescribeAnomalyDetectorResponse.Builder, DescribeAnomalyDetectorResponse> {
    private static final SdkField<AnomalyDetectorDescription> ANOMALY_DETECTOR_FIELD = SdkField
            .<AnomalyDetectorDescription> builder(MarshallingType.SDK_POJO).memberName("anomalyDetector")
            .getter(getter(DescribeAnomalyDetectorResponse::anomalyDetector)).setter(setter(Builder::anomalyDetector))
            .constructor(AnomalyDetectorDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalyDetector").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AnomalyDetectorDescription anomalyDetector;

    private DescribeAnomalyDetectorResponse(BuilderImpl builder) {
        super(builder);
        this.anomalyDetector = builder.anomalyDetector;
    }

    /**
     * <p>
     * The detailed information about the anomaly detector.
     * </p>
     * 
     * @return The detailed information about the anomaly detector.
     */
    public final AnomalyDetectorDescription anomalyDetector() {
        return anomalyDetector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetector());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAnomalyDetectorResponse)) {
            return false;
        }
        DescribeAnomalyDetectorResponse other = (DescribeAnomalyDetectorResponse) obj;
        return Objects.equals(anomalyDetector(), other.anomalyDetector());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAnomalyDetectorResponse").add("AnomalyDetector", anomalyDetector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "anomalyDetector":
            return Optional.ofNullable(clazz.cast(anomalyDetector()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("anomalyDetector", ANOMALY_DETECTOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAnomalyDetectorResponse, T> g) {
        return obj -> g.apply((DescribeAnomalyDetectorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AmpResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAnomalyDetectorResponse> {
        /**
         * <p>
         * The detailed information about the anomaly detector.
         * </p>
         * 
         * @param anomalyDetector
         *        The detailed information about the anomaly detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetector(AnomalyDetectorDescription anomalyDetector);

        /**
         * <p>
         * The detailed information about the anomaly detector.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnomalyDetectorDescription.Builder}
         * avoiding the need to create one manually via {@link AnomalyDetectorDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnomalyDetectorDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #anomalyDetector(AnomalyDetectorDescription)}.
         * 
         * @param anomalyDetector
         *        a consumer that will call methods on {@link AnomalyDetectorDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anomalyDetector(AnomalyDetectorDescription)
         */
        default Builder anomalyDetector(Consumer<AnomalyDetectorDescription.Builder> anomalyDetector) {
            return anomalyDetector(AnomalyDetectorDescription.builder().applyMutation(anomalyDetector).build());
        }
    }

    static final class BuilderImpl extends AmpResponse.BuilderImpl implements Builder {
        private AnomalyDetectorDescription anomalyDetector;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAnomalyDetectorResponse model) {
            super(model);
            anomalyDetector(model.anomalyDetector);
        }

        public final AnomalyDetectorDescription.Builder getAnomalyDetector() {
            return anomalyDetector != null ? anomalyDetector.toBuilder() : null;
        }

        public final void setAnomalyDetector(AnomalyDetectorDescription.BuilderImpl anomalyDetector) {
            this.anomalyDetector = anomalyDetector != null ? anomalyDetector.build() : null;
        }

        @Override
        public final Builder anomalyDetector(AnomalyDetectorDescription anomalyDetector) {
            this.anomalyDetector = anomalyDetector;
            return this;
        }

        @Override
        public DescribeAnomalyDetectorResponse build() {
            return new DescribeAnomalyDetectorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
