/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeScraperLoggingConfigurationResponse extends AmpResponse implements
        ToCopyableBuilder<DescribeScraperLoggingConfigurationResponse.Builder, DescribeScraperLoggingConfigurationResponse> {
    private static final SdkField<ScraperLoggingConfigurationStatus> STATUS_FIELD = SdkField
            .<ScraperLoggingConfigurationStatus> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(DescribeScraperLoggingConfigurationResponse::status)).setter(setter(Builder::status))
            .constructor(ScraperLoggingConfigurationStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> SCRAPER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scraperId").getter(getter(DescribeScraperLoggingConfigurationResponse::scraperId))
            .setter(setter(Builder::scraperId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scraperId").build()).build();

    private static final SdkField<ScraperLoggingDestination> LOGGING_DESTINATION_FIELD = SdkField
            .<ScraperLoggingDestination> builder(MarshallingType.SDK_POJO).memberName("loggingDestination")
            .getter(getter(DescribeScraperLoggingConfigurationResponse::loggingDestination))
            .setter(setter(Builder::loggingDestination)).constructor(ScraperLoggingDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingDestination").build())
            .build();

    private static final SdkField<List<ScraperComponent>> SCRAPER_COMPONENTS_FIELD = SdkField
            .<List<ScraperComponent>> builder(MarshallingType.LIST)
            .memberName("scraperComponents")
            .getter(getter(DescribeScraperLoggingConfigurationResponse::scraperComponents))
            .setter(setter(Builder::scraperComponents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scraperComponents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScraperComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScraperComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedAt").getter(getter(DescribeScraperLoggingConfigurationResponse::modifiedAt))
            .setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            SCRAPER_ID_FIELD, LOGGING_DESTINATION_FIELD, SCRAPER_COMPONENTS_FIELD, MODIFIED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ScraperLoggingConfigurationStatus status;

    private final String scraperId;

    private final ScraperLoggingDestination loggingDestination;

    private final List<ScraperComponent> scraperComponents;

    private final Instant modifiedAt;

    private DescribeScraperLoggingConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.scraperId = builder.scraperId;
        this.loggingDestination = builder.loggingDestination;
        this.scraperComponents = builder.scraperComponents;
        this.modifiedAt = builder.modifiedAt;
    }

    /**
     * <p>
     * The status of the scraper logging configuration.
     * </p>
     * 
     * @return The status of the scraper logging configuration.
     */
    public final ScraperLoggingConfigurationStatus status() {
        return status;
    }

    /**
     * <p>
     * The ID of the scraper.
     * </p>
     * 
     * @return The ID of the scraper.
     */
    public final String scraperId() {
        return scraperId;
    }

    /**
     * <p>
     * The destination where scraper logs are sent.
     * </p>
     * 
     * @return The destination where scraper logs are sent.
     */
    public final ScraperLoggingDestination loggingDestination() {
        return loggingDestination;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScraperComponents property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScraperComponents() {
        return scraperComponents != null && !(scraperComponents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of scraper components configured for logging.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScraperComponents} method.
     * </p>
     * 
     * @return The list of scraper components configured for logging.
     */
    public final List<ScraperComponent> scraperComponents() {
        return scraperComponents;
    }

    /**
     * <p>
     * The date and time when the logging configuration was last modified.
     * </p>
     * 
     * @return The date and time when the logging configuration was last modified.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(scraperId());
        hashCode = 31 * hashCode + Objects.hashCode(loggingDestination());
        hashCode = 31 * hashCode + Objects.hashCode(hasScraperComponents() ? scraperComponents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScraperLoggingConfigurationResponse)) {
            return false;
        }
        DescribeScraperLoggingConfigurationResponse other = (DescribeScraperLoggingConfigurationResponse) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(scraperId(), other.scraperId())
                && Objects.equals(loggingDestination(), other.loggingDestination())
                && hasScraperComponents() == other.hasScraperComponents()
                && Objects.equals(scraperComponents(), other.scraperComponents())
                && Objects.equals(modifiedAt(), other.modifiedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeScraperLoggingConfigurationResponse").add("Status", status())
                .add("ScraperId", scraperId()).add("LoggingDestination", loggingDestination())
                .add("ScraperComponents", hasScraperComponents() ? scraperComponents() : null).add("ModifiedAt", modifiedAt())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "scraperId":
            return Optional.ofNullable(clazz.cast(scraperId()));
        case "loggingDestination":
            return Optional.ofNullable(clazz.cast(loggingDestination()));
        case "scraperComponents":
            return Optional.ofNullable(clazz.cast(scraperComponents()));
        case "modifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("scraperId", SCRAPER_ID_FIELD);
        map.put("loggingDestination", LOGGING_DESTINATION_FIELD);
        map.put("scraperComponents", SCRAPER_COMPONENTS_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeScraperLoggingConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeScraperLoggingConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AmpResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeScraperLoggingConfigurationResponse> {
        /**
         * <p>
         * The status of the scraper logging configuration.
         * </p>
         * 
         * @param status
         *        The status of the scraper logging configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ScraperLoggingConfigurationStatus status);

        /**
         * <p>
         * The status of the scraper logging configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ScraperLoggingConfigurationStatus.Builder} avoiding the need to create one manually via
         * {@link ScraperLoggingConfigurationStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScraperLoggingConfigurationStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #status(ScraperLoggingConfigurationStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link ScraperLoggingConfigurationStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(ScraperLoggingConfigurationStatus)
         */
        default Builder status(Consumer<ScraperLoggingConfigurationStatus.Builder> status) {
            return status(ScraperLoggingConfigurationStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The ID of the scraper.
         * </p>
         * 
         * @param scraperId
         *        The ID of the scraper.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scraperId(String scraperId);

        /**
         * <p>
         * The destination where scraper logs are sent.
         * </p>
         * 
         * @param loggingDestination
         *        The destination where scraper logs are sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingDestination(ScraperLoggingDestination loggingDestination);

        /**
         * <p>
         * The destination where scraper logs are sent.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScraperLoggingDestination.Builder}
         * avoiding the need to create one manually via {@link ScraperLoggingDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScraperLoggingDestination.Builder#build()} is called immediately
         * and its result is passed to {@link #loggingDestination(ScraperLoggingDestination)}.
         * 
         * @param loggingDestination
         *        a consumer that will call methods on {@link ScraperLoggingDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingDestination(ScraperLoggingDestination)
         */
        default Builder loggingDestination(Consumer<ScraperLoggingDestination.Builder> loggingDestination) {
            return loggingDestination(ScraperLoggingDestination.builder().applyMutation(loggingDestination).build());
        }

        /**
         * <p>
         * The list of scraper components configured for logging.
         * </p>
         * 
         * @param scraperComponents
         *        The list of scraper components configured for logging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scraperComponents(Collection<ScraperComponent> scraperComponents);

        /**
         * <p>
         * The list of scraper components configured for logging.
         * </p>
         * 
         * @param scraperComponents
         *        The list of scraper components configured for logging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scraperComponents(ScraperComponent... scraperComponents);

        /**
         * <p>
         * The list of scraper components configured for logging.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.amp.model.ScraperComponent.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.amp.model.ScraperComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.amp.model.ScraperComponent.Builder#build()} is called immediately and
         * its result is passed to {@link #scraperComponents(List<ScraperComponent>)}.
         * 
         * @param scraperComponents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.amp.model.ScraperComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scraperComponents(java.util.Collection<ScraperComponent>)
         */
        Builder scraperComponents(Consumer<ScraperComponent.Builder>... scraperComponents);

        /**
         * <p>
         * The date and time when the logging configuration was last modified.
         * </p>
         * 
         * @param modifiedAt
         *        The date and time when the logging configuration was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);
    }

    static final class BuilderImpl extends AmpResponse.BuilderImpl implements Builder {
        private ScraperLoggingConfigurationStatus status;

        private String scraperId;

        private ScraperLoggingDestination loggingDestination;

        private List<ScraperComponent> scraperComponents = DefaultSdkAutoConstructList.getInstance();

        private Instant modifiedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScraperLoggingConfigurationResponse model) {
            super(model);
            status(model.status);
            scraperId(model.scraperId);
            loggingDestination(model.loggingDestination);
            scraperComponents(model.scraperComponents);
            modifiedAt(model.modifiedAt);
        }

        public final ScraperLoggingConfigurationStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(ScraperLoggingConfigurationStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(ScraperLoggingConfigurationStatus status) {
            this.status = status;
            return this;
        }

        public final String getScraperId() {
            return scraperId;
        }

        public final void setScraperId(String scraperId) {
            this.scraperId = scraperId;
        }

        @Override
        public final Builder scraperId(String scraperId) {
            this.scraperId = scraperId;
            return this;
        }

        public final ScraperLoggingDestination.Builder getLoggingDestination() {
            return loggingDestination != null ? loggingDestination.toBuilder() : null;
        }

        public final void setLoggingDestination(ScraperLoggingDestination.BuilderImpl loggingDestination) {
            this.loggingDestination = loggingDestination != null ? loggingDestination.build() : null;
        }

        @Override
        public final Builder loggingDestination(ScraperLoggingDestination loggingDestination) {
            this.loggingDestination = loggingDestination;
            return this;
        }

        public final List<ScraperComponent.Builder> getScraperComponents() {
            List<ScraperComponent.Builder> result = ScraperComponentsCopier.copyToBuilder(this.scraperComponents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScraperComponents(Collection<ScraperComponent.BuilderImpl> scraperComponents) {
            this.scraperComponents = ScraperComponentsCopier.copyFromBuilder(scraperComponents);
        }

        @Override
        public final Builder scraperComponents(Collection<ScraperComponent> scraperComponents) {
            this.scraperComponents = ScraperComponentsCopier.copy(scraperComponents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scraperComponents(ScraperComponent... scraperComponents) {
            scraperComponents(Arrays.asList(scraperComponents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scraperComponents(Consumer<ScraperComponent.Builder>... scraperComponents) {
            scraperComponents(Stream.of(scraperComponents).map(c -> ScraperComponent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        @Override
        public DescribeScraperLoggingConfigurationResponse build() {
            return new DescribeScraperLoggingConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
