/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure defines one label set used to enforce active time series limits for the workspace, and defines the
 * limit for that label set.
 * </p>
 * <p>
 * A label set is a unique combination of label-value pairs. Use them to control time series limits and to monitor usage
 * by specific label groups. Example label sets might be <code>team:finance</code> or <code>env:prod</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LimitsPerLabelSet implements SdkPojo, Serializable,
        ToCopyableBuilder<LimitsPerLabelSet.Builder, LimitsPerLabelSet> {
    private static final SdkField<LimitsPerLabelSetEntry> LIMITS_FIELD = SdkField
            .<LimitsPerLabelSetEntry> builder(MarshallingType.SDK_POJO).memberName("limits")
            .getter(getter(LimitsPerLabelSet::limits)).setter(setter(Builder::limits))
            .constructor(LimitsPerLabelSetEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limits").build()).build();

    private static final SdkField<Map<String, String>> LABEL_SET_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("labelSet")
            .getter(getter(LimitsPerLabelSet::labelSet))
            .setter(setter(Builder::labelSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labelSet").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(LIMITS_FIELD, LABEL_SET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LimitsPerLabelSetEntry limits;

    private final Map<String, String> labelSet;

    private LimitsPerLabelSet(BuilderImpl builder) {
        this.limits = builder.limits;
        this.labelSet = builder.labelSet;
    }

    /**
     * <p>
     * This structure contains the information about the limits that apply to time series that match this label set.
     * </p>
     * 
     * @return This structure contains the information about the limits that apply to time series that match this label
     *         set.
     */
    public final LimitsPerLabelSetEntry limits() {
        return limits;
    }

    /**
     * For responses, this returns true if the service returned a value for the LabelSet property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLabelSet() {
        return labelSet != null && !(labelSet instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * This defines one label set that will have an enforced active time series limit.
     * </p>
     * <p>
     * Label values accept ASCII characters and must contain at least one character that isn't whitespace. ASCII control
     * characters are not accepted. If the label name is metric name label <code>__<i>name</i>__</code>, then the
     * <i>metric</i> part of the name must conform to the following pattern: <code>[a-zA-Z_:][a-zA-Z0-9_:]*</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabelSet} method.
     * </p>
     * 
     * @return This defines one label set that will have an enforced active time series limit. </p>
     *         <p>
     *         Label values accept ASCII characters and must contain at least one character that isn't whitespace. ASCII
     *         control characters are not accepted. If the label name is metric name label <code>__<i>name</i>__</code>,
     *         then the <i>metric</i> part of the name must conform to the following pattern:
     *         <code>[a-zA-Z_:][a-zA-Z0-9_:]*</code>
     */
    public final Map<String, String> labelSet() {
        return labelSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(limits());
        hashCode = 31 * hashCode + Objects.hashCode(hasLabelSet() ? labelSet() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LimitsPerLabelSet)) {
            return false;
        }
        LimitsPerLabelSet other = (LimitsPerLabelSet) obj;
        return Objects.equals(limits(), other.limits()) && hasLabelSet() == other.hasLabelSet()
                && Objects.equals(labelSet(), other.labelSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LimitsPerLabelSet").add("Limits", limits()).add("LabelSet", hasLabelSet() ? labelSet() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "limits":
            return Optional.ofNullable(clazz.cast(limits()));
        case "labelSet":
            return Optional.ofNullable(clazz.cast(labelSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("limits", LIMITS_FIELD);
        map.put("labelSet", LABEL_SET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LimitsPerLabelSet, T> g) {
        return obj -> g.apply((LimitsPerLabelSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LimitsPerLabelSet> {
        /**
         * <p>
         * This structure contains the information about the limits that apply to time series that match this label set.
         * </p>
         * 
         * @param limits
         *        This structure contains the information about the limits that apply to time series that match this
         *        label set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limits(LimitsPerLabelSetEntry limits);

        /**
         * <p>
         * This structure contains the information about the limits that apply to time series that match this label set.
         * </p>
         * This is a convenience method that creates an instance of the {@link LimitsPerLabelSetEntry.Builder} avoiding
         * the need to create one manually via {@link LimitsPerLabelSetEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LimitsPerLabelSetEntry.Builder#build()} is called immediately and
         * its result is passed to {@link #limits(LimitsPerLabelSetEntry)}.
         * 
         * @param limits
         *        a consumer that will call methods on {@link LimitsPerLabelSetEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #limits(LimitsPerLabelSetEntry)
         */
        default Builder limits(Consumer<LimitsPerLabelSetEntry.Builder> limits) {
            return limits(LimitsPerLabelSetEntry.builder().applyMutation(limits).build());
        }

        /**
         * <p>
         * This defines one label set that will have an enforced active time series limit.
         * </p>
         * <p>
         * Label values accept ASCII characters and must contain at least one character that isn't whitespace. ASCII
         * control characters are not accepted. If the label name is metric name label <code>__<i>name</i>__</code>,
         * then the <i>metric</i> part of the name must conform to the following pattern:
         * <code>[a-zA-Z_:][a-zA-Z0-9_:]*</code>
         * </p>
         * 
         * @param labelSet
         *        This defines one label set that will have an enforced active time series limit. </p>
         *        <p>
         *        Label values accept ASCII characters and must contain at least one character that isn't whitespace.
         *        ASCII control characters are not accepted. If the label name is metric name label
         *        <code>__<i>name</i>__</code>, then the <i>metric</i> part of the name must conform to the following
         *        pattern: <code>[a-zA-Z_:][a-zA-Z0-9_:]*</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelSet(Map<String, String> labelSet);
    }

    static final class BuilderImpl implements Builder {
        private LimitsPerLabelSetEntry limits;

        private Map<String, String> labelSet = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LimitsPerLabelSet model) {
            limits(model.limits);
            labelSet(model.labelSet);
        }

        public final LimitsPerLabelSetEntry.Builder getLimits() {
            return limits != null ? limits.toBuilder() : null;
        }

        public final void setLimits(LimitsPerLabelSetEntry.BuilderImpl limits) {
            this.limits = limits != null ? limits.build() : null;
        }

        @Override
        public final Builder limits(LimitsPerLabelSetEntry limits) {
            this.limits = limits;
            return this;
        }

        public final Map<String, String> getLabelSet() {
            if (labelSet instanceof SdkAutoConstructMap) {
                return null;
            }
            return labelSet;
        }

        public final void setLabelSet(Map<String, String> labelSet) {
            this.labelSet = LabelSetCopier.copy(labelSet);
        }

        @Override
        public final Builder labelSet(Map<String, String> labelSet) {
            this.labelSet = LabelSetCopier.copy(labelSet);
            return this;
        }

        @Override
        public LimitsPerLabelSet build() {
            return new LimitsPerLabelSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
