/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>ListScrapers</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListScrapersRequest extends AmpRequest implements
        ToCopyableBuilder<ListScrapersRequest.Builder, ListScrapersRequest> {
    private static final SdkField<Map<String, List<String>>> FILTERS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("filters")
            .getter(getter(ListScrapersRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("filters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListScrapersRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListScrapersRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Map<String, List<String>> filters;

    private final String nextToken;

    private final Integer maxResults;

    private ListScrapersRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * (Optional) A list of key-value pairs to filter the list of scrapers returned. Keys include <code>status</code>,
     * <code>sourceArn</code>, <code>destinationArn</code>, and <code>alias</code>.
     * </p>
     * <p>
     * Filters on the same key are <code>OR</code>'d together, and filters on different keys are <code>AND</code>'d
     * together. For example, <code>status=ACTIVE&amp;status=CREATING&amp;alias=Test</code>, will return all scrapers
     * that have the alias Test, and are either in status ACTIVE or CREATING.
     * </p>
     * <p>
     * To find all active scrapers that are sending metrics to a specific Amazon Managed Service for Prometheus
     * workspace, you would use the ARN of the workspace in a query:
     * </p>
     * <p>
     * <code>status=ACTIVE&amp;destinationArn=arn:aws:aps:us-east-1:123456789012:workspace/ws-example1-1234-abcd-56ef-123456789012</code>
     * </p>
     * <p>
     * If this is included, it filters the results to only the scrapers that match the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return (Optional) A list of key-value pairs to filter the list of scrapers returned. Keys include
     *         <code>status</code>, <code>sourceArn</code>, <code>destinationArn</code>, and <code>alias</code>.</p>
     *         <p>
     *         Filters on the same key are <code>OR</code>'d together, and filters on different keys are
     *         <code>AND</code>'d together. For example, <code>status=ACTIVE&amp;status=CREATING&amp;alias=Test</code>,
     *         will return all scrapers that have the alias Test, and are either in status ACTIVE or CREATING.
     *         </p>
     *         <p>
     *         To find all active scrapers that are sending metrics to a specific Amazon Managed Service for Prometheus
     *         workspace, you would use the ARN of the workspace in a query:
     *         </p>
     *         <p>
     *         <code>status=ACTIVE&amp;destinationArn=arn:aws:aps:us-east-1:123456789012:workspace/ws-example1-1234-abcd-56ef-123456789012</code>
     *         </p>
     *         <p>
     *         If this is included, it filters the results to only the scrapers that match the filter.
     */
    public final Map<String, List<String>> filters() {
        return filters;
    }

    /**
     * <p>
     * (Optional) The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return (Optional) The token for the next set of items to return. (You received this token from a previous call.)
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Optional) The maximum number of scrapers to return in one <code>ListScrapers</code> operation. The range is
     * 1-1000.
     * </p>
     * <p>
     * If you omit this parameter, the default of 100 is used.
     * </p>
     * 
     * @return Optional) The maximum number of scrapers to return in one <code>ListScrapers</code> operation. The range
     *         is 1-1000.</p>
     *         <p>
     *         If you omit this parameter, the default of 100 is used.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScrapersRequest)) {
            return false;
        }
        ListScrapersRequest other = (ListScrapersRequest) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListScrapersRequest").add("Filters", hasFilters() ? filters() : null)
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("filters", FILTERS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListScrapersRequest, T> g) {
        return obj -> g.apply((ListScrapersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AmpRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListScrapersRequest> {
        /**
         * <p>
         * (Optional) A list of key-value pairs to filter the list of scrapers returned. Keys include
         * <code>status</code>, <code>sourceArn</code>, <code>destinationArn</code>, and <code>alias</code>.
         * </p>
         * <p>
         * Filters on the same key are <code>OR</code>'d together, and filters on different keys are <code>AND</code>'d
         * together. For example, <code>status=ACTIVE&amp;status=CREATING&amp;alias=Test</code>, will return all
         * scrapers that have the alias Test, and are either in status ACTIVE or CREATING.
         * </p>
         * <p>
         * To find all active scrapers that are sending metrics to a specific Amazon Managed Service for Prometheus
         * workspace, you would use the ARN of the workspace in a query:
         * </p>
         * <p>
         * <code>status=ACTIVE&amp;destinationArn=arn:aws:aps:us-east-1:123456789012:workspace/ws-example1-1234-abcd-56ef-123456789012</code>
         * </p>
         * <p>
         * If this is included, it filters the results to only the scrapers that match the filter.
         * </p>
         * 
         * @param filters
         *        (Optional) A list of key-value pairs to filter the list of scrapers returned. Keys include
         *        <code>status</code>, <code>sourceArn</code>, <code>destinationArn</code>, and <code>alias</code>.</p>
         *        <p>
         *        Filters on the same key are <code>OR</code>'d together, and filters on different keys are
         *        <code>AND</code>'d together. For example,
         *        <code>status=ACTIVE&amp;status=CREATING&amp;alias=Test</code>, will return all scrapers that have the
         *        alias Test, and are either in status ACTIVE or CREATING.
         *        </p>
         *        <p>
         *        To find all active scrapers that are sending metrics to a specific Amazon Managed Service for
         *        Prometheus workspace, you would use the ARN of the workspace in a query:
         *        </p>
         *        <p>
         *        <code>status=ACTIVE&amp;destinationArn=arn:aws:aps:us-east-1:123456789012:workspace/ws-example1-1234-abcd-56ef-123456789012</code>
         *        </p>
         *        <p>
         *        If this is included, it filters the results to only the scrapers that match the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Map<String, ? extends Collection<String>> filters);

        /**
         * <p>
         * (Optional) The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        (Optional) The token for the next set of items to return. (You received this token from a previous
         *        call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Optional) The maximum number of scrapers to return in one <code>ListScrapers</code> operation. The range is
         * 1-1000.
         * </p>
         * <p>
         * If you omit this parameter, the default of 100 is used.
         * </p>
         * 
         * @param maxResults
         *        Optional) The maximum number of scrapers to return in one <code>ListScrapers</code> operation. The
         *        range is 1-1000.</p>
         *        <p>
         *        If you omit this parameter, the default of 100 is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmpRequest.BuilderImpl implements Builder {
        private Map<String, List<String>> filters = DefaultSdkAutoConstructMap.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListScrapersRequest model) {
            super(model);
            filters(model.filters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Map<String, ? extends Collection<String>> getFilters() {
            if (filters instanceof SdkAutoConstructMap) {
                return null;
            }
            return filters;
        }

        public final void setFilters(Map<String, ? extends Collection<String>> filters) {
            this.filters = ScraperFiltersCopier.copy(filters);
        }

        @Override
        public final Builder filters(Map<String, ? extends Collection<String>> filters) {
            this.filters = ScraperFiltersCopier.copy(filters);
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListScrapersRequest build() {
            return new ListScrapersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
