/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the current rules and alerting logging configuration for the workspace.
 * </p>
 * <note>
 * <p>
 * These logging configurations are only for rules and alerting logs.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoggingConfigurationMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<LoggingConfigurationMetadata.Builder, LoggingConfigurationMetadata> {
    private static final SdkField<LoggingConfigurationStatus> STATUS_FIELD = SdkField
            .<LoggingConfigurationStatus> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(LoggingConfigurationMetadata::status)).setter(setter(Builder::status))
            .constructor(LoggingConfigurationStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> WORKSPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspace").getter(getter(LoggingConfigurationMetadata::workspace)).setter(setter(Builder::workspace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspace").build()).build();

    private static final SdkField<String> LOG_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupArn").getter(getter(LoggingConfigurationMetadata::logGroupArn))
            .setter(setter(Builder::logGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupArn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(LoggingConfigurationMetadata::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedAt").getter(getter(LoggingConfigurationMetadata::modifiedAt))
            .setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, WORKSPACE_FIELD,
            LOG_GROUP_ARN_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LoggingConfigurationStatus status;

    private final String workspace;

    private final String logGroupArn;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private LoggingConfigurationMetadata(BuilderImpl builder) {
        this.status = builder.status;
        this.workspace = builder.workspace;
        this.logGroupArn = builder.logGroupArn;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
    }

    /**
     * <p>
     * The current status of the logging configuration.
     * </p>
     * 
     * @return The current status of the logging configuration.
     */
    public final LoggingConfigurationStatus status() {
        return status;
    }

    /**
     * <p>
     * The ID of the workspace the logging configuration is for.
     * </p>
     * 
     * @return The ID of the workspace the logging configuration is for.
     */
    public final String workspace() {
        return workspace;
    }

    /**
     * <p>
     * The ARN of the CloudWatch log group to which the vended log data will be published.
     * </p>
     * 
     * @return The ARN of the CloudWatch log group to which the vended log data will be published.
     */
    public final String logGroupArn() {
        return logGroupArn;
    }

    /**
     * <p>
     * The date and time that the logging configuration was created.
     * </p>
     * 
     * @return The date and time that the logging configuration was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time that the logging configuration was most recently changed.
     * </p>
     * 
     * @return The date and time that the logging configuration was most recently changed.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(workspace());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfigurationMetadata)) {
            return false;
        }
        LoggingConfigurationMetadata other = (LoggingConfigurationMetadata) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(workspace(), other.workspace())
                && Objects.equals(logGroupArn(), other.logGroupArn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(modifiedAt(), other.modifiedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoggingConfigurationMetadata").add("Status", status()).add("Workspace", workspace())
                .add("LogGroupArn", logGroupArn()).add("CreatedAt", createdAt()).add("ModifiedAt", modifiedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "workspace":
            return Optional.ofNullable(clazz.cast(workspace()));
        case "logGroupArn":
            return Optional.ofNullable(clazz.cast(logGroupArn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "modifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("workspace", WORKSPACE_FIELD);
        map.put("logGroupArn", LOG_GROUP_ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoggingConfigurationMetadata, T> g) {
        return obj -> g.apply((LoggingConfigurationMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoggingConfigurationMetadata> {
        /**
         * <p>
         * The current status of the logging configuration.
         * </p>
         * 
         * @param status
         *        The current status of the logging configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(LoggingConfigurationStatus status);

        /**
         * <p>
         * The current status of the logging configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoggingConfigurationStatus.Builder}
         * avoiding the need to create one manually via {@link LoggingConfigurationStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoggingConfigurationStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #status(LoggingConfigurationStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link LoggingConfigurationStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(LoggingConfigurationStatus)
         */
        default Builder status(Consumer<LoggingConfigurationStatus.Builder> status) {
            return status(LoggingConfigurationStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The ID of the workspace the logging configuration is for.
         * </p>
         * 
         * @param workspace
         *        The ID of the workspace the logging configuration is for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspace(String workspace);

        /**
         * <p>
         * The ARN of the CloudWatch log group to which the vended log data will be published.
         * </p>
         * 
         * @param logGroupArn
         *        The ARN of the CloudWatch log group to which the vended log data will be published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupArn(String logGroupArn);

        /**
         * <p>
         * The date and time that the logging configuration was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the logging configuration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time that the logging configuration was most recently changed.
         * </p>
         * 
         * @param modifiedAt
         *        The date and time that the logging configuration was most recently changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);
    }

    static final class BuilderImpl implements Builder {
        private LoggingConfigurationStatus status;

        private String workspace;

        private String logGroupArn;

        private Instant createdAt;

        private Instant modifiedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingConfigurationMetadata model) {
            status(model.status);
            workspace(model.workspace);
            logGroupArn(model.logGroupArn);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
        }

        public final LoggingConfigurationStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(LoggingConfigurationStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(LoggingConfigurationStatus status) {
            this.status = status;
            return this;
        }

        public final String getWorkspace() {
            return workspace;
        }

        public final void setWorkspace(String workspace) {
            this.workspace = workspace;
        }

        @Override
        public final Builder workspace(String workspace) {
            this.workspace = workspace;
            return this;
        }

        public final String getLogGroupArn() {
            return logGroupArn;
        }

        public final void setLogGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
        }

        @Override
        public final Builder logGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        @Override
        public LoggingConfigurationMetadata build() {
            return new LoggingConfigurationMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
