/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a destination and its associated filtering criteria for query logging.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoggingDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<LoggingDestination.Builder, LoggingDestination> {
    private static final SdkField<CloudWatchLogDestination> CLOUD_WATCH_LOGS_FIELD = SdkField
            .<CloudWatchLogDestination> builder(MarshallingType.SDK_POJO).memberName("cloudWatchLogs")
            .getter(getter(LoggingDestination::cloudWatchLogs)).setter(setter(Builder::cloudWatchLogs))
            .constructor(CloudWatchLogDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogs").build()).build();

    private static final SdkField<LoggingFilter> FILTERS_FIELD = SdkField.<LoggingFilter> builder(MarshallingType.SDK_POJO)
            .memberName("filters").getter(getter(LoggingDestination::filters)).setter(setter(Builder::filters))
            .constructor(LoggingFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOGS_FIELD,
            FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CloudWatchLogDestination cloudWatchLogs;

    private final LoggingFilter filters;

    private LoggingDestination(BuilderImpl builder) {
        this.cloudWatchLogs = builder.cloudWatchLogs;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * Configuration details for logging to CloudWatch Logs.
     * </p>
     * 
     * @return Configuration details for logging to CloudWatch Logs.
     */
    public final CloudWatchLogDestination cloudWatchLogs() {
        return cloudWatchLogs;
    }

    /**
     * <p>
     * Filtering criteria that determine which queries are logged.
     * </p>
     * 
     * @return Filtering criteria that determine which queries are logged.
     */
    public final LoggingFilter filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingDestination)) {
            return false;
        }
        LoggingDestination other = (LoggingDestination) obj;
        return Objects.equals(cloudWatchLogs(), other.cloudWatchLogs()) && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoggingDestination").add("CloudWatchLogs", cloudWatchLogs()).add("Filters", filters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudWatchLogs":
            return Optional.ofNullable(clazz.cast(cloudWatchLogs()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cloudWatchLogs", CLOUD_WATCH_LOGS_FIELD);
        map.put("filters", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoggingDestination, T> g) {
        return obj -> g.apply((LoggingDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoggingDestination> {
        /**
         * <p>
         * Configuration details for logging to CloudWatch Logs.
         * </p>
         * 
         * @param cloudWatchLogs
         *        Configuration details for logging to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogs(CloudWatchLogDestination cloudWatchLogs);

        /**
         * <p>
         * Configuration details for logging to CloudWatch Logs.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudWatchLogDestination.Builder}
         * avoiding the need to create one manually via {@link CloudWatchLogDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchLogDestination.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudWatchLogs(CloudWatchLogDestination)}.
         * 
         * @param cloudWatchLogs
         *        a consumer that will call methods on {@link CloudWatchLogDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogs(CloudWatchLogDestination)
         */
        default Builder cloudWatchLogs(Consumer<CloudWatchLogDestination.Builder> cloudWatchLogs) {
            return cloudWatchLogs(CloudWatchLogDestination.builder().applyMutation(cloudWatchLogs).build());
        }

        /**
         * <p>
         * Filtering criteria that determine which queries are logged.
         * </p>
         * 
         * @param filters
         *        Filtering criteria that determine which queries are logged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(LoggingFilter filters);

        /**
         * <p>
         * Filtering criteria that determine which queries are logged.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoggingFilter.Builder} avoiding the need
         * to create one manually via {@link LoggingFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoggingFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(LoggingFilter)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link LoggingFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(LoggingFilter)
         */
        default Builder filters(Consumer<LoggingFilter.Builder> filters) {
            return filters(LoggingFilter.builder().applyMutation(filters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CloudWatchLogDestination cloudWatchLogs;

        private LoggingFilter filters;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingDestination model) {
            cloudWatchLogs(model.cloudWatchLogs);
            filters(model.filters);
        }

        public final CloudWatchLogDestination.Builder getCloudWatchLogs() {
            return cloudWatchLogs != null ? cloudWatchLogs.toBuilder() : null;
        }

        public final void setCloudWatchLogs(CloudWatchLogDestination.BuilderImpl cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs != null ? cloudWatchLogs.build() : null;
        }

        @Override
        public final Builder cloudWatchLogs(CloudWatchLogDestination cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs;
            return this;
        }

        public final LoggingFilter.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(LoggingFilter.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(LoggingFilter filters) {
            this.filters = filters;
            return this;
        }

        @Override
        public LoggingDestination build() {
            return new LoggingDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
