/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata for a query logging configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryLoggingConfigurationMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<QueryLoggingConfigurationMetadata.Builder, QueryLoggingConfigurationMetadata> {
    private static final SdkField<QueryLoggingConfigurationStatus> STATUS_FIELD = SdkField
            .<QueryLoggingConfigurationStatus> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(QueryLoggingConfigurationMetadata::status)).setter(setter(Builder::status))
            .constructor(QueryLoggingConfigurationStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> WORKSPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspace").getter(getter(QueryLoggingConfigurationMetadata::workspace))
            .setter(setter(Builder::workspace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspace").build()).build();

    private static final SdkField<List<LoggingDestination>> DESTINATIONS_FIELD = SdkField
            .<List<LoggingDestination>> builder(MarshallingType.LIST)
            .memberName("destinations")
            .getter(getter(QueryLoggingConfigurationMetadata::destinations))
            .setter(setter(Builder::destinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoggingDestination> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoggingDestination::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(QueryLoggingConfigurationMetadata::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedAt").getter(getter(QueryLoggingConfigurationMetadata::modifiedAt))
            .setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, WORKSPACE_FIELD,
            DESTINATIONS_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final QueryLoggingConfigurationStatus status;

    private final String workspace;

    private final List<LoggingDestination> destinations;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private QueryLoggingConfigurationMetadata(BuilderImpl builder) {
        this.status = builder.status;
        this.workspace = builder.workspace;
        this.destinations = builder.destinations;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
    }

    /**
     * <p>
     * The current status of the query logging configuration.
     * </p>
     * 
     * @return The current status of the query logging configuration.
     */
    public final QueryLoggingConfigurationStatus status() {
        return status;
    }

    /**
     * <p>
     * The ID of the workspace associated with this query logging configuration.
     * </p>
     * 
     * @return The ID of the workspace associated with this query logging configuration.
     */
    public final String workspace() {
        return workspace;
    }

    /**
     * For responses, this returns true if the service returned a value for the Destinations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinations() {
        return destinations != null && !(destinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configured destinations for the query logging configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinations} method.
     * </p>
     * 
     * @return The configured destinations for the query logging configuration.
     */
    public final List<LoggingDestination> destinations() {
        return destinations;
    }

    /**
     * <p>
     * The date and time when the query logging configuration was created.
     * </p>
     * 
     * @return The date and time when the query logging configuration was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time when the query logging configuration was last modified.
     * </p>
     * 
     * @return The date and time when the query logging configuration was last modified.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(workspace());
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinations() ? destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryLoggingConfigurationMetadata)) {
            return false;
        }
        QueryLoggingConfigurationMetadata other = (QueryLoggingConfigurationMetadata) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(workspace(), other.workspace())
                && hasDestinations() == other.hasDestinations() && Objects.equals(destinations(), other.destinations())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(modifiedAt(), other.modifiedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryLoggingConfigurationMetadata").add("Status", status()).add("Workspace", workspace())
                .add("Destinations", hasDestinations() ? destinations() : null).add("CreatedAt", createdAt())
                .add("ModifiedAt", modifiedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "workspace":
            return Optional.ofNullable(clazz.cast(workspace()));
        case "destinations":
            return Optional.ofNullable(clazz.cast(destinations()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "modifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("workspace", WORKSPACE_FIELD);
        map.put("destinations", DESTINATIONS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryLoggingConfigurationMetadata, T> g) {
        return obj -> g.apply((QueryLoggingConfigurationMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryLoggingConfigurationMetadata> {
        /**
         * <p>
         * The current status of the query logging configuration.
         * </p>
         * 
         * @param status
         *        The current status of the query logging configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(QueryLoggingConfigurationStatus status);

        /**
         * <p>
         * The current status of the query logging configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryLoggingConfigurationStatus.Builder}
         * avoiding the need to create one manually via {@link QueryLoggingConfigurationStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryLoggingConfigurationStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #status(QueryLoggingConfigurationStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link QueryLoggingConfigurationStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(QueryLoggingConfigurationStatus)
         */
        default Builder status(Consumer<QueryLoggingConfigurationStatus.Builder> status) {
            return status(QueryLoggingConfigurationStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The ID of the workspace associated with this query logging configuration.
         * </p>
         * 
         * @param workspace
         *        The ID of the workspace associated with this query logging configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspace(String workspace);

        /**
         * <p>
         * The configured destinations for the query logging configuration.
         * </p>
         * 
         * @param destinations
         *        The configured destinations for the query logging configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<LoggingDestination> destinations);

        /**
         * <p>
         * The configured destinations for the query logging configuration.
         * </p>
         * 
         * @param destinations
         *        The configured destinations for the query logging configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(LoggingDestination... destinations);

        /**
         * <p>
         * The configured destinations for the query logging configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.amp.model.LoggingDestination.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.amp.model.LoggingDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.amp.model.LoggingDestination.Builder#build()} is called immediately
         * and its result is passed to {@link #destinations(List<LoggingDestination>)}.
         * 
         * @param destinations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.amp.model.LoggingDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinations(java.util.Collection<LoggingDestination>)
         */
        Builder destinations(Consumer<LoggingDestination.Builder>... destinations);

        /**
         * <p>
         * The date and time when the query logging configuration was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time when the query logging configuration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time when the query logging configuration was last modified.
         * </p>
         * 
         * @param modifiedAt
         *        The date and time when the query logging configuration was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);
    }

    static final class BuilderImpl implements Builder {
        private QueryLoggingConfigurationStatus status;

        private String workspace;

        private List<LoggingDestination> destinations = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private Instant modifiedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryLoggingConfigurationMetadata model) {
            status(model.status);
            workspace(model.workspace);
            destinations(model.destinations);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
        }

        public final QueryLoggingConfigurationStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(QueryLoggingConfigurationStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(QueryLoggingConfigurationStatus status) {
            this.status = status;
            return this;
        }

        public final String getWorkspace() {
            return workspace;
        }

        public final void setWorkspace(String workspace) {
            this.workspace = workspace;
        }

        @Override
        public final Builder workspace(String workspace) {
            this.workspace = workspace;
            return this;
        }

        public final List<LoggingDestination.Builder> getDestinations() {
            List<LoggingDestination.Builder> result = LoggingDestinationsCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<LoggingDestination.BuilderImpl> destinations) {
            this.destinations = LoggingDestinationsCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<LoggingDestination> destinations) {
            this.destinations = LoggingDestinationsCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(LoggingDestination... destinations) {
            destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<LoggingDestination.Builder>... destinations) {
            destinations(Stream.of(destinations).map(c -> LoggingDestination.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        @Override
        public QueryLoggingConfigurationMetadata build() {
            return new QueryLoggingConfigurationMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
