/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateQueryLoggingConfigurationRequest extends AmpRequest implements
        ToCopyableBuilder<UpdateQueryLoggingConfigurationRequest.Builder, UpdateQueryLoggingConfigurationRequest> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(UpdateQueryLoggingConfigurationRequest::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()).build();

    private static final SdkField<List<LoggingDestination>> DESTINATIONS_FIELD = SdkField
            .<List<LoggingDestination>> builder(MarshallingType.LIST)
            .memberName("destinations")
            .getter(getter(UpdateQueryLoggingConfigurationRequest::destinations))
            .setter(setter(Builder::destinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoggingDestination> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoggingDestination::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateQueryLoggingConfigurationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD,
            DESTINATIONS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workspaceId;

    private final List<LoggingDestination> destinations;

    private final String clientToken;

    private UpdateQueryLoggingConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.destinations = builder.destinations;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the workspace for which to update the query logging configuration.
     * </p>
     * 
     * @return The ID of the workspace for which to update the query logging configuration.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Destinations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinations() {
        return destinations != null && !(destinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The destinations where query logs will be sent. Only CloudWatch Logs destination is supported. The list must
     * contain exactly one element.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinations} method.
     * </p>
     * 
     * @return The destinations where query logs will be sent. Only CloudWatch Logs destination is supported. The list
     *         must contain exactly one element.
     */
    public final List<LoggingDestination> destinations() {
        return destinations;
    }

    /**
     * <p>
     * (Optional) A unique, case-sensitive identifier that you can provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return (Optional) A unique, case-sensitive identifier that you can provide to ensure the idempotency of the
     *         request.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinations() ? destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQueryLoggingConfigurationRequest)) {
            return false;
        }
        UpdateQueryLoggingConfigurationRequest other = (UpdateQueryLoggingConfigurationRequest) obj;
        return Objects.equals(workspaceId(), other.workspaceId()) && hasDestinations() == other.hasDestinations()
                && Objects.equals(destinations(), other.destinations()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateQueryLoggingConfigurationRequest").add("WorkspaceId", workspaceId())
                .add("Destinations", hasDestinations() ? destinations() : null).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        case "destinations":
            return Optional.ofNullable(clazz.cast(destinations()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        map.put("destinations", DESTINATIONS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateQueryLoggingConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateQueryLoggingConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AmpRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateQueryLoggingConfigurationRequest> {
        /**
         * <p>
         * The ID of the workspace for which to update the query logging configuration.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace for which to update the query logging configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        /**
         * <p>
         * The destinations where query logs will be sent. Only CloudWatch Logs destination is supported. The list must
         * contain exactly one element.
         * </p>
         * 
         * @param destinations
         *        The destinations where query logs will be sent. Only CloudWatch Logs destination is supported. The
         *        list must contain exactly one element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<LoggingDestination> destinations);

        /**
         * <p>
         * The destinations where query logs will be sent. Only CloudWatch Logs destination is supported. The list must
         * contain exactly one element.
         * </p>
         * 
         * @param destinations
         *        The destinations where query logs will be sent. Only CloudWatch Logs destination is supported. The
         *        list must contain exactly one element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(LoggingDestination... destinations);

        /**
         * <p>
         * The destinations where query logs will be sent. Only CloudWatch Logs destination is supported. The list must
         * contain exactly one element.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.amp.model.LoggingDestination.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.amp.model.LoggingDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.amp.model.LoggingDestination.Builder#build()} is called immediately
         * and its result is passed to {@link #destinations(List<LoggingDestination>)}.
         * 
         * @param destinations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.amp.model.LoggingDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinations(java.util.Collection<LoggingDestination>)
         */
        Builder destinations(Consumer<LoggingDestination.Builder>... destinations);

        /**
         * <p>
         * (Optional) A unique, case-sensitive identifier that you can provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        (Optional) A unique, case-sensitive identifier that you can provide to ensure the idempotency of the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmpRequest.BuilderImpl implements Builder {
        private String workspaceId;

        private List<LoggingDestination> destinations = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQueryLoggingConfigurationRequest model) {
            super(model);
            workspaceId(model.workspaceId);
            destinations(model.destinations);
            clientToken(model.clientToken);
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final List<LoggingDestination.Builder> getDestinations() {
            List<LoggingDestination.Builder> result = LoggingDestinationsCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<LoggingDestination.BuilderImpl> destinations) {
            this.destinations = LoggingDestinationsCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<LoggingDestination> destinations) {
            this.destinations = LoggingDestinationsCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(LoggingDestination... destinations) {
            destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<LoggingDestination.Builder>... destinations) {
            destinations(Stream.of(destinations).map(c -> LoggingDestination.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQueryLoggingConfigurationRequest build() {
            return new UpdateQueryLoggingConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
