/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure for an execution step for an execution job, for an Amplify App.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Step implements SdkPojo, Serializable, ToCopyableBuilder<Step.Builder, Step> {
    private static final SdkField<String> STEP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Step::stepName)).setter(setter(Builder::stepName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepName").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Step::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Step::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Step::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> LOG_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Step::logUrl)).setter(setter(Builder::logUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logUrl").build()).build();

    private static final SdkField<String> ARTIFACTS_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Step::artifactsUrl)).setter(setter(Builder::artifactsUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactsUrl").build()).build();

    private static final SdkField<Map<String, String>> SCREENSHOTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(Step::screenshots))
            .setter(setter(Builder::screenshots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("screenshots").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_NAME_FIELD,
            START_TIME_FIELD, STATUS_FIELD, END_TIME_FIELD, LOG_URL_FIELD, ARTIFACTS_URL_FIELD, SCREENSHOTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stepName;

    private final Instant startTime;

    private final String status;

    private final Instant endTime;

    private final String logUrl;

    private final String artifactsUrl;

    private final Map<String, String> screenshots;

    private Step(BuilderImpl builder) {
        this.stepName = builder.stepName;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.endTime = builder.endTime;
        this.logUrl = builder.logUrl;
        this.artifactsUrl = builder.artifactsUrl;
        this.screenshots = builder.screenshots;
    }

    /**
     * <p>
     * Name of the execution step.
     * </p>
     * 
     * @return Name of the execution step.
     */
    public String stepName() {
        return stepName;
    }

    /**
     * <p>
     * Start date/ time of the execution step.
     * </p>
     * 
     * @return Start date/ time of the execution step.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * Status of the execution step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the execution step.
     * @see JobStatus
     */
    public JobStatus status() {
        return JobStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the execution step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the execution step.
     * @see JobStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * End date/ time of the execution step.
     * </p>
     * 
     * @return End date/ time of the execution step.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Url to the logs for the execution step.
     * </p>
     * 
     * @return Url to the logs for the execution step.
     */
    public String logUrl() {
        return logUrl;
    }

    /**
     * <p>
     * Url to teh artifact for the execution step.
     * </p>
     * 
     * @return Url to teh artifact for the execution step.
     */
    public String artifactsUrl() {
        return artifactsUrl;
    }

    /**
     * <p>
     * List of screenshot Urls for the execution step, if relevant.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return List of screenshot Urls for the execution step, if relevant.
     */
    public Map<String, String> screenshots() {
        return screenshots;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stepName());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(logUrl());
        hashCode = 31 * hashCode + Objects.hashCode(artifactsUrl());
        hashCode = 31 * hashCode + Objects.hashCode(screenshots());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Step)) {
            return false;
        }
        Step other = (Step) obj;
        return Objects.equals(stepName(), other.stepName()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(logUrl(), other.logUrl()) && Objects.equals(artifactsUrl(), other.artifactsUrl())
                && Objects.equals(screenshots(), other.screenshots());
    }

    @Override
    public String toString() {
        return ToString.builder("Step").add("StepName", stepName()).add("StartTime", startTime()).add("Status", statusAsString())
                .add("EndTime", endTime()).add("LogUrl", logUrl()).add("ArtifactsUrl", artifactsUrl())
                .add("Screenshots", screenshots()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stepName":
            return Optional.ofNullable(clazz.cast(stepName()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "logUrl":
            return Optional.ofNullable(clazz.cast(logUrl()));
        case "artifactsUrl":
            return Optional.ofNullable(clazz.cast(artifactsUrl()));
        case "screenshots":
            return Optional.ofNullable(clazz.cast(screenshots()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Step, T> g) {
        return obj -> g.apply((Step) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Step> {
        /**
         * <p>
         * Name of the execution step.
         * </p>
         * 
         * @param stepName
         *        Name of the execution step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepName(String stepName);

        /**
         * <p>
         * Start date/ time of the execution step.
         * </p>
         * 
         * @param startTime
         *        Start date/ time of the execution step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Status of the execution step.
         * </p>
         * 
         * @param status
         *        Status of the execution step.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the execution step.
         * </p>
         * 
         * @param status
         *        Status of the execution step.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(JobStatus status);

        /**
         * <p>
         * End date/ time of the execution step.
         * </p>
         * 
         * @param endTime
         *        End date/ time of the execution step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Url to the logs for the execution step.
         * </p>
         * 
         * @param logUrl
         *        Url to the logs for the execution step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logUrl(String logUrl);

        /**
         * <p>
         * Url to teh artifact for the execution step.
         * </p>
         * 
         * @param artifactsUrl
         *        Url to teh artifact for the execution step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactsUrl(String artifactsUrl);

        /**
         * <p>
         * List of screenshot Urls for the execution step, if relevant.
         * </p>
         * 
         * @param screenshots
         *        List of screenshot Urls for the execution step, if relevant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder screenshots(Map<String, String> screenshots);
    }

    static final class BuilderImpl implements Builder {
        private String stepName;

        private Instant startTime;

        private String status;

        private Instant endTime;

        private String logUrl;

        private String artifactsUrl;

        private Map<String, String> screenshots = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Step model) {
            stepName(model.stepName);
            startTime(model.startTime);
            status(model.status);
            endTime(model.endTime);
            logUrl(model.logUrl);
            artifactsUrl(model.artifactsUrl);
            screenshots(model.screenshots);
        }

        public final String getStepName() {
            return stepName;
        }

        @Override
        public final Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public final void setStepName(String stepName) {
            this.stepName = stepName;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getLogUrl() {
            return logUrl;
        }

        @Override
        public final Builder logUrl(String logUrl) {
            this.logUrl = logUrl;
            return this;
        }

        public final void setLogUrl(String logUrl) {
            this.logUrl = logUrl;
        }

        public final String getArtifactsUrl() {
            return artifactsUrl;
        }

        @Override
        public final Builder artifactsUrl(String artifactsUrl) {
            this.artifactsUrl = artifactsUrl;
            return this;
        }

        public final void setArtifactsUrl(String artifactsUrl) {
            this.artifactsUrl = artifactsUrl;
        }

        public final Map<String, String> getScreenshots() {
            return screenshots;
        }

        @Override
        public final Builder screenshots(Map<String, String> screenshots) {
            this.screenshots = ScreenshotsCopier.copy(screenshots);
            return this;
        }

        public final void setScreenshots(Map<String, String> screenshots) {
            this.screenshots = ScreenshotsCopier.copy(screenshots);
        }

        @Override
        public Step build() {
            return new Step(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
