/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.amplify.AmplifyClient;
import software.amazon.awssdk.services.amplify.model.AmplifyException;
import software.amazon.awssdk.services.amplify.model.BadRequestException;
import software.amazon.awssdk.services.amplify.model.CreateAppRequest;
import software.amazon.awssdk.services.amplify.model.CreateAppResponse;
import software.amazon.awssdk.services.amplify.model.CreateBackendEnvironmentRequest;
import software.amazon.awssdk.services.amplify.model.CreateBackendEnvironmentResponse;
import software.amazon.awssdk.services.amplify.model.CreateBranchRequest;
import software.amazon.awssdk.services.amplify.model.CreateBranchResponse;
import software.amazon.awssdk.services.amplify.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.amplify.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.amplify.model.CreateDomainAssociationRequest;
import software.amazon.awssdk.services.amplify.model.CreateDomainAssociationResponse;
import software.amazon.awssdk.services.amplify.model.CreateWebhookRequest;
import software.amazon.awssdk.services.amplify.model.CreateWebhookResponse;
import software.amazon.awssdk.services.amplify.model.DeleteAppRequest;
import software.amazon.awssdk.services.amplify.model.DeleteAppResponse;
import software.amazon.awssdk.services.amplify.model.DeleteBackendEnvironmentRequest;
import software.amazon.awssdk.services.amplify.model.DeleteBackendEnvironmentResponse;
import software.amazon.awssdk.services.amplify.model.DeleteBranchRequest;
import software.amazon.awssdk.services.amplify.model.DeleteBranchResponse;
import software.amazon.awssdk.services.amplify.model.DeleteDomainAssociationRequest;
import software.amazon.awssdk.services.amplify.model.DeleteDomainAssociationResponse;
import software.amazon.awssdk.services.amplify.model.DeleteJobRequest;
import software.amazon.awssdk.services.amplify.model.DeleteJobResponse;
import software.amazon.awssdk.services.amplify.model.DeleteWebhookRequest;
import software.amazon.awssdk.services.amplify.model.DeleteWebhookResponse;
import software.amazon.awssdk.services.amplify.model.DependentServiceFailureException;
import software.amazon.awssdk.services.amplify.model.GenerateAccessLogsRequest;
import software.amazon.awssdk.services.amplify.model.GenerateAccessLogsResponse;
import software.amazon.awssdk.services.amplify.model.GetAppRequest;
import software.amazon.awssdk.services.amplify.model.GetAppResponse;
import software.amazon.awssdk.services.amplify.model.GetArtifactUrlRequest;
import software.amazon.awssdk.services.amplify.model.GetArtifactUrlResponse;
import software.amazon.awssdk.services.amplify.model.GetBackendEnvironmentRequest;
import software.amazon.awssdk.services.amplify.model.GetBackendEnvironmentResponse;
import software.amazon.awssdk.services.amplify.model.GetBranchRequest;
import software.amazon.awssdk.services.amplify.model.GetBranchResponse;
import software.amazon.awssdk.services.amplify.model.GetDomainAssociationRequest;
import software.amazon.awssdk.services.amplify.model.GetDomainAssociationResponse;
import software.amazon.awssdk.services.amplify.model.GetJobRequest;
import software.amazon.awssdk.services.amplify.model.GetJobResponse;
import software.amazon.awssdk.services.amplify.model.GetWebhookRequest;
import software.amazon.awssdk.services.amplify.model.GetWebhookResponse;
import software.amazon.awssdk.services.amplify.model.InternalFailureException;
import software.amazon.awssdk.services.amplify.model.LimitExceededException;
import software.amazon.awssdk.services.amplify.model.ListAppsRequest;
import software.amazon.awssdk.services.amplify.model.ListAppsResponse;
import software.amazon.awssdk.services.amplify.model.ListArtifactsRequest;
import software.amazon.awssdk.services.amplify.model.ListArtifactsResponse;
import software.amazon.awssdk.services.amplify.model.ListBackendEnvironmentsRequest;
import software.amazon.awssdk.services.amplify.model.ListBackendEnvironmentsResponse;
import software.amazon.awssdk.services.amplify.model.ListBranchesRequest;
import software.amazon.awssdk.services.amplify.model.ListBranchesResponse;
import software.amazon.awssdk.services.amplify.model.ListDomainAssociationsRequest;
import software.amazon.awssdk.services.amplify.model.ListDomainAssociationsResponse;
import software.amazon.awssdk.services.amplify.model.ListJobsRequest;
import software.amazon.awssdk.services.amplify.model.ListJobsResponse;
import software.amazon.awssdk.services.amplify.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.amplify.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.amplify.model.ListWebhooksRequest;
import software.amazon.awssdk.services.amplify.model.ListWebhooksResponse;
import software.amazon.awssdk.services.amplify.model.NotFoundException;
import software.amazon.awssdk.services.amplify.model.ResourceNotFoundException;
import software.amazon.awssdk.services.amplify.model.StartDeploymentRequest;
import software.amazon.awssdk.services.amplify.model.StartDeploymentResponse;
import software.amazon.awssdk.services.amplify.model.StartJobRequest;
import software.amazon.awssdk.services.amplify.model.StartJobResponse;
import software.amazon.awssdk.services.amplify.model.StopJobRequest;
import software.amazon.awssdk.services.amplify.model.StopJobResponse;
import software.amazon.awssdk.services.amplify.model.TagResourceRequest;
import software.amazon.awssdk.services.amplify.model.TagResourceResponse;
import software.amazon.awssdk.services.amplify.model.UnauthorizedException;
import software.amazon.awssdk.services.amplify.model.UntagResourceRequest;
import software.amazon.awssdk.services.amplify.model.UntagResourceResponse;
import software.amazon.awssdk.services.amplify.model.UpdateAppRequest;
import software.amazon.awssdk.services.amplify.model.UpdateAppResponse;
import software.amazon.awssdk.services.amplify.model.UpdateBranchRequest;
import software.amazon.awssdk.services.amplify.model.UpdateBranchResponse;
import software.amazon.awssdk.services.amplify.model.UpdateDomainAssociationRequest;
import software.amazon.awssdk.services.amplify.model.UpdateDomainAssociationResponse;
import software.amazon.awssdk.services.amplify.model.UpdateWebhookRequest;
import software.amazon.awssdk.services.amplify.model.UpdateWebhookResponse;
import software.amazon.awssdk.services.amplify.transform.CreateAppRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.CreateBackendEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.CreateBranchRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.CreateDeploymentRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.CreateDomainAssociationRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.CreateWebhookRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.DeleteAppRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.DeleteBackendEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.DeleteBranchRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.DeleteDomainAssociationRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.DeleteJobRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.DeleteWebhookRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.GenerateAccessLogsRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.GetAppRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.GetArtifactUrlRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.GetBackendEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.GetBranchRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.GetDomainAssociationRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.GetJobRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.GetWebhookRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.ListAppsRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.ListArtifactsRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.ListBackendEnvironmentsRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.ListBranchesRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.ListDomainAssociationsRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.ListWebhooksRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.StartDeploymentRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.StartJobRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.StopJobRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.UpdateAppRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.UpdateBranchRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.UpdateDomainAssociationRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.UpdateWebhookRequestMarshaller;

@SdkInternalApi
final class DefaultAmplifyClient
implements AmplifyClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAmplifyClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "amplify";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAppResponse createApp(CreateAppRequest createAppRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, LimitExceededException, DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAppResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateApp");
            CreateAppResponse createAppResponse = (CreateAppResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApp").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAppRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAppResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, createAppRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBackendEnvironmentResponse createBackendEnvironment(CreateBackendEnvironmentRequest createBackendEnvironmentRequest) throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBackendEnvironmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBackendEnvironment");
            CreateBackendEnvironmentResponse createBackendEnvironmentResponse = (CreateBackendEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBackendEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createBackendEnvironmentRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateBackendEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBackendEnvironmentResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, createBackendEnvironmentRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBranchResponse createBranch(CreateBranchRequest createBranchRequest) throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, LimitExceededException, DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBranchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBranch");
            CreateBranchResponse createBranchResponse = (CreateBranchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBranch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createBranchRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateBranchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBranchResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, createBranchRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDeploymentResponse createDeployment(CreateDeploymentRequest createDeploymentRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDeploymentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDeployment");
            CreateDeploymentResponse createDeploymentResponse = (CreateDeploymentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDeployment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDeploymentRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateDeploymentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDeploymentResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, createDeploymentRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDomainAssociationResponse createDomainAssociation(CreateDomainAssociationRequest createDomainAssociationRequest) throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, LimitExceededException, DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDomainAssociationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDomainAssociation");
            CreateDomainAssociationResponse createDomainAssociationResponse = (CreateDomainAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDomainAssociation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDomainAssociationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateDomainAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDomainAssociationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, createDomainAssociationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWebhookResponse createWebhook(CreateWebhookRequest createWebhookRequest) throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, LimitExceededException, DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWebhookResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWebhook");
            CreateWebhookResponse createWebhookResponse = (CreateWebhookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWebhook").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createWebhookRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateWebhookRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWebhookResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, createWebhookRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAppResponse deleteApp(DeleteAppRequest deleteAppRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAppResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApp");
            DeleteAppResponse deleteAppResponse = (DeleteAppResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApp").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAppRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAppResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, deleteAppRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBackendEnvironmentResponse deleteBackendEnvironment(DeleteBackendEnvironmentRequest deleteBackendEnvironmentRequest) throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBackendEnvironmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBackendEnvironment");
            DeleteBackendEnvironmentResponse deleteBackendEnvironmentResponse = (DeleteBackendEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBackendEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteBackendEnvironmentRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteBackendEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteBackendEnvironmentResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, deleteBackendEnvironmentRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBranchResponse deleteBranch(DeleteBranchRequest deleteBranchRequest) throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBranchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBranch");
            DeleteBranchResponse deleteBranchResponse = (DeleteBranchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBranch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteBranchRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteBranchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteBranchResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, deleteBranchRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDomainAssociationResponse deleteDomainAssociation(DeleteDomainAssociationRequest deleteDomainAssociationRequest) throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDomainAssociationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDomainAssociation");
            DeleteDomainAssociationResponse deleteDomainAssociationResponse = (DeleteDomainAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDomainAssociation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDomainAssociationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDomainAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDomainAssociationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, deleteDomainAssociationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteJobResponse deleteJob(DeleteJobRequest deleteJobRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteJob");
            DeleteJobResponse deleteJobResponse = (DeleteJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteJobRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteJobResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, deleteJobRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWebhookResponse deleteWebhook(DeleteWebhookRequest deleteWebhookRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWebhookResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWebhook");
            DeleteWebhookResponse deleteWebhookResponse = (DeleteWebhookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWebhook").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteWebhookRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWebhookRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWebhookResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, deleteWebhookRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerateAccessLogsResponse generateAccessLogs(GenerateAccessLogsRequest generateAccessLogsRequest) throws NotFoundException, BadRequestException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateAccessLogsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateAccessLogs");
            GenerateAccessLogsResponse generateAccessLogsResponse = (GenerateAccessLogsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateAccessLogs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)generateAccessLogsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GenerateAccessLogsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return generateAccessLogsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, generateAccessLogsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAppResponse getApp(GetAppRequest getAppRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAppResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetApp");
            GetAppResponse getAppResponse = (GetAppResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApp").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAppRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAppResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, getAppRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetArtifactUrlResponse getArtifactUrl(GetArtifactUrlRequest getArtifactUrlRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetArtifactUrlResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetArtifactUrl");
            GetArtifactUrlResponse getArtifactUrlResponse = (GetArtifactUrlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetArtifactUrl").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getArtifactUrlRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetArtifactUrlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getArtifactUrlResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, getArtifactUrlRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBackendEnvironmentResponse getBackendEnvironment(GetBackendEnvironmentRequest getBackendEnvironmentRequest) throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBackendEnvironmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBackendEnvironment");
            GetBackendEnvironmentResponse getBackendEnvironmentResponse = (GetBackendEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBackendEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getBackendEnvironmentRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetBackendEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getBackendEnvironmentResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, getBackendEnvironmentRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBranchResponse getBranch(GetBranchRequest getBranchRequest) throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBranchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBranch");
            GetBranchResponse getBranchResponse = (GetBranchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBranch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getBranchRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetBranchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getBranchResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, getBranchRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDomainAssociationResponse getDomainAssociation(GetDomainAssociationRequest getDomainAssociationRequest) throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDomainAssociationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDomainAssociation");
            GetDomainAssociationResponse getDomainAssociationResponse = (GetDomainAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDomainAssociation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDomainAssociationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetDomainAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDomainAssociationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, getDomainAssociationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetJobResponse getJob(GetJobRequest getJobRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJob");
            GetJobResponse getJobResponse = (GetJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getJobRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getJobResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, getJobRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetWebhookResponse getWebhook(GetWebhookRequest getWebhookRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWebhookResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWebhook");
            GetWebhookResponse getWebhookResponse = (GetWebhookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWebhook").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getWebhookRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetWebhookRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getWebhookResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, getWebhookRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAppsResponse listApps(ListAppsRequest listAppsRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAppsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApps");
            ListAppsResponse listAppsResponse = (ListAppsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApps").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAppsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListAppsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAppsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, listAppsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListArtifactsResponse listArtifacts(ListArtifactsRequest listArtifactsRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListArtifactsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListArtifacts");
            ListArtifactsResponse listArtifactsResponse = (ListArtifactsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListArtifacts").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listArtifactsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListArtifactsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listArtifactsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, listArtifactsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBackendEnvironmentsResponse listBackendEnvironments(ListBackendEnvironmentsRequest listBackendEnvironmentsRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBackendEnvironmentsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBackendEnvironments");
            ListBackendEnvironmentsResponse listBackendEnvironmentsResponse = (ListBackendEnvironmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBackendEnvironments").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBackendEnvironmentsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListBackendEnvironmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBackendEnvironmentsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, listBackendEnvironmentsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBranchesResponse listBranches(ListBranchesRequest listBranchesRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBranchesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBranches");
            ListBranchesResponse listBranchesResponse = (ListBranchesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBranches").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBranchesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListBranchesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBranchesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, listBranchesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDomainAssociationsResponse listDomainAssociations(ListDomainAssociationsRequest listDomainAssociationsRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDomainAssociationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDomainAssociations");
            ListDomainAssociationsResponse listDomainAssociationsResponse = (ListDomainAssociationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDomainAssociations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDomainAssociationsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListDomainAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDomainAssociationsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, listDomainAssociationsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListJobs");
            ListJobsResponse listJobsResponse = (ListJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listJobsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listJobsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, listJobsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalFailureException, BadRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWebhooksResponse listWebhooks(ListWebhooksRequest listWebhooksRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWebhooksResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWebhooks");
            ListWebhooksResponse listWebhooksResponse = (ListWebhooksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWebhooks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listWebhooksRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListWebhooksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWebhooksResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, listWebhooksRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartDeploymentResponse startDeployment(StartDeploymentRequest startDeploymentRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDeploymentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDeployment");
            StartDeploymentResponse startDeploymentResponse = (StartDeploymentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDeployment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startDeploymentRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new StartDeploymentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startDeploymentResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, startDeploymentRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartJobResponse startJob(StartJobRequest startJobRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartJob");
            StartJobResponse startJobResponse = (StartJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startJobRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new StartJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startJobResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, startJobRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopJobResponse stopJob(StopJobRequest stopJobRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopJob");
            StopJobResponse stopJobResponse = (StopJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopJobRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new StopJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopJobResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, stopJobRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalFailureException, BadRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalFailureException, BadRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAppResponse updateApp(UpdateAppRequest updateAppRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAppResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApp");
            UpdateAppResponse updateAppResponse = (UpdateAppResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApp").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAppRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAppResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, updateAppRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateBranchResponse updateBranch(UpdateBranchRequest updateBranchRequest) throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBranchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBranch");
            UpdateBranchResponse updateBranchResponse = (UpdateBranchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBranch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateBranchRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateBranchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateBranchResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, updateBranchRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDomainAssociationResponse updateDomainAssociation(UpdateDomainAssociationRequest updateDomainAssociationRequest) throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDomainAssociationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDomainAssociation");
            UpdateDomainAssociationResponse updateDomainAssociationResponse = (UpdateDomainAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDomainAssociation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDomainAssociationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDomainAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDomainAssociationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, updateDomainAssociationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateWebhookResponse updateWebhook(UpdateWebhookRequest updateWebhookRequest) throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateWebhookResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateWebhook");
            UpdateWebhookResponse updateWebhookResponse = (UpdateWebhookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateWebhook").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateWebhookRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateWebhookRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateWebhookResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(this.clientConfiguration, updateWebhookRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(AmplifyException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InternalFailureException").exceptionBuilderSupplier(InternalFailureException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFoundException").exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnauthorizedException").exceptionBuilderSupplier(UnauthorizedException::builder).httpStatusCode(Integer.valueOf(401)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DependentServiceFailureException").exceptionBuilderSupplier(DependentServiceFailureException::builder).httpStatusCode(Integer.valueOf(503)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BadRequestException").exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

