/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request structure for the update webhook request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWebhookRequest extends AmplifyRequest implements
        ToCopyableBuilder<UpdateWebhookRequest.Builder, UpdateWebhookRequest> {
    private static final SdkField<String> WEBHOOK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("webhookId").getter(getter(UpdateWebhookRequest::webhookId)).setter(setter(Builder::webhookId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("webhookId").build()).build();

    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("branchName").getter(getter(UpdateWebhookRequest::branchName)).setter(setter(Builder::branchName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateWebhookRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEBHOOK_ID_FIELD,
            BRANCH_NAME_FIELD, DESCRIPTION_FIELD));

    private final String webhookId;

    private final String branchName;

    private final String description;

    private UpdateWebhookRequest(BuilderImpl builder) {
        super(builder);
        this.webhookId = builder.webhookId;
        this.branchName = builder.branchName;
        this.description = builder.description;
    }

    /**
     * <p>
     * The unique ID for a webhook.
     * </p>
     * 
     * @return The unique ID for a webhook.
     */
    public String webhookId() {
        return webhookId;
    }

    /**
     * <p>
     * The name for a branch that is part of an Amplify app.
     * </p>
     * 
     * @return The name for a branch that is part of an Amplify app.
     */
    public String branchName() {
        return branchName;
    }

    /**
     * <p>
     * The description for a webhook.
     * </p>
     * 
     * @return The description for a webhook.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(webhookId());
        hashCode = 31 * hashCode + Objects.hashCode(branchName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWebhookRequest)) {
            return false;
        }
        UpdateWebhookRequest other = (UpdateWebhookRequest) obj;
        return Objects.equals(webhookId(), other.webhookId()) && Objects.equals(branchName(), other.branchName())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateWebhookRequest").add("WebhookId", webhookId()).add("BranchName", branchName())
                .add("Description", description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "webhookId":
            return Optional.ofNullable(clazz.cast(webhookId()));
        case "branchName":
            return Optional.ofNullable(clazz.cast(branchName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWebhookRequest, T> g) {
        return obj -> g.apply((UpdateWebhookRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWebhookRequest> {
        /**
         * <p>
         * The unique ID for a webhook.
         * </p>
         * 
         * @param webhookId
         *        The unique ID for a webhook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webhookId(String webhookId);

        /**
         * <p>
         * The name for a branch that is part of an Amplify app.
         * </p>
         * 
         * @param branchName
         *        The name for a branch that is part of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchName(String branchName);

        /**
         * <p>
         * The description for a webhook.
         * </p>
         * 
         * @param description
         *        The description for a webhook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmplifyRequest.BuilderImpl implements Builder {
        private String webhookId;

        private String branchName;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWebhookRequest model) {
            super(model);
            webhookId(model.webhookId);
            branchName(model.branchName);
            description(model.description);
        }

        public final String getWebhookId() {
            return webhookId;
        }

        @Override
        public final Builder webhookId(String webhookId) {
            this.webhookId = webhookId;
            return this;
        }

        public final void setWebhookId(String webhookId) {
            this.webhookId = webhookId;
        }

        public final String getBranchName() {
            return branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWebhookRequest build() {
            return new UpdateWebhookRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
