/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result structure for the delete app request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAppResponse extends AmplifyResponse implements
        ToCopyableBuilder<DeleteAppResponse.Builder, DeleteAppResponse> {
    private static final SdkField<App> APP_FIELD = SdkField.<App> builder(MarshallingType.SDK_POJO).memberName("app")
            .getter(getter(DeleteAppResponse::app)).setter(setter(Builder::app)).constructor(App::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("app").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_FIELD));

    private final App app;

    private DeleteAppResponse(BuilderImpl builder) {
        super(builder);
        this.app = builder.app;
    }

    /**
     * Returns the value of the App property for this object.
     * 
     * @return The value of the App property for this object.
     */
    public App app() {
        return app;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(app());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAppResponse)) {
            return false;
        }
        DeleteAppResponse other = (DeleteAppResponse) obj;
        return Objects.equals(app(), other.app());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteAppResponse").add("App", app()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "app":
            return Optional.ofNullable(clazz.cast(app()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAppResponse, T> g) {
        return obj -> g.apply((DeleteAppResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteAppResponse> {
        /**
         * Sets the value of the App property for this object.
         *
         * @param app
         *        The new value for the App property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder app(App app);

        /**
         * Sets the value of the App property for this object.
         *
         * This is a convenience that creates an instance of the {@link App.Builder} avoiding the need to create one
         * manually via {@link App#builder()}.
         *
         * When the {@link Consumer} completes, {@link App.Builder#build()} is called immediately and its result is
         * passed to {@link #app(App)}.
         * 
         * @param app
         *        a consumer that will call methods on {@link App.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #app(App)
         */
        default Builder app(Consumer<App.Builder> app) {
            return app(App.builder().applyMutation(app).build());
        }
    }

    static final class BuilderImpl extends AmplifyResponse.BuilderImpl implements Builder {
        private App app;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAppResponse model) {
            super(model);
            app(model.app);
        }

        public final App.Builder getApp() {
            return app != null ? app.toBuilder() : null;
        }

        @Override
        public final Builder app(App app) {
            this.app = app;
            return this;
        }

        public final void setApp(App.BuilderImpl app) {
            this.app = app != null ? app.build() : null;
        }

        @Override
        public DeleteAppResponse build() {
            return new DeleteAppResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
