/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplify.model.AmplifyResponse;
import software.amazon.awssdk.services.amplify.model.DomainAssociation;
import software.amazon.awssdk.services.amplify.model.DomainAssociationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDomainAssociationsResponse
extends AmplifyResponse
implements ToCopyableBuilder<Builder, ListDomainAssociationsResponse> {
    private static final SdkField<List<DomainAssociation>> DOMAIN_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("domainAssociations").getter(ListDomainAssociationsResponse.getter(ListDomainAssociationsResponse::domainAssociations)).setter(ListDomainAssociationsResponse.setter(Builder::domainAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDomainAssociationsResponse.getter(ListDomainAssociationsResponse::nextToken)).setter(ListDomainAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<DomainAssociation> domainAssociations;
    private final String nextToken;

    private ListDomainAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.domainAssociations = builder.domainAssociations;
        this.nextToken = builder.nextToken;
    }

    public boolean hasDomainAssociations() {
        return this.domainAssociations != null && !(this.domainAssociations instanceof SdkAutoConstructList);
    }

    public List<DomainAssociation> domainAssociations() {
        return this.domainAssociations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainAssociations() ? this.domainAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainAssociationsResponse)) {
            return false;
        }
        ListDomainAssociationsResponse other = (ListDomainAssociationsResponse)((Object)obj);
        return this.hasDomainAssociations() == other.hasDomainAssociations() && Objects.equals(this.domainAssociations(), other.domainAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDomainAssociationsResponse").add("DomainAssociations", this.hasDomainAssociations() ? this.domainAssociations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainAssociations": {
                return Optional.ofNullable(clazz.cast(this.domainAssociations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDomainAssociationsResponse, T> g) {
        return obj -> g.apply((ListDomainAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyResponse.BuilderImpl
    implements Builder {
        private List<DomainAssociation> domainAssociations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainAssociationsResponse model) {
            super(model);
            this.domainAssociations(model.domainAssociations);
            this.nextToken(model.nextToken);
        }

        public final Collection<DomainAssociation.Builder> getDomainAssociations() {
            if (this.domainAssociations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.domainAssociations != null ? (Collection)this.domainAssociations.stream().map(DomainAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainAssociations(Collection<DomainAssociation> domainAssociations) {
            this.domainAssociations = DomainAssociationsCopier.copy(domainAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainAssociations(DomainAssociation ... domainAssociations) {
            this.domainAssociations(Arrays.asList(domainAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainAssociations(Consumer<DomainAssociation.Builder> ... domainAssociations) {
            this.domainAssociations(Stream.of(domainAssociations).map(c -> (DomainAssociation)((DomainAssociation.Builder)DomainAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDomainAssociations(Collection<DomainAssociation.BuilderImpl> domainAssociations) {
            this.domainAssociations = DomainAssociationsCopier.copyFromBuilder(domainAssociations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDomainAssociationsResponse build() {
            return new ListDomainAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AmplifyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDomainAssociationsResponse> {
        public Builder domainAssociations(Collection<DomainAssociation> var1);

        public Builder domainAssociations(DomainAssociation ... var1);

        public Builder domainAssociations(Consumer<DomainAssociation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

