/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amplify.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.amplify.model.Stage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoBranchCreationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoBranchCreationConfig> {
    private static final SdkField<String> STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stage").getter(AutoBranchCreationConfig.getter(AutoBranchCreationConfig::stageAsString)).setter(AutoBranchCreationConfig.setter(Builder::stage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()}).build();
    private static final SdkField<String> FRAMEWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("framework").getter(AutoBranchCreationConfig.getter(AutoBranchCreationConfig::framework)).setter(AutoBranchCreationConfig.setter(Builder::framework)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framework").build()}).build();
    private static final SdkField<Boolean> ENABLE_AUTO_BUILD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableAutoBuild").getter(AutoBranchCreationConfig.getter(AutoBranchCreationConfig::enableAutoBuild)).setter(AutoBranchCreationConfig.setter(Builder::enableAutoBuild)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableAutoBuild").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("environmentVariables").getter(AutoBranchCreationConfig.getter(AutoBranchCreationConfig::environmentVariables)).setter(AutoBranchCreationConfig.setter(Builder::environmentVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> BASIC_AUTH_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("basicAuthCredentials").getter(AutoBranchCreationConfig.getter(AutoBranchCreationConfig::basicAuthCredentials)).setter(AutoBranchCreationConfig.setter(Builder::basicAuthCredentials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basicAuthCredentials").build()}).build();
    private static final SdkField<Boolean> ENABLE_BASIC_AUTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableBasicAuth").getter(AutoBranchCreationConfig.getter(AutoBranchCreationConfig::enableBasicAuth)).setter(AutoBranchCreationConfig.setter(Builder::enableBasicAuth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBasicAuth").build()}).build();
    private static final SdkField<Boolean> ENABLE_PERFORMANCE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enablePerformanceMode").getter(AutoBranchCreationConfig.getter(AutoBranchCreationConfig::enablePerformanceMode)).setter(AutoBranchCreationConfig.setter(Builder::enablePerformanceMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enablePerformanceMode").build()}).build();
    private static final SdkField<String> BUILD_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("buildSpec").getter(AutoBranchCreationConfig.getter(AutoBranchCreationConfig::buildSpec)).setter(AutoBranchCreationConfig.setter(Builder::buildSpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildSpec").build()}).build();
    private static final SdkField<Boolean> ENABLE_PULL_REQUEST_PREVIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enablePullRequestPreview").getter(AutoBranchCreationConfig.getter(AutoBranchCreationConfig::enablePullRequestPreview)).setter(AutoBranchCreationConfig.setter(Builder::enablePullRequestPreview)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enablePullRequestPreview").build()}).build();
    private static final SdkField<String> PULL_REQUEST_ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pullRequestEnvironmentName").getter(AutoBranchCreationConfig.getter(AutoBranchCreationConfig::pullRequestEnvironmentName)).setter(AutoBranchCreationConfig.setter(Builder::pullRequestEnvironmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestEnvironmentName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_FIELD, FRAMEWORK_FIELD, ENABLE_AUTO_BUILD_FIELD, ENVIRONMENT_VARIABLES_FIELD, BASIC_AUTH_CREDENTIALS_FIELD, ENABLE_BASIC_AUTH_FIELD, ENABLE_PERFORMANCE_MODE_FIELD, BUILD_SPEC_FIELD, ENABLE_PULL_REQUEST_PREVIEW_FIELD, PULL_REQUEST_ENVIRONMENT_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String stage;
    private final String framework;
    private final Boolean enableAutoBuild;
    private final Map<String, String> environmentVariables;
    private final String basicAuthCredentials;
    private final Boolean enableBasicAuth;
    private final Boolean enablePerformanceMode;
    private final String buildSpec;
    private final Boolean enablePullRequestPreview;
    private final String pullRequestEnvironmentName;

    private AutoBranchCreationConfig(BuilderImpl builder) {
        this.stage = builder.stage;
        this.framework = builder.framework;
        this.enableAutoBuild = builder.enableAutoBuild;
        this.environmentVariables = builder.environmentVariables;
        this.basicAuthCredentials = builder.basicAuthCredentials;
        this.enableBasicAuth = builder.enableBasicAuth;
        this.enablePerformanceMode = builder.enablePerformanceMode;
        this.buildSpec = builder.buildSpec;
        this.enablePullRequestPreview = builder.enablePullRequestPreview;
        this.pullRequestEnvironmentName = builder.pullRequestEnvironmentName;
    }

    public Stage stage() {
        return Stage.fromValue(this.stage);
    }

    public String stageAsString() {
        return this.stage;
    }

    public String framework() {
        return this.framework;
    }

    public Boolean enableAutoBuild() {
        return this.enableAutoBuild;
    }

    public boolean hasEnvironmentVariables() {
        return this.environmentVariables != null && !(this.environmentVariables instanceof SdkAutoConstructMap);
    }

    public Map<String, String> environmentVariables() {
        return this.environmentVariables;
    }

    public String basicAuthCredentials() {
        return this.basicAuthCredentials;
    }

    public Boolean enableBasicAuth() {
        return this.enableBasicAuth;
    }

    public Boolean enablePerformanceMode() {
        return this.enablePerformanceMode;
    }

    public String buildSpec() {
        return this.buildSpec;
    }

    public Boolean enablePullRequestPreview() {
        return this.enablePullRequestPreview;
    }

    public String pullRequestEnvironmentName() {
        return this.pullRequestEnvironmentName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framework());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableAutoBuild());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentVariables() ? this.environmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.basicAuthCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableBasicAuth());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePerformanceMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePullRequestPreview());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestEnvironmentName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoBranchCreationConfig)) {
            return false;
        }
        AutoBranchCreationConfig other = (AutoBranchCreationConfig)obj;
        return Objects.equals(this.stageAsString(), other.stageAsString()) && Objects.equals(this.framework(), other.framework()) && Objects.equals(this.enableAutoBuild(), other.enableAutoBuild()) && this.hasEnvironmentVariables() == other.hasEnvironmentVariables() && Objects.equals(this.environmentVariables(), other.environmentVariables()) && Objects.equals(this.basicAuthCredentials(), other.basicAuthCredentials()) && Objects.equals(this.enableBasicAuth(), other.enableBasicAuth()) && Objects.equals(this.enablePerformanceMode(), other.enablePerformanceMode()) && Objects.equals(this.buildSpec(), other.buildSpec()) && Objects.equals(this.enablePullRequestPreview(), other.enablePullRequestPreview()) && Objects.equals(this.pullRequestEnvironmentName(), other.pullRequestEnvironmentName());
    }

    public String toString() {
        return ToString.builder((String)"AutoBranchCreationConfig").add("Stage", (Object)this.stageAsString()).add("Framework", (Object)this.framework()).add("EnableAutoBuild", (Object)this.enableAutoBuild()).add("EnvironmentVariables", this.hasEnvironmentVariables() ? this.environmentVariables() : null).add("BasicAuthCredentials", (Object)(this.basicAuthCredentials() == null ? null : "*** Sensitive Data Redacted ***")).add("EnableBasicAuth", (Object)this.enableBasicAuth()).add("EnablePerformanceMode", (Object)this.enablePerformanceMode()).add("BuildSpec", (Object)this.buildSpec()).add("EnablePullRequestPreview", (Object)this.enablePullRequestPreview()).add("PullRequestEnvironmentName", (Object)this.pullRequestEnvironmentName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stage": {
                return Optional.ofNullable(clazz.cast(this.stageAsString()));
            }
            case "framework": {
                return Optional.ofNullable(clazz.cast(this.framework()));
            }
            case "enableAutoBuild": {
                return Optional.ofNullable(clazz.cast(this.enableAutoBuild()));
            }
            case "environmentVariables": {
                return Optional.ofNullable(clazz.cast(this.environmentVariables()));
            }
            case "basicAuthCredentials": {
                return Optional.ofNullable(clazz.cast(this.basicAuthCredentials()));
            }
            case "enableBasicAuth": {
                return Optional.ofNullable(clazz.cast(this.enableBasicAuth()));
            }
            case "enablePerformanceMode": {
                return Optional.ofNullable(clazz.cast(this.enablePerformanceMode()));
            }
            case "buildSpec": {
                return Optional.ofNullable(clazz.cast(this.buildSpec()));
            }
            case "enablePullRequestPreview": {
                return Optional.ofNullable(clazz.cast(this.enablePullRequestPreview()));
            }
            case "pullRequestEnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.pullRequestEnvironmentName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoBranchCreationConfig, T> g) {
        return obj -> g.apply((AutoBranchCreationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stage;
        private String framework;
        private Boolean enableAutoBuild;
        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();
        private String basicAuthCredentials;
        private Boolean enableBasicAuth;
        private Boolean enablePerformanceMode;
        private String buildSpec;
        private Boolean enablePullRequestPreview;
        private String pullRequestEnvironmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoBranchCreationConfig model) {
            this.stage(model.stage);
            this.framework(model.framework);
            this.enableAutoBuild(model.enableAutoBuild);
            this.environmentVariables(model.environmentVariables);
            this.basicAuthCredentials(model.basicAuthCredentials);
            this.enableBasicAuth(model.enableBasicAuth);
            this.enablePerformanceMode(model.enablePerformanceMode);
            this.buildSpec(model.buildSpec);
            this.enablePullRequestPreview(model.enablePullRequestPreview);
            this.pullRequestEnvironmentName(model.pullRequestEnvironmentName);
        }

        public final String getStage() {
            return this.stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public final Builder stage(Stage stage) {
            this.stage(stage == null ? null : stage.toString());
            return this;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        public final String getFramework() {
            return this.framework;
        }

        @Override
        public final Builder framework(String framework) {
            this.framework = framework;
            return this;
        }

        public final void setFramework(String framework) {
            this.framework = framework;
        }

        public final Boolean getEnableAutoBuild() {
            return this.enableAutoBuild;
        }

        @Override
        public final Builder enableAutoBuild(Boolean enableAutoBuild) {
            this.enableAutoBuild = enableAutoBuild;
            return this;
        }

        public final void setEnableAutoBuild(Boolean enableAutoBuild) {
            this.enableAutoBuild = enableAutoBuild;
        }

        public final Map<String, String> getEnvironmentVariables() {
            if (this.environmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environmentVariables;
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
            return this;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
        }

        public final String getBasicAuthCredentials() {
            return this.basicAuthCredentials;
        }

        @Override
        public final Builder basicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
            return this;
        }

        public final void setBasicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
        }

        public final Boolean getEnableBasicAuth() {
            return this.enableBasicAuth;
        }

        @Override
        public final Builder enableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
            return this;
        }

        public final void setEnableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
        }

        public final Boolean getEnablePerformanceMode() {
            return this.enablePerformanceMode;
        }

        @Override
        public final Builder enablePerformanceMode(Boolean enablePerformanceMode) {
            this.enablePerformanceMode = enablePerformanceMode;
            return this;
        }

        public final void setEnablePerformanceMode(Boolean enablePerformanceMode) {
            this.enablePerformanceMode = enablePerformanceMode;
        }

        public final String getBuildSpec() {
            return this.buildSpec;
        }

        @Override
        public final Builder buildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        public final void setBuildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
        }

        public final Boolean getEnablePullRequestPreview() {
            return this.enablePullRequestPreview;
        }

        @Override
        public final Builder enablePullRequestPreview(Boolean enablePullRequestPreview) {
            this.enablePullRequestPreview = enablePullRequestPreview;
            return this;
        }

        public final void setEnablePullRequestPreview(Boolean enablePullRequestPreview) {
            this.enablePullRequestPreview = enablePullRequestPreview;
        }

        public final String getPullRequestEnvironmentName() {
            return this.pullRequestEnvironmentName;
        }

        @Override
        public final Builder pullRequestEnvironmentName(String pullRequestEnvironmentName) {
            this.pullRequestEnvironmentName = pullRequestEnvironmentName;
            return this;
        }

        public final void setPullRequestEnvironmentName(String pullRequestEnvironmentName) {
            this.pullRequestEnvironmentName = pullRequestEnvironmentName;
        }

        public AutoBranchCreationConfig build() {
            return new AutoBranchCreationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoBranchCreationConfig> {
        public Builder stage(String var1);

        public Builder stage(Stage var1);

        public Builder framework(String var1);

        public Builder enableAutoBuild(Boolean var1);

        public Builder environmentVariables(Map<String, String> var1);

        public Builder basicAuthCredentials(String var1);

        public Builder enableBasicAuth(Boolean var1);

        public Builder enablePerformanceMode(Boolean var1);

        public Builder buildSpec(String var1);

        public Builder enablePullRequestPreview(Boolean var1);

        public Builder pullRequestEnvironmentName(String var1);
    }
}

