/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result structure for the list backend environments result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBackendEnvironmentsResponse extends AmplifyResponse implements
        ToCopyableBuilder<ListBackendEnvironmentsResponse.Builder, ListBackendEnvironmentsResponse> {
    private static final SdkField<List<BackendEnvironment>> BACKEND_ENVIRONMENTS_FIELD = SdkField
            .<List<BackendEnvironment>> builder(MarshallingType.LIST)
            .memberName("backendEnvironments")
            .getter(getter(ListBackendEnvironmentsResponse::backendEnvironments))
            .setter(setter(Builder::backendEnvironments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendEnvironments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BackendEnvironment> builder(MarshallingType.SDK_POJO)
                                            .constructor(BackendEnvironment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBackendEnvironmentsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKEND_ENVIRONMENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<BackendEnvironment> backendEnvironments;

    private final String nextToken;

    private ListBackendEnvironmentsResponse(BuilderImpl builder) {
        super(builder);
        this.backendEnvironments = builder.backendEnvironments;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the BackendEnvironments property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBackendEnvironments() {
        return backendEnvironments != null && !(backendEnvironments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of backend environments for an Amplify app.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBackendEnvironments} method.
     * </p>
     * 
     * @return The list of backend environments for an Amplify app.
     */
    public final List<BackendEnvironment> backendEnvironments() {
        return backendEnvironments;
    }

    /**
     * <p>
     * A pagination token. If a non-null pagination token is returned in a result, pass its value in another request to
     * retrieve more entries.
     * </p>
     * 
     * @return A pagination token. If a non-null pagination token is returned in a result, pass its value in another
     *         request to retrieve more entries.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBackendEnvironments() ? backendEnvironments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBackendEnvironmentsResponse)) {
            return false;
        }
        ListBackendEnvironmentsResponse other = (ListBackendEnvironmentsResponse) obj;
        return hasBackendEnvironments() == other.hasBackendEnvironments()
                && Objects.equals(backendEnvironments(), other.backendEnvironments())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBackendEnvironmentsResponse")
                .add("BackendEnvironments", hasBackendEnvironments() ? backendEnvironments() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "backendEnvironments":
            return Optional.ofNullable(clazz.cast(backendEnvironments()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBackendEnvironmentsResponse, T> g) {
        return obj -> g.apply((ListBackendEnvironmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListBackendEnvironmentsResponse> {
        /**
         * <p>
         * The list of backend environments for an Amplify app.
         * </p>
         * 
         * @param backendEnvironments
         *        The list of backend environments for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backendEnvironments(Collection<BackendEnvironment> backendEnvironments);

        /**
         * <p>
         * The list of backend environments for an Amplify app.
         * </p>
         * 
         * @param backendEnvironments
         *        The list of backend environments for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backendEnvironments(BackendEnvironment... backendEnvironments);

        /**
         * <p>
         * The list of backend environments for an Amplify app.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BackendEnvironment>.Builder} avoiding the
         * need to create one manually via {@link List<BackendEnvironment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BackendEnvironment>.Builder#build()} is called immediately
         * and its result is passed to {@link #backendEnvironments(List<BackendEnvironment>)}.
         * 
         * @param backendEnvironments
         *        a consumer that will call methods on {@link List<BackendEnvironment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backendEnvironments(List<BackendEnvironment>)
         */
        Builder backendEnvironments(Consumer<BackendEnvironment.Builder>... backendEnvironments);

        /**
         * <p>
         * A pagination token. If a non-null pagination token is returned in a result, pass its value in another request
         * to retrieve more entries.
         * </p>
         * 
         * @param nextToken
         *        A pagination token. If a non-null pagination token is returned in a result, pass its value in another
         *        request to retrieve more entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AmplifyResponse.BuilderImpl implements Builder {
        private List<BackendEnvironment> backendEnvironments = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBackendEnvironmentsResponse model) {
            super(model);
            backendEnvironments(model.backendEnvironments);
            nextToken(model.nextToken);
        }

        public final List<BackendEnvironment.Builder> getBackendEnvironments() {
            List<BackendEnvironment.Builder> result = BackendEnvironmentsCopier.copyToBuilder(this.backendEnvironments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBackendEnvironments(Collection<BackendEnvironment.BuilderImpl> backendEnvironments) {
            this.backendEnvironments = BackendEnvironmentsCopier.copyFromBuilder(backendEnvironments);
        }

        @Override
        @Transient
        public final Builder backendEnvironments(Collection<BackendEnvironment> backendEnvironments) {
            this.backendEnvironments = BackendEnvironmentsCopier.copy(backendEnvironments);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder backendEnvironments(BackendEnvironment... backendEnvironments) {
            backendEnvironments(Arrays.asList(backendEnvironments));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder backendEnvironments(Consumer<BackendEnvironment.Builder>... backendEnvironments) {
            backendEnvironments(Stream.of(backendEnvironments).map(c -> BackendEnvironment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBackendEnvironmentsResponse build() {
            return new ListBackendEnvironmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
