/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an execution job for an Amplify app.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Job implements SdkPojo, Serializable, ToCopyableBuilder<Job.Builder, Job> {
    private static final SdkField<JobSummary> SUMMARY_FIELD = SdkField.<JobSummary> builder(MarshallingType.SDK_POJO)
            .memberName("summary").getter(getter(Job::summary)).setter(setter(Builder::summary)).constructor(JobSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()).build();

    private static final SdkField<List<Step>> STEPS_FIELD = SdkField
            .<List<Step>> builder(MarshallingType.LIST)
            .memberName("steps")
            .getter(getter(Job::steps))
            .setter(setter(Builder::steps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("steps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Step> builder(MarshallingType.SDK_POJO)
                                            .constructor(Step::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_FIELD, STEPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final JobSummary summary;

    private final List<Step> steps;

    private Job(BuilderImpl builder) {
        this.summary = builder.summary;
        this.steps = builder.steps;
    }

    /**
     * <p>
     * Describes the summary for an execution job for an Amplify app.
     * </p>
     * 
     * @return Describes the summary for an execution job for an Amplify app.
     */
    public final JobSummary summary() {
        return summary;
    }

    /**
     * For responses, this returns true if the service returned a value for the Steps property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSteps() {
        return steps != null && !(steps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The execution steps for an execution job, for an Amplify app.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSteps} method.
     * </p>
     * 
     * @return The execution steps for an execution job, for an Amplify app.
     */
    public final List<Step> steps() {
        return steps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        hashCode = 31 * hashCode + Objects.hashCode(hasSteps() ? steps() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job) obj;
        return Objects.equals(summary(), other.summary()) && hasSteps() == other.hasSteps()
                && Objects.equals(steps(), other.steps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Job").add("Summary", summary()).add("Steps", hasSteps() ? steps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "summary":
            return Optional.ofNullable(clazz.cast(summary()));
        case "steps":
            return Optional.ofNullable(clazz.cast(steps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Job, T> g) {
        return obj -> g.apply((Job) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Job> {
        /**
         * <p>
         * Describes the summary for an execution job for an Amplify app.
         * </p>
         * 
         * @param summary
         *        Describes the summary for an execution job for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(JobSummary summary);

        /**
         * <p>
         * Describes the summary for an execution job for an Amplify app.
         * </p>
         * This is a convenience that creates an instance of the {@link JobSummary.Builder} avoiding the need to create
         * one manually via {@link JobSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobSummary.Builder#build()} is called immediately and its result
         * is passed to {@link #summary(JobSummary)}.
         * 
         * @param summary
         *        a consumer that will call methods on {@link JobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summary(JobSummary)
         */
        default Builder summary(Consumer<JobSummary.Builder> summary) {
            return summary(JobSummary.builder().applyMutation(summary).build());
        }

        /**
         * <p>
         * The execution steps for an execution job, for an Amplify app.
         * </p>
         * 
         * @param steps
         *        The execution steps for an execution job, for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(Collection<Step> steps);

        /**
         * <p>
         * The execution steps for an execution job, for an Amplify app.
         * </p>
         * 
         * @param steps
         *        The execution steps for an execution job, for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(Step... steps);

        /**
         * <p>
         * The execution steps for an execution job, for an Amplify app.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Step>.Builder} avoiding the need to create
         * one manually via {@link List<Step>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Step>.Builder#build()} is called immediately and its result
         * is passed to {@link #steps(List<Step>)}.
         * 
         * @param steps
         *        a consumer that will call methods on {@link List<Step>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #steps(List<Step>)
         */
        Builder steps(Consumer<Step.Builder>... steps);
    }

    static final class BuilderImpl implements Builder {
        private JobSummary summary;

        private List<Step> steps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Job model) {
            summary(model.summary);
            steps(model.steps);
        }

        public final JobSummary.Builder getSummary() {
            return summary != null ? summary.toBuilder() : null;
        }

        public final void setSummary(JobSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        @Transient
        public final Builder summary(JobSummary summary) {
            this.summary = summary;
            return this;
        }

        public final List<Step.Builder> getSteps() {
            List<Step.Builder> result = StepsCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<Step.BuilderImpl> steps) {
            this.steps = StepsCopier.copyFromBuilder(steps);
        }

        @Override
        @Transient
        public final Builder steps(Collection<Step> steps) {
            this.steps = StepsCopier.copy(steps);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder steps(Step... steps) {
            steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder steps(Consumer<Step.Builder>... steps) {
            steps(Stream.of(steps).map(c -> Step.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Job build() {
            return new Job(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
