/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Setting for the Subdomain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubDomainSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<SubDomainSetting.Builder, SubDomainSetting> {
    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SubDomainSetting::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()).build();

    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SubDomainSetting::branchName)).setter(setter(Builder::branchName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIX_FIELD,
            BRANCH_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String prefix;

    private final String branchName;

    private SubDomainSetting(BuilderImpl builder) {
        this.prefix = builder.prefix;
        this.branchName = builder.branchName;
    }

    /**
     * <p>
     * Prefix setting for the Subdomain.
     * </p>
     * 
     * @return Prefix setting for the Subdomain.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * <p>
     * Branch name setting for the Subdomain.
     * </p>
     * 
     * @return Branch name setting for the Subdomain.
     */
    public String branchName() {
        return branchName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(branchName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubDomainSetting)) {
            return false;
        }
        SubDomainSetting other = (SubDomainSetting) obj;
        return Objects.equals(prefix(), other.prefix()) && Objects.equals(branchName(), other.branchName());
    }

    @Override
    public String toString() {
        return ToString.builder("SubDomainSetting").add("Prefix", prefix()).add("BranchName", branchName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "branchName":
            return Optional.ofNullable(clazz.cast(branchName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubDomainSetting, T> g) {
        return obj -> g.apply((SubDomainSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubDomainSetting> {
        /**
         * <p>
         * Prefix setting for the Subdomain.
         * </p>
         * 
         * @param prefix
         *        Prefix setting for the Subdomain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * Branch name setting for the Subdomain.
         * </p>
         * 
         * @param branchName
         *        Branch name setting for the Subdomain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchName(String branchName);
    }

    static final class BuilderImpl implements Builder {
        private String prefix;

        private String branchName;

        private BuilderImpl() {
        }

        private BuilderImpl(SubDomainSetting model) {
            prefix(model.prefix);
            branchName(model.branchName);
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getBranchName() {
            return branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        @Override
        public SubDomainSetting build() {
            return new SubDomainSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
