/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.amplify.model.AmplifyException;
import software.amazon.awssdk.services.amplify.model.BadRequestException;
import software.amazon.awssdk.services.amplify.model.CreateAppRequest;
import software.amazon.awssdk.services.amplify.model.CreateAppResponse;
import software.amazon.awssdk.services.amplify.model.CreateBackendEnvironmentRequest;
import software.amazon.awssdk.services.amplify.model.CreateBackendEnvironmentResponse;
import software.amazon.awssdk.services.amplify.model.CreateBranchRequest;
import software.amazon.awssdk.services.amplify.model.CreateBranchResponse;
import software.amazon.awssdk.services.amplify.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.amplify.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.amplify.model.CreateDomainAssociationRequest;
import software.amazon.awssdk.services.amplify.model.CreateDomainAssociationResponse;
import software.amazon.awssdk.services.amplify.model.CreateWebhookRequest;
import software.amazon.awssdk.services.amplify.model.CreateWebhookResponse;
import software.amazon.awssdk.services.amplify.model.DeleteAppRequest;
import software.amazon.awssdk.services.amplify.model.DeleteAppResponse;
import software.amazon.awssdk.services.amplify.model.DeleteBackendEnvironmentRequest;
import software.amazon.awssdk.services.amplify.model.DeleteBackendEnvironmentResponse;
import software.amazon.awssdk.services.amplify.model.DeleteBranchRequest;
import software.amazon.awssdk.services.amplify.model.DeleteBranchResponse;
import software.amazon.awssdk.services.amplify.model.DeleteDomainAssociationRequest;
import software.amazon.awssdk.services.amplify.model.DeleteDomainAssociationResponse;
import software.amazon.awssdk.services.amplify.model.DeleteJobRequest;
import software.amazon.awssdk.services.amplify.model.DeleteJobResponse;
import software.amazon.awssdk.services.amplify.model.DeleteWebhookRequest;
import software.amazon.awssdk.services.amplify.model.DeleteWebhookResponse;
import software.amazon.awssdk.services.amplify.model.DependentServiceFailureException;
import software.amazon.awssdk.services.amplify.model.GenerateAccessLogsRequest;
import software.amazon.awssdk.services.amplify.model.GenerateAccessLogsResponse;
import software.amazon.awssdk.services.amplify.model.GetAppRequest;
import software.amazon.awssdk.services.amplify.model.GetAppResponse;
import software.amazon.awssdk.services.amplify.model.GetArtifactUrlRequest;
import software.amazon.awssdk.services.amplify.model.GetArtifactUrlResponse;
import software.amazon.awssdk.services.amplify.model.GetBackendEnvironmentRequest;
import software.amazon.awssdk.services.amplify.model.GetBackendEnvironmentResponse;
import software.amazon.awssdk.services.amplify.model.GetBranchRequest;
import software.amazon.awssdk.services.amplify.model.GetBranchResponse;
import software.amazon.awssdk.services.amplify.model.GetDomainAssociationRequest;
import software.amazon.awssdk.services.amplify.model.GetDomainAssociationResponse;
import software.amazon.awssdk.services.amplify.model.GetJobRequest;
import software.amazon.awssdk.services.amplify.model.GetJobResponse;
import software.amazon.awssdk.services.amplify.model.GetWebhookRequest;
import software.amazon.awssdk.services.amplify.model.GetWebhookResponse;
import software.amazon.awssdk.services.amplify.model.InternalFailureException;
import software.amazon.awssdk.services.amplify.model.LimitExceededException;
import software.amazon.awssdk.services.amplify.model.ListAppsRequest;
import software.amazon.awssdk.services.amplify.model.ListAppsResponse;
import software.amazon.awssdk.services.amplify.model.ListArtifactsRequest;
import software.amazon.awssdk.services.amplify.model.ListArtifactsResponse;
import software.amazon.awssdk.services.amplify.model.ListBackendEnvironmentsRequest;
import software.amazon.awssdk.services.amplify.model.ListBackendEnvironmentsResponse;
import software.amazon.awssdk.services.amplify.model.ListBranchesRequest;
import software.amazon.awssdk.services.amplify.model.ListBranchesResponse;
import software.amazon.awssdk.services.amplify.model.ListDomainAssociationsRequest;
import software.amazon.awssdk.services.amplify.model.ListDomainAssociationsResponse;
import software.amazon.awssdk.services.amplify.model.ListJobsRequest;
import software.amazon.awssdk.services.amplify.model.ListJobsResponse;
import software.amazon.awssdk.services.amplify.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.amplify.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.amplify.model.ListWebhooksRequest;
import software.amazon.awssdk.services.amplify.model.ListWebhooksResponse;
import software.amazon.awssdk.services.amplify.model.NotFoundException;
import software.amazon.awssdk.services.amplify.model.ResourceNotFoundException;
import software.amazon.awssdk.services.amplify.model.StartDeploymentRequest;
import software.amazon.awssdk.services.amplify.model.StartDeploymentResponse;
import software.amazon.awssdk.services.amplify.model.StartJobRequest;
import software.amazon.awssdk.services.amplify.model.StartJobResponse;
import software.amazon.awssdk.services.amplify.model.StopJobRequest;
import software.amazon.awssdk.services.amplify.model.StopJobResponse;
import software.amazon.awssdk.services.amplify.model.TagResourceRequest;
import software.amazon.awssdk.services.amplify.model.TagResourceResponse;
import software.amazon.awssdk.services.amplify.model.UnauthorizedException;
import software.amazon.awssdk.services.amplify.model.UntagResourceRequest;
import software.amazon.awssdk.services.amplify.model.UntagResourceResponse;
import software.amazon.awssdk.services.amplify.model.UpdateAppRequest;
import software.amazon.awssdk.services.amplify.model.UpdateAppResponse;
import software.amazon.awssdk.services.amplify.model.UpdateBranchRequest;
import software.amazon.awssdk.services.amplify.model.UpdateBranchResponse;
import software.amazon.awssdk.services.amplify.model.UpdateDomainAssociationRequest;
import software.amazon.awssdk.services.amplify.model.UpdateDomainAssociationResponse;
import software.amazon.awssdk.services.amplify.model.UpdateWebhookRequest;
import software.amazon.awssdk.services.amplify.model.UpdateWebhookResponse;

/**
 * Service client for accessing Amplify. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amplify enables developers to develop and deploy cloud-powered mobile and web apps. The Amplify Console provides a
 * continuous delivery and hosting service for web applications. For more information, see the <a
 * href="https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html">Amplify Console User Guide</a>. The Amplify
 * Framework is a comprehensive set of SDKs, libraries, tools, and documentation for client app development. For more
 * information, see the <a href="https://docs.amplify.aws/">Amplify Framework.</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AmplifyClient extends AwsClient {
    String SERVICE_NAME = "amplify";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "amplify";

    /**
     * <p>
     * Creates a new Amplify app.
     * </p>
     *
     * @param createAppRequest
     *        The request structure used to create apps in Amplify.
     * @return Result of the CreateApp operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws DependentServiceFailureException
     *         An operation failed because a dependent service threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.CreateApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/CreateApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAppResponse createApp(CreateAppRequest createAppRequest) throws BadRequestException, UnauthorizedException,
            InternalFailureException, LimitExceededException, DependentServiceFailureException, AwsServiceException,
            SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAppRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAppRequest#builder()}
     * </p>
     *
     * @param createAppRequest
     *        A {@link Consumer} that will call methods on {@link CreateAppRequest.Builder} to create a request. The
     *        request structure used to create apps in Amplify.
     * @return Result of the CreateApp operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws DependentServiceFailureException
     *         An operation failed because a dependent service threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.CreateApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/CreateApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAppResponse createApp(Consumer<CreateAppRequest.Builder> createAppRequest) throws BadRequestException,
            UnauthorizedException, InternalFailureException, LimitExceededException, DependentServiceFailureException,
            AwsServiceException, SdkClientException, AmplifyException {
        return createApp(CreateAppRequest.builder().applyMutation(createAppRequest).build());
    }

    /**
     * <p>
     * Creates a new backend environment for an Amplify app.
     * </p>
     *
     * @param createBackendEnvironmentRequest
     *        The request structure for the backend environment create request.
     * @return Result of the CreateBackendEnvironment operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.CreateBackendEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/CreateBackendEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBackendEnvironmentResponse createBackendEnvironment(
            CreateBackendEnvironmentRequest createBackendEnvironmentRequest) throws BadRequestException, UnauthorizedException,
            NotFoundException, InternalFailureException, LimitExceededException, AwsServiceException, SdkClientException,
            AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new backend environment for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBackendEnvironmentRequest.Builder} avoiding
     * the need to create one manually via {@link CreateBackendEnvironmentRequest#builder()}
     * </p>
     *
     * @param createBackendEnvironmentRequest
     *        A {@link Consumer} that will call methods on {@link CreateBackendEnvironmentRequest.Builder} to create a
     *        request. The request structure for the backend environment create request.
     * @return Result of the CreateBackendEnvironment operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.CreateBackendEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/CreateBackendEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBackendEnvironmentResponse createBackendEnvironment(
            Consumer<CreateBackendEnvironmentRequest.Builder> createBackendEnvironmentRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, InternalFailureException, LimitExceededException, AwsServiceException,
            SdkClientException, AmplifyException {
        return createBackendEnvironment(CreateBackendEnvironmentRequest.builder().applyMutation(createBackendEnvironmentRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new branch for an Amplify app.
     * </p>
     *
     * @param createBranchRequest
     *        The request structure for the create branch request.
     * @return Result of the CreateBranch operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws DependentServiceFailureException
     *         An operation failed because a dependent service threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.CreateBranch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/CreateBranch" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateBranchResponse createBranch(CreateBranchRequest createBranchRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, InternalFailureException, LimitExceededException,
            DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new branch for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBranchRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBranchRequest#builder()}
     * </p>
     *
     * @param createBranchRequest
     *        A {@link Consumer} that will call methods on {@link CreateBranchRequest.Builder} to create a request. The
     *        request structure for the create branch request.
     * @return Result of the CreateBranch operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws DependentServiceFailureException
     *         An operation failed because a dependent service threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.CreateBranch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/CreateBranch" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateBranchResponse createBranch(Consumer<CreateBranchRequest.Builder> createBranchRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException,
            LimitExceededException, DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        return createBranch(CreateBranchRequest.builder().applyMutation(createBranchRequest).build());
    }

    /**
     * <p>
     * Creates a deployment for a manually deployed Amplify app. Manually deployed apps are not connected to a
     * repository.
     * </p>
     *
     * @param createDeploymentRequest
     *        The request structure for the create a new deployment request.
     * @return Result of the CreateDeployment operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.CreateDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/CreateDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDeploymentResponse createDeployment(CreateDeploymentRequest createDeploymentRequest)
            throws BadRequestException, UnauthorizedException, InternalFailureException, LimitExceededException,
            AwsServiceException, SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a deployment for a manually deployed Amplify app. Manually deployed apps are not connected to a
     * repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeploymentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDeploymentRequest#builder()}
     * </p>
     *
     * @param createDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link CreateDeploymentRequest.Builder} to create a request.
     *        The request structure for the create a new deployment request.
     * @return Result of the CreateDeployment operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.CreateDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/CreateDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDeploymentResponse createDeployment(Consumer<CreateDeploymentRequest.Builder> createDeploymentRequest)
            throws BadRequestException, UnauthorizedException, InternalFailureException, LimitExceededException,
            AwsServiceException, SdkClientException, AmplifyException {
        return createDeployment(CreateDeploymentRequest.builder().applyMutation(createDeploymentRequest).build());
    }

    /**
     * <p>
     * Creates a new domain association for an Amplify app. This action associates a custom domain with the Amplify app
     * </p>
     *
     * @param createDomainAssociationRequest
     *        The request structure for the create domain association request.
     * @return Result of the CreateDomainAssociation operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws DependentServiceFailureException
     *         An operation failed because a dependent service threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.CreateDomainAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/CreateDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDomainAssociationResponse createDomainAssociation(CreateDomainAssociationRequest createDomainAssociationRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException,
            LimitExceededException, DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new domain association for an Amplify app. This action associates a custom domain with the Amplify app
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDomainAssociationRequest#builder()}
     * </p>
     *
     * @param createDomainAssociationRequest
     *        A {@link Consumer} that will call methods on {@link CreateDomainAssociationRequest.Builder} to create a
     *        request. The request structure for the create domain association request.
     * @return Result of the CreateDomainAssociation operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws DependentServiceFailureException
     *         An operation failed because a dependent service threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.CreateDomainAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/CreateDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDomainAssociationResponse createDomainAssociation(
            Consumer<CreateDomainAssociationRequest.Builder> createDomainAssociationRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, InternalFailureException, LimitExceededException,
            DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        return createDomainAssociation(CreateDomainAssociationRequest.builder().applyMutation(createDomainAssociationRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new webhook on an Amplify app.
     * </p>
     *
     * @param createWebhookRequest
     *        The request structure for the create webhook request.
     * @return Result of the CreateWebhook operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws DependentServiceFailureException
     *         An operation failed because a dependent service threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.CreateWebhook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/CreateWebhook" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateWebhookResponse createWebhook(CreateWebhookRequest createWebhookRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, InternalFailureException, LimitExceededException,
            DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new webhook on an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWebhookRequest.Builder} avoiding the need to
     * create one manually via {@link CreateWebhookRequest#builder()}
     * </p>
     *
     * @param createWebhookRequest
     *        A {@link Consumer} that will call methods on {@link CreateWebhookRequest.Builder} to create a request. The
     *        request structure for the create webhook request.
     * @return Result of the CreateWebhook operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws DependentServiceFailureException
     *         An operation failed because a dependent service threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.CreateWebhook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/CreateWebhook" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateWebhookResponse createWebhook(Consumer<CreateWebhookRequest.Builder> createWebhookRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException,
            LimitExceededException, DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        return createWebhook(CreateWebhookRequest.builder().applyMutation(createWebhookRequest).build());
    }

    /**
     * <p>
     * Deletes an existing Amplify app specified by an app ID.
     * </p>
     *
     * @param deleteAppRequest
     *        Describes the request structure for the delete app request.
     * @return Result of the DeleteApp operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws DependentServiceFailureException
     *         An operation failed because a dependent service threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.DeleteApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAppResponse deleteApp(DeleteAppRequest deleteAppRequest) throws BadRequestException, NotFoundException,
            UnauthorizedException, InternalFailureException, DependentServiceFailureException, AwsServiceException,
            SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing Amplify app specified by an app ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAppRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAppRequest#builder()}
     * </p>
     *
     * @param deleteAppRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAppRequest.Builder} to create a request.
     *        Describes the request structure for the delete app request.
     * @return Result of the DeleteApp operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws DependentServiceFailureException
     *         An operation failed because a dependent service threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.DeleteApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAppResponse deleteApp(Consumer<DeleteAppRequest.Builder> deleteAppRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, InternalFailureException, DependentServiceFailureException,
            AwsServiceException, SdkClientException, AmplifyException {
        return deleteApp(DeleteAppRequest.builder().applyMutation(deleteAppRequest).build());
    }

    /**
     * <p>
     * Deletes a backend environment for an Amplify app.
     * </p>
     *
     * @param deleteBackendEnvironmentRequest
     *        The request structure for the delete backend environment request.
     * @return Result of the DeleteBackendEnvironment operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws DependentServiceFailureException
     *         An operation failed because a dependent service threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.DeleteBackendEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/DeleteBackendEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBackendEnvironmentResponse deleteBackendEnvironment(
            DeleteBackendEnvironmentRequest deleteBackendEnvironmentRequest) throws BadRequestException, UnauthorizedException,
            NotFoundException, InternalFailureException, DependentServiceFailureException, AwsServiceException,
            SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a backend environment for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackendEnvironmentRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteBackendEnvironmentRequest#builder()}
     * </p>
     *
     * @param deleteBackendEnvironmentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBackendEnvironmentRequest.Builder} to create a
     *        request. The request structure for the delete backend environment request.
     * @return Result of the DeleteBackendEnvironment operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws DependentServiceFailureException
     *         An operation failed because a dependent service threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.DeleteBackendEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/DeleteBackendEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBackendEnvironmentResponse deleteBackendEnvironment(
            Consumer<DeleteBackendEnvironmentRequest.Builder> deleteBackendEnvironmentRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, InternalFailureException, DependentServiceFailureException,
            AwsServiceException, SdkClientException, AmplifyException {
        return deleteBackendEnvironment(DeleteBackendEnvironmentRequest.builder().applyMutation(deleteBackendEnvironmentRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a branch for an Amplify app.
     * </p>
     *
     * @param deleteBranchRequest
     *        The request structure for the delete branch request.
     * @return Result of the DeleteBranch operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws DependentServiceFailureException
     *         An operation failed because a dependent service threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.DeleteBranch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/DeleteBranch" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteBranchResponse deleteBranch(DeleteBranchRequest deleteBranchRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, InternalFailureException, DependentServiceFailureException,
            AwsServiceException, SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a branch for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBranchRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBranchRequest#builder()}
     * </p>
     *
     * @param deleteBranchRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBranchRequest.Builder} to create a request. The
     *        request structure for the delete branch request.
     * @return Result of the DeleteBranch operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws DependentServiceFailureException
     *         An operation failed because a dependent service threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.DeleteBranch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/DeleteBranch" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteBranchResponse deleteBranch(Consumer<DeleteBranchRequest.Builder> deleteBranchRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException,
            DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        return deleteBranch(DeleteBranchRequest.builder().applyMutation(deleteBranchRequest).build());
    }

    /**
     * <p>
     * Deletes a domain association for an Amplify app.
     * </p>
     *
     * @param deleteDomainAssociationRequest
     *        The request structure for the delete domain association request.
     * @return Result of the DeleteDomainAssociation operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws DependentServiceFailureException
     *         An operation failed because a dependent service threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.DeleteDomainAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/DeleteDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDomainAssociationResponse deleteDomainAssociation(DeleteDomainAssociationRequest deleteDomainAssociationRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException,
            DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a domain association for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDomainAssociationRequest#builder()}
     * </p>
     *
     * @param deleteDomainAssociationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDomainAssociationRequest.Builder} to create a
     *        request. The request structure for the delete domain association request.
     * @return Result of the DeleteDomainAssociation operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws DependentServiceFailureException
     *         An operation failed because a dependent service threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.DeleteDomainAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/DeleteDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDomainAssociationResponse deleteDomainAssociation(
            Consumer<DeleteDomainAssociationRequest.Builder> deleteDomainAssociationRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, InternalFailureException, DependentServiceFailureException,
            AwsServiceException, SdkClientException, AmplifyException {
        return deleteDomainAssociation(DeleteDomainAssociationRequest.builder().applyMutation(deleteDomainAssociationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a job for a branch of an Amplify app.
     * </p>
     *
     * @param deleteJobRequest
     *        The request structure for the delete job request.
     * @return Result of the DeleteJob operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.DeleteJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/DeleteJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteJobResponse deleteJob(DeleteJobRequest deleteJobRequest) throws BadRequestException, UnauthorizedException,
            InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException,
            AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a job for a branch of an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteJobRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteJobRequest#builder()}
     * </p>
     *
     * @param deleteJobRequest
     *        A {@link Consumer} that will call methods on {@link DeleteJobRequest.Builder} to create a request. The
     *        request structure for the delete job request.
     * @return Result of the DeleteJob operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.DeleteJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/DeleteJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteJobResponse deleteJob(Consumer<DeleteJobRequest.Builder> deleteJobRequest) throws BadRequestException,
            UnauthorizedException, InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException,
            SdkClientException, AmplifyException {
        return deleteJob(DeleteJobRequest.builder().applyMutation(deleteJobRequest).build());
    }

    /**
     * <p>
     * Deletes a webhook.
     * </p>
     *
     * @param deleteWebhookRequest
     *        The request structure for the delete webhook request.
     * @return Result of the DeleteWebhook operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.DeleteWebhook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/DeleteWebhook" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteWebhookResponse deleteWebhook(DeleteWebhookRequest deleteWebhookRequest) throws BadRequestException,
            UnauthorizedException, InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException,
            SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a webhook.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWebhookRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWebhookRequest#builder()}
     * </p>
     *
     * @param deleteWebhookRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWebhookRequest.Builder} to create a request. The
     *        request structure for the delete webhook request.
     * @return Result of the DeleteWebhook operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.DeleteWebhook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/DeleteWebhook" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteWebhookResponse deleteWebhook(Consumer<DeleteWebhookRequest.Builder> deleteWebhookRequest)
            throws BadRequestException, UnauthorizedException, InternalFailureException, NotFoundException,
            LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        return deleteWebhook(DeleteWebhookRequest.builder().applyMutation(deleteWebhookRequest).build());
    }

    /**
     * <p>
     * Returns the website access logs for a specific time range using a presigned URL.
     * </p>
     *
     * @param generateAccessLogsRequest
     *        The request structure for the generate access logs request.
     * @return Result of the GenerateAccessLogs operation returned by the service.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.GenerateAccessLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/GenerateAccessLogs" target="_top">AWS
     *      API Documentation</a>
     */
    default GenerateAccessLogsResponse generateAccessLogs(GenerateAccessLogsRequest generateAccessLogsRequest)
            throws NotFoundException, BadRequestException, UnauthorizedException, InternalFailureException, AwsServiceException,
            SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the website access logs for a specific time range using a presigned URL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GenerateAccessLogsRequest.Builder} avoiding the
     * need to create one manually via {@link GenerateAccessLogsRequest#builder()}
     * </p>
     *
     * @param generateAccessLogsRequest
     *        A {@link Consumer} that will call methods on {@link GenerateAccessLogsRequest.Builder} to create a
     *        request. The request structure for the generate access logs request.
     * @return Result of the GenerateAccessLogs operation returned by the service.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.GenerateAccessLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/GenerateAccessLogs" target="_top">AWS
     *      API Documentation</a>
     */
    default GenerateAccessLogsResponse generateAccessLogs(Consumer<GenerateAccessLogsRequest.Builder> generateAccessLogsRequest)
            throws NotFoundException, BadRequestException, UnauthorizedException, InternalFailureException, AwsServiceException,
            SdkClientException, AmplifyException {
        return generateAccessLogs(GenerateAccessLogsRequest.builder().applyMutation(generateAccessLogsRequest).build());
    }

    /**
     * <p>
     * Returns an existing Amplify app by appID.
     * </p>
     *
     * @param getAppRequest
     *        The request structure for the get app request.
     * @return Result of the GetApp operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.GetApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/GetApp" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAppResponse getApp(GetAppRequest getAppRequest) throws BadRequestException, NotFoundException,
            UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an existing Amplify app by appID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAppRequest.Builder} avoiding the need to create
     * one manually via {@link GetAppRequest#builder()}
     * </p>
     *
     * @param getAppRequest
     *        A {@link Consumer} that will call methods on {@link GetAppRequest.Builder} to create a request. The
     *        request structure for the get app request.
     * @return Result of the GetApp operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.GetApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/GetApp" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAppResponse getApp(Consumer<GetAppRequest.Builder> getAppRequest) throws BadRequestException, NotFoundException,
            UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        return getApp(GetAppRequest.builder().applyMutation(getAppRequest).build());
    }

    /**
     * <p>
     * Returns the artifact info that corresponds to an artifact id.
     * </p>
     *
     * @param getArtifactUrlRequest
     *        Returns the request structure for the get artifact request.
     * @return Result of the GetArtifactUrl operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.GetArtifactUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/GetArtifactUrl" target="_top">AWS API
     *      Documentation</a>
     */
    default GetArtifactUrlResponse getArtifactUrl(GetArtifactUrlRequest getArtifactUrlRequest) throws BadRequestException,
            UnauthorizedException, InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException,
            SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the artifact info that corresponds to an artifact id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetArtifactUrlRequest.Builder} avoiding the need to
     * create one manually via {@link GetArtifactUrlRequest#builder()}
     * </p>
     *
     * @param getArtifactUrlRequest
     *        A {@link Consumer} that will call methods on {@link GetArtifactUrlRequest.Builder} to create a request.
     *        Returns the request structure for the get artifact request.
     * @return Result of the GetArtifactUrl operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.GetArtifactUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/GetArtifactUrl" target="_top">AWS API
     *      Documentation</a>
     */
    default GetArtifactUrlResponse getArtifactUrl(Consumer<GetArtifactUrlRequest.Builder> getArtifactUrlRequest)
            throws BadRequestException, UnauthorizedException, InternalFailureException, NotFoundException,
            LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        return getArtifactUrl(GetArtifactUrlRequest.builder().applyMutation(getArtifactUrlRequest).build());
    }

    /**
     * <p>
     * Returns a backend environment for an Amplify app.
     * </p>
     *
     * @param getBackendEnvironmentRequest
     *        The request structure for the get backend environment request.
     * @return Result of the GetBackendEnvironment operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.GetBackendEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/GetBackendEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default GetBackendEnvironmentResponse getBackendEnvironment(GetBackendEnvironmentRequest getBackendEnvironmentRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, AwsServiceException,
            SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a backend environment for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackendEnvironmentRequest.Builder} avoiding the
     * need to create one manually via {@link GetBackendEnvironmentRequest#builder()}
     * </p>
     *
     * @param getBackendEnvironmentRequest
     *        A {@link Consumer} that will call methods on {@link GetBackendEnvironmentRequest.Builder} to create a
     *        request. The request structure for the get backend environment request.
     * @return Result of the GetBackendEnvironment operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.GetBackendEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/GetBackendEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default GetBackendEnvironmentResponse getBackendEnvironment(
            Consumer<GetBackendEnvironmentRequest.Builder> getBackendEnvironmentRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, InternalFailureException, AwsServiceException, SdkClientException,
            AmplifyException {
        return getBackendEnvironment(GetBackendEnvironmentRequest.builder().applyMutation(getBackendEnvironmentRequest).build());
    }

    /**
     * <p>
     * Returns a branch for an Amplify app.
     * </p>
     *
     * @param getBranchRequest
     *        The request structure for the get branch request.
     * @return Result of the GetBranch operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.GetBranch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/GetBranch" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBranchResponse getBranch(GetBranchRequest getBranchRequest) throws BadRequestException, UnauthorizedException,
            NotFoundException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a branch for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBranchRequest.Builder} avoiding the need to
     * create one manually via {@link GetBranchRequest#builder()}
     * </p>
     *
     * @param getBranchRequest
     *        A {@link Consumer} that will call methods on {@link GetBranchRequest.Builder} to create a request. The
     *        request structure for the get branch request.
     * @return Result of the GetBranch operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.GetBranch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/GetBranch" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBranchResponse getBranch(Consumer<GetBranchRequest.Builder> getBranchRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, InternalFailureException, AwsServiceException, SdkClientException,
            AmplifyException {
        return getBranch(GetBranchRequest.builder().applyMutation(getBranchRequest).build());
    }

    /**
     * <p>
     * Returns the domain information for an Amplify app.
     * </p>
     *
     * @param getDomainAssociationRequest
     *        The request structure for the get domain association request.
     * @return Result of the GetDomainAssociation operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.GetDomainAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/GetDomainAssociation" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDomainAssociationResponse getDomainAssociation(GetDomainAssociationRequest getDomainAssociationRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, AwsServiceException,
            SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the domain information for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainAssociationRequest.Builder} avoiding the
     * need to create one manually via {@link GetDomainAssociationRequest#builder()}
     * </p>
     *
     * @param getDomainAssociationRequest
     *        A {@link Consumer} that will call methods on {@link GetDomainAssociationRequest.Builder} to create a
     *        request. The request structure for the get domain association request.
     * @return Result of the GetDomainAssociation operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.GetDomainAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/GetDomainAssociation" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDomainAssociationResponse getDomainAssociation(
            Consumer<GetDomainAssociationRequest.Builder> getDomainAssociationRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, InternalFailureException, AwsServiceException, SdkClientException,
            AmplifyException {
        return getDomainAssociation(GetDomainAssociationRequest.builder().applyMutation(getDomainAssociationRequest).build());
    }

    /**
     * <p>
     * Returns a job for a branch of an Amplify app.
     * </p>
     *
     * @param getJobRequest
     *        The request structure for the get job request.
     * @return Result of the GetJob operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.GetJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobResponse getJob(GetJobRequest getJobRequest) throws BadRequestException, UnauthorizedException,
            InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException,
            AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a job for a branch of an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobRequest.Builder} avoiding the need to create
     * one manually via {@link GetJobRequest#builder()}
     * </p>
     *
     * @param getJobRequest
     *        A {@link Consumer} that will call methods on {@link GetJobRequest.Builder} to create a request. The
     *        request structure for the get job request.
     * @return Result of the GetJob operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.GetJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobResponse getJob(Consumer<GetJobRequest.Builder> getJobRequest) throws BadRequestException,
            UnauthorizedException, InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException,
            SdkClientException, AmplifyException {
        return getJob(GetJobRequest.builder().applyMutation(getJobRequest).build());
    }

    /**
     * <p>
     * Returns the webhook information that corresponds to a specified webhook ID.
     * </p>
     *
     * @param getWebhookRequest
     *        The request structure for the get webhook request.
     * @return Result of the GetWebhook operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.GetWebhook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/GetWebhook" target="_top">AWS API
     *      Documentation</a>
     */
    default GetWebhookResponse getWebhook(GetWebhookRequest getWebhookRequest) throws BadRequestException, UnauthorizedException,
            InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException,
            AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the webhook information that corresponds to a specified webhook ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWebhookRequest.Builder} avoiding the need to
     * create one manually via {@link GetWebhookRequest#builder()}
     * </p>
     *
     * @param getWebhookRequest
     *        A {@link Consumer} that will call methods on {@link GetWebhookRequest.Builder} to create a request. The
     *        request structure for the get webhook request.
     * @return Result of the GetWebhook operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.GetWebhook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/GetWebhook" target="_top">AWS API
     *      Documentation</a>
     */
    default GetWebhookResponse getWebhook(Consumer<GetWebhookRequest.Builder> getWebhookRequest) throws BadRequestException,
            UnauthorizedException, InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException,
            SdkClientException, AmplifyException {
        return getWebhook(GetWebhookRequest.builder().applyMutation(getWebhookRequest).build());
    }

    /**
     * <p>
     * Returns a list of the existing Amplify apps.
     * </p>
     *
     * @param listAppsRequest
     *        The request structure for the list apps request.
     * @return Result of the ListApps operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.ListApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAppsResponse listApps(ListAppsRequest listAppsRequest) throws BadRequestException, UnauthorizedException,
            InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the existing Amplify apps.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAppsRequest#builder()}
     * </p>
     *
     * @param listAppsRequest
     *        A {@link Consumer} that will call methods on {@link ListAppsRequest.Builder} to create a request. The
     *        request structure for the list apps request.
     * @return Result of the ListApps operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.ListApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAppsResponse listApps(Consumer<ListAppsRequest.Builder> listAppsRequest) throws BadRequestException,
            UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        return listApps(ListAppsRequest.builder().applyMutation(listAppsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the existing Amplify apps.
     * </p>
     *
     * @return Result of the ListApps operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.ListApps
     * @see #listApps(ListAppsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAppsResponse listApps() throws BadRequestException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AmplifyException {
        return listApps(ListAppsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of artifacts for a specified app, branch, and job.
     * </p>
     *
     * @param listArtifactsRequest
     *        Describes the request structure for the list artifacts request.
     * @return Result of the ListArtifacts operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.ListArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListArtifacts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListArtifactsResponse listArtifacts(ListArtifactsRequest listArtifactsRequest) throws BadRequestException,
            UnauthorizedException, InternalFailureException, LimitExceededException, AwsServiceException, SdkClientException,
            AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of artifacts for a specified app, branch, and job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListArtifactsRequest.Builder} avoiding the need to
     * create one manually via {@link ListArtifactsRequest#builder()}
     * </p>
     *
     * @param listArtifactsRequest
     *        A {@link Consumer} that will call methods on {@link ListArtifactsRequest.Builder} to create a request.
     *        Describes the request structure for the list artifacts request.
     * @return Result of the ListArtifacts operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.ListArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListArtifacts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListArtifactsResponse listArtifacts(Consumer<ListArtifactsRequest.Builder> listArtifactsRequest)
            throws BadRequestException, UnauthorizedException, InternalFailureException, LimitExceededException,
            AwsServiceException, SdkClientException, AmplifyException {
        return listArtifacts(ListArtifactsRequest.builder().applyMutation(listArtifactsRequest).build());
    }

    /**
     * <p>
     * Lists the backend environments for an Amplify app.
     * </p>
     *
     * @param listBackendEnvironmentsRequest
     *        The request structure for the list backend environments request.
     * @return Result of the ListBackendEnvironments operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.ListBackendEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListBackendEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBackendEnvironmentsResponse listBackendEnvironments(ListBackendEnvironmentsRequest listBackendEnvironmentsRequest)
            throws BadRequestException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the backend environments for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackendEnvironmentsRequest.Builder} avoiding
     * the need to create one manually via {@link ListBackendEnvironmentsRequest#builder()}
     * </p>
     *
     * @param listBackendEnvironmentsRequest
     *        A {@link Consumer} that will call methods on {@link ListBackendEnvironmentsRequest.Builder} to create a
     *        request. The request structure for the list backend environments request.
     * @return Result of the ListBackendEnvironments operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.ListBackendEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListBackendEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBackendEnvironmentsResponse listBackendEnvironments(
            Consumer<ListBackendEnvironmentsRequest.Builder> listBackendEnvironmentsRequest) throws BadRequestException,
            UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        return listBackendEnvironments(ListBackendEnvironmentsRequest.builder().applyMutation(listBackendEnvironmentsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the branches of an Amplify app.
     * </p>
     *
     * @param listBranchesRequest
     *        The request structure for the list branches request.
     * @return Result of the ListBranches operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.ListBranches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListBranches" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBranchesResponse listBranches(ListBranchesRequest listBranchesRequest) throws BadRequestException,
            UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the branches of an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBranchesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBranchesRequest#builder()}
     * </p>
     *
     * @param listBranchesRequest
     *        A {@link Consumer} that will call methods on {@link ListBranchesRequest.Builder} to create a request. The
     *        request structure for the list branches request.
     * @return Result of the ListBranches operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.ListBranches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListBranches" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBranchesResponse listBranches(Consumer<ListBranchesRequest.Builder> listBranchesRequest)
            throws BadRequestException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AmplifyException {
        return listBranches(ListBranchesRequest.builder().applyMutation(listBranchesRequest).build());
    }

    /**
     * <p>
     * Returns the domain associations for an Amplify app.
     * </p>
     *
     * @param listDomainAssociationsRequest
     *        The request structure for the list domain associations request.
     * @return Result of the ListDomainAssociations operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.ListDomainAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListDomainAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDomainAssociationsResponse listDomainAssociations(ListDomainAssociationsRequest listDomainAssociationsRequest)
            throws BadRequestException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the domain associations for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainAssociationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDomainAssociationsRequest#builder()}
     * </p>
     *
     * @param listDomainAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ListDomainAssociationsRequest.Builder} to create a
     *        request. The request structure for the list domain associations request.
     * @return Result of the ListDomainAssociations operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.ListDomainAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListDomainAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDomainAssociationsResponse listDomainAssociations(
            Consumer<ListDomainAssociationsRequest.Builder> listDomainAssociationsRequest) throws BadRequestException,
            UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        return listDomainAssociations(ListDomainAssociationsRequest.builder().applyMutation(listDomainAssociationsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the jobs for a branch of an Amplify app.
     * </p>
     *
     * @param listJobsRequest
     *        The request structure for the list jobs request.
     * @return Result of the ListJobs operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws BadRequestException, UnauthorizedException,
            InternalFailureException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the jobs for a branch of an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobsRequest#builder()}
     * </p>
     *
     * @param listJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListJobsRequest.Builder} to create a request. The
     *        request structure for the list jobs request.
     * @return Result of the ListJobs operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsResponse listJobs(Consumer<ListJobsRequest.Builder> listJobsRequest) throws BadRequestException,
            UnauthorizedException, InternalFailureException, LimitExceededException, AwsServiceException, SdkClientException,
            AmplifyException {
        return listJobs(ListJobsRequest.builder().applyMutation(listJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags for a specified Amazon Resource Name (ARN).
     * </p>
     *
     * @param listTagsForResourceRequest
     *        The request structure to use to list tags for a resource.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws ResourceNotFoundException
     *         An operation failed due to a non-existent resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalFailureException, BadRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags for a specified Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request. The request structure to use to list tags for a resource.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws ResourceNotFoundException
     *         An operation failed due to a non-existent resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalFailureException,
            BadRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AmplifyException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Returns a list of webhooks for an Amplify app.
     * </p>
     *
     * @param listWebhooksRequest
     *        The request structure for the list webhooks request.
     * @return Result of the ListWebhooks operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.ListWebhooks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListWebhooks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWebhooksResponse listWebhooks(ListWebhooksRequest listWebhooksRequest) throws BadRequestException,
            UnauthorizedException, InternalFailureException, LimitExceededException, AwsServiceException, SdkClientException,
            AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of webhooks for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWebhooksRequest.Builder} avoiding the need to
     * create one manually via {@link ListWebhooksRequest#builder()}
     * </p>
     *
     * @param listWebhooksRequest
     *        A {@link Consumer} that will call methods on {@link ListWebhooksRequest.Builder} to create a request. The
     *        request structure for the list webhooks request.
     * @return Result of the ListWebhooks operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.ListWebhooks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListWebhooks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWebhooksResponse listWebhooks(Consumer<ListWebhooksRequest.Builder> listWebhooksRequest)
            throws BadRequestException, UnauthorizedException, InternalFailureException, LimitExceededException,
            AwsServiceException, SdkClientException, AmplifyException {
        return listWebhooks(ListWebhooksRequest.builder().applyMutation(listWebhooksRequest).build());
    }

    /**
     * <p>
     * Starts a deployment for a manually deployed app. Manually deployed apps are not connected to a repository.
     * </p>
     *
     * @param startDeploymentRequest
     *        The request structure for the start a deployment request.
     * @return Result of the StartDeployment operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.StartDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/StartDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default StartDeploymentResponse startDeployment(StartDeploymentRequest startDeploymentRequest) throws BadRequestException,
            UnauthorizedException, InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException,
            SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a deployment for a manually deployed app. Manually deployed apps are not connected to a repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDeploymentRequest.Builder} avoiding the need
     * to create one manually via {@link StartDeploymentRequest#builder()}
     * </p>
     *
     * @param startDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link StartDeploymentRequest.Builder} to create a request.
     *        The request structure for the start a deployment request.
     * @return Result of the StartDeployment operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.StartDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/StartDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default StartDeploymentResponse startDeployment(Consumer<StartDeploymentRequest.Builder> startDeploymentRequest)
            throws BadRequestException, UnauthorizedException, InternalFailureException, NotFoundException,
            LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        return startDeployment(StartDeploymentRequest.builder().applyMutation(startDeploymentRequest).build());
    }

    /**
     * <p>
     * Starts a new job for a branch of an Amplify app.
     * </p>
     *
     * @param startJobRequest
     *        The request structure for the start job request.
     * @return Result of the StartJob operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.StartJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/StartJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StartJobResponse startJob(StartJobRequest startJobRequest) throws BadRequestException, UnauthorizedException,
            InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException,
            AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a new job for a branch of an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartJobRequest.Builder} avoiding the need to
     * create one manually via {@link StartJobRequest#builder()}
     * </p>
     *
     * @param startJobRequest
     *        A {@link Consumer} that will call methods on {@link StartJobRequest.Builder} to create a request. The
     *        request structure for the start job request.
     * @return Result of the StartJob operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.StartJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/StartJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StartJobResponse startJob(Consumer<StartJobRequest.Builder> startJobRequest) throws BadRequestException,
            UnauthorizedException, InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException,
            SdkClientException, AmplifyException {
        return startJob(StartJobRequest.builder().applyMutation(startJobRequest).build());
    }

    /**
     * <p>
     * Stops a job that is in progress for a branch of an Amplify app.
     * </p>
     *
     * @param stopJobRequest
     *        The request structure for the stop job request.
     * @return Result of the StopJob operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.StopJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/StopJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StopJobResponse stopJob(StopJobRequest stopJobRequest) throws BadRequestException, UnauthorizedException,
            InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException,
            AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a job that is in progress for a branch of an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopJobRequest.Builder} avoiding the need to create
     * one manually via {@link StopJobRequest#builder()}
     * </p>
     *
     * @param stopJobRequest
     *        A {@link Consumer} that will call methods on {@link StopJobRequest.Builder} to create a request. The
     *        request structure for the stop job request.
     * @return Result of the StopJob operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws LimitExceededException
     *         A resource could not be created because service quotas were exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.StopJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/StopJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StopJobResponse stopJob(Consumer<StopJobRequest.Builder> stopJobRequest) throws BadRequestException,
            UnauthorizedException, InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException,
            SdkClientException, AmplifyException {
        return stopJob(StopJobRequest.builder().applyMutation(stopJobRequest).build());
    }

    /**
     * <p>
     * Tags the resource with a tag key and value.
     * </p>
     *
     * @param tagResourceRequest
     *        The request structure to tag a resource with a tag key and value.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws ResourceNotFoundException
     *         An operation failed due to a non-existent resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalFailureException,
            BadRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags the resource with a tag key and value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request. The
     *        request structure to tag a resource with a tag key and value.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws ResourceNotFoundException
     *         An operation failed due to a non-existent resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalFailureException, BadRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AmplifyException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Untags a resource with a specified Amazon Resource Name (ARN).
     * </p>
     *
     * @param untagResourceRequest
     *        The request structure for the untag resource request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws ResourceNotFoundException
     *         An operation failed due to a non-existent resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalFailureException,
            BadRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Untags a resource with a specified Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request. The
     *        request structure for the untag resource request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws ResourceNotFoundException
     *         An operation failed due to a non-existent resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalFailureException, BadRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AmplifyException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing Amplify app.
     * </p>
     *
     * @param updateAppRequest
     *        The request structure for the update app request.
     * @return Result of the UpdateApp operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.UpdateApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/UpdateApp" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAppResponse updateApp(UpdateAppRequest updateAppRequest) throws BadRequestException, NotFoundException,
            UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAppRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAppRequest#builder()}
     * </p>
     *
     * @param updateAppRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAppRequest.Builder} to create a request. The
     *        request structure for the update app request.
     * @return Result of the UpdateApp operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.UpdateApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/UpdateApp" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAppResponse updateApp(Consumer<UpdateAppRequest.Builder> updateAppRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AmplifyException {
        return updateApp(UpdateAppRequest.builder().applyMutation(updateAppRequest).build());
    }

    /**
     * <p>
     * Updates a branch for an Amplify app.
     * </p>
     *
     * @param updateBranchRequest
     *        The request structure for the update branch request.
     * @return Result of the UpdateBranch operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws DependentServiceFailureException
     *         An operation failed because a dependent service threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.UpdateBranch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/UpdateBranch" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateBranchResponse updateBranch(UpdateBranchRequest updateBranchRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, InternalFailureException, DependentServiceFailureException,
            AwsServiceException, SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a branch for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBranchRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateBranchRequest#builder()}
     * </p>
     *
     * @param updateBranchRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBranchRequest.Builder} to create a request. The
     *        request structure for the update branch request.
     * @return Result of the UpdateBranch operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws DependentServiceFailureException
     *         An operation failed because a dependent service threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.UpdateBranch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/UpdateBranch" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateBranchResponse updateBranch(Consumer<UpdateBranchRequest.Builder> updateBranchRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException,
            DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        return updateBranch(UpdateBranchRequest.builder().applyMutation(updateBranchRequest).build());
    }

    /**
     * <p>
     * Creates a new domain association for an Amplify app.
     * </p>
     *
     * @param updateDomainAssociationRequest
     *        The request structure for the update domain association request.
     * @return Result of the UpdateDomainAssociation operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws DependentServiceFailureException
     *         An operation failed because a dependent service threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.UpdateDomainAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/UpdateDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDomainAssociationResponse updateDomainAssociation(UpdateDomainAssociationRequest updateDomainAssociationRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException,
            DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new domain association for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDomainAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateDomainAssociationRequest#builder()}
     * </p>
     *
     * @param updateDomainAssociationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDomainAssociationRequest.Builder} to create a
     *        request. The request structure for the update domain association request.
     * @return Result of the UpdateDomainAssociation operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws DependentServiceFailureException
     *         An operation failed because a dependent service threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.UpdateDomainAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/UpdateDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDomainAssociationResponse updateDomainAssociation(
            Consumer<UpdateDomainAssociationRequest.Builder> updateDomainAssociationRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, InternalFailureException, DependentServiceFailureException,
            AwsServiceException, SdkClientException, AmplifyException {
        return updateDomainAssociation(UpdateDomainAssociationRequest.builder().applyMutation(updateDomainAssociationRequest)
                .build());
    }

    /**
     * <p>
     * Updates a webhook.
     * </p>
     *
     * @param updateWebhookRequest
     *        The request structure for the update webhook request.
     * @return Result of the UpdateWebhook operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws DependentServiceFailureException
     *         An operation failed because a dependent service threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.UpdateWebhook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/UpdateWebhook" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateWebhookResponse updateWebhook(UpdateWebhookRequest updateWebhookRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, InternalFailureException, DependentServiceFailureException,
            AwsServiceException, SdkClientException, AmplifyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a webhook.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWebhookRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateWebhookRequest#builder()}
     * </p>
     *
     * @param updateWebhookRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWebhookRequest.Builder} to create a request. The
     *        request structure for the update webhook request.
     * @return Result of the UpdateWebhook operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws UnauthorizedException
     *         An operation failed due to a lack of access.
     * @throws NotFoundException
     *         An entity was not found during an operation.
     * @throws InternalFailureException
     *         The service failed to perform an operation due to an internal issue.
     * @throws DependentServiceFailureException
     *         An operation failed because a dependent service threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyClient.UpdateWebhook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/UpdateWebhook" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateWebhookResponse updateWebhook(Consumer<UpdateWebhookRequest.Builder> updateWebhookRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException,
            DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        return updateWebhook(UpdateWebhookRequest.builder().applyMutation(updateWebhookRequest).build());
    }

    /**
     * Create a {@link AmplifyClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AmplifyClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AmplifyClient}.
     */
    static AmplifyClientBuilder builder() {
        return new DefaultAmplifyClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default AmplifyServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
