/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result structure of the delete backend environment result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteBackendEnvironmentResponse extends AmplifyResponse implements
        ToCopyableBuilder<DeleteBackendEnvironmentResponse.Builder, DeleteBackendEnvironmentResponse> {
    private static final SdkField<BackendEnvironment> BACKEND_ENVIRONMENT_FIELD = SdkField
            .<BackendEnvironment> builder(MarshallingType.SDK_POJO).memberName("backendEnvironment")
            .getter(getter(DeleteBackendEnvironmentResponse::backendEnvironment)).setter(setter(Builder::backendEnvironment))
            .constructor(BackendEnvironment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendEnvironment").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKEND_ENVIRONMENT_FIELD));

    private final BackendEnvironment backendEnvironment;

    private DeleteBackendEnvironmentResponse(BuilderImpl builder) {
        super(builder);
        this.backendEnvironment = builder.backendEnvironment;
    }

    /**
     * <p>
     * Describes the backend environment for an Amplify app.
     * </p>
     * 
     * @return Describes the backend environment for an Amplify app.
     */
    public final BackendEnvironment backendEnvironment() {
        return backendEnvironment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backendEnvironment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBackendEnvironmentResponse)) {
            return false;
        }
        DeleteBackendEnvironmentResponse other = (DeleteBackendEnvironmentResponse) obj;
        return Objects.equals(backendEnvironment(), other.backendEnvironment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteBackendEnvironmentResponse").add("BackendEnvironment", backendEnvironment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "backendEnvironment":
            return Optional.ofNullable(clazz.cast(backendEnvironment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteBackendEnvironmentResponse, T> g) {
        return obj -> g.apply((DeleteBackendEnvironmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteBackendEnvironmentResponse> {
        /**
         * <p>
         * Describes the backend environment for an Amplify app.
         * </p>
         * 
         * @param backendEnvironment
         *        Describes the backend environment for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backendEnvironment(BackendEnvironment backendEnvironment);

        /**
         * <p>
         * Describes the backend environment for an Amplify app.
         * </p>
         * This is a convenience method that creates an instance of the {@link BackendEnvironment.Builder} avoiding the
         * need to create one manually via {@link BackendEnvironment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BackendEnvironment.Builder#build()} is called immediately and its
         * result is passed to {@link #backendEnvironment(BackendEnvironment)}.
         * 
         * @param backendEnvironment
         *        a consumer that will call methods on {@link BackendEnvironment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backendEnvironment(BackendEnvironment)
         */
        default Builder backendEnvironment(Consumer<BackendEnvironment.Builder> backendEnvironment) {
            return backendEnvironment(BackendEnvironment.builder().applyMutation(backendEnvironment).build());
        }
    }

    static final class BuilderImpl extends AmplifyResponse.BuilderImpl implements Builder {
        private BackendEnvironment backendEnvironment;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBackendEnvironmentResponse model) {
            super(model);
            backendEnvironment(model.backendEnvironment);
        }

        public final BackendEnvironment.Builder getBackendEnvironment() {
            return backendEnvironment != null ? backendEnvironment.toBuilder() : null;
        }

        public final void setBackendEnvironment(BackendEnvironment.BuilderImpl backendEnvironment) {
            this.backendEnvironment = backendEnvironment != null ? backendEnvironment.build() : null;
        }

        @Override
        public final Builder backendEnvironment(BackendEnvironment backendEnvironment) {
            this.backendEnvironment = backendEnvironment;
            return this;
        }

        @Override
        public DeleteBackendEnvironmentResponse build() {
            return new DeleteBackendEnvironmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
