/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the different branches of a repository for building, deploying, and hosting an Amplify app.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class App implements SdkPojo, Serializable, ToCopyableBuilder<App.Builder, App> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(App::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(App::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(App::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(App::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(App::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repository").getter(getter(App::repository)).setter(setter(Builder::repository))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repository").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(App::platformAsString)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(App::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime").getter(getter(App::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final SdkField<String> IAM_SERVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamServiceRoleArn").getter(getter(App::iamServiceRoleArn)).setter(setter(Builder::iamServiceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamServiceRoleArn").build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("environmentVariables")
            .getter(getter(App::environmentVariables))
            .setter(setter(Builder::environmentVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultDomain").getter(getter(App::defaultDomain)).setter(setter(Builder::defaultDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultDomain").build()).build();

    private static final SdkField<Boolean> ENABLE_BRANCH_AUTO_BUILD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableBranchAutoBuild").getter(getter(App::enableBranchAutoBuild))
            .setter(setter(Builder::enableBranchAutoBuild))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBranchAutoBuild").build())
            .build();

    private static final SdkField<Boolean> ENABLE_BRANCH_AUTO_DELETION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("enableBranchAutoDeletion")
            .getter(getter(App::enableBranchAutoDeletion)).setter(setter(Builder::enableBranchAutoDeletion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBranchAutoDeletion").build())
            .build();

    private static final SdkField<Boolean> ENABLE_BASIC_AUTH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableBasicAuth").getter(getter(App::enableBasicAuth)).setter(setter(Builder::enableBasicAuth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBasicAuth").build()).build();

    private static final SdkField<String> BASIC_AUTH_CREDENTIALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("basicAuthCredentials").getter(getter(App::basicAuthCredentials))
            .setter(setter(Builder::basicAuthCredentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basicAuthCredentials").build())
            .build();

    private static final SdkField<List<CustomRule>> CUSTOM_RULES_FIELD = SdkField
            .<List<CustomRule>> builder(MarshallingType.LIST)
            .memberName("customRules")
            .getter(getter(App::customRules))
            .setter(setter(Builder::customRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProductionBranch> PRODUCTION_BRANCH_FIELD = SdkField
            .<ProductionBranch> builder(MarshallingType.SDK_POJO).memberName("productionBranch")
            .getter(getter(App::productionBranch)).setter(setter(Builder::productionBranch))
            .constructor(ProductionBranch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productionBranch").build()).build();

    private static final SdkField<String> BUILD_SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("buildSpec").getter(getter(App::buildSpec)).setter(setter(Builder::buildSpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildSpec").build()).build();

    private static final SdkField<String> CUSTOM_HEADERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customHeaders").getter(getter(App::customHeaders)).setter(setter(Builder::customHeaders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customHeaders").build()).build();

    private static final SdkField<Boolean> ENABLE_AUTO_BRANCH_CREATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("enableAutoBranchCreation")
            .getter(getter(App::enableAutoBranchCreation)).setter(setter(Builder::enableAutoBranchCreation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableAutoBranchCreation").build())
            .build();

    private static final SdkField<List<String>> AUTO_BRANCH_CREATION_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("autoBranchCreationPatterns")
            .getter(getter(App::autoBranchCreationPatterns))
            .setter(setter(Builder::autoBranchCreationPatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoBranchCreationPatterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AutoBranchCreationConfig> AUTO_BRANCH_CREATION_CONFIG_FIELD = SdkField
            .<AutoBranchCreationConfig> builder(MarshallingType.SDK_POJO).memberName("autoBranchCreationConfig")
            .getter(getter(App::autoBranchCreationConfig)).setter(setter(Builder::autoBranchCreationConfig))
            .constructor(AutoBranchCreationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoBranchCreationConfig").build())
            .build();

    private static final SdkField<String> REPOSITORY_CLONE_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryCloneMethod").getter(getter(App::repositoryCloneMethodAsString))
            .setter(setter(Builder::repositoryCloneMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryCloneMethod").build())
            .build();

    private static final SdkField<CacheConfig> CACHE_CONFIG_FIELD = SdkField.<CacheConfig> builder(MarshallingType.SDK_POJO)
            .memberName("cacheConfig").getter(getter(App::cacheConfig)).setter(setter(Builder::cacheConfig))
            .constructor(CacheConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, APP_ARN_FIELD,
            NAME_FIELD, TAGS_FIELD, DESCRIPTION_FIELD, REPOSITORY_FIELD, PLATFORM_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD,
            IAM_SERVICE_ROLE_ARN_FIELD, ENVIRONMENT_VARIABLES_FIELD, DEFAULT_DOMAIN_FIELD, ENABLE_BRANCH_AUTO_BUILD_FIELD,
            ENABLE_BRANCH_AUTO_DELETION_FIELD, ENABLE_BASIC_AUTH_FIELD, BASIC_AUTH_CREDENTIALS_FIELD, CUSTOM_RULES_FIELD,
            PRODUCTION_BRANCH_FIELD, BUILD_SPEC_FIELD, CUSTOM_HEADERS_FIELD, ENABLE_AUTO_BRANCH_CREATION_FIELD,
            AUTO_BRANCH_CREATION_PATTERNS_FIELD, AUTO_BRANCH_CREATION_CONFIG_FIELD, REPOSITORY_CLONE_METHOD_FIELD,
            CACHE_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String appId;

    private final String appArn;

    private final String name;

    private final Map<String, String> tags;

    private final String description;

    private final String repository;

    private final String platform;

    private final Instant createTime;

    private final Instant updateTime;

    private final String iamServiceRoleArn;

    private final Map<String, String> environmentVariables;

    private final String defaultDomain;

    private final Boolean enableBranchAutoBuild;

    private final Boolean enableBranchAutoDeletion;

    private final Boolean enableBasicAuth;

    private final String basicAuthCredentials;

    private final List<CustomRule> customRules;

    private final ProductionBranch productionBranch;

    private final String buildSpec;

    private final String customHeaders;

    private final Boolean enableAutoBranchCreation;

    private final List<String> autoBranchCreationPatterns;

    private final AutoBranchCreationConfig autoBranchCreationConfig;

    private final String repositoryCloneMethod;

    private final CacheConfig cacheConfig;

    private App(BuilderImpl builder) {
        this.appId = builder.appId;
        this.appArn = builder.appArn;
        this.name = builder.name;
        this.tags = builder.tags;
        this.description = builder.description;
        this.repository = builder.repository;
        this.platform = builder.platform;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.iamServiceRoleArn = builder.iamServiceRoleArn;
        this.environmentVariables = builder.environmentVariables;
        this.defaultDomain = builder.defaultDomain;
        this.enableBranchAutoBuild = builder.enableBranchAutoBuild;
        this.enableBranchAutoDeletion = builder.enableBranchAutoDeletion;
        this.enableBasicAuth = builder.enableBasicAuth;
        this.basicAuthCredentials = builder.basicAuthCredentials;
        this.customRules = builder.customRules;
        this.productionBranch = builder.productionBranch;
        this.buildSpec = builder.buildSpec;
        this.customHeaders = builder.customHeaders;
        this.enableAutoBranchCreation = builder.enableAutoBranchCreation;
        this.autoBranchCreationPatterns = builder.autoBranchCreationPatterns;
        this.autoBranchCreationConfig = builder.autoBranchCreationConfig;
        this.repositoryCloneMethod = builder.repositoryCloneMethod;
        this.cacheConfig = builder.cacheConfig;
    }

    /**
     * <p>
     * The unique ID of the Amplify app.
     * </p>
     * 
     * @return The unique ID of the Amplify app.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amplify app.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amplify app.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * <p>
     * The name for the Amplify app.
     * </p>
     * 
     * @return The name for the Amplify app.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tag for the Amplify app.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tag for the Amplify app.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The description for the Amplify app.
     * </p>
     * 
     * @return The description for the Amplify app.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Git repository for the Amplify app.
     * </p>
     * 
     * @return The Git repository for the Amplify app.
     */
    public final String repository() {
        return repository;
    }

    /**
     * <p>
     * The platform for the Amplify app. For a static app, set the platform type to <code>WEB</code>. For a dynamic
     * server-side rendered (SSR) app, set the platform type to <code>WEB_COMPUTE</code>. For an app requiring Amplify
     * Hosting's original SSR support only, set the platform type to <code>WEB_DYNAMIC</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform for the Amplify app. For a static app, set the platform type to <code>WEB</code>. For a
     *         dynamic server-side rendered (SSR) app, set the platform type to <code>WEB_COMPUTE</code>. For an app
     *         requiring Amplify Hosting's original SSR support only, set the platform type to <code>WEB_DYNAMIC</code>.
     * @see Platform
     */
    public final Platform platform() {
        return Platform.fromValue(platform);
    }

    /**
     * <p>
     * The platform for the Amplify app. For a static app, set the platform type to <code>WEB</code>. For a dynamic
     * server-side rendered (SSR) app, set the platform type to <code>WEB_COMPUTE</code>. For an app requiring Amplify
     * Hosting's original SSR support only, set the platform type to <code>WEB_DYNAMIC</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform for the Amplify app. For a static app, set the platform type to <code>WEB</code>. For a
     *         dynamic server-side rendered (SSR) app, set the platform type to <code>WEB_COMPUTE</code>. For an app
     *         requiring Amplify Hosting's original SSR support only, set the platform type to <code>WEB_DYNAMIC</code>.
     * @see Platform
     */
    public final String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * Creates a date and time for the Amplify app.
     * </p>
     * 
     * @return Creates a date and time for the Amplify app.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * Updates the date and time for the Amplify app.
     * </p>
     * 
     * @return Updates the date and time for the Amplify app.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) of the Amplify app.
     * </p>
     * 
     * @return The AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) of the
     *         Amplify app.
     */
    public final String iamServiceRoleArn() {
        return iamServiceRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentVariables property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironmentVariables() {
        return environmentVariables != null && !(environmentVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The environment variables for the Amplify app.
     * </p>
     * <p>
     * For a list of the environment variables that are accessible to Amplify by default, see <a
     * href="https://docs.aws.amazon.com/amplify/latest/userguide/amplify-console-environment-variables.html">Amplify
     * Environment variables</a> in the <i>Amplify Hosting User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentVariables} method.
     * </p>
     * 
     * @return The environment variables for the Amplify app. </p>
     *         <p>
     *         For a list of the environment variables that are accessible to Amplify by default, see <a
     *         href="https://docs.aws.amazon.com/amplify/latest/userguide/amplify-console-environment-variables.html"
     *         >Amplify Environment variables</a> in the <i>Amplify Hosting User Guide</i>.
     */
    public final Map<String, String> environmentVariables() {
        return environmentVariables;
    }

    /**
     * <p>
     * The default domain for the Amplify app.
     * </p>
     * 
     * @return The default domain for the Amplify app.
     */
    public final String defaultDomain() {
        return defaultDomain;
    }

    /**
     * <p>
     * Enables the auto-building of branches for the Amplify app.
     * </p>
     * 
     * @return Enables the auto-building of branches for the Amplify app.
     */
    public final Boolean enableBranchAutoBuild() {
        return enableBranchAutoBuild;
    }

    /**
     * <p>
     * Automatically disconnect a branch in the Amplify console when you delete a branch from your Git repository.
     * </p>
     * 
     * @return Automatically disconnect a branch in the Amplify console when you delete a branch from your Git
     *         repository.
     */
    public final Boolean enableBranchAutoDeletion() {
        return enableBranchAutoDeletion;
    }

    /**
     * <p>
     * Enables basic authorization for the Amplify app's branches.
     * </p>
     * 
     * @return Enables basic authorization for the Amplify app's branches.
     */
    public final Boolean enableBasicAuth() {
        return enableBasicAuth;
    }

    /**
     * <p>
     * The basic authorization credentials for branches for the Amplify app. You must base64-encode the authorization
     * credentials and provide them in the format <code>user:password</code>.
     * </p>
     * 
     * @return The basic authorization credentials for branches for the Amplify app. You must base64-encode the
     *         authorization credentials and provide them in the format <code>user:password</code>.
     */
    public final String basicAuthCredentials() {
        return basicAuthCredentials;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomRules() {
        return customRules != null && !(customRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the custom redirect and rewrite rules for the Amplify app.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomRules} method.
     * </p>
     * 
     * @return Describes the custom redirect and rewrite rules for the Amplify app.
     */
    public final List<CustomRule> customRules() {
        return customRules;
    }

    /**
     * <p>
     * Describes the information about a production branch of the Amplify app.
     * </p>
     * 
     * @return Describes the information about a production branch of the Amplify app.
     */
    public final ProductionBranch productionBranch() {
        return productionBranch;
    }

    /**
     * <p>
     * Describes the content of the build specification (build spec) for the Amplify app.
     * </p>
     * 
     * @return Describes the content of the build specification (build spec) for the Amplify app.
     */
    public final String buildSpec() {
        return buildSpec;
    }

    /**
     * <p>
     * Describes the custom HTTP headers for the Amplify app.
     * </p>
     * 
     * @return Describes the custom HTTP headers for the Amplify app.
     */
    public final String customHeaders() {
        return customHeaders;
    }

    /**
     * <p>
     * Enables automated branch creation for the Amplify app.
     * </p>
     * 
     * @return Enables automated branch creation for the Amplify app.
     */
    public final Boolean enableAutoBranchCreation() {
        return enableAutoBranchCreation;
    }

    /**
     * For responses, this returns true if the service returned a value for the AutoBranchCreationPatterns property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAutoBranchCreationPatterns() {
        return autoBranchCreationPatterns != null && !(autoBranchCreationPatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the automated branch creation glob patterns for the Amplify app.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutoBranchCreationPatterns} method.
     * </p>
     * 
     * @return Describes the automated branch creation glob patterns for the Amplify app.
     */
    public final List<String> autoBranchCreationPatterns() {
        return autoBranchCreationPatterns;
    }

    /**
     * <p>
     * Describes the automated branch creation configuration for the Amplify app.
     * </p>
     * 
     * @return Describes the automated branch creation configuration for the Amplify app.
     */
    public final AutoBranchCreationConfig autoBranchCreationConfig() {
        return autoBranchCreationConfig;
    }

    /**
     * <note>
     * <p>
     * This is for internal use.
     * </p>
     * </note>
     * <p>
     * The Amplify service uses this parameter to specify the authentication protocol to use to access the Git
     * repository for an Amplify app. Amplify specifies <code>TOKEN</code> for a GitHub repository, <code>SIGV4</code>
     * for an Amazon Web Services CodeCommit repository, and <code>SSH</code> for GitLab and Bitbucket repositories.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #repositoryCloneMethod} will return {@link RepositoryCloneMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #repositoryCloneMethodAsString}.
     * </p>
     * 
     * @return <p>
     *         This is for internal use.
     *         </p>
     *         </note>
     *         <p>
     *         The Amplify service uses this parameter to specify the authentication protocol to use to access the Git
     *         repository for an Amplify app. Amplify specifies <code>TOKEN</code> for a GitHub repository,
     *         <code>SIGV4</code> for an Amazon Web Services CodeCommit repository, and <code>SSH</code> for GitLab and
     *         Bitbucket repositories.
     * @see RepositoryCloneMethod
     */
    public final RepositoryCloneMethod repositoryCloneMethod() {
        return RepositoryCloneMethod.fromValue(repositoryCloneMethod);
    }

    /**
     * <note>
     * <p>
     * This is for internal use.
     * </p>
     * </note>
     * <p>
     * The Amplify service uses this parameter to specify the authentication protocol to use to access the Git
     * repository for an Amplify app. Amplify specifies <code>TOKEN</code> for a GitHub repository, <code>SIGV4</code>
     * for an Amazon Web Services CodeCommit repository, and <code>SSH</code> for GitLab and Bitbucket repositories.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #repositoryCloneMethod} will return {@link RepositoryCloneMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #repositoryCloneMethodAsString}.
     * </p>
     * 
     * @return <p>
     *         This is for internal use.
     *         </p>
     *         </note>
     *         <p>
     *         The Amplify service uses this parameter to specify the authentication protocol to use to access the Git
     *         repository for an Amplify app. Amplify specifies <code>TOKEN</code> for a GitHub repository,
     *         <code>SIGV4</code> for an Amazon Web Services CodeCommit repository, and <code>SSH</code> for GitLab and
     *         Bitbucket repositories.
     * @see RepositoryCloneMethod
     */
    public final String repositoryCloneMethodAsString() {
        return repositoryCloneMethod;
    }

    /**
     * <p>
     * The cache configuration for the Amplify app. If you don't specify the cache configuration <code>type</code>,
     * Amplify uses the default <code>AMPLIFY_MANAGED</code> setting.
     * </p>
     * 
     * @return The cache configuration for the Amplify app. If you don't specify the cache configuration
     *         <code>type</code>, Amplify uses the default <code>AMPLIFY_MANAGED</code> setting.
     */
    public final CacheConfig cacheConfig() {
        return cacheConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(repository());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(iamServiceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentVariables() ? environmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultDomain());
        hashCode = 31 * hashCode + Objects.hashCode(enableBranchAutoBuild());
        hashCode = 31 * hashCode + Objects.hashCode(enableBranchAutoDeletion());
        hashCode = 31 * hashCode + Objects.hashCode(enableBasicAuth());
        hashCode = 31 * hashCode + Objects.hashCode(basicAuthCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomRules() ? customRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(productionBranch());
        hashCode = 31 * hashCode + Objects.hashCode(buildSpec());
        hashCode = 31 * hashCode + Objects.hashCode(customHeaders());
        hashCode = 31 * hashCode + Objects.hashCode(enableAutoBranchCreation());
        hashCode = 31 * hashCode + Objects.hashCode(hasAutoBranchCreationPatterns() ? autoBranchCreationPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(autoBranchCreationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryCloneMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cacheConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof App)) {
            return false;
        }
        App other = (App) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(appArn(), other.appArn())
                && Objects.equals(name(), other.name()) && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(description(), other.description()) && Objects.equals(repository(), other.repository())
                && Objects.equals(platformAsString(), other.platformAsString())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(iamServiceRoleArn(), other.iamServiceRoleArn())
                && hasEnvironmentVariables() == other.hasEnvironmentVariables()
                && Objects.equals(environmentVariables(), other.environmentVariables())
                && Objects.equals(defaultDomain(), other.defaultDomain())
                && Objects.equals(enableBranchAutoBuild(), other.enableBranchAutoBuild())
                && Objects.equals(enableBranchAutoDeletion(), other.enableBranchAutoDeletion())
                && Objects.equals(enableBasicAuth(), other.enableBasicAuth())
                && Objects.equals(basicAuthCredentials(), other.basicAuthCredentials())
                && hasCustomRules() == other.hasCustomRules() && Objects.equals(customRules(), other.customRules())
                && Objects.equals(productionBranch(), other.productionBranch()) && Objects.equals(buildSpec(), other.buildSpec())
                && Objects.equals(customHeaders(), other.customHeaders())
                && Objects.equals(enableAutoBranchCreation(), other.enableAutoBranchCreation())
                && hasAutoBranchCreationPatterns() == other.hasAutoBranchCreationPatterns()
                && Objects.equals(autoBranchCreationPatterns(), other.autoBranchCreationPatterns())
                && Objects.equals(autoBranchCreationConfig(), other.autoBranchCreationConfig())
                && Objects.equals(repositoryCloneMethodAsString(), other.repositoryCloneMethodAsString())
                && Objects.equals(cacheConfig(), other.cacheConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("App").add("AppId", appId()).add("AppArn", appArn()).add("Name", name())
                .add("Tags", hasTags() ? tags() : null).add("Description", description()).add("Repository", repository())
                .add("Platform", platformAsString()).add("CreateTime", createTime()).add("UpdateTime", updateTime())
                .add("IamServiceRoleArn", iamServiceRoleArn())
                .add("EnvironmentVariables", hasEnvironmentVariables() ? environmentVariables() : null)
                .add("DefaultDomain", defaultDomain()).add("EnableBranchAutoBuild", enableBranchAutoBuild())
                .add("EnableBranchAutoDeletion", enableBranchAutoDeletion()).add("EnableBasicAuth", enableBasicAuth())
                .add("BasicAuthCredentials", basicAuthCredentials() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CustomRules", hasCustomRules() ? customRules() : null).add("ProductionBranch", productionBranch())
                .add("BuildSpec", buildSpec() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CustomHeaders", customHeaders()).add("EnableAutoBranchCreation", enableAutoBranchCreation())
                .add("AutoBranchCreationPatterns", hasAutoBranchCreationPatterns() ? autoBranchCreationPatterns() : null)
                .add("AutoBranchCreationConfig", autoBranchCreationConfig())
                .add("RepositoryCloneMethod", repositoryCloneMethodAsString()).add("CacheConfig", cacheConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "repository":
            return Optional.ofNullable(clazz.cast(repository()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "iamServiceRoleArn":
            return Optional.ofNullable(clazz.cast(iamServiceRoleArn()));
        case "environmentVariables":
            return Optional.ofNullable(clazz.cast(environmentVariables()));
        case "defaultDomain":
            return Optional.ofNullable(clazz.cast(defaultDomain()));
        case "enableBranchAutoBuild":
            return Optional.ofNullable(clazz.cast(enableBranchAutoBuild()));
        case "enableBranchAutoDeletion":
            return Optional.ofNullable(clazz.cast(enableBranchAutoDeletion()));
        case "enableBasicAuth":
            return Optional.ofNullable(clazz.cast(enableBasicAuth()));
        case "basicAuthCredentials":
            return Optional.ofNullable(clazz.cast(basicAuthCredentials()));
        case "customRules":
            return Optional.ofNullable(clazz.cast(customRules()));
        case "productionBranch":
            return Optional.ofNullable(clazz.cast(productionBranch()));
        case "buildSpec":
            return Optional.ofNullable(clazz.cast(buildSpec()));
        case "customHeaders":
            return Optional.ofNullable(clazz.cast(customHeaders()));
        case "enableAutoBranchCreation":
            return Optional.ofNullable(clazz.cast(enableAutoBranchCreation()));
        case "autoBranchCreationPatterns":
            return Optional.ofNullable(clazz.cast(autoBranchCreationPatterns()));
        case "autoBranchCreationConfig":
            return Optional.ofNullable(clazz.cast(autoBranchCreationConfig()));
        case "repositoryCloneMethod":
            return Optional.ofNullable(clazz.cast(repositoryCloneMethodAsString()));
        case "cacheConfig":
            return Optional.ofNullable(clazz.cast(cacheConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<App, T> g) {
        return obj -> g.apply((App) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, App> {
        /**
         * <p>
         * The unique ID of the Amplify app.
         * </p>
         * 
         * @param appId
         *        The unique ID of the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amplify app.
         * </p>
         * 
         * @param appArn
         *        The Amazon Resource Name (ARN) of the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * The name for the Amplify app.
         * </p>
         * 
         * @param name
         *        The name for the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The tag for the Amplify app.
         * </p>
         * 
         * @param tags
         *        The tag for the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The description for the Amplify app.
         * </p>
         * 
         * @param description
         *        The description for the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Git repository for the Amplify app.
         * </p>
         * 
         * @param repository
         *        The Git repository for the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repository(String repository);

        /**
         * <p>
         * The platform for the Amplify app. For a static app, set the platform type to <code>WEB</code>. For a dynamic
         * server-side rendered (SSR) app, set the platform type to <code>WEB_COMPUTE</code>. For an app requiring
         * Amplify Hosting's original SSR support only, set the platform type to <code>WEB_DYNAMIC</code>.
         * </p>
         * 
         * @param platform
         *        The platform for the Amplify app. For a static app, set the platform type to <code>WEB</code>. For a
         *        dynamic server-side rendered (SSR) app, set the platform type to <code>WEB_COMPUTE</code>. For an app
         *        requiring Amplify Hosting's original SSR support only, set the platform type to
         *        <code>WEB_DYNAMIC</code>.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(String platform);

        /**
         * <p>
         * The platform for the Amplify app. For a static app, set the platform type to <code>WEB</code>. For a dynamic
         * server-side rendered (SSR) app, set the platform type to <code>WEB_COMPUTE</code>. For an app requiring
         * Amplify Hosting's original SSR support only, set the platform type to <code>WEB_DYNAMIC</code>.
         * </p>
         * 
         * @param platform
         *        The platform for the Amplify app. For a static app, set the platform type to <code>WEB</code>. For a
         *        dynamic server-side rendered (SSR) app, set the platform type to <code>WEB_COMPUTE</code>. For an app
         *        requiring Amplify Hosting's original SSR support only, set the platform type to
         *        <code>WEB_DYNAMIC</code>.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(Platform platform);

        /**
         * <p>
         * Creates a date and time for the Amplify app.
         * </p>
         * 
         * @param createTime
         *        Creates a date and time for the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * Updates the date and time for the Amplify app.
         * </p>
         * 
         * @param updateTime
         *        Updates the date and time for the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) of the Amplify
         * app.
         * </p>
         * 
         * @param iamServiceRoleArn
         *        The AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) of the
         *        Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamServiceRoleArn(String iamServiceRoleArn);

        /**
         * <p>
         * The environment variables for the Amplify app.
         * </p>
         * <p>
         * For a list of the environment variables that are accessible to Amplify by default, see <a
         * href="https://docs.aws.amazon.com/amplify/latest/userguide/amplify-console-environment-variables.html"
         * >Amplify Environment variables</a> in the <i>Amplify Hosting User Guide</i>.
         * </p>
         * 
         * @param environmentVariables
         *        The environment variables for the Amplify app. </p>
         *        <p>
         *        For a list of the environment variables that are accessible to Amplify by default, see <a href=
         *        "https://docs.aws.amazon.com/amplify/latest/userguide/amplify-console-environment-variables.html"
         *        >Amplify Environment variables</a> in the <i>Amplify Hosting User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentVariables(Map<String, String> environmentVariables);

        /**
         * <p>
         * The default domain for the Amplify app.
         * </p>
         * 
         * @param defaultDomain
         *        The default domain for the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultDomain(String defaultDomain);

        /**
         * <p>
         * Enables the auto-building of branches for the Amplify app.
         * </p>
         * 
         * @param enableBranchAutoBuild
         *        Enables the auto-building of branches for the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableBranchAutoBuild(Boolean enableBranchAutoBuild);

        /**
         * <p>
         * Automatically disconnect a branch in the Amplify console when you delete a branch from your Git repository.
         * </p>
         * 
         * @param enableBranchAutoDeletion
         *        Automatically disconnect a branch in the Amplify console when you delete a branch from your Git
         *        repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableBranchAutoDeletion(Boolean enableBranchAutoDeletion);

        /**
         * <p>
         * Enables basic authorization for the Amplify app's branches.
         * </p>
         * 
         * @param enableBasicAuth
         *        Enables basic authorization for the Amplify app's branches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableBasicAuth(Boolean enableBasicAuth);

        /**
         * <p>
         * The basic authorization credentials for branches for the Amplify app. You must base64-encode the
         * authorization credentials and provide them in the format <code>user:password</code>.
         * </p>
         * 
         * @param basicAuthCredentials
         *        The basic authorization credentials for branches for the Amplify app. You must base64-encode the
         *        authorization credentials and provide them in the format <code>user:password</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basicAuthCredentials(String basicAuthCredentials);

        /**
         * <p>
         * Describes the custom redirect and rewrite rules for the Amplify app.
         * </p>
         * 
         * @param customRules
         *        Describes the custom redirect and rewrite rules for the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customRules(Collection<CustomRule> customRules);

        /**
         * <p>
         * Describes the custom redirect and rewrite rules for the Amplify app.
         * </p>
         * 
         * @param customRules
         *        Describes the custom redirect and rewrite rules for the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customRules(CustomRule... customRules);

        /**
         * <p>
         * Describes the custom redirect and rewrite rules for the Amplify app.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.amplify.model.CustomRule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.amplify.model.CustomRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.amplify.model.CustomRule.Builder#build()} is called immediately and
         * its result is passed to {@link #customRules(List<CustomRule>)}.
         * 
         * @param customRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.amplify.model.CustomRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customRules(java.util.Collection<CustomRule>)
         */
        Builder customRules(Consumer<CustomRule.Builder>... customRules);

        /**
         * <p>
         * Describes the information about a production branch of the Amplify app.
         * </p>
         * 
         * @param productionBranch
         *        Describes the information about a production branch of the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productionBranch(ProductionBranch productionBranch);

        /**
         * <p>
         * Describes the information about a production branch of the Amplify app.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProductionBranch.Builder} avoiding the
         * need to create one manually via {@link ProductionBranch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProductionBranch.Builder#build()} is called immediately and its
         * result is passed to {@link #productionBranch(ProductionBranch)}.
         * 
         * @param productionBranch
         *        a consumer that will call methods on {@link ProductionBranch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productionBranch(ProductionBranch)
         */
        default Builder productionBranch(Consumer<ProductionBranch.Builder> productionBranch) {
            return productionBranch(ProductionBranch.builder().applyMutation(productionBranch).build());
        }

        /**
         * <p>
         * Describes the content of the build specification (build spec) for the Amplify app.
         * </p>
         * 
         * @param buildSpec
         *        Describes the content of the build specification (build spec) for the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildSpec(String buildSpec);

        /**
         * <p>
         * Describes the custom HTTP headers for the Amplify app.
         * </p>
         * 
         * @param customHeaders
         *        Describes the custom HTTP headers for the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customHeaders(String customHeaders);

        /**
         * <p>
         * Enables automated branch creation for the Amplify app.
         * </p>
         * 
         * @param enableAutoBranchCreation
         *        Enables automated branch creation for the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableAutoBranchCreation(Boolean enableAutoBranchCreation);

        /**
         * <p>
         * Describes the automated branch creation glob patterns for the Amplify app.
         * </p>
         * 
         * @param autoBranchCreationPatterns
         *        Describes the automated branch creation glob patterns for the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoBranchCreationPatterns(Collection<String> autoBranchCreationPatterns);

        /**
         * <p>
         * Describes the automated branch creation glob patterns for the Amplify app.
         * </p>
         * 
         * @param autoBranchCreationPatterns
         *        Describes the automated branch creation glob patterns for the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoBranchCreationPatterns(String... autoBranchCreationPatterns);

        /**
         * <p>
         * Describes the automated branch creation configuration for the Amplify app.
         * </p>
         * 
         * @param autoBranchCreationConfig
         *        Describes the automated branch creation configuration for the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoBranchCreationConfig(AutoBranchCreationConfig autoBranchCreationConfig);

        /**
         * <p>
         * Describes the automated branch creation configuration for the Amplify app.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoBranchCreationConfig.Builder}
         * avoiding the need to create one manually via {@link AutoBranchCreationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoBranchCreationConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #autoBranchCreationConfig(AutoBranchCreationConfig)}.
         * 
         * @param autoBranchCreationConfig
         *        a consumer that will call methods on {@link AutoBranchCreationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoBranchCreationConfig(AutoBranchCreationConfig)
         */
        default Builder autoBranchCreationConfig(Consumer<AutoBranchCreationConfig.Builder> autoBranchCreationConfig) {
            return autoBranchCreationConfig(AutoBranchCreationConfig.builder().applyMutation(autoBranchCreationConfig).build());
        }

        /**
         * <note>
         * <p>
         * This is for internal use.
         * </p>
         * </note>
         * <p>
         * The Amplify service uses this parameter to specify the authentication protocol to use to access the Git
         * repository for an Amplify app. Amplify specifies <code>TOKEN</code> for a GitHub repository,
         * <code>SIGV4</code> for an Amazon Web Services CodeCommit repository, and <code>SSH</code> for GitLab and
         * Bitbucket repositories.
         * </p>
         * 
         * @param repositoryCloneMethod
         *        <p>
         *        This is for internal use.
         *        </p>
         *        </note>
         *        <p>
         *        The Amplify service uses this parameter to specify the authentication protocol to use to access the
         *        Git repository for an Amplify app. Amplify specifies <code>TOKEN</code> for a GitHub repository,
         *        <code>SIGV4</code> for an Amazon Web Services CodeCommit repository, and <code>SSH</code> for GitLab
         *        and Bitbucket repositories.
         * @see RepositoryCloneMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepositoryCloneMethod
         */
        Builder repositoryCloneMethod(String repositoryCloneMethod);

        /**
         * <note>
         * <p>
         * This is for internal use.
         * </p>
         * </note>
         * <p>
         * The Amplify service uses this parameter to specify the authentication protocol to use to access the Git
         * repository for an Amplify app. Amplify specifies <code>TOKEN</code> for a GitHub repository,
         * <code>SIGV4</code> for an Amazon Web Services CodeCommit repository, and <code>SSH</code> for GitLab and
         * Bitbucket repositories.
         * </p>
         * 
         * @param repositoryCloneMethod
         *        <p>
         *        This is for internal use.
         *        </p>
         *        </note>
         *        <p>
         *        The Amplify service uses this parameter to specify the authentication protocol to use to access the
         *        Git repository for an Amplify app. Amplify specifies <code>TOKEN</code> for a GitHub repository,
         *        <code>SIGV4</code> for an Amazon Web Services CodeCommit repository, and <code>SSH</code> for GitLab
         *        and Bitbucket repositories.
         * @see RepositoryCloneMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepositoryCloneMethod
         */
        Builder repositoryCloneMethod(RepositoryCloneMethod repositoryCloneMethod);

        /**
         * <p>
         * The cache configuration for the Amplify app. If you don't specify the cache configuration <code>type</code>,
         * Amplify uses the default <code>AMPLIFY_MANAGED</code> setting.
         * </p>
         * 
         * @param cacheConfig
         *        The cache configuration for the Amplify app. If you don't specify the cache configuration
         *        <code>type</code>, Amplify uses the default <code>AMPLIFY_MANAGED</code> setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheConfig(CacheConfig cacheConfig);

        /**
         * <p>
         * The cache configuration for the Amplify app. If you don't specify the cache configuration <code>type</code>,
         * Amplify uses the default <code>AMPLIFY_MANAGED</code> setting.
         * </p>
         * This is a convenience method that creates an instance of the {@link CacheConfig.Builder} avoiding the need to
         * create one manually via {@link CacheConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CacheConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #cacheConfig(CacheConfig)}.
         * 
         * @param cacheConfig
         *        a consumer that will call methods on {@link CacheConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheConfig(CacheConfig)
         */
        default Builder cacheConfig(Consumer<CacheConfig.Builder> cacheConfig) {
            return cacheConfig(CacheConfig.builder().applyMutation(cacheConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String appId;

        private String appArn;

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String description;

        private String repository;

        private String platform;

        private Instant createTime;

        private Instant updateTime;

        private String iamServiceRoleArn;

        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();

        private String defaultDomain;

        private Boolean enableBranchAutoBuild;

        private Boolean enableBranchAutoDeletion;

        private Boolean enableBasicAuth;

        private String basicAuthCredentials;

        private List<CustomRule> customRules = DefaultSdkAutoConstructList.getInstance();

        private ProductionBranch productionBranch;

        private String buildSpec;

        private String customHeaders;

        private Boolean enableAutoBranchCreation;

        private List<String> autoBranchCreationPatterns = DefaultSdkAutoConstructList.getInstance();

        private AutoBranchCreationConfig autoBranchCreationConfig;

        private String repositoryCloneMethod;

        private CacheConfig cacheConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(App model) {
            appId(model.appId);
            appArn(model.appArn);
            name(model.name);
            tags(model.tags);
            description(model.description);
            repository(model.repository);
            platform(model.platform);
            createTime(model.createTime);
            updateTime(model.updateTime);
            iamServiceRoleArn(model.iamServiceRoleArn);
            environmentVariables(model.environmentVariables);
            defaultDomain(model.defaultDomain);
            enableBranchAutoBuild(model.enableBranchAutoBuild);
            enableBranchAutoDeletion(model.enableBranchAutoDeletion);
            enableBasicAuth(model.enableBasicAuth);
            basicAuthCredentials(model.basicAuthCredentials);
            customRules(model.customRules);
            productionBranch(model.productionBranch);
            buildSpec(model.buildSpec);
            customHeaders(model.customHeaders);
            enableAutoBranchCreation(model.enableAutoBranchCreation);
            autoBranchCreationPatterns(model.autoBranchCreationPatterns);
            autoBranchCreationConfig(model.autoBranchCreationConfig);
            repositoryCloneMethod(model.repositoryCloneMethod);
            cacheConfig(model.cacheConfig);
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRepository() {
            return repository;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getIamServiceRoleArn() {
            return iamServiceRoleArn;
        }

        public final void setIamServiceRoleArn(String iamServiceRoleArn) {
            this.iamServiceRoleArn = iamServiceRoleArn;
        }

        @Override
        public final Builder iamServiceRoleArn(String iamServiceRoleArn) {
            this.iamServiceRoleArn = iamServiceRoleArn;
            return this;
        }

        public final Map<String, String> getEnvironmentVariables() {
            if (environmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return environmentVariables;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
            return this;
        }

        public final String getDefaultDomain() {
            return defaultDomain;
        }

        public final void setDefaultDomain(String defaultDomain) {
            this.defaultDomain = defaultDomain;
        }

        @Override
        public final Builder defaultDomain(String defaultDomain) {
            this.defaultDomain = defaultDomain;
            return this;
        }

        public final Boolean getEnableBranchAutoBuild() {
            return enableBranchAutoBuild;
        }

        public final void setEnableBranchAutoBuild(Boolean enableBranchAutoBuild) {
            this.enableBranchAutoBuild = enableBranchAutoBuild;
        }

        @Override
        public final Builder enableBranchAutoBuild(Boolean enableBranchAutoBuild) {
            this.enableBranchAutoBuild = enableBranchAutoBuild;
            return this;
        }

        public final Boolean getEnableBranchAutoDeletion() {
            return enableBranchAutoDeletion;
        }

        public final void setEnableBranchAutoDeletion(Boolean enableBranchAutoDeletion) {
            this.enableBranchAutoDeletion = enableBranchAutoDeletion;
        }

        @Override
        public final Builder enableBranchAutoDeletion(Boolean enableBranchAutoDeletion) {
            this.enableBranchAutoDeletion = enableBranchAutoDeletion;
            return this;
        }

        public final Boolean getEnableBasicAuth() {
            return enableBasicAuth;
        }

        public final void setEnableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
        }

        @Override
        public final Builder enableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
            return this;
        }

        public final String getBasicAuthCredentials() {
            return basicAuthCredentials;
        }

        public final void setBasicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
        }

        @Override
        public final Builder basicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
            return this;
        }

        public final List<CustomRule.Builder> getCustomRules() {
            List<CustomRule.Builder> result = CustomRulesCopier.copyToBuilder(this.customRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomRules(Collection<CustomRule.BuilderImpl> customRules) {
            this.customRules = CustomRulesCopier.copyFromBuilder(customRules);
        }

        @Override
        public final Builder customRules(Collection<CustomRule> customRules) {
            this.customRules = CustomRulesCopier.copy(customRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customRules(CustomRule... customRules) {
            customRules(Arrays.asList(customRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customRules(Consumer<CustomRule.Builder>... customRules) {
            customRules(Stream.of(customRules).map(c -> CustomRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ProductionBranch.Builder getProductionBranch() {
            return productionBranch != null ? productionBranch.toBuilder() : null;
        }

        public final void setProductionBranch(ProductionBranch.BuilderImpl productionBranch) {
            this.productionBranch = productionBranch != null ? productionBranch.build() : null;
        }

        @Override
        public final Builder productionBranch(ProductionBranch productionBranch) {
            this.productionBranch = productionBranch;
            return this;
        }

        public final String getBuildSpec() {
            return buildSpec;
        }

        public final void setBuildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
        }

        @Override
        public final Builder buildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        public final String getCustomHeaders() {
            return customHeaders;
        }

        public final void setCustomHeaders(String customHeaders) {
            this.customHeaders = customHeaders;
        }

        @Override
        public final Builder customHeaders(String customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public final Boolean getEnableAutoBranchCreation() {
            return enableAutoBranchCreation;
        }

        public final void setEnableAutoBranchCreation(Boolean enableAutoBranchCreation) {
            this.enableAutoBranchCreation = enableAutoBranchCreation;
        }

        @Override
        public final Builder enableAutoBranchCreation(Boolean enableAutoBranchCreation) {
            this.enableAutoBranchCreation = enableAutoBranchCreation;
            return this;
        }

        public final Collection<String> getAutoBranchCreationPatterns() {
            if (autoBranchCreationPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return autoBranchCreationPatterns;
        }

        public final void setAutoBranchCreationPatterns(Collection<String> autoBranchCreationPatterns) {
            this.autoBranchCreationPatterns = AutoBranchCreationPatternsCopier.copy(autoBranchCreationPatterns);
        }

        @Override
        public final Builder autoBranchCreationPatterns(Collection<String> autoBranchCreationPatterns) {
            this.autoBranchCreationPatterns = AutoBranchCreationPatternsCopier.copy(autoBranchCreationPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoBranchCreationPatterns(String... autoBranchCreationPatterns) {
            autoBranchCreationPatterns(Arrays.asList(autoBranchCreationPatterns));
            return this;
        }

        public final AutoBranchCreationConfig.Builder getAutoBranchCreationConfig() {
            return autoBranchCreationConfig != null ? autoBranchCreationConfig.toBuilder() : null;
        }

        public final void setAutoBranchCreationConfig(AutoBranchCreationConfig.BuilderImpl autoBranchCreationConfig) {
            this.autoBranchCreationConfig = autoBranchCreationConfig != null ? autoBranchCreationConfig.build() : null;
        }

        @Override
        public final Builder autoBranchCreationConfig(AutoBranchCreationConfig autoBranchCreationConfig) {
            this.autoBranchCreationConfig = autoBranchCreationConfig;
            return this;
        }

        public final String getRepositoryCloneMethod() {
            return repositoryCloneMethod;
        }

        public final void setRepositoryCloneMethod(String repositoryCloneMethod) {
            this.repositoryCloneMethod = repositoryCloneMethod;
        }

        @Override
        public final Builder repositoryCloneMethod(String repositoryCloneMethod) {
            this.repositoryCloneMethod = repositoryCloneMethod;
            return this;
        }

        @Override
        public final Builder repositoryCloneMethod(RepositoryCloneMethod repositoryCloneMethod) {
            this.repositoryCloneMethod(repositoryCloneMethod == null ? null : repositoryCloneMethod.toString());
            return this;
        }

        public final CacheConfig.Builder getCacheConfig() {
            return cacheConfig != null ? cacheConfig.toBuilder() : null;
        }

        public final void setCacheConfig(CacheConfig.BuilderImpl cacheConfig) {
            this.cacheConfig = cacheConfig != null ? cacheConfig.build() : null;
        }

        @Override
        public final Builder cacheConfig(CacheConfig cacheConfig) {
            this.cacheConfig = cacheConfig;
            return this;
        }

        @Override
        public App build() {
            return new App(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
