/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request structure used to create Apps in Amplify.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAppRequest extends AmplifyRequest implements
        ToCopyableBuilder<CreateAppRequest.Builder, CreateAppRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateAppRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateAppRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateAppRequest::repository)).setter(setter(Builder::repository))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repository").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateAppRequest::platformAsString)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<String> IAM_SERVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateAppRequest::iamServiceRoleArn)).setter(setter(Builder::iamServiceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamServiceRoleArn").build()).build();

    private static final SdkField<String> OAUTH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateAppRequest::oauthToken)).setter(setter(Builder::oauthToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oauthToken").build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateAppRequest::environmentVariables))
            .setter(setter(Builder::environmentVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_BRANCH_AUTO_BUILD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateAppRequest::enableBranchAutoBuild)).setter(setter(Builder::enableBranchAutoBuild))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBranchAutoBuild").build())
            .build();

    private static final SdkField<Boolean> ENABLE_BASIC_AUTH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateAppRequest::enableBasicAuth)).setter(setter(Builder::enableBasicAuth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBasicAuth").build()).build();

    private static final SdkField<String> BASIC_AUTH_CREDENTIALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateAppRequest::basicAuthCredentials)).setter(setter(Builder::basicAuthCredentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basicAuthCredentials").build())
            .build();

    private static final SdkField<List<CustomRule>> CUSTOM_RULES_FIELD = SdkField
            .<List<CustomRule>> builder(MarshallingType.LIST)
            .getter(getter(CreateAppRequest::customRules))
            .setter(setter(Builder::customRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateAppRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> BUILD_SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateAppRequest::buildSpec)).setter(setter(Builder::buildSpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildSpec").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            REPOSITORY_FIELD, PLATFORM_FIELD, IAM_SERVICE_ROLE_ARN_FIELD, OAUTH_TOKEN_FIELD, ENVIRONMENT_VARIABLES_FIELD,
            ENABLE_BRANCH_AUTO_BUILD_FIELD, ENABLE_BASIC_AUTH_FIELD, BASIC_AUTH_CREDENTIALS_FIELD, CUSTOM_RULES_FIELD,
            TAGS_FIELD, BUILD_SPEC_FIELD));

    private final String name;

    private final String description;

    private final String repository;

    private final String platform;

    private final String iamServiceRoleArn;

    private final String oauthToken;

    private final Map<String, String> environmentVariables;

    private final Boolean enableBranchAutoBuild;

    private final Boolean enableBasicAuth;

    private final String basicAuthCredentials;

    private final List<CustomRule> customRules;

    private final Map<String, String> tags;

    private final String buildSpec;

    private CreateAppRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.repository = builder.repository;
        this.platform = builder.platform;
        this.iamServiceRoleArn = builder.iamServiceRoleArn;
        this.oauthToken = builder.oauthToken;
        this.environmentVariables = builder.environmentVariables;
        this.enableBranchAutoBuild = builder.enableBranchAutoBuild;
        this.enableBasicAuth = builder.enableBasicAuth;
        this.basicAuthCredentials = builder.basicAuthCredentials;
        this.customRules = builder.customRules;
        this.tags = builder.tags;
        this.buildSpec = builder.buildSpec;
    }

    /**
     * <p>
     * Name for the Amplify App
     * </p>
     * 
     * @return Name for the Amplify App
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Description for an Amplify App
     * </p>
     * 
     * @return Description for an Amplify App
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Repository for an Amplify App
     * </p>
     * 
     * @return Repository for an Amplify App
     */
    public String repository() {
        return repository;
    }

    /**
     * <p>
     * Platform / framework for an Amplify App
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return Platform / framework for an Amplify App
     * @see Platform
     */
    public Platform platform() {
        return Platform.fromValue(platform);
    }

    /**
     * <p>
     * Platform / framework for an Amplify App
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return Platform / framework for an Amplify App
     * @see Platform
     */
    public String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * AWS IAM service role for an Amplify App
     * </p>
     * 
     * @return AWS IAM service role for an Amplify App
     */
    public String iamServiceRoleArn() {
        return iamServiceRoleArn;
    }

    /**
     * <p>
     * OAuth token for 3rd party source control system for an Amplify App, used to create webhook and read-only deploy
     * key. OAuth token is not stored.
     * </p>
     * 
     * @return OAuth token for 3rd party source control system for an Amplify App, used to create webhook and read-only
     *         deploy key. OAuth token is not stored.
     */
    public String oauthToken() {
        return oauthToken;
    }

    /**
     * <p>
     * Environment variables map for an Amplify App.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Environment variables map for an Amplify App.
     */
    public Map<String, String> environmentVariables() {
        return environmentVariables;
    }

    /**
     * <p>
     * Enable the auto building of branches for an Amplify App.
     * </p>
     * 
     * @return Enable the auto building of branches for an Amplify App.
     */
    public Boolean enableBranchAutoBuild() {
        return enableBranchAutoBuild;
    }

    /**
     * <p>
     * Enable Basic Authorization for an Amplify App, this will apply to all branches part of this App.
     * </p>
     * 
     * @return Enable Basic Authorization for an Amplify App, this will apply to all branches part of this App.
     */
    public Boolean enableBasicAuth() {
        return enableBasicAuth;
    }

    /**
     * <p>
     * Credentials for Basic Authorization for an Amplify App.
     * </p>
     * 
     * @return Credentials for Basic Authorization for an Amplify App.
     */
    public String basicAuthCredentials() {
        return basicAuthCredentials;
    }

    /**
     * <p>
     * Custom rewrite / redirect rules for an Amplify App.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Custom rewrite / redirect rules for an Amplify App.
     */
    public List<CustomRule> customRules() {
        return customRules;
    }

    /**
     * <p>
     * Tag for an Amplify App
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Tag for an Amplify App
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * BuildSpec for an Amplify App
     * </p>
     * 
     * @return BuildSpec for an Amplify App
     */
    public String buildSpec() {
        return buildSpec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(repository());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(iamServiceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(oauthToken());
        hashCode = 31 * hashCode + Objects.hashCode(environmentVariables());
        hashCode = 31 * hashCode + Objects.hashCode(enableBranchAutoBuild());
        hashCode = 31 * hashCode + Objects.hashCode(enableBasicAuth());
        hashCode = 31 * hashCode + Objects.hashCode(basicAuthCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(customRules());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(buildSpec());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppRequest)) {
            return false;
        }
        CreateAppRequest other = (CreateAppRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(repository(), other.repository())
                && Objects.equals(platformAsString(), other.platformAsString())
                && Objects.equals(iamServiceRoleArn(), other.iamServiceRoleArn())
                && Objects.equals(oauthToken(), other.oauthToken())
                && Objects.equals(environmentVariables(), other.environmentVariables())
                && Objects.equals(enableBranchAutoBuild(), other.enableBranchAutoBuild())
                && Objects.equals(enableBasicAuth(), other.enableBasicAuth())
                && Objects.equals(basicAuthCredentials(), other.basicAuthCredentials())
                && Objects.equals(customRules(), other.customRules()) && Objects.equals(tags(), other.tags())
                && Objects.equals(buildSpec(), other.buildSpec());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateAppRequest").add("Name", name()).add("Description", description())
                .add("Repository", repository()).add("Platform", platformAsString())
                .add("IamServiceRoleArn", iamServiceRoleArn()).add("OauthToken", oauthToken())
                .add("EnvironmentVariables", environmentVariables()).add("EnableBranchAutoBuild", enableBranchAutoBuild())
                .add("EnableBasicAuth", enableBasicAuth()).add("BasicAuthCredentials", basicAuthCredentials())
                .add("CustomRules", customRules()).add("Tags", tags()).add("BuildSpec", buildSpec()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "repository":
            return Optional.ofNullable(clazz.cast(repository()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "iamServiceRoleArn":
            return Optional.ofNullable(clazz.cast(iamServiceRoleArn()));
        case "oauthToken":
            return Optional.ofNullable(clazz.cast(oauthToken()));
        case "environmentVariables":
            return Optional.ofNullable(clazz.cast(environmentVariables()));
        case "enableBranchAutoBuild":
            return Optional.ofNullable(clazz.cast(enableBranchAutoBuild()));
        case "enableBasicAuth":
            return Optional.ofNullable(clazz.cast(enableBasicAuth()));
        case "basicAuthCredentials":
            return Optional.ofNullable(clazz.cast(basicAuthCredentials()));
        case "customRules":
            return Optional.ofNullable(clazz.cast(customRules()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "buildSpec":
            return Optional.ofNullable(clazz.cast(buildSpec()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAppRequest, T> g) {
        return obj -> g.apply((CreateAppRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAppRequest> {
        /**
         * <p>
         * Name for the Amplify App
         * </p>
         * 
         * @param name
         *        Name for the Amplify App
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Description for an Amplify App
         * </p>
         * 
         * @param description
         *        Description for an Amplify App
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Repository for an Amplify App
         * </p>
         * 
         * @param repository
         *        Repository for an Amplify App
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repository(String repository);

        /**
         * <p>
         * Platform / framework for an Amplify App
         * </p>
         * 
         * @param platform
         *        Platform / framework for an Amplify App
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(String platform);

        /**
         * <p>
         * Platform / framework for an Amplify App
         * </p>
         * 
         * @param platform
         *        Platform / framework for an Amplify App
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(Platform platform);

        /**
         * <p>
         * AWS IAM service role for an Amplify App
         * </p>
         * 
         * @param iamServiceRoleArn
         *        AWS IAM service role for an Amplify App
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamServiceRoleArn(String iamServiceRoleArn);

        /**
         * <p>
         * OAuth token for 3rd party source control system for an Amplify App, used to create webhook and read-only
         * deploy key. OAuth token is not stored.
         * </p>
         * 
         * @param oauthToken
         *        OAuth token for 3rd party source control system for an Amplify App, used to create webhook and
         *        read-only deploy key. OAuth token is not stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oauthToken(String oauthToken);

        /**
         * <p>
         * Environment variables map for an Amplify App.
         * </p>
         * 
         * @param environmentVariables
         *        Environment variables map for an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentVariables(Map<String, String> environmentVariables);

        /**
         * <p>
         * Enable the auto building of branches for an Amplify App.
         * </p>
         * 
         * @param enableBranchAutoBuild
         *        Enable the auto building of branches for an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableBranchAutoBuild(Boolean enableBranchAutoBuild);

        /**
         * <p>
         * Enable Basic Authorization for an Amplify App, this will apply to all branches part of this App.
         * </p>
         * 
         * @param enableBasicAuth
         *        Enable Basic Authorization for an Amplify App, this will apply to all branches part of this App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableBasicAuth(Boolean enableBasicAuth);

        /**
         * <p>
         * Credentials for Basic Authorization for an Amplify App.
         * </p>
         * 
         * @param basicAuthCredentials
         *        Credentials for Basic Authorization for an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basicAuthCredentials(String basicAuthCredentials);

        /**
         * <p>
         * Custom rewrite / redirect rules for an Amplify App.
         * </p>
         * 
         * @param customRules
         *        Custom rewrite / redirect rules for an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customRules(Collection<CustomRule> customRules);

        /**
         * <p>
         * Custom rewrite / redirect rules for an Amplify App.
         * </p>
         * 
         * @param customRules
         *        Custom rewrite / redirect rules for an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customRules(CustomRule... customRules);

        /**
         * <p>
         * Custom rewrite / redirect rules for an Amplify App.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CustomRule>.Builder} avoiding the need to
         * create one manually via {@link List<CustomRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CustomRule>.Builder#build()} is called immediately and its
         * result is passed to {@link #customRules(List<CustomRule>)}.
         * 
         * @param customRules
         *        a consumer that will call methods on {@link List<CustomRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customRules(List<CustomRule>)
         */
        Builder customRules(Consumer<CustomRule.Builder>... customRules);

        /**
         * <p>
         * Tag for an Amplify App
         * </p>
         * 
         * @param tags
         *        Tag for an Amplify App
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * BuildSpec for an Amplify App
         * </p>
         * 
         * @param buildSpec
         *        BuildSpec for an Amplify App
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildSpec(String buildSpec);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmplifyRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String repository;

        private String platform;

        private String iamServiceRoleArn;

        private String oauthToken;

        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();

        private Boolean enableBranchAutoBuild;

        private Boolean enableBasicAuth;

        private String basicAuthCredentials;

        private List<CustomRule> customRules = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String buildSpec;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            repository(model.repository);
            platform(model.platform);
            iamServiceRoleArn(model.iamServiceRoleArn);
            oauthToken(model.oauthToken);
            environmentVariables(model.environmentVariables);
            enableBranchAutoBuild(model.enableBranchAutoBuild);
            enableBasicAuth(model.enableBasicAuth);
            basicAuthCredentials(model.basicAuthCredentials);
            customRules(model.customRules);
            tags(model.tags);
            buildSpec(model.buildSpec);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getRepository() {
            return repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        public final String getPlatformAsString() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getIamServiceRoleArn() {
            return iamServiceRoleArn;
        }

        @Override
        public final Builder iamServiceRoleArn(String iamServiceRoleArn) {
            this.iamServiceRoleArn = iamServiceRoleArn;
            return this;
        }

        public final void setIamServiceRoleArn(String iamServiceRoleArn) {
            this.iamServiceRoleArn = iamServiceRoleArn;
        }

        public final String getOauthToken() {
            return oauthToken;
        }

        @Override
        public final Builder oauthToken(String oauthToken) {
            this.oauthToken = oauthToken;
            return this;
        }

        public final void setOauthToken(String oauthToken) {
            this.oauthToken = oauthToken;
        }

        public final Map<String, String> getEnvironmentVariables() {
            return environmentVariables;
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
            return this;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
        }

        public final Boolean getEnableBranchAutoBuild() {
            return enableBranchAutoBuild;
        }

        @Override
        public final Builder enableBranchAutoBuild(Boolean enableBranchAutoBuild) {
            this.enableBranchAutoBuild = enableBranchAutoBuild;
            return this;
        }

        public final void setEnableBranchAutoBuild(Boolean enableBranchAutoBuild) {
            this.enableBranchAutoBuild = enableBranchAutoBuild;
        }

        public final Boolean getEnableBasicAuth() {
            return enableBasicAuth;
        }

        @Override
        public final Builder enableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
            return this;
        }

        public final void setEnableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
        }

        public final String getBasicAuthCredentials() {
            return basicAuthCredentials;
        }

        @Override
        public final Builder basicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
            return this;
        }

        public final void setBasicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
        }

        public final Collection<CustomRule.Builder> getCustomRules() {
            return customRules != null ? customRules.stream().map(CustomRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder customRules(Collection<CustomRule> customRules) {
            this.customRules = CustomRulesCopier.copy(customRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customRules(CustomRule... customRules) {
            customRules(Arrays.asList(customRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customRules(Consumer<CustomRule.Builder>... customRules) {
            customRules(Stream.of(customRules).map(c -> CustomRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCustomRules(Collection<CustomRule.BuilderImpl> customRules) {
            this.customRules = CustomRulesCopier.copyFromBuilder(customRules);
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final String getBuildSpec() {
            return buildSpec;
        }

        @Override
        public final Builder buildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        public final void setBuildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAppRequest build() {
            return new CreateAppRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
