/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Result structure for the list Domain Association request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDomainAssociationsResponse extends AmplifyResponse implements
        ToCopyableBuilder<ListDomainAssociationsResponse.Builder, ListDomainAssociationsResponse> {
    private static final SdkField<List<DomainAssociation>> DOMAIN_ASSOCIATIONS_FIELD = SdkField
            .<List<DomainAssociation>> builder(MarshallingType.LIST)
            .getter(getter(ListDomainAssociationsResponse::domainAssociations))
            .setter(setter(Builder::domainAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDomainAssociationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ASSOCIATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DomainAssociation> domainAssociations;

    private final String nextToken;

    private ListDomainAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.domainAssociations = builder.domainAssociations;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * List of Domain Associations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return List of Domain Associations.
     */
    public List<DomainAssociation> domainAssociations() {
        return domainAssociations;
    }

    /**
     * <p>
     * Pagination token. If non-null pagination token is returned in a result, then pass its value in another request to
     * fetch more entries.
     * </p>
     * 
     * @return Pagination token. If non-null pagination token is returned in a result, then pass its value in another
     *         request to fetch more entries.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainAssociationsResponse)) {
            return false;
        }
        ListDomainAssociationsResponse other = (ListDomainAssociationsResponse) obj;
        return Objects.equals(domainAssociations(), other.domainAssociations()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListDomainAssociationsResponse").add("DomainAssociations", domainAssociations())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainAssociations":
            return Optional.ofNullable(clazz.cast(domainAssociations()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDomainAssociationsResponse, T> g) {
        return obj -> g.apply((ListDomainAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDomainAssociationsResponse> {
        /**
         * <p>
         * List of Domain Associations.
         * </p>
         * 
         * @param domainAssociations
         *        List of Domain Associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainAssociations(Collection<DomainAssociation> domainAssociations);

        /**
         * <p>
         * List of Domain Associations.
         * </p>
         * 
         * @param domainAssociations
         *        List of Domain Associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainAssociations(DomainAssociation... domainAssociations);

        /**
         * <p>
         * List of Domain Associations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DomainAssociation>.Builder} avoiding the
         * need to create one manually via {@link List<DomainAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DomainAssociation>.Builder#build()} is called immediately
         * and its result is passed to {@link #domainAssociations(List<DomainAssociation>)}.
         * 
         * @param domainAssociations
         *        a consumer that will call methods on {@link List<DomainAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainAssociations(List<DomainAssociation>)
         */
        Builder domainAssociations(Consumer<DomainAssociation.Builder>... domainAssociations);

        /**
         * <p>
         * Pagination token. If non-null pagination token is returned in a result, then pass its value in another
         * request to fetch more entries.
         * </p>
         * 
         * @param nextToken
         *        Pagination token. If non-null pagination token is returned in a result, then pass its value in another
         *        request to fetch more entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AmplifyResponse.BuilderImpl implements Builder {
        private List<DomainAssociation> domainAssociations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainAssociationsResponse model) {
            super(model);
            domainAssociations(model.domainAssociations);
            nextToken(model.nextToken);
        }

        public final Collection<DomainAssociation.Builder> getDomainAssociations() {
            return domainAssociations != null ? domainAssociations.stream().map(DomainAssociation::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainAssociations(Collection<DomainAssociation> domainAssociations) {
            this.domainAssociations = DomainAssociationsCopier.copy(domainAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainAssociations(DomainAssociation... domainAssociations) {
            domainAssociations(Arrays.asList(domainAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainAssociations(Consumer<DomainAssociation.Builder>... domainAssociations) {
            domainAssociations(Stream.of(domainAssociations).map(c -> DomainAssociation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDomainAssociations(Collection<DomainAssociation.BuilderImpl> domainAssociations) {
            this.domainAssociations = DomainAssociationsCopier.copyFromBuilder(domainAssociations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDomainAssociationsResponse build() {
            return new ListDomainAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
