/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request structure for a branch create request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBranchRequest extends AmplifyRequest implements
        ToCopyableBuilder<CreateBranchRequest.Builder, CreateBranchRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateBranchRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()).build();

    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateBranchRequest::branchName)).setter(setter(Builder::branchName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateBranchRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateBranchRequest::stageAsString)).setter(setter(Builder::stage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()).build();

    private static final SdkField<String> FRAMEWORK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateBranchRequest::framework)).setter(setter(Builder::framework))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framework").build()).build();

    private static final SdkField<Boolean> ENABLE_NOTIFICATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateBranchRequest::enableNotification)).setter(setter(Builder::enableNotification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableNotification").build())
            .build();

    private static final SdkField<Boolean> ENABLE_AUTO_BUILD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateBranchRequest::enableAutoBuild)).setter(setter(Builder::enableAutoBuild))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableAutoBuild").build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateBranchRequest::environmentVariables))
            .setter(setter(Builder::environmentVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> BASIC_AUTH_CREDENTIALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateBranchRequest::basicAuthCredentials)).setter(setter(Builder::basicAuthCredentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basicAuthCredentials").build())
            .build();

    private static final SdkField<Boolean> ENABLE_BASIC_AUTH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateBranchRequest::enableBasicAuth)).setter(setter(Builder::enableBasicAuth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBasicAuth").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateBranchRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> BUILD_SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateBranchRequest::buildSpec)).setter(setter(Builder::buildSpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildSpec").build()).build();

    private static final SdkField<String> TTL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateBranchRequest::ttl)).setter(setter(Builder::ttl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            BRANCH_NAME_FIELD, DESCRIPTION_FIELD, STAGE_FIELD, FRAMEWORK_FIELD, ENABLE_NOTIFICATION_FIELD,
            ENABLE_AUTO_BUILD_FIELD, ENVIRONMENT_VARIABLES_FIELD, BASIC_AUTH_CREDENTIALS_FIELD, ENABLE_BASIC_AUTH_FIELD,
            TAGS_FIELD, BUILD_SPEC_FIELD, TTL_FIELD));

    private final String appId;

    private final String branchName;

    private final String description;

    private final String stage;

    private final String framework;

    private final Boolean enableNotification;

    private final Boolean enableAutoBuild;

    private final Map<String, String> environmentVariables;

    private final String basicAuthCredentials;

    private final Boolean enableBasicAuth;

    private final Map<String, String> tags;

    private final String buildSpec;

    private final String ttl;

    private CreateBranchRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.branchName = builder.branchName;
        this.description = builder.description;
        this.stage = builder.stage;
        this.framework = builder.framework;
        this.enableNotification = builder.enableNotification;
        this.enableAutoBuild = builder.enableAutoBuild;
        this.environmentVariables = builder.environmentVariables;
        this.basicAuthCredentials = builder.basicAuthCredentials;
        this.enableBasicAuth = builder.enableBasicAuth;
        this.tags = builder.tags;
        this.buildSpec = builder.buildSpec;
        this.ttl = builder.ttl;
    }

    /**
     * <p>
     * Unique Id for an Amplify App.
     * </p>
     * 
     * @return Unique Id for an Amplify App.
     */
    public String appId() {
        return appId;
    }

    /**
     * <p>
     * Name for the branch.
     * </p>
     * 
     * @return Name for the branch.
     */
    public String branchName() {
        return branchName;
    }

    /**
     * <p>
     * Description for the branch.
     * </p>
     * 
     * @return Description for the branch.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Stage for the branch.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link Stage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return Stage for the branch.
     * @see Stage
     */
    public Stage stage() {
        return Stage.fromValue(stage);
    }

    /**
     * <p>
     * Stage for the branch.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link Stage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return Stage for the branch.
     * @see Stage
     */
    public String stageAsString() {
        return stage;
    }

    /**
     * <p>
     * Framework for the branch.
     * </p>
     * 
     * @return Framework for the branch.
     */
    public String framework() {
        return framework;
    }

    /**
     * <p>
     * Enables notifications for the branch.
     * </p>
     * 
     * @return Enables notifications for the branch.
     */
    public Boolean enableNotification() {
        return enableNotification;
    }

    /**
     * <p>
     * Enables auto building for the branch.
     * </p>
     * 
     * @return Enables auto building for the branch.
     */
    public Boolean enableAutoBuild() {
        return enableAutoBuild;
    }

    /**
     * <p>
     * Environment Variables for the branch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Environment Variables for the branch.
     */
    public Map<String, String> environmentVariables() {
        return environmentVariables;
    }

    /**
     * <p>
     * Basic Authorization credentials for the branch.
     * </p>
     * 
     * @return Basic Authorization credentials for the branch.
     */
    public String basicAuthCredentials() {
        return basicAuthCredentials;
    }

    /**
     * <p>
     * Enables Basic Auth for the branch.
     * </p>
     * 
     * @return Enables Basic Auth for the branch.
     */
    public Boolean enableBasicAuth() {
        return enableBasicAuth;
    }

    /**
     * <p>
     * Tag for the branch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Tag for the branch.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * BuildSpec for the branch.
     * </p>
     * 
     * @return BuildSpec for the branch.
     */
    public String buildSpec() {
        return buildSpec;
    }

    /**
     * <p>
     * The content TTL for the website in seconds.
     * </p>
     * 
     * @return The content TTL for the website in seconds.
     */
    public String ttl() {
        return ttl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(branchName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(stageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framework());
        hashCode = 31 * hashCode + Objects.hashCode(enableNotification());
        hashCode = 31 * hashCode + Objects.hashCode(enableAutoBuild());
        hashCode = 31 * hashCode + Objects.hashCode(environmentVariables());
        hashCode = 31 * hashCode + Objects.hashCode(basicAuthCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(enableBasicAuth());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(buildSpec());
        hashCode = 31 * hashCode + Objects.hashCode(ttl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBranchRequest)) {
            return false;
        }
        CreateBranchRequest other = (CreateBranchRequest) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(branchName(), other.branchName())
                && Objects.equals(description(), other.description()) && Objects.equals(stageAsString(), other.stageAsString())
                && Objects.equals(framework(), other.framework())
                && Objects.equals(enableNotification(), other.enableNotification())
                && Objects.equals(enableAutoBuild(), other.enableAutoBuild())
                && Objects.equals(environmentVariables(), other.environmentVariables())
                && Objects.equals(basicAuthCredentials(), other.basicAuthCredentials())
                && Objects.equals(enableBasicAuth(), other.enableBasicAuth()) && Objects.equals(tags(), other.tags())
                && Objects.equals(buildSpec(), other.buildSpec()) && Objects.equals(ttl(), other.ttl());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateBranchRequest").add("AppId", appId()).add("BranchName", branchName())
                .add("Description", description()).add("Stage", stageAsString()).add("Framework", framework())
                .add("EnableNotification", enableNotification()).add("EnableAutoBuild", enableAutoBuild())
                .add("EnvironmentVariables", environmentVariables()).add("BasicAuthCredentials", basicAuthCredentials())
                .add("EnableBasicAuth", enableBasicAuth()).add("Tags", tags()).add("BuildSpec", buildSpec()).add("Ttl", ttl())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "branchName":
            return Optional.ofNullable(clazz.cast(branchName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "stage":
            return Optional.ofNullable(clazz.cast(stageAsString()));
        case "framework":
            return Optional.ofNullable(clazz.cast(framework()));
        case "enableNotification":
            return Optional.ofNullable(clazz.cast(enableNotification()));
        case "enableAutoBuild":
            return Optional.ofNullable(clazz.cast(enableAutoBuild()));
        case "environmentVariables":
            return Optional.ofNullable(clazz.cast(environmentVariables()));
        case "basicAuthCredentials":
            return Optional.ofNullable(clazz.cast(basicAuthCredentials()));
        case "enableBasicAuth":
            return Optional.ofNullable(clazz.cast(enableBasicAuth()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "buildSpec":
            return Optional.ofNullable(clazz.cast(buildSpec()));
        case "ttl":
            return Optional.ofNullable(clazz.cast(ttl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBranchRequest, T> g) {
        return obj -> g.apply((CreateBranchRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateBranchRequest> {
        /**
         * <p>
         * Unique Id for an Amplify App.
         * </p>
         * 
         * @param appId
         *        Unique Id for an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * Name for the branch.
         * </p>
         * 
         * @param branchName
         *        Name for the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchName(String branchName);

        /**
         * <p>
         * Description for the branch.
         * </p>
         * 
         * @param description
         *        Description for the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Stage for the branch.
         * </p>
         * 
         * @param stage
         *        Stage for the branch.
         * @see Stage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Stage
         */
        Builder stage(String stage);

        /**
         * <p>
         * Stage for the branch.
         * </p>
         * 
         * @param stage
         *        Stage for the branch.
         * @see Stage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Stage
         */
        Builder stage(Stage stage);

        /**
         * <p>
         * Framework for the branch.
         * </p>
         * 
         * @param framework
         *        Framework for the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framework(String framework);

        /**
         * <p>
         * Enables notifications for the branch.
         * </p>
         * 
         * @param enableNotification
         *        Enables notifications for the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableNotification(Boolean enableNotification);

        /**
         * <p>
         * Enables auto building for the branch.
         * </p>
         * 
         * @param enableAutoBuild
         *        Enables auto building for the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableAutoBuild(Boolean enableAutoBuild);

        /**
         * <p>
         * Environment Variables for the branch.
         * </p>
         * 
         * @param environmentVariables
         *        Environment Variables for the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentVariables(Map<String, String> environmentVariables);

        /**
         * <p>
         * Basic Authorization credentials for the branch.
         * </p>
         * 
         * @param basicAuthCredentials
         *        Basic Authorization credentials for the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basicAuthCredentials(String basicAuthCredentials);

        /**
         * <p>
         * Enables Basic Auth for the branch.
         * </p>
         * 
         * @param enableBasicAuth
         *        Enables Basic Auth for the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableBasicAuth(Boolean enableBasicAuth);

        /**
         * <p>
         * Tag for the branch.
         * </p>
         * 
         * @param tags
         *        Tag for the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * BuildSpec for the branch.
         * </p>
         * 
         * @param buildSpec
         *        BuildSpec for the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildSpec(String buildSpec);

        /**
         * <p>
         * The content TTL for the website in seconds.
         * </p>
         * 
         * @param ttl
         *        The content TTL for the website in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttl(String ttl);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmplifyRequest.BuilderImpl implements Builder {
        private String appId;

        private String branchName;

        private String description;

        private String stage;

        private String framework;

        private Boolean enableNotification;

        private Boolean enableAutoBuild;

        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();

        private String basicAuthCredentials;

        private Boolean enableBasicAuth;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String buildSpec;

        private String ttl;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBranchRequest model) {
            super(model);
            appId(model.appId);
            branchName(model.branchName);
            description(model.description);
            stage(model.stage);
            framework(model.framework);
            enableNotification(model.enableNotification);
            enableAutoBuild(model.enableAutoBuild);
            environmentVariables(model.environmentVariables);
            basicAuthCredentials(model.basicAuthCredentials);
            enableBasicAuth(model.enableBasicAuth);
            tags(model.tags);
            buildSpec(model.buildSpec);
            ttl(model.ttl);
        }

        public final String getAppId() {
            return appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getBranchName() {
            return branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getStageAsString() {
            return stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public final Builder stage(Stage stage) {
            this.stage(stage.toString());
            return this;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        public final String getFramework() {
            return framework;
        }

        @Override
        public final Builder framework(String framework) {
            this.framework = framework;
            return this;
        }

        public final void setFramework(String framework) {
            this.framework = framework;
        }

        public final Boolean getEnableNotification() {
            return enableNotification;
        }

        @Override
        public final Builder enableNotification(Boolean enableNotification) {
            this.enableNotification = enableNotification;
            return this;
        }

        public final void setEnableNotification(Boolean enableNotification) {
            this.enableNotification = enableNotification;
        }

        public final Boolean getEnableAutoBuild() {
            return enableAutoBuild;
        }

        @Override
        public final Builder enableAutoBuild(Boolean enableAutoBuild) {
            this.enableAutoBuild = enableAutoBuild;
            return this;
        }

        public final void setEnableAutoBuild(Boolean enableAutoBuild) {
            this.enableAutoBuild = enableAutoBuild;
        }

        public final Map<String, String> getEnvironmentVariables() {
            return environmentVariables;
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
            return this;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
        }

        public final String getBasicAuthCredentials() {
            return basicAuthCredentials;
        }

        @Override
        public final Builder basicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
            return this;
        }

        public final void setBasicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
        }

        public final Boolean getEnableBasicAuth() {
            return enableBasicAuth;
        }

        @Override
        public final Builder enableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
            return this;
        }

        public final void setEnableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final String getBuildSpec() {
            return buildSpec;
        }

        @Override
        public final Builder buildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        public final void setBuildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
        }

        public final String getTtl() {
            return ttl;
        }

        @Override
        public final Builder ttl(String ttl) {
            this.ttl = ttl;
            return this;
        }

        public final void setTtl(String ttl) {
            this.ttl = ttl;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBranchRequest build() {
            return new CreateBranchRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
