/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Result structure for an Amplify App list request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAppsResponse extends AmplifyResponse implements
        ToCopyableBuilder<ListAppsResponse.Builder, ListAppsResponse> {
    private static final SdkField<List<App>> APPS_FIELD = SdkField
            .<List<App>> builder(MarshallingType.LIST)
            .getter(getter(ListAppsResponse::apps))
            .setter(setter(Builder::apps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<App> builder(MarshallingType.SDK_POJO)
                                            .constructor(App::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAppsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPS_FIELD, NEXT_TOKEN_FIELD));

    private final List<App> apps;

    private final String nextToken;

    private ListAppsResponse(BuilderImpl builder) {
        super(builder);
        this.apps = builder.apps;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * List of Amplify Apps.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return List of Amplify Apps.
     */
    public List<App> apps() {
        return apps;
    }

    /**
     * <p>
     * Pagination token. Set to null to start listing Apps from start. If non-null pagination token is returned in a
     * result, then pass its value in here to list more projects.
     * </p>
     * 
     * @return Pagination token. Set to null to start listing Apps from start. If non-null pagination token is returned
     *         in a result, then pass its value in here to list more projects.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apps());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppsResponse)) {
            return false;
        }
        ListAppsResponse other = (ListAppsResponse) obj;
        return Objects.equals(apps(), other.apps()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListAppsResponse").add("Apps", apps()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apps":
            return Optional.ofNullable(clazz.cast(apps()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppsResponse, T> g) {
        return obj -> g.apply((ListAppsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAppsResponse> {
        /**
         * <p>
         * List of Amplify Apps.
         * </p>
         * 
         * @param apps
         *        List of Amplify Apps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apps(Collection<App> apps);

        /**
         * <p>
         * List of Amplify Apps.
         * </p>
         * 
         * @param apps
         *        List of Amplify Apps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apps(App... apps);

        /**
         * <p>
         * List of Amplify Apps.
         * </p>
         * This is a convenience that creates an instance of the {@link List<App>.Builder} avoiding the need to create
         * one manually via {@link List<App>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<App>.Builder#build()} is called immediately and its result
         * is passed to {@link #apps(List<App>)}.
         * 
         * @param apps
         *        a consumer that will call methods on {@link List<App>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apps(List<App>)
         */
        Builder apps(Consumer<App.Builder>... apps);

        /**
         * <p>
         * Pagination token. Set to null to start listing Apps from start. If non-null pagination token is returned in a
         * result, then pass its value in here to list more projects.
         * </p>
         * 
         * @param nextToken
         *        Pagination token. Set to null to start listing Apps from start. If non-null pagination token is
         *        returned in a result, then pass its value in here to list more projects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AmplifyResponse.BuilderImpl implements Builder {
        private List<App> apps = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppsResponse model) {
            super(model);
            apps(model.apps);
            nextToken(model.nextToken);
        }

        public final Collection<App.Builder> getApps() {
            return apps != null ? apps.stream().map(App::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder apps(Collection<App> apps) {
            this.apps = AppsCopier.copy(apps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apps(App... apps) {
            apps(Arrays.asList(apps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apps(Consumer<App.Builder>... apps) {
            apps(Stream.of(apps).map(c -> App.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setApps(Collection<App.BuilderImpl> apps) {
            this.apps = AppsCopier.copyFromBuilder(apps);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAppsResponse build() {
            return new ListAppsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
