/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a webhook that connects repository events to an Amplify app.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Webhook implements SdkPojo, Serializable, ToCopyableBuilder<Webhook.Builder, Webhook> {
    private static final SdkField<String> WEBHOOK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("webhookArn").getter(getter(Webhook::webhookArn)).setter(setter(Builder::webhookArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webhookArn").build()).build();

    private static final SdkField<String> WEBHOOK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("webhookId").getter(getter(Webhook::webhookId)).setter(setter(Builder::webhookId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webhookId").build()).build();

    private static final SdkField<String> WEBHOOK_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("webhookUrl").getter(getter(Webhook::webhookUrl)).setter(setter(Builder::webhookUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webhookUrl").build()).build();

    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(Webhook::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("branchName").getter(getter(Webhook::branchName)).setter(setter(Builder::branchName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Webhook::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(Webhook::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime").getter(getter(Webhook::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEBHOOK_ARN_FIELD,
            WEBHOOK_ID_FIELD, WEBHOOK_URL_FIELD, APP_ID_FIELD, BRANCH_NAME_FIELD, DESCRIPTION_FIELD, CREATE_TIME_FIELD,
            UPDATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String webhookArn;

    private final String webhookId;

    private final String webhookUrl;

    private final String appId;

    private final String branchName;

    private final String description;

    private final Instant createTime;

    private final Instant updateTime;

    private Webhook(BuilderImpl builder) {
        this.webhookArn = builder.webhookArn;
        this.webhookId = builder.webhookId;
        this.webhookUrl = builder.webhookUrl;
        this.appId = builder.appId;
        this.branchName = builder.branchName;
        this.description = builder.description;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the webhook.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the webhook.
     */
    public final String webhookArn() {
        return webhookArn;
    }

    /**
     * <p>
     * The ID of the webhook.
     * </p>
     * 
     * @return The ID of the webhook.
     */
    public final String webhookId() {
        return webhookId;
    }

    /**
     * <p>
     * The URL of the webhook.
     * </p>
     * 
     * @return The URL of the webhook.
     */
    public final String webhookUrl() {
        return webhookUrl;
    }

    /**
     * <p>
     * The unique ID of an Amplify app.
     * </p>
     * 
     * @return The unique ID of an Amplify app.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The name for a branch that is part of an Amplify app.
     * </p>
     * 
     * @return The name for a branch that is part of an Amplify app.
     */
    public final String branchName() {
        return branchName;
    }

    /**
     * <p>
     * The description for a webhook.
     * </p>
     * 
     * @return The description for a webhook.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A timestamp of when Amplify created the webhook in your Git repository.
     * </p>
     * 
     * @return A timestamp of when Amplify created the webhook in your Git repository.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * A timestamp of when Amplify updated the webhook in your Git repository.
     * </p>
     * 
     * @return A timestamp of when Amplify updated the webhook in your Git repository.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(webhookArn());
        hashCode = 31 * hashCode + Objects.hashCode(webhookId());
        hashCode = 31 * hashCode + Objects.hashCode(webhookUrl());
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(branchName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Webhook)) {
            return false;
        }
        Webhook other = (Webhook) obj;
        return Objects.equals(webhookArn(), other.webhookArn()) && Objects.equals(webhookId(), other.webhookId())
                && Objects.equals(webhookUrl(), other.webhookUrl()) && Objects.equals(appId(), other.appId())
                && Objects.equals(branchName(), other.branchName()) && Objects.equals(description(), other.description())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Webhook").add("WebhookArn", webhookArn()).add("WebhookId", webhookId())
                .add("WebhookUrl", webhookUrl()).add("AppId", appId()).add("BranchName", branchName())
                .add("Description", description()).add("CreateTime", createTime()).add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "webhookArn":
            return Optional.ofNullable(clazz.cast(webhookArn()));
        case "webhookId":
            return Optional.ofNullable(clazz.cast(webhookId()));
        case "webhookUrl":
            return Optional.ofNullable(clazz.cast(webhookUrl()));
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "branchName":
            return Optional.ofNullable(clazz.cast(branchName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("webhookArn", WEBHOOK_ARN_FIELD);
        map.put("webhookId", WEBHOOK_ID_FIELD);
        map.put("webhookUrl", WEBHOOK_URL_FIELD);
        map.put("appId", APP_ID_FIELD);
        map.put("branchName", BRANCH_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Webhook, T> g) {
        return obj -> g.apply((Webhook) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Webhook> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the webhook.
         * </p>
         * 
         * @param webhookArn
         *        The Amazon Resource Name (ARN) for the webhook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webhookArn(String webhookArn);

        /**
         * <p>
         * The ID of the webhook.
         * </p>
         * 
         * @param webhookId
         *        The ID of the webhook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webhookId(String webhookId);

        /**
         * <p>
         * The URL of the webhook.
         * </p>
         * 
         * @param webhookUrl
         *        The URL of the webhook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webhookUrl(String webhookUrl);

        /**
         * <p>
         * The unique ID of an Amplify app.
         * </p>
         * 
         * @param appId
         *        The unique ID of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The name for a branch that is part of an Amplify app.
         * </p>
         * 
         * @param branchName
         *        The name for a branch that is part of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchName(String branchName);

        /**
         * <p>
         * The description for a webhook.
         * </p>
         * 
         * @param description
         *        The description for a webhook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A timestamp of when Amplify created the webhook in your Git repository.
         * </p>
         * 
         * @param createTime
         *        A timestamp of when Amplify created the webhook in your Git repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * A timestamp of when Amplify updated the webhook in your Git repository.
         * </p>
         * 
         * @param updateTime
         *        A timestamp of when Amplify updated the webhook in your Git repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl implements Builder {
        private String webhookArn;

        private String webhookId;

        private String webhookUrl;

        private String appId;

        private String branchName;

        private String description;

        private Instant createTime;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Webhook model) {
            webhookArn(model.webhookArn);
            webhookId(model.webhookId);
            webhookUrl(model.webhookUrl);
            appId(model.appId);
            branchName(model.branchName);
            description(model.description);
            createTime(model.createTime);
            updateTime(model.updateTime);
        }

        public final String getWebhookArn() {
            return webhookArn;
        }

        public final void setWebhookArn(String webhookArn) {
            this.webhookArn = webhookArn;
        }

        @Override
        public final Builder webhookArn(String webhookArn) {
            this.webhookArn = webhookArn;
            return this;
        }

        public final String getWebhookId() {
            return webhookId;
        }

        public final void setWebhookId(String webhookId) {
            this.webhookId = webhookId;
        }

        @Override
        public final Builder webhookId(String webhookId) {
            this.webhookId = webhookId;
            return this;
        }

        public final String getWebhookUrl() {
            return webhookUrl;
        }

        public final void setWebhookUrl(String webhookUrl) {
            this.webhookUrl = webhookUrl;
        }

        @Override
        public final Builder webhookUrl(String webhookUrl) {
            this.webhookUrl = webhookUrl;
            return this;
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getBranchName() {
            return branchName;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public Webhook build() {
            return new Webhook(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
