/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The branch for an Amplify app, which maps to a third-party repository branch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Branch implements SdkPojo, Serializable, ToCopyableBuilder<Branch.Builder, Branch> {
    private static final SdkField<String> BRANCH_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("branchArn").getter(getter(Branch::branchArn)).setter(setter(Builder::branchArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchArn").build()).build();

    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("branchName").getter(getter(Branch::branchName)).setter(setter(Builder::branchName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Branch::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(Branch::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("stage")
            .getter(getter(Branch::stageAsString)).setter(setter(Builder::stage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(Branch::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<Boolean> ENABLE_NOTIFICATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableNotification").getter(getter(Branch::enableNotification))
            .setter(setter(Builder::enableNotification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableNotification").build())
            .build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(Branch::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime").getter(getter(Branch::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("environmentVariables")
            .getter(getter(Branch::environmentVariables))
            .setter(setter(Builder::environmentVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_AUTO_BUILD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableAutoBuild").getter(getter(Branch::enableAutoBuild)).setter(setter(Builder::enableAutoBuild))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableAutoBuild").build()).build();

    private static final SdkField<Boolean> ENABLE_SKEW_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableSkewProtection").getter(getter(Branch::enableSkewProtection))
            .setter(setter(Builder::enableSkewProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableSkewProtection").build())
            .build();

    private static final SdkField<List<String>> CUSTOM_DOMAINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("customDomains")
            .getter(getter(Branch::customDomains))
            .setter(setter(Builder::customDomains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FRAMEWORK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("framework").getter(getter(Branch::framework)).setter(setter(Builder::framework))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framework").build()).build();

    private static final SdkField<String> ACTIVE_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("activeJobId").getter(getter(Branch::activeJobId)).setter(setter(Builder::activeJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeJobId").build()).build();

    private static final SdkField<String> TOTAL_NUMBER_OF_JOBS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("totalNumberOfJobs").getter(getter(Branch::totalNumberOfJobs)).setter(setter(Builder::totalNumberOfJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalNumberOfJobs").build()).build();

    private static final SdkField<Boolean> ENABLE_BASIC_AUTH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableBasicAuth").getter(getter(Branch::enableBasicAuth)).setter(setter(Builder::enableBasicAuth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBasicAuth").build()).build();

    private static final SdkField<Boolean> ENABLE_PERFORMANCE_MODE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enablePerformanceMode").getter(getter(Branch::enablePerformanceMode))
            .setter(setter(Builder::enablePerformanceMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enablePerformanceMode").build())
            .build();

    private static final SdkField<String> THUMBNAIL_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thumbnailUrl").getter(getter(Branch::thumbnailUrl)).setter(setter(Builder::thumbnailUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnailUrl").build()).build();

    private static final SdkField<String> BASIC_AUTH_CREDENTIALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("basicAuthCredentials").getter(getter(Branch::basicAuthCredentials))
            .setter(setter(Builder::basicAuthCredentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basicAuthCredentials").build())
            .build();

    private static final SdkField<String> BUILD_SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("buildSpec").getter(getter(Branch::buildSpec)).setter(setter(Builder::buildSpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildSpec").build()).build();

    private static final SdkField<String> TTL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ttl")
            .getter(getter(Branch::ttl)).setter(setter(Builder::ttl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttl").build()).build();

    private static final SdkField<List<String>> ASSOCIATED_RESOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("associatedResources")
            .getter(getter(Branch::associatedResources))
            .setter(setter(Builder::associatedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_PULL_REQUEST_PREVIEW_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("enablePullRequestPreview")
            .getter(getter(Branch::enablePullRequestPreview)).setter(setter(Builder::enablePullRequestPreview))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enablePullRequestPreview").build())
            .build();

    private static final SdkField<String> PULL_REQUEST_ENVIRONMENT_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("pullRequestEnvironmentName")
            .getter(getter(Branch::pullRequestEnvironmentName))
            .setter(setter(Builder::pullRequestEnvironmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestEnvironmentName").build())
            .build();

    private static final SdkField<String> DESTINATION_BRANCH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationBranch").getter(getter(Branch::destinationBranch)).setter(setter(Builder::destinationBranch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationBranch").build()).build();

    private static final SdkField<String> SOURCE_BRANCH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceBranch").getter(getter(Branch::sourceBranch)).setter(setter(Builder::sourceBranch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceBranch").build()).build();

    private static final SdkField<String> BACKEND_ENVIRONMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("backendEnvironmentArn").getter(getter(Branch::backendEnvironmentArn))
            .setter(setter(Builder::backendEnvironmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendEnvironmentArn").build())
            .build();

    private static final SdkField<Backend> BACKEND_FIELD = SdkField.<Backend> builder(MarshallingType.SDK_POJO)
            .memberName("backend").getter(getter(Branch::backend)).setter(setter(Builder::backend)).constructor(Backend::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backend").build()).build();

    private static final SdkField<String> COMPUTE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computeRoleArn").getter(getter(Branch::computeRoleArn)).setter(setter(Builder::computeRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_ARN_FIELD,
            BRANCH_NAME_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, STAGE_FIELD, DISPLAY_NAME_FIELD, ENABLE_NOTIFICATION_FIELD,
            CREATE_TIME_FIELD, UPDATE_TIME_FIELD, ENVIRONMENT_VARIABLES_FIELD, ENABLE_AUTO_BUILD_FIELD,
            ENABLE_SKEW_PROTECTION_FIELD, CUSTOM_DOMAINS_FIELD, FRAMEWORK_FIELD, ACTIVE_JOB_ID_FIELD, TOTAL_NUMBER_OF_JOBS_FIELD,
            ENABLE_BASIC_AUTH_FIELD, ENABLE_PERFORMANCE_MODE_FIELD, THUMBNAIL_URL_FIELD, BASIC_AUTH_CREDENTIALS_FIELD,
            BUILD_SPEC_FIELD, TTL_FIELD, ASSOCIATED_RESOURCES_FIELD, ENABLE_PULL_REQUEST_PREVIEW_FIELD,
            PULL_REQUEST_ENVIRONMENT_NAME_FIELD, DESTINATION_BRANCH_FIELD, SOURCE_BRANCH_FIELD, BACKEND_ENVIRONMENT_ARN_FIELD,
            BACKEND_FIELD, COMPUTE_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String branchArn;

    private final String branchName;

    private final String description;

    private final Map<String, String> tags;

    private final String stage;

    private final String displayName;

    private final Boolean enableNotification;

    private final Instant createTime;

    private final Instant updateTime;

    private final Map<String, String> environmentVariables;

    private final Boolean enableAutoBuild;

    private final Boolean enableSkewProtection;

    private final List<String> customDomains;

    private final String framework;

    private final String activeJobId;

    private final String totalNumberOfJobs;

    private final Boolean enableBasicAuth;

    private final Boolean enablePerformanceMode;

    private final String thumbnailUrl;

    private final String basicAuthCredentials;

    private final String buildSpec;

    private final String ttl;

    private final List<String> associatedResources;

    private final Boolean enablePullRequestPreview;

    private final String pullRequestEnvironmentName;

    private final String destinationBranch;

    private final String sourceBranch;

    private final String backendEnvironmentArn;

    private final Backend backend;

    private final String computeRoleArn;

    private Branch(BuilderImpl builder) {
        this.branchArn = builder.branchArn;
        this.branchName = builder.branchName;
        this.description = builder.description;
        this.tags = builder.tags;
        this.stage = builder.stage;
        this.displayName = builder.displayName;
        this.enableNotification = builder.enableNotification;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.environmentVariables = builder.environmentVariables;
        this.enableAutoBuild = builder.enableAutoBuild;
        this.enableSkewProtection = builder.enableSkewProtection;
        this.customDomains = builder.customDomains;
        this.framework = builder.framework;
        this.activeJobId = builder.activeJobId;
        this.totalNumberOfJobs = builder.totalNumberOfJobs;
        this.enableBasicAuth = builder.enableBasicAuth;
        this.enablePerformanceMode = builder.enablePerformanceMode;
        this.thumbnailUrl = builder.thumbnailUrl;
        this.basicAuthCredentials = builder.basicAuthCredentials;
        this.buildSpec = builder.buildSpec;
        this.ttl = builder.ttl;
        this.associatedResources = builder.associatedResources;
        this.enablePullRequestPreview = builder.enablePullRequestPreview;
        this.pullRequestEnvironmentName = builder.pullRequestEnvironmentName;
        this.destinationBranch = builder.destinationBranch;
        this.sourceBranch = builder.sourceBranch;
        this.backendEnvironmentArn = builder.backendEnvironmentArn;
        this.backend = builder.backend;
        this.computeRoleArn = builder.computeRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for a branch that is part of an Amplify app.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for a branch that is part of an Amplify app.
     */
    public final String branchArn() {
        return branchArn;
    }

    /**
     * <p>
     * The name for the branch that is part of an Amplify app.
     * </p>
     * 
     * @return The name for the branch that is part of an Amplify app.
     */
    public final String branchName() {
        return branchName;
    }

    /**
     * <p>
     * The description for the branch that is part of an Amplify app.
     * </p>
     * 
     * @return The description for the branch that is part of an Amplify app.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tag for the branch of an Amplify app.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tag for the branch of an Amplify app.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The current stage for the branch that is part of an Amplify app.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link Stage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return The current stage for the branch that is part of an Amplify app.
     * @see Stage
     */
    public final Stage stage() {
        return Stage.fromValue(stage);
    }

    /**
     * <p>
     * The current stage for the branch that is part of an Amplify app.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link Stage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return The current stage for the branch that is part of an Amplify app.
     * @see Stage
     */
    public final String stageAsString() {
        return stage;
    }

    /**
     * <p>
     * The display name for the branch. This is used as the default domain prefix.
     * </p>
     * 
     * @return The display name for the branch. This is used as the default domain prefix.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * Enables notifications for a branch that is part of an Amplify app.
     * </p>
     * 
     * @return Enables notifications for a branch that is part of an Amplify app.
     */
    public final Boolean enableNotification() {
        return enableNotification;
    }

    /**
     * <p>
     * A timestamp of when Amplify created the branch.
     * </p>
     * 
     * @return A timestamp of when Amplify created the branch.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * A timestamp for the last updated time for a branch.
     * </p>
     * 
     * @return A timestamp for the last updated time for a branch.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentVariables property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironmentVariables() {
        return environmentVariables != null && !(environmentVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The environment variables specific to a branch of an Amplify app.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentVariables} method.
     * </p>
     * 
     * @return The environment variables specific to a branch of an Amplify app.
     */
    public final Map<String, String> environmentVariables() {
        return environmentVariables;
    }

    /**
     * <p>
     * Enables auto-building on push for a branch of an Amplify app.
     * </p>
     * 
     * @return Enables auto-building on push for a branch of an Amplify app.
     */
    public final Boolean enableAutoBuild() {
        return enableAutoBuild;
    }

    /**
     * <p>
     * Specifies whether the skew protection feature is enabled for the branch.
     * </p>
     * <p>
     * Deployment skew protection is available to Amplify applications to eliminate version skew issues between client
     * and servers in web applications. When you apply skew protection to a branch, you can ensure that your clients
     * always interact with the correct version of server-side assets, regardless of when a deployment occurs. For more
     * information about skew protection, see <a
     * href="https://docs.aws.amazon.com/amplify/latest/userguide/skew-protection.html">Skew protection for Amplify
     * deployments</a> in the <i>Amplify User Guide</i>.
     * </p>
     * 
     * @return Specifies whether the skew protection feature is enabled for the branch.</p>
     *         <p>
     *         Deployment skew protection is available to Amplify applications to eliminate version skew issues between
     *         client and servers in web applications. When you apply skew protection to a branch, you can ensure that
     *         your clients always interact with the correct version of server-side assets, regardless of when a
     *         deployment occurs. For more information about skew protection, see <a
     *         href="https://docs.aws.amazon.com/amplify/latest/userguide/skew-protection.html">Skew protection for
     *         Amplify deployments</a> in the <i>Amplify User Guide</i>.
     */
    public final Boolean enableSkewProtection() {
        return enableSkewProtection;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomDomains property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomDomains() {
        return customDomains != null && !(customDomains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The custom domains for a branch of an Amplify app.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomDomains} method.
     * </p>
     * 
     * @return The custom domains for a branch of an Amplify app.
     */
    public final List<String> customDomains() {
        return customDomains;
    }

    /**
     * <p>
     * The framework for a branch of an Amplify app.
     * </p>
     * 
     * @return The framework for a branch of an Amplify app.
     */
    public final String framework() {
        return framework;
    }

    /**
     * <p>
     * The ID of the active job for a branch of an Amplify app.
     * </p>
     * 
     * @return The ID of the active job for a branch of an Amplify app.
     */
    public final String activeJobId() {
        return activeJobId;
    }

    /**
     * <p>
     * The total number of jobs that are part of an Amplify app.
     * </p>
     * 
     * @return The total number of jobs that are part of an Amplify app.
     */
    public final String totalNumberOfJobs() {
        return totalNumberOfJobs;
    }

    /**
     * <p>
     * Enables basic authorization for a branch of an Amplify app.
     * </p>
     * 
     * @return Enables basic authorization for a branch of an Amplify app.
     */
    public final Boolean enableBasicAuth() {
        return enableBasicAuth;
    }

    /**
     * <p>
     * Enables performance mode for the branch.
     * </p>
     * <p>
     * Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer
     * interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to
     * roll out.
     * </p>
     * 
     * @return Enables performance mode for the branch.</p>
     *         <p>
     *         Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a
     *         longer interval. When performance mode is enabled, hosting configuration or code changes can take up to
     *         10 minutes to roll out.
     */
    public final Boolean enablePerformanceMode() {
        return enablePerformanceMode;
    }

    /**
     * <p>
     * The thumbnail URL for the branch of an Amplify app.
     * </p>
     * 
     * @return The thumbnail URL for the branch of an Amplify app.
     */
    public final String thumbnailUrl() {
        return thumbnailUrl;
    }

    /**
     * <p>
     * The basic authorization credentials for a branch of an Amplify app. You must base64-encode the authorization
     * credentials and provide them in the format <code>user:password</code>.
     * </p>
     * 
     * @return The basic authorization credentials for a branch of an Amplify app. You must base64-encode the
     *         authorization credentials and provide them in the format <code>user:password</code>.
     */
    public final String basicAuthCredentials() {
        return basicAuthCredentials;
    }

    /**
     * <p>
     * The build specification (build spec) content for the branch of an Amplify app.
     * </p>
     * 
     * @return The build specification (build spec) content for the branch of an Amplify app.
     */
    public final String buildSpec() {
        return buildSpec;
    }

    /**
     * <p>
     * The content Time to Live (TTL) for the website in seconds.
     * </p>
     * 
     * @return The content Time to Live (TTL) for the website in seconds.
     */
    public final String ttl() {
        return ttl;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedResources property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociatedResources() {
        return associatedResources != null && !(associatedResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of custom resources that are linked to this branch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedResources} method.
     * </p>
     * 
     * @return A list of custom resources that are linked to this branch.
     */
    public final List<String> associatedResources() {
        return associatedResources;
    }

    /**
     * <p>
     * Enables pull request previews for the branch.
     * </p>
     * 
     * @return Enables pull request previews for the branch.
     */
    public final Boolean enablePullRequestPreview() {
        return enablePullRequestPreview;
    }

    /**
     * <p>
     * The Amplify environment name for the pull request.
     * </p>
     * 
     * @return The Amplify environment name for the pull request.
     */
    public final String pullRequestEnvironmentName() {
        return pullRequestEnvironmentName;
    }

    /**
     * <p>
     * The destination branch if the branch is a pull request branch.
     * </p>
     * 
     * @return The destination branch if the branch is a pull request branch.
     */
    public final String destinationBranch() {
        return destinationBranch;
    }

    /**
     * <p>
     * The source branch if the branch is a pull request branch.
     * </p>
     * 
     * @return The source branch if the branch is a pull request branch.
     */
    public final String sourceBranch() {
        return sourceBranch;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app.
     * </p>
     * <p>
     * This property is available to Amplify Gen 1 apps only. When you deploy an application with Amplify Gen 2, you
     * provision the app's backend infrastructure using Typescript code.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app. </p>
     *         <p>
     *         This property is available to Amplify Gen 1 apps only. When you deploy an application with Amplify Gen 2,
     *         you provision the app's backend infrastructure using Typescript code.
     */
    public final String backendEnvironmentArn() {
        return backendEnvironmentArn;
    }

    /**
     * Returns the value of the Backend property for this object.
     * 
     * @return The value of the Backend property for this object.
     */
    public final Backend backend() {
        return backend;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role for a branch of an SSR app. The Compute role allows the Amplify
     * Hosting compute service to securely access specific Amazon Web Services resources based on the role's
     * permissions. For more information about the SSR Compute role, see <a
     * href="https://docs.aws.amazon.com/amplify/latest/userguide/amplify-SSR-compute-role.html">Adding an SSR Compute
     * role</a> in the <i>Amplify User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role for a branch of an SSR app. The Compute role allows the
     *         Amplify Hosting compute service to securely access specific Amazon Web Services resources based on the
     *         role's permissions. For more information about the SSR Compute role, see <a
     *         href="https://docs.aws.amazon.com/amplify/latest/userguide/amplify-SSR-compute-role.html">Adding an SSR
     *         Compute role</a> in the <i>Amplify User Guide</i>.
     */
    public final String computeRoleArn() {
        return computeRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(branchArn());
        hashCode = 31 * hashCode + Objects.hashCode(branchName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(enableNotification());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentVariables() ? environmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enableAutoBuild());
        hashCode = 31 * hashCode + Objects.hashCode(enableSkewProtection());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomDomains() ? customDomains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(framework());
        hashCode = 31 * hashCode + Objects.hashCode(activeJobId());
        hashCode = 31 * hashCode + Objects.hashCode(totalNumberOfJobs());
        hashCode = 31 * hashCode + Objects.hashCode(enableBasicAuth());
        hashCode = 31 * hashCode + Objects.hashCode(enablePerformanceMode());
        hashCode = 31 * hashCode + Objects.hashCode(thumbnailUrl());
        hashCode = 31 * hashCode + Objects.hashCode(basicAuthCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(buildSpec());
        hashCode = 31 * hashCode + Objects.hashCode(ttl());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedResources() ? associatedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enablePullRequestPreview());
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(destinationBranch());
        hashCode = 31 * hashCode + Objects.hashCode(sourceBranch());
        hashCode = 31 * hashCode + Objects.hashCode(backendEnvironmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(backend());
        hashCode = 31 * hashCode + Objects.hashCode(computeRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Branch)) {
            return false;
        }
        Branch other = (Branch) obj;
        return Objects.equals(branchArn(), other.branchArn()) && Objects.equals(branchName(), other.branchName())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(stageAsString(), other.stageAsString())
                && Objects.equals(displayName(), other.displayName())
                && Objects.equals(enableNotification(), other.enableNotification())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && hasEnvironmentVariables() == other.hasEnvironmentVariables()
                && Objects.equals(environmentVariables(), other.environmentVariables())
                && Objects.equals(enableAutoBuild(), other.enableAutoBuild())
                && Objects.equals(enableSkewProtection(), other.enableSkewProtection())
                && hasCustomDomains() == other.hasCustomDomains() && Objects.equals(customDomains(), other.customDomains())
                && Objects.equals(framework(), other.framework()) && Objects.equals(activeJobId(), other.activeJobId())
                && Objects.equals(totalNumberOfJobs(), other.totalNumberOfJobs())
                && Objects.equals(enableBasicAuth(), other.enableBasicAuth())
                && Objects.equals(enablePerformanceMode(), other.enablePerformanceMode())
                && Objects.equals(thumbnailUrl(), other.thumbnailUrl())
                && Objects.equals(basicAuthCredentials(), other.basicAuthCredentials())
                && Objects.equals(buildSpec(), other.buildSpec()) && Objects.equals(ttl(), other.ttl())
                && hasAssociatedResources() == other.hasAssociatedResources()
                && Objects.equals(associatedResources(), other.associatedResources())
                && Objects.equals(enablePullRequestPreview(), other.enablePullRequestPreview())
                && Objects.equals(pullRequestEnvironmentName(), other.pullRequestEnvironmentName())
                && Objects.equals(destinationBranch(), other.destinationBranch())
                && Objects.equals(sourceBranch(), other.sourceBranch())
                && Objects.equals(backendEnvironmentArn(), other.backendEnvironmentArn())
                && Objects.equals(backend(), other.backend()) && Objects.equals(computeRoleArn(), other.computeRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Branch").add("BranchArn", branchArn()).add("BranchName", branchName())
                .add("Description", description()).add("Tags", hasTags() ? tags() : null).add("Stage", stageAsString())
                .add("DisplayName", displayName()).add("EnableNotification", enableNotification())
                .add("CreateTime", createTime()).add("UpdateTime", updateTime())
                .add("EnvironmentVariables", hasEnvironmentVariables() ? environmentVariables() : null)
                .add("EnableAutoBuild", enableAutoBuild()).add("EnableSkewProtection", enableSkewProtection())
                .add("CustomDomains", hasCustomDomains() ? customDomains() : null).add("Framework", framework())
                .add("ActiveJobId", activeJobId()).add("TotalNumberOfJobs", totalNumberOfJobs())
                .add("EnableBasicAuth", enableBasicAuth()).add("EnablePerformanceMode", enablePerformanceMode())
                .add("ThumbnailUrl", thumbnailUrl())
                .add("BasicAuthCredentials", basicAuthCredentials() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BuildSpec", buildSpec() == null ? null : "*** Sensitive Data Redacted ***").add("Ttl", ttl())
                .add("AssociatedResources", hasAssociatedResources() ? associatedResources() : null)
                .add("EnablePullRequestPreview", enablePullRequestPreview())
                .add("PullRequestEnvironmentName", pullRequestEnvironmentName()).add("DestinationBranch", destinationBranch())
                .add("SourceBranch", sourceBranch()).add("BackendEnvironmentArn", backendEnvironmentArn())
                .add("Backend", backend()).add("ComputeRoleArn", computeRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "branchArn":
            return Optional.ofNullable(clazz.cast(branchArn()));
        case "branchName":
            return Optional.ofNullable(clazz.cast(branchName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "stage":
            return Optional.ofNullable(clazz.cast(stageAsString()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "enableNotification":
            return Optional.ofNullable(clazz.cast(enableNotification()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "environmentVariables":
            return Optional.ofNullable(clazz.cast(environmentVariables()));
        case "enableAutoBuild":
            return Optional.ofNullable(clazz.cast(enableAutoBuild()));
        case "enableSkewProtection":
            return Optional.ofNullable(clazz.cast(enableSkewProtection()));
        case "customDomains":
            return Optional.ofNullable(clazz.cast(customDomains()));
        case "framework":
            return Optional.ofNullable(clazz.cast(framework()));
        case "activeJobId":
            return Optional.ofNullable(clazz.cast(activeJobId()));
        case "totalNumberOfJobs":
            return Optional.ofNullable(clazz.cast(totalNumberOfJobs()));
        case "enableBasicAuth":
            return Optional.ofNullable(clazz.cast(enableBasicAuth()));
        case "enablePerformanceMode":
            return Optional.ofNullable(clazz.cast(enablePerformanceMode()));
        case "thumbnailUrl":
            return Optional.ofNullable(clazz.cast(thumbnailUrl()));
        case "basicAuthCredentials":
            return Optional.ofNullable(clazz.cast(basicAuthCredentials()));
        case "buildSpec":
            return Optional.ofNullable(clazz.cast(buildSpec()));
        case "ttl":
            return Optional.ofNullable(clazz.cast(ttl()));
        case "associatedResources":
            return Optional.ofNullable(clazz.cast(associatedResources()));
        case "enablePullRequestPreview":
            return Optional.ofNullable(clazz.cast(enablePullRequestPreview()));
        case "pullRequestEnvironmentName":
            return Optional.ofNullable(clazz.cast(pullRequestEnvironmentName()));
        case "destinationBranch":
            return Optional.ofNullable(clazz.cast(destinationBranch()));
        case "sourceBranch":
            return Optional.ofNullable(clazz.cast(sourceBranch()));
        case "backendEnvironmentArn":
            return Optional.ofNullable(clazz.cast(backendEnvironmentArn()));
        case "backend":
            return Optional.ofNullable(clazz.cast(backend()));
        case "computeRoleArn":
            return Optional.ofNullable(clazz.cast(computeRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("branchArn", BRANCH_ARN_FIELD);
        map.put("branchName", BRANCH_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("stage", STAGE_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("enableNotification", ENABLE_NOTIFICATION_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("environmentVariables", ENVIRONMENT_VARIABLES_FIELD);
        map.put("enableAutoBuild", ENABLE_AUTO_BUILD_FIELD);
        map.put("enableSkewProtection", ENABLE_SKEW_PROTECTION_FIELD);
        map.put("customDomains", CUSTOM_DOMAINS_FIELD);
        map.put("framework", FRAMEWORK_FIELD);
        map.put("activeJobId", ACTIVE_JOB_ID_FIELD);
        map.put("totalNumberOfJobs", TOTAL_NUMBER_OF_JOBS_FIELD);
        map.put("enableBasicAuth", ENABLE_BASIC_AUTH_FIELD);
        map.put("enablePerformanceMode", ENABLE_PERFORMANCE_MODE_FIELD);
        map.put("thumbnailUrl", THUMBNAIL_URL_FIELD);
        map.put("basicAuthCredentials", BASIC_AUTH_CREDENTIALS_FIELD);
        map.put("buildSpec", BUILD_SPEC_FIELD);
        map.put("ttl", TTL_FIELD);
        map.put("associatedResources", ASSOCIATED_RESOURCES_FIELD);
        map.put("enablePullRequestPreview", ENABLE_PULL_REQUEST_PREVIEW_FIELD);
        map.put("pullRequestEnvironmentName", PULL_REQUEST_ENVIRONMENT_NAME_FIELD);
        map.put("destinationBranch", DESTINATION_BRANCH_FIELD);
        map.put("sourceBranch", SOURCE_BRANCH_FIELD);
        map.put("backendEnvironmentArn", BACKEND_ENVIRONMENT_ARN_FIELD);
        map.put("backend", BACKEND_FIELD);
        map.put("computeRoleArn", COMPUTE_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Branch, T> g) {
        return obj -> g.apply((Branch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Branch> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for a branch that is part of an Amplify app.
         * </p>
         * 
         * @param branchArn
         *        The Amazon Resource Name (ARN) for a branch that is part of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchArn(String branchArn);

        /**
         * <p>
         * The name for the branch that is part of an Amplify app.
         * </p>
         * 
         * @param branchName
         *        The name for the branch that is part of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchName(String branchName);

        /**
         * <p>
         * The description for the branch that is part of an Amplify app.
         * </p>
         * 
         * @param description
         *        The description for the branch that is part of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The tag for the branch of an Amplify app.
         * </p>
         * 
         * @param tags
         *        The tag for the branch of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The current stage for the branch that is part of an Amplify app.
         * </p>
         * 
         * @param stage
         *        The current stage for the branch that is part of an Amplify app.
         * @see Stage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Stage
         */
        Builder stage(String stage);

        /**
         * <p>
         * The current stage for the branch that is part of an Amplify app.
         * </p>
         * 
         * @param stage
         *        The current stage for the branch that is part of an Amplify app.
         * @see Stage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Stage
         */
        Builder stage(Stage stage);

        /**
         * <p>
         * The display name for the branch. This is used as the default domain prefix.
         * </p>
         * 
         * @param displayName
         *        The display name for the branch. This is used as the default domain prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * Enables notifications for a branch that is part of an Amplify app.
         * </p>
         * 
         * @param enableNotification
         *        Enables notifications for a branch that is part of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableNotification(Boolean enableNotification);

        /**
         * <p>
         * A timestamp of when Amplify created the branch.
         * </p>
         * 
         * @param createTime
         *        A timestamp of when Amplify created the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * A timestamp for the last updated time for a branch.
         * </p>
         * 
         * @param updateTime
         *        A timestamp for the last updated time for a branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The environment variables specific to a branch of an Amplify app.
         * </p>
         * 
         * @param environmentVariables
         *        The environment variables specific to a branch of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentVariables(Map<String, String> environmentVariables);

        /**
         * <p>
         * Enables auto-building on push for a branch of an Amplify app.
         * </p>
         * 
         * @param enableAutoBuild
         *        Enables auto-building on push for a branch of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableAutoBuild(Boolean enableAutoBuild);

        /**
         * <p>
         * Specifies whether the skew protection feature is enabled for the branch.
         * </p>
         * <p>
         * Deployment skew protection is available to Amplify applications to eliminate version skew issues between
         * client and servers in web applications. When you apply skew protection to a branch, you can ensure that your
         * clients always interact with the correct version of server-side assets, regardless of when a deployment
         * occurs. For more information about skew protection, see <a
         * href="https://docs.aws.amazon.com/amplify/latest/userguide/skew-protection.html">Skew protection for Amplify
         * deployments</a> in the <i>Amplify User Guide</i>.
         * </p>
         * 
         * @param enableSkewProtection
         *        Specifies whether the skew protection feature is enabled for the branch.</p>
         *        <p>
         *        Deployment skew protection is available to Amplify applications to eliminate version skew issues
         *        between client and servers in web applications. When you apply skew protection to a branch, you can
         *        ensure that your clients always interact with the correct version of server-side assets, regardless of
         *        when a deployment occurs. For more information about skew protection, see <a
         *        href="https://docs.aws.amazon.com/amplify/latest/userguide/skew-protection.html">Skew protection for
         *        Amplify deployments</a> in the <i>Amplify User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableSkewProtection(Boolean enableSkewProtection);

        /**
         * <p>
         * The custom domains for a branch of an Amplify app.
         * </p>
         * 
         * @param customDomains
         *        The custom domains for a branch of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomains(Collection<String> customDomains);

        /**
         * <p>
         * The custom domains for a branch of an Amplify app.
         * </p>
         * 
         * @param customDomains
         *        The custom domains for a branch of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomains(String... customDomains);

        /**
         * <p>
         * The framework for a branch of an Amplify app.
         * </p>
         * 
         * @param framework
         *        The framework for a branch of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framework(String framework);

        /**
         * <p>
         * The ID of the active job for a branch of an Amplify app.
         * </p>
         * 
         * @param activeJobId
         *        The ID of the active job for a branch of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeJobId(String activeJobId);

        /**
         * <p>
         * The total number of jobs that are part of an Amplify app.
         * </p>
         * 
         * @param totalNumberOfJobs
         *        The total number of jobs that are part of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalNumberOfJobs(String totalNumberOfJobs);

        /**
         * <p>
         * Enables basic authorization for a branch of an Amplify app.
         * </p>
         * 
         * @param enableBasicAuth
         *        Enables basic authorization for a branch of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableBasicAuth(Boolean enableBasicAuth);

        /**
         * <p>
         * Enables performance mode for the branch.
         * </p>
         * <p>
         * Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer
         * interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes
         * to roll out.
         * </p>
         * 
         * @param enablePerformanceMode
         *        Enables performance mode for the branch.</p>
         *        <p>
         *        Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a
         *        longer interval. When performance mode is enabled, hosting configuration or code changes can take up
         *        to 10 minutes to roll out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePerformanceMode(Boolean enablePerformanceMode);

        /**
         * <p>
         * The thumbnail URL for the branch of an Amplify app.
         * </p>
         * 
         * @param thumbnailUrl
         *        The thumbnail URL for the branch of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnailUrl(String thumbnailUrl);

        /**
         * <p>
         * The basic authorization credentials for a branch of an Amplify app. You must base64-encode the authorization
         * credentials and provide them in the format <code>user:password</code>.
         * </p>
         * 
         * @param basicAuthCredentials
         *        The basic authorization credentials for a branch of an Amplify app. You must base64-encode the
         *        authorization credentials and provide them in the format <code>user:password</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basicAuthCredentials(String basicAuthCredentials);

        /**
         * <p>
         * The build specification (build spec) content for the branch of an Amplify app.
         * </p>
         * 
         * @param buildSpec
         *        The build specification (build spec) content for the branch of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildSpec(String buildSpec);

        /**
         * <p>
         * The content Time to Live (TTL) for the website in seconds.
         * </p>
         * 
         * @param ttl
         *        The content Time to Live (TTL) for the website in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttl(String ttl);

        /**
         * <p>
         * A list of custom resources that are linked to this branch.
         * </p>
         * 
         * @param associatedResources
         *        A list of custom resources that are linked to this branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResources(Collection<String> associatedResources);

        /**
         * <p>
         * A list of custom resources that are linked to this branch.
         * </p>
         * 
         * @param associatedResources
         *        A list of custom resources that are linked to this branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResources(String... associatedResources);

        /**
         * <p>
         * Enables pull request previews for the branch.
         * </p>
         * 
         * @param enablePullRequestPreview
         *        Enables pull request previews for the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePullRequestPreview(Boolean enablePullRequestPreview);

        /**
         * <p>
         * The Amplify environment name for the pull request.
         * </p>
         * 
         * @param pullRequestEnvironmentName
         *        The Amplify environment name for the pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullRequestEnvironmentName(String pullRequestEnvironmentName);

        /**
         * <p>
         * The destination branch if the branch is a pull request branch.
         * </p>
         * 
         * @param destinationBranch
         *        The destination branch if the branch is a pull request branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationBranch(String destinationBranch);

        /**
         * <p>
         * The source branch if the branch is a pull request branch.
         * </p>
         * 
         * @param sourceBranch
         *        The source branch if the branch is a pull request branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceBranch(String sourceBranch);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app.
         * </p>
         * <p>
         * This property is available to Amplify Gen 1 apps only. When you deploy an application with Amplify Gen 2, you
         * provision the app's backend infrastructure using Typescript code.
         * </p>
         * 
         * @param backendEnvironmentArn
         *        The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app. </p>
         *        <p>
         *        This property is available to Amplify Gen 1 apps only. When you deploy an application with Amplify Gen
         *        2, you provision the app's backend infrastructure using Typescript code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backendEnvironmentArn(String backendEnvironmentArn);

        /**
         * Sets the value of the Backend property for this object.
         *
         * @param backend
         *        The new value for the Backend property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backend(Backend backend);

        /**
         * Sets the value of the Backend property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Backend.Builder} avoiding the need to
         * create one manually via {@link Backend#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Backend.Builder#build()} is called immediately and its result is
         * passed to {@link #backend(Backend)}.
         * 
         * @param backend
         *        a consumer that will call methods on {@link Backend.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backend(Backend)
         */
        default Builder backend(Consumer<Backend.Builder> backend) {
            return backend(Backend.builder().applyMutation(backend).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role for a branch of an SSR app. The Compute role allows the
         * Amplify Hosting compute service to securely access specific Amazon Web Services resources based on the role's
         * permissions. For more information about the SSR Compute role, see <a
         * href="https://docs.aws.amazon.com/amplify/latest/userguide/amplify-SSR-compute-role.html">Adding an SSR
         * Compute role</a> in the <i>Amplify User Guide</i>.
         * </p>
         * 
         * @param computeRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role for a branch of an SSR app. The Compute role allows the
         *        Amplify Hosting compute service to securely access specific Amazon Web Services resources based on the
         *        role's permissions. For more information about the SSR Compute role, see <a
         *        href="https://docs.aws.amazon.com/amplify/latest/userguide/amplify-SSR-compute-role.html">Adding an
         *        SSR Compute role</a> in the <i>Amplify User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeRoleArn(String computeRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String branchArn;

        private String branchName;

        private String description;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String stage;

        private String displayName;

        private Boolean enableNotification;

        private Instant createTime;

        private Instant updateTime;

        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();

        private Boolean enableAutoBuild;

        private Boolean enableSkewProtection;

        private List<String> customDomains = DefaultSdkAutoConstructList.getInstance();

        private String framework;

        private String activeJobId;

        private String totalNumberOfJobs;

        private Boolean enableBasicAuth;

        private Boolean enablePerformanceMode;

        private String thumbnailUrl;

        private String basicAuthCredentials;

        private String buildSpec;

        private String ttl;

        private List<String> associatedResources = DefaultSdkAutoConstructList.getInstance();

        private Boolean enablePullRequestPreview;

        private String pullRequestEnvironmentName;

        private String destinationBranch;

        private String sourceBranch;

        private String backendEnvironmentArn;

        private Backend backend;

        private String computeRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Branch model) {
            branchArn(model.branchArn);
            branchName(model.branchName);
            description(model.description);
            tags(model.tags);
            stage(model.stage);
            displayName(model.displayName);
            enableNotification(model.enableNotification);
            createTime(model.createTime);
            updateTime(model.updateTime);
            environmentVariables(model.environmentVariables);
            enableAutoBuild(model.enableAutoBuild);
            enableSkewProtection(model.enableSkewProtection);
            customDomains(model.customDomains);
            framework(model.framework);
            activeJobId(model.activeJobId);
            totalNumberOfJobs(model.totalNumberOfJobs);
            enableBasicAuth(model.enableBasicAuth);
            enablePerformanceMode(model.enablePerformanceMode);
            thumbnailUrl(model.thumbnailUrl);
            basicAuthCredentials(model.basicAuthCredentials);
            buildSpec(model.buildSpec);
            ttl(model.ttl);
            associatedResources(model.associatedResources);
            enablePullRequestPreview(model.enablePullRequestPreview);
            pullRequestEnvironmentName(model.pullRequestEnvironmentName);
            destinationBranch(model.destinationBranch);
            sourceBranch(model.sourceBranch);
            backendEnvironmentArn(model.backendEnvironmentArn);
            backend(model.backend);
            computeRoleArn(model.computeRoleArn);
        }

        public final String getBranchArn() {
            return branchArn;
        }

        public final void setBranchArn(String branchArn) {
            this.branchArn = branchArn;
        }

        @Override
        public final Builder branchArn(String branchArn) {
            this.branchArn = branchArn;
            return this;
        }

        public final String getBranchName() {
            return branchName;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getStage() {
            return stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public final Builder stage(Stage stage) {
            this.stage(stage == null ? null : stage.toString());
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Boolean getEnableNotification() {
            return enableNotification;
        }

        public final void setEnableNotification(Boolean enableNotification) {
            this.enableNotification = enableNotification;
        }

        @Override
        public final Builder enableNotification(Boolean enableNotification) {
            this.enableNotification = enableNotification;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final Map<String, String> getEnvironmentVariables() {
            if (environmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return environmentVariables;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
            return this;
        }

        public final Boolean getEnableAutoBuild() {
            return enableAutoBuild;
        }

        public final void setEnableAutoBuild(Boolean enableAutoBuild) {
            this.enableAutoBuild = enableAutoBuild;
        }

        @Override
        public final Builder enableAutoBuild(Boolean enableAutoBuild) {
            this.enableAutoBuild = enableAutoBuild;
            return this;
        }

        public final Boolean getEnableSkewProtection() {
            return enableSkewProtection;
        }

        public final void setEnableSkewProtection(Boolean enableSkewProtection) {
            this.enableSkewProtection = enableSkewProtection;
        }

        @Override
        public final Builder enableSkewProtection(Boolean enableSkewProtection) {
            this.enableSkewProtection = enableSkewProtection;
            return this;
        }

        public final Collection<String> getCustomDomains() {
            if (customDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return customDomains;
        }

        public final void setCustomDomains(Collection<String> customDomains) {
            this.customDomains = CustomDomainsCopier.copy(customDomains);
        }

        @Override
        public final Builder customDomains(Collection<String> customDomains) {
            this.customDomains = CustomDomainsCopier.copy(customDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customDomains(String... customDomains) {
            customDomains(Arrays.asList(customDomains));
            return this;
        }

        public final String getFramework() {
            return framework;
        }

        public final void setFramework(String framework) {
            this.framework = framework;
        }

        @Override
        public final Builder framework(String framework) {
            this.framework = framework;
            return this;
        }

        public final String getActiveJobId() {
            return activeJobId;
        }

        public final void setActiveJobId(String activeJobId) {
            this.activeJobId = activeJobId;
        }

        @Override
        public final Builder activeJobId(String activeJobId) {
            this.activeJobId = activeJobId;
            return this;
        }

        public final String getTotalNumberOfJobs() {
            return totalNumberOfJobs;
        }

        public final void setTotalNumberOfJobs(String totalNumberOfJobs) {
            this.totalNumberOfJobs = totalNumberOfJobs;
        }

        @Override
        public final Builder totalNumberOfJobs(String totalNumberOfJobs) {
            this.totalNumberOfJobs = totalNumberOfJobs;
            return this;
        }

        public final Boolean getEnableBasicAuth() {
            return enableBasicAuth;
        }

        public final void setEnableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
        }

        @Override
        public final Builder enableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
            return this;
        }

        public final Boolean getEnablePerformanceMode() {
            return enablePerformanceMode;
        }

        public final void setEnablePerformanceMode(Boolean enablePerformanceMode) {
            this.enablePerformanceMode = enablePerformanceMode;
        }

        @Override
        public final Builder enablePerformanceMode(Boolean enablePerformanceMode) {
            this.enablePerformanceMode = enablePerformanceMode;
            return this;
        }

        public final String getThumbnailUrl() {
            return thumbnailUrl;
        }

        public final void setThumbnailUrl(String thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
        }

        @Override
        public final Builder thumbnailUrl(String thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
            return this;
        }

        public final String getBasicAuthCredentials() {
            return basicAuthCredentials;
        }

        public final void setBasicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
        }

        @Override
        public final Builder basicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
            return this;
        }

        public final String getBuildSpec() {
            return buildSpec;
        }

        public final void setBuildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
        }

        @Override
        public final Builder buildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        public final String getTtl() {
            return ttl;
        }

        public final void setTtl(String ttl) {
            this.ttl = ttl;
        }

        @Override
        public final Builder ttl(String ttl) {
            this.ttl = ttl;
            return this;
        }

        public final Collection<String> getAssociatedResources() {
            if (associatedResources instanceof SdkAutoConstructList) {
                return null;
            }
            return associatedResources;
        }

        public final void setAssociatedResources(Collection<String> associatedResources) {
            this.associatedResources = AssociatedResourcesCopier.copy(associatedResources);
        }

        @Override
        public final Builder associatedResources(Collection<String> associatedResources) {
            this.associatedResources = AssociatedResourcesCopier.copy(associatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedResources(String... associatedResources) {
            associatedResources(Arrays.asList(associatedResources));
            return this;
        }

        public final Boolean getEnablePullRequestPreview() {
            return enablePullRequestPreview;
        }

        public final void setEnablePullRequestPreview(Boolean enablePullRequestPreview) {
            this.enablePullRequestPreview = enablePullRequestPreview;
        }

        @Override
        public final Builder enablePullRequestPreview(Boolean enablePullRequestPreview) {
            this.enablePullRequestPreview = enablePullRequestPreview;
            return this;
        }

        public final String getPullRequestEnvironmentName() {
            return pullRequestEnvironmentName;
        }

        public final void setPullRequestEnvironmentName(String pullRequestEnvironmentName) {
            this.pullRequestEnvironmentName = pullRequestEnvironmentName;
        }

        @Override
        public final Builder pullRequestEnvironmentName(String pullRequestEnvironmentName) {
            this.pullRequestEnvironmentName = pullRequestEnvironmentName;
            return this;
        }

        public final String getDestinationBranch() {
            return destinationBranch;
        }

        public final void setDestinationBranch(String destinationBranch) {
            this.destinationBranch = destinationBranch;
        }

        @Override
        public final Builder destinationBranch(String destinationBranch) {
            this.destinationBranch = destinationBranch;
            return this;
        }

        public final String getSourceBranch() {
            return sourceBranch;
        }

        public final void setSourceBranch(String sourceBranch) {
            this.sourceBranch = sourceBranch;
        }

        @Override
        public final Builder sourceBranch(String sourceBranch) {
            this.sourceBranch = sourceBranch;
            return this;
        }

        public final String getBackendEnvironmentArn() {
            return backendEnvironmentArn;
        }

        public final void setBackendEnvironmentArn(String backendEnvironmentArn) {
            this.backendEnvironmentArn = backendEnvironmentArn;
        }

        @Override
        public final Builder backendEnvironmentArn(String backendEnvironmentArn) {
            this.backendEnvironmentArn = backendEnvironmentArn;
            return this;
        }

        public final Backend.Builder getBackend() {
            return backend != null ? backend.toBuilder() : null;
        }

        public final void setBackend(Backend.BuilderImpl backend) {
            this.backend = backend != null ? backend.build() : null;
        }

        @Override
        public final Builder backend(Backend backend) {
            this.backend = backend;
            return this;
        }

        public final String getComputeRoleArn() {
            return computeRoleArn;
        }

        public final void setComputeRoleArn(String computeRoleArn) {
            this.computeRoleArn = computeRoleArn;
        }

        @Override
        public final Builder computeRoleArn(String computeRoleArn) {
            this.computeRoleArn = computeRoleArn;
            return this;
        }

        @Override
        public Branch build() {
            return new Branch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
