/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request structure used to create apps in Amplify.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAppRequest extends AmplifyRequest implements
        ToCopyableBuilder<CreateAppRequest.Builder, CreateAppRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateAppRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateAppRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repository").getter(getter(CreateAppRequest::repository)).setter(setter(Builder::repository))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repository").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(CreateAppRequest::platformAsString)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<String> COMPUTE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computeRoleArn").getter(getter(CreateAppRequest::computeRoleArn))
            .setter(setter(Builder::computeRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeRoleArn").build()).build();

    private static final SdkField<String> IAM_SERVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamServiceRoleArn").getter(getter(CreateAppRequest::iamServiceRoleArn))
            .setter(setter(Builder::iamServiceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamServiceRoleArn").build()).build();

    private static final SdkField<String> OAUTH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("oauthToken").getter(getter(CreateAppRequest::oauthToken)).setter(setter(Builder::oauthToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oauthToken").build()).build();

    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessToken").getter(getter(CreateAppRequest::accessToken)).setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("environmentVariables")
            .getter(getter(CreateAppRequest::environmentVariables))
            .setter(setter(Builder::environmentVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_BRANCH_AUTO_BUILD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableBranchAutoBuild").getter(getter(CreateAppRequest::enableBranchAutoBuild))
            .setter(setter(Builder::enableBranchAutoBuild))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBranchAutoBuild").build())
            .build();

    private static final SdkField<Boolean> ENABLE_BRANCH_AUTO_DELETION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("enableBranchAutoDeletion")
            .getter(getter(CreateAppRequest::enableBranchAutoDeletion)).setter(setter(Builder::enableBranchAutoDeletion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBranchAutoDeletion").build())
            .build();

    private static final SdkField<Boolean> ENABLE_BASIC_AUTH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableBasicAuth").getter(getter(CreateAppRequest::enableBasicAuth))
            .setter(setter(Builder::enableBasicAuth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBasicAuth").build()).build();

    private static final SdkField<String> BASIC_AUTH_CREDENTIALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("basicAuthCredentials").getter(getter(CreateAppRequest::basicAuthCredentials))
            .setter(setter(Builder::basicAuthCredentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basicAuthCredentials").build())
            .build();

    private static final SdkField<List<CustomRule>> CUSTOM_RULES_FIELD = SdkField
            .<List<CustomRule>> builder(MarshallingType.LIST)
            .memberName("customRules")
            .getter(getter(CreateAppRequest::customRules))
            .setter(setter(Builder::customRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateAppRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> BUILD_SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("buildSpec").getter(getter(CreateAppRequest::buildSpec)).setter(setter(Builder::buildSpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildSpec").build()).build();

    private static final SdkField<String> CUSTOM_HEADERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customHeaders").getter(getter(CreateAppRequest::customHeaders)).setter(setter(Builder::customHeaders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customHeaders").build()).build();

    private static final SdkField<Boolean> ENABLE_AUTO_BRANCH_CREATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("enableAutoBranchCreation")
            .getter(getter(CreateAppRequest::enableAutoBranchCreation)).setter(setter(Builder::enableAutoBranchCreation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableAutoBranchCreation").build())
            .build();

    private static final SdkField<List<String>> AUTO_BRANCH_CREATION_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("autoBranchCreationPatterns")
            .getter(getter(CreateAppRequest::autoBranchCreationPatterns))
            .setter(setter(Builder::autoBranchCreationPatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoBranchCreationPatterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AutoBranchCreationConfig> AUTO_BRANCH_CREATION_CONFIG_FIELD = SdkField
            .<AutoBranchCreationConfig> builder(MarshallingType.SDK_POJO).memberName("autoBranchCreationConfig")
            .getter(getter(CreateAppRequest::autoBranchCreationConfig)).setter(setter(Builder::autoBranchCreationConfig))
            .constructor(AutoBranchCreationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoBranchCreationConfig").build())
            .build();

    private static final SdkField<CacheConfig> CACHE_CONFIG_FIELD = SdkField.<CacheConfig> builder(MarshallingType.SDK_POJO)
            .memberName("cacheConfig").getter(getter(CreateAppRequest::cacheConfig)).setter(setter(Builder::cacheConfig))
            .constructor(CacheConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            REPOSITORY_FIELD, PLATFORM_FIELD, COMPUTE_ROLE_ARN_FIELD, IAM_SERVICE_ROLE_ARN_FIELD, OAUTH_TOKEN_FIELD,
            ACCESS_TOKEN_FIELD, ENVIRONMENT_VARIABLES_FIELD, ENABLE_BRANCH_AUTO_BUILD_FIELD, ENABLE_BRANCH_AUTO_DELETION_FIELD,
            ENABLE_BASIC_AUTH_FIELD, BASIC_AUTH_CREDENTIALS_FIELD, CUSTOM_RULES_FIELD, TAGS_FIELD, BUILD_SPEC_FIELD,
            CUSTOM_HEADERS_FIELD, ENABLE_AUTO_BRANCH_CREATION_FIELD, AUTO_BRANCH_CREATION_PATTERNS_FIELD,
            AUTO_BRANCH_CREATION_CONFIG_FIELD, CACHE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final String repository;

    private final String platform;

    private final String computeRoleArn;

    private final String iamServiceRoleArn;

    private final String oauthToken;

    private final String accessToken;

    private final Map<String, String> environmentVariables;

    private final Boolean enableBranchAutoBuild;

    private final Boolean enableBranchAutoDeletion;

    private final Boolean enableBasicAuth;

    private final String basicAuthCredentials;

    private final List<CustomRule> customRules;

    private final Map<String, String> tags;

    private final String buildSpec;

    private final String customHeaders;

    private final Boolean enableAutoBranchCreation;

    private final List<String> autoBranchCreationPatterns;

    private final AutoBranchCreationConfig autoBranchCreationConfig;

    private final CacheConfig cacheConfig;

    private CreateAppRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.repository = builder.repository;
        this.platform = builder.platform;
        this.computeRoleArn = builder.computeRoleArn;
        this.iamServiceRoleArn = builder.iamServiceRoleArn;
        this.oauthToken = builder.oauthToken;
        this.accessToken = builder.accessToken;
        this.environmentVariables = builder.environmentVariables;
        this.enableBranchAutoBuild = builder.enableBranchAutoBuild;
        this.enableBranchAutoDeletion = builder.enableBranchAutoDeletion;
        this.enableBasicAuth = builder.enableBasicAuth;
        this.basicAuthCredentials = builder.basicAuthCredentials;
        this.customRules = builder.customRules;
        this.tags = builder.tags;
        this.buildSpec = builder.buildSpec;
        this.customHeaders = builder.customHeaders;
        this.enableAutoBranchCreation = builder.enableAutoBranchCreation;
        this.autoBranchCreationPatterns = builder.autoBranchCreationPatterns;
        this.autoBranchCreationConfig = builder.autoBranchCreationConfig;
        this.cacheConfig = builder.cacheConfig;
    }

    /**
     * <p>
     * The name of the Amplify app.
     * </p>
     * 
     * @return The name of the Amplify app.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the Amplify app.
     * </p>
     * 
     * @return The description of the Amplify app.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Git repository for the Amplify app.
     * </p>
     * 
     * @return The Git repository for the Amplify app.
     */
    public final String repository() {
        return repository;
    }

    /**
     * <p>
     * The platform for the Amplify app. For a static app, set the platform type to <code>WEB</code>. For a dynamic
     * server-side rendered (SSR) app, set the platform type to <code>WEB_COMPUTE</code>. For an app requiring Amplify
     * Hosting's original SSR support only, set the platform type to <code>WEB_DYNAMIC</code>.
     * </p>
     * <p>
     * If you are deploying an SSG only app with Next.js version 14 or later, you must set the platform type to
     * <code>WEB_COMPUTE</code> and set the artifacts <code>baseDirectory</code> to <code>.next</code> in the
     * application's build settings. For an example of the build specification settings, see <a href=
     * "https://docs.aws.amazon.com/amplify/latest/userguide/deploy-nextjs-app.html#build-setting-detection-ssg-14"
     * >Amplify build settings for a Next.js 14 SSG application</a> in the <i>Amplify Hosting User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform for the Amplify app. For a static app, set the platform type to <code>WEB</code>. For a
     *         dynamic server-side rendered (SSR) app, set the platform type to <code>WEB_COMPUTE</code>. For an app
     *         requiring Amplify Hosting's original SSR support only, set the platform type to <code>WEB_DYNAMIC</code>
     *         .</p>
     *         <p>
     *         If you are deploying an SSG only app with Next.js version 14 or later, you must set the platform type to
     *         <code>WEB_COMPUTE</code> and set the artifacts <code>baseDirectory</code> to <code>.next</code> in the
     *         application's build settings. For an example of the build specification settings, see <a href=
     *         "https://docs.aws.amazon.com/amplify/latest/userguide/deploy-nextjs-app.html#build-setting-detection-ssg-14"
     *         >Amplify build settings for a Next.js 14 SSG application</a> in the <i>Amplify Hosting User Guide</i>.
     * @see Platform
     */
    public final Platform platform() {
        return Platform.fromValue(platform);
    }

    /**
     * <p>
     * The platform for the Amplify app. For a static app, set the platform type to <code>WEB</code>. For a dynamic
     * server-side rendered (SSR) app, set the platform type to <code>WEB_COMPUTE</code>. For an app requiring Amplify
     * Hosting's original SSR support only, set the platform type to <code>WEB_DYNAMIC</code>.
     * </p>
     * <p>
     * If you are deploying an SSG only app with Next.js version 14 or later, you must set the platform type to
     * <code>WEB_COMPUTE</code> and set the artifacts <code>baseDirectory</code> to <code>.next</code> in the
     * application's build settings. For an example of the build specification settings, see <a href=
     * "https://docs.aws.amazon.com/amplify/latest/userguide/deploy-nextjs-app.html#build-setting-detection-ssg-14"
     * >Amplify build settings for a Next.js 14 SSG application</a> in the <i>Amplify Hosting User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform for the Amplify app. For a static app, set the platform type to <code>WEB</code>. For a
     *         dynamic server-side rendered (SSR) app, set the platform type to <code>WEB_COMPUTE</code>. For an app
     *         requiring Amplify Hosting's original SSR support only, set the platform type to <code>WEB_DYNAMIC</code>
     *         .</p>
     *         <p>
     *         If you are deploying an SSG only app with Next.js version 14 or later, you must set the platform type to
     *         <code>WEB_COMPUTE</code> and set the artifacts <code>baseDirectory</code> to <code>.next</code> in the
     *         application's build settings. For an example of the build specification settings, see <a href=
     *         "https://docs.aws.amazon.com/amplify/latest/userguide/deploy-nextjs-app.html#build-setting-detection-ssg-14"
     *         >Amplify build settings for a Next.js 14 SSG application</a> in the <i>Amplify Hosting User Guide</i>.
     * @see Platform
     */
    public final String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to assign to an SSR app. The SSR Compute role allows the Amplify
     * Hosting compute service to securely access specific Amazon Web Services resources based on the role's
     * permissions. For more information about the SSR Compute role, see <a
     * href="https://docs.aws.amazon.com/amplify/latest/userguide/amplify-SSR-compute-role.html">Adding an SSR Compute
     * role</a> in the <i>Amplify User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role to assign to an SSR app. The SSR Compute role allows the
     *         Amplify Hosting compute service to securely access specific Amazon Web Services resources based on the
     *         role's permissions. For more information about the SSR Compute role, see <a
     *         href="https://docs.aws.amazon.com/amplify/latest/userguide/amplify-SSR-compute-role.html">Adding an SSR
     *         Compute role</a> in the <i>Amplify User Guide</i>.
     */
    public final String computeRoleArn() {
        return computeRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM service role for the Amplify app.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM service role for the Amplify app.
     */
    public final String iamServiceRoleArn() {
        return iamServiceRoleArn;
    }

    /**
     * <p>
     * The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a
     * webhook and a read-only deploy key using SSH cloning. The OAuth token is not stored.
     * </p>
     * <p>
     * Use <code>oauthToken</code> for repository providers other than GitHub, such as Bitbucket or CodeCommit. To
     * authorize access to GitHub as your repository provider, use <code>accessToken</code>.
     * </p>
     * <p>
     * You must specify either <code>oauthToken</code> or <code>accessToken</code> when you create a new app.
     * </p>
     * <p>
     * Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we
     * strongly recommend that you migrate these apps to use the GitHub App. For more information, see <a href=
     * "https://docs.aws.amazon.com/amplify/latest/userguide/setting-up-GitHub-access.html#migrating-to-github-app-auth"
     * >Migrating an existing OAuth app to the Amplify GitHub App</a> in the <i>Amplify User Guide</i> .
     * </p>
     * 
     * @return The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to
     *         create a webhook and a read-only deploy key using SSH cloning. The OAuth token is not stored.</p>
     *         <p>
     *         Use <code>oauthToken</code> for repository providers other than GitHub, such as Bitbucket or CodeCommit.
     *         To authorize access to GitHub as your repository provider, use <code>accessToken</code>.
     *         </p>
     *         <p>
     *         You must specify either <code>oauthToken</code> or <code>accessToken</code> when you create a new app.
     *         </p>
     *         <p>
     *         Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However,
     *         we strongly recommend that you migrate these apps to use the GitHub App. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/amplify/latest/userguide/setting-up-GitHub-access.html#migrating-to-github-app-auth"
     *         >Migrating an existing OAuth app to the Amplify GitHub App</a> in the <i>Amplify User Guide</i> .
     */
    public final String oauthToken() {
        return oauthToken;
    }

    /**
     * <p>
     * The personal access token for a GitHub repository for an Amplify app. The personal access token is used to
     * authorize access to a GitHub repository using the Amplify GitHub App. The token is not stored.
     * </p>
     * <p>
     * Use <code>accessToken</code> for GitHub repositories only. To authorize access to a repository provider such as
     * Bitbucket or CodeCommit, use <code>oauthToken</code>.
     * </p>
     * <p>
     * You must specify either <code>accessToken</code> or <code>oauthToken</code> when you create a new app.
     * </p>
     * <p>
     * Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we
     * strongly recommend that you migrate these apps to use the GitHub App. For more information, see <a href=
     * "https://docs.aws.amazon.com/amplify/latest/userguide/setting-up-GitHub-access.html#migrating-to-github-app-auth"
     * >Migrating an existing OAuth app to the Amplify GitHub App</a> in the <i>Amplify User Guide</i> .
     * </p>
     * 
     * @return The personal access token for a GitHub repository for an Amplify app. The personal access token is used
     *         to authorize access to a GitHub repository using the Amplify GitHub App. The token is not stored.</p>
     *         <p>
     *         Use <code>accessToken</code> for GitHub repositories only. To authorize access to a repository provider
     *         such as Bitbucket or CodeCommit, use <code>oauthToken</code>.
     *         </p>
     *         <p>
     *         You must specify either <code>accessToken</code> or <code>oauthToken</code> when you create a new app.
     *         </p>
     *         <p>
     *         Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However,
     *         we strongly recommend that you migrate these apps to use the GitHub App. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/amplify/latest/userguide/setting-up-GitHub-access.html#migrating-to-github-app-auth"
     *         >Migrating an existing OAuth app to the Amplify GitHub App</a> in the <i>Amplify User Guide</i> .
     */
    public final String accessToken() {
        return accessToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentVariables property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironmentVariables() {
        return environmentVariables != null && !(environmentVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The environment variables map for an Amplify app.
     * </p>
     * <p>
     * For a list of the environment variables that are accessible to Amplify by default, see <a
     * href="https://docs.aws.amazon.com/amplify/latest/userguide/amplify-console-environment-variables.html">Amplify
     * Environment variables</a> in the <i>Amplify Hosting User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentVariables} method.
     * </p>
     * 
     * @return The environment variables map for an Amplify app. </p>
     *         <p>
     *         For a list of the environment variables that are accessible to Amplify by default, see <a
     *         href="https://docs.aws.amazon.com/amplify/latest/userguide/amplify-console-environment-variables.html"
     *         >Amplify Environment variables</a> in the <i>Amplify Hosting User Guide</i>.
     */
    public final Map<String, String> environmentVariables() {
        return environmentVariables;
    }

    /**
     * <p>
     * Enables the auto building of branches for an Amplify app.
     * </p>
     * 
     * @return Enables the auto building of branches for an Amplify app.
     */
    public final Boolean enableBranchAutoBuild() {
        return enableBranchAutoBuild;
    }

    /**
     * <p>
     * Automatically disconnects a branch in the Amplify console when you delete a branch from your Git repository.
     * </p>
     * 
     * @return Automatically disconnects a branch in the Amplify console when you delete a branch from your Git
     *         repository.
     */
    public final Boolean enableBranchAutoDeletion() {
        return enableBranchAutoDeletion;
    }

    /**
     * <p>
     * Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
     * </p>
     * 
     * @return Enables basic authorization for an Amplify app. This will apply to all branches that are part of this
     *         app.
     */
    public final Boolean enableBasicAuth() {
        return enableBasicAuth;
    }

    /**
     * <p>
     * The credentials for basic authorization for an Amplify app. You must base64-encode the authorization credentials
     * and provide them in the format <code>user:password</code>.
     * </p>
     * 
     * @return The credentials for basic authorization for an Amplify app. You must base64-encode the authorization
     *         credentials and provide them in the format <code>user:password</code>.
     */
    public final String basicAuthCredentials() {
        return basicAuthCredentials;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomRules() {
        return customRules != null && !(customRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The custom rewrite and redirect rules for an Amplify app.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomRules} method.
     * </p>
     * 
     * @return The custom rewrite and redirect rules for an Amplify app.
     */
    public final List<CustomRule> customRules() {
        return customRules;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tag for an Amplify app.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tag for an Amplify app.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The build specification (build spec) for an Amplify app.
     * </p>
     * 
     * @return The build specification (build spec) for an Amplify app.
     */
    public final String buildSpec() {
        return buildSpec;
    }

    /**
     * <p>
     * The custom HTTP headers for an Amplify app.
     * </p>
     * 
     * @return The custom HTTP headers for an Amplify app.
     */
    public final String customHeaders() {
        return customHeaders;
    }

    /**
     * <p>
     * Enables automated branch creation for an Amplify app.
     * </p>
     * 
     * @return Enables automated branch creation for an Amplify app.
     */
    public final Boolean enableAutoBranchCreation() {
        return enableAutoBranchCreation;
    }

    /**
     * For responses, this returns true if the service returned a value for the AutoBranchCreationPatterns property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAutoBranchCreationPatterns() {
        return autoBranchCreationPatterns != null && !(autoBranchCreationPatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The automated branch creation glob patterns for an Amplify app.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutoBranchCreationPatterns} method.
     * </p>
     * 
     * @return The automated branch creation glob patterns for an Amplify app.
     */
    public final List<String> autoBranchCreationPatterns() {
        return autoBranchCreationPatterns;
    }

    /**
     * <p>
     * The automated branch creation configuration for an Amplify app.
     * </p>
     * 
     * @return The automated branch creation configuration for an Amplify app.
     */
    public final AutoBranchCreationConfig autoBranchCreationConfig() {
        return autoBranchCreationConfig;
    }

    /**
     * <p>
     * The cache configuration for the Amplify app.
     * </p>
     * 
     * @return The cache configuration for the Amplify app.
     */
    public final CacheConfig cacheConfig() {
        return cacheConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(repository());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(computeRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(iamServiceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(oauthToken());
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentVariables() ? environmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enableBranchAutoBuild());
        hashCode = 31 * hashCode + Objects.hashCode(enableBranchAutoDeletion());
        hashCode = 31 * hashCode + Objects.hashCode(enableBasicAuth());
        hashCode = 31 * hashCode + Objects.hashCode(basicAuthCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomRules() ? customRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(buildSpec());
        hashCode = 31 * hashCode + Objects.hashCode(customHeaders());
        hashCode = 31 * hashCode + Objects.hashCode(enableAutoBranchCreation());
        hashCode = 31 * hashCode + Objects.hashCode(hasAutoBranchCreationPatterns() ? autoBranchCreationPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(autoBranchCreationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(cacheConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppRequest)) {
            return false;
        }
        CreateAppRequest other = (CreateAppRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(repository(), other.repository())
                && Objects.equals(platformAsString(), other.platformAsString())
                && Objects.equals(computeRoleArn(), other.computeRoleArn())
                && Objects.equals(iamServiceRoleArn(), other.iamServiceRoleArn())
                && Objects.equals(oauthToken(), other.oauthToken()) && Objects.equals(accessToken(), other.accessToken())
                && hasEnvironmentVariables() == other.hasEnvironmentVariables()
                && Objects.equals(environmentVariables(), other.environmentVariables())
                && Objects.equals(enableBranchAutoBuild(), other.enableBranchAutoBuild())
                && Objects.equals(enableBranchAutoDeletion(), other.enableBranchAutoDeletion())
                && Objects.equals(enableBasicAuth(), other.enableBasicAuth())
                && Objects.equals(basicAuthCredentials(), other.basicAuthCredentials())
                && hasCustomRules() == other.hasCustomRules() && Objects.equals(customRules(), other.customRules())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(buildSpec(), other.buildSpec()) && Objects.equals(customHeaders(), other.customHeaders())
                && Objects.equals(enableAutoBranchCreation(), other.enableAutoBranchCreation())
                && hasAutoBranchCreationPatterns() == other.hasAutoBranchCreationPatterns()
                && Objects.equals(autoBranchCreationPatterns(), other.autoBranchCreationPatterns())
                && Objects.equals(autoBranchCreationConfig(), other.autoBranchCreationConfig())
                && Objects.equals(cacheConfig(), other.cacheConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAppRequest").add("Name", name()).add("Description", description())
                .add("Repository", repository()).add("Platform", platformAsString()).add("ComputeRoleArn", computeRoleArn())
                .add("IamServiceRoleArn", iamServiceRoleArn())
                .add("OauthToken", oauthToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AccessToken", accessToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EnvironmentVariables", hasEnvironmentVariables() ? environmentVariables() : null)
                .add("EnableBranchAutoBuild", enableBranchAutoBuild())
                .add("EnableBranchAutoDeletion", enableBranchAutoDeletion()).add("EnableBasicAuth", enableBasicAuth())
                .add("BasicAuthCredentials", basicAuthCredentials() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CustomRules", hasCustomRules() ? customRules() : null).add("Tags", hasTags() ? tags() : null)
                .add("BuildSpec", buildSpec() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CustomHeaders", customHeaders()).add("EnableAutoBranchCreation", enableAutoBranchCreation())
                .add("AutoBranchCreationPatterns", hasAutoBranchCreationPatterns() ? autoBranchCreationPatterns() : null)
                .add("AutoBranchCreationConfig", autoBranchCreationConfig()).add("CacheConfig", cacheConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "repository":
            return Optional.ofNullable(clazz.cast(repository()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "computeRoleArn":
            return Optional.ofNullable(clazz.cast(computeRoleArn()));
        case "iamServiceRoleArn":
            return Optional.ofNullable(clazz.cast(iamServiceRoleArn()));
        case "oauthToken":
            return Optional.ofNullable(clazz.cast(oauthToken()));
        case "accessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        case "environmentVariables":
            return Optional.ofNullable(clazz.cast(environmentVariables()));
        case "enableBranchAutoBuild":
            return Optional.ofNullable(clazz.cast(enableBranchAutoBuild()));
        case "enableBranchAutoDeletion":
            return Optional.ofNullable(clazz.cast(enableBranchAutoDeletion()));
        case "enableBasicAuth":
            return Optional.ofNullable(clazz.cast(enableBasicAuth()));
        case "basicAuthCredentials":
            return Optional.ofNullable(clazz.cast(basicAuthCredentials()));
        case "customRules":
            return Optional.ofNullable(clazz.cast(customRules()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "buildSpec":
            return Optional.ofNullable(clazz.cast(buildSpec()));
        case "customHeaders":
            return Optional.ofNullable(clazz.cast(customHeaders()));
        case "enableAutoBranchCreation":
            return Optional.ofNullable(clazz.cast(enableAutoBranchCreation()));
        case "autoBranchCreationPatterns":
            return Optional.ofNullable(clazz.cast(autoBranchCreationPatterns()));
        case "autoBranchCreationConfig":
            return Optional.ofNullable(clazz.cast(autoBranchCreationConfig()));
        case "cacheConfig":
            return Optional.ofNullable(clazz.cast(cacheConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("repository", REPOSITORY_FIELD);
        map.put("platform", PLATFORM_FIELD);
        map.put("computeRoleArn", COMPUTE_ROLE_ARN_FIELD);
        map.put("iamServiceRoleArn", IAM_SERVICE_ROLE_ARN_FIELD);
        map.put("oauthToken", OAUTH_TOKEN_FIELD);
        map.put("accessToken", ACCESS_TOKEN_FIELD);
        map.put("environmentVariables", ENVIRONMENT_VARIABLES_FIELD);
        map.put("enableBranchAutoBuild", ENABLE_BRANCH_AUTO_BUILD_FIELD);
        map.put("enableBranchAutoDeletion", ENABLE_BRANCH_AUTO_DELETION_FIELD);
        map.put("enableBasicAuth", ENABLE_BASIC_AUTH_FIELD);
        map.put("basicAuthCredentials", BASIC_AUTH_CREDENTIALS_FIELD);
        map.put("customRules", CUSTOM_RULES_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("buildSpec", BUILD_SPEC_FIELD);
        map.put("customHeaders", CUSTOM_HEADERS_FIELD);
        map.put("enableAutoBranchCreation", ENABLE_AUTO_BRANCH_CREATION_FIELD);
        map.put("autoBranchCreationPatterns", AUTO_BRANCH_CREATION_PATTERNS_FIELD);
        map.put("autoBranchCreationConfig", AUTO_BRANCH_CREATION_CONFIG_FIELD);
        map.put("cacheConfig", CACHE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAppRequest, T> g) {
        return obj -> g.apply((CreateAppRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAppRequest> {
        /**
         * <p>
         * The name of the Amplify app.
         * </p>
         * 
         * @param name
         *        The name of the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the Amplify app.
         * </p>
         * 
         * @param description
         *        The description of the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Git repository for the Amplify app.
         * </p>
         * 
         * @param repository
         *        The Git repository for the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repository(String repository);

        /**
         * <p>
         * The platform for the Amplify app. For a static app, set the platform type to <code>WEB</code>. For a dynamic
         * server-side rendered (SSR) app, set the platform type to <code>WEB_COMPUTE</code>. For an app requiring
         * Amplify Hosting's original SSR support only, set the platform type to <code>WEB_DYNAMIC</code>.
         * </p>
         * <p>
         * If you are deploying an SSG only app with Next.js version 14 or later, you must set the platform type to
         * <code>WEB_COMPUTE</code> and set the artifacts <code>baseDirectory</code> to <code>.next</code> in the
         * application's build settings. For an example of the build specification settings, see <a href=
         * "https://docs.aws.amazon.com/amplify/latest/userguide/deploy-nextjs-app.html#build-setting-detection-ssg-14"
         * >Amplify build settings for a Next.js 14 SSG application</a> in the <i>Amplify Hosting User Guide</i>.
         * </p>
         * 
         * @param platform
         *        The platform for the Amplify app. For a static app, set the platform type to <code>WEB</code>. For a
         *        dynamic server-side rendered (SSR) app, set the platform type to <code>WEB_COMPUTE</code>. For an app
         *        requiring Amplify Hosting's original SSR support only, set the platform type to
         *        <code>WEB_DYNAMIC</code>.</p>
         *        <p>
         *        If you are deploying an SSG only app with Next.js version 14 or later, you must set the platform type
         *        to <code>WEB_COMPUTE</code> and set the artifacts <code>baseDirectory</code> to <code>.next</code> in
         *        the application's build settings. For an example of the build specification settings, see <a href=
         *        "https://docs.aws.amazon.com/amplify/latest/userguide/deploy-nextjs-app.html#build-setting-detection-ssg-14"
         *        >Amplify build settings for a Next.js 14 SSG application</a> in the <i>Amplify Hosting User Guide</i>.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(String platform);

        /**
         * <p>
         * The platform for the Amplify app. For a static app, set the platform type to <code>WEB</code>. For a dynamic
         * server-side rendered (SSR) app, set the platform type to <code>WEB_COMPUTE</code>. For an app requiring
         * Amplify Hosting's original SSR support only, set the platform type to <code>WEB_DYNAMIC</code>.
         * </p>
         * <p>
         * If you are deploying an SSG only app with Next.js version 14 or later, you must set the platform type to
         * <code>WEB_COMPUTE</code> and set the artifacts <code>baseDirectory</code> to <code>.next</code> in the
         * application's build settings. For an example of the build specification settings, see <a href=
         * "https://docs.aws.amazon.com/amplify/latest/userguide/deploy-nextjs-app.html#build-setting-detection-ssg-14"
         * >Amplify build settings for a Next.js 14 SSG application</a> in the <i>Amplify Hosting User Guide</i>.
         * </p>
         * 
         * @param platform
         *        The platform for the Amplify app. For a static app, set the platform type to <code>WEB</code>. For a
         *        dynamic server-side rendered (SSR) app, set the platform type to <code>WEB_COMPUTE</code>. For an app
         *        requiring Amplify Hosting's original SSR support only, set the platform type to
         *        <code>WEB_DYNAMIC</code>.</p>
         *        <p>
         *        If you are deploying an SSG only app with Next.js version 14 or later, you must set the platform type
         *        to <code>WEB_COMPUTE</code> and set the artifacts <code>baseDirectory</code> to <code>.next</code> in
         *        the application's build settings. For an example of the build specification settings, see <a href=
         *        "https://docs.aws.amazon.com/amplify/latest/userguide/deploy-nextjs-app.html#build-setting-detection-ssg-14"
         *        >Amplify build settings for a Next.js 14 SSG application</a> in the <i>Amplify Hosting User Guide</i>.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(Platform platform);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role to assign to an SSR app. The SSR Compute role allows the
         * Amplify Hosting compute service to securely access specific Amazon Web Services resources based on the role's
         * permissions. For more information about the SSR Compute role, see <a
         * href="https://docs.aws.amazon.com/amplify/latest/userguide/amplify-SSR-compute-role.html">Adding an SSR
         * Compute role</a> in the <i>Amplify User Guide</i>.
         * </p>
         * 
         * @param computeRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role to assign to an SSR app. The SSR Compute role allows
         *        the Amplify Hosting compute service to securely access specific Amazon Web Services resources based on
         *        the role's permissions. For more information about the SSR Compute role, see <a
         *        href="https://docs.aws.amazon.com/amplify/latest/userguide/amplify-SSR-compute-role.html">Adding an
         *        SSR Compute role</a> in the <i>Amplify User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeRoleArn(String computeRoleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM service role for the Amplify app.
         * </p>
         * 
         * @param iamServiceRoleArn
         *        The Amazon Resource Name (ARN) of the IAM service role for the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamServiceRoleArn(String iamServiceRoleArn);

        /**
         * <p>
         * The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create
         * a webhook and a read-only deploy key using SSH cloning. The OAuth token is not stored.
         * </p>
         * <p>
         * Use <code>oauthToken</code> for repository providers other than GitHub, such as Bitbucket or CodeCommit. To
         * authorize access to GitHub as your repository provider, use <code>accessToken</code>.
         * </p>
         * <p>
         * You must specify either <code>oauthToken</code> or <code>accessToken</code> when you create a new app.
         * </p>
         * <p>
         * Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we
         * strongly recommend that you migrate these apps to use the GitHub App. For more information, see <a href=
         * "https://docs.aws.amazon.com/amplify/latest/userguide/setting-up-GitHub-access.html#migrating-to-github-app-auth"
         * >Migrating an existing OAuth app to the Amplify GitHub App</a> in the <i>Amplify User Guide</i> .
         * </p>
         * 
         * @param oauthToken
         *        The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to
         *        create a webhook and a read-only deploy key using SSH cloning. The OAuth token is not stored.</p>
         *        <p>
         *        Use <code>oauthToken</code> for repository providers other than GitHub, such as Bitbucket or
         *        CodeCommit. To authorize access to GitHub as your repository provider, use <code>accessToken</code>.
         *        </p>
         *        <p>
         *        You must specify either <code>oauthToken</code> or <code>accessToken</code> when you create a new app.
         *        </p>
         *        <p>
         *        Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD.
         *        However, we strongly recommend that you migrate these apps to use the GitHub App. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/amplify/latest/userguide/setting-up-GitHub-access.html#migrating-to-github-app-auth"
         *        >Migrating an existing OAuth app to the Amplify GitHub App</a> in the <i>Amplify User Guide</i> .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oauthToken(String oauthToken);

        /**
         * <p>
         * The personal access token for a GitHub repository for an Amplify app. The personal access token is used to
         * authorize access to a GitHub repository using the Amplify GitHub App. The token is not stored.
         * </p>
         * <p>
         * Use <code>accessToken</code> for GitHub repositories only. To authorize access to a repository provider such
         * as Bitbucket or CodeCommit, use <code>oauthToken</code>.
         * </p>
         * <p>
         * You must specify either <code>accessToken</code> or <code>oauthToken</code> when you create a new app.
         * </p>
         * <p>
         * Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we
         * strongly recommend that you migrate these apps to use the GitHub App. For more information, see <a href=
         * "https://docs.aws.amazon.com/amplify/latest/userguide/setting-up-GitHub-access.html#migrating-to-github-app-auth"
         * >Migrating an existing OAuth app to the Amplify GitHub App</a> in the <i>Amplify User Guide</i> .
         * </p>
         * 
         * @param accessToken
         *        The personal access token for a GitHub repository for an Amplify app. The personal access token is
         *        used to authorize access to a GitHub repository using the Amplify GitHub App. The token is not
         *        stored.</p>
         *        <p>
         *        Use <code>accessToken</code> for GitHub repositories only. To authorize access to a repository
         *        provider such as Bitbucket or CodeCommit, use <code>oauthToken</code>.
         *        </p>
         *        <p>
         *        You must specify either <code>accessToken</code> or <code>oauthToken</code> when you create a new app.
         *        </p>
         *        <p>
         *        Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD.
         *        However, we strongly recommend that you migrate these apps to use the GitHub App. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/amplify/latest/userguide/setting-up-GitHub-access.html#migrating-to-github-app-auth"
         *        >Migrating an existing OAuth app to the Amplify GitHub App</a> in the <i>Amplify User Guide</i> .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        /**
         * <p>
         * The environment variables map for an Amplify app.
         * </p>
         * <p>
         * For a list of the environment variables that are accessible to Amplify by default, see <a
         * href="https://docs.aws.amazon.com/amplify/latest/userguide/amplify-console-environment-variables.html"
         * >Amplify Environment variables</a> in the <i>Amplify Hosting User Guide</i>.
         * </p>
         * 
         * @param environmentVariables
         *        The environment variables map for an Amplify app. </p>
         *        <p>
         *        For a list of the environment variables that are accessible to Amplify by default, see <a href=
         *        "https://docs.aws.amazon.com/amplify/latest/userguide/amplify-console-environment-variables.html"
         *        >Amplify Environment variables</a> in the <i>Amplify Hosting User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentVariables(Map<String, String> environmentVariables);

        /**
         * <p>
         * Enables the auto building of branches for an Amplify app.
         * </p>
         * 
         * @param enableBranchAutoBuild
         *        Enables the auto building of branches for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableBranchAutoBuild(Boolean enableBranchAutoBuild);

        /**
         * <p>
         * Automatically disconnects a branch in the Amplify console when you delete a branch from your Git repository.
         * </p>
         * 
         * @param enableBranchAutoDeletion
         *        Automatically disconnects a branch in the Amplify console when you delete a branch from your Git
         *        repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableBranchAutoDeletion(Boolean enableBranchAutoDeletion);

        /**
         * <p>
         * Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
         * </p>
         * 
         * @param enableBasicAuth
         *        Enables basic authorization for an Amplify app. This will apply to all branches that are part of this
         *        app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableBasicAuth(Boolean enableBasicAuth);

        /**
         * <p>
         * The credentials for basic authorization for an Amplify app. You must base64-encode the authorization
         * credentials and provide them in the format <code>user:password</code>.
         * </p>
         * 
         * @param basicAuthCredentials
         *        The credentials for basic authorization for an Amplify app. You must base64-encode the authorization
         *        credentials and provide them in the format <code>user:password</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basicAuthCredentials(String basicAuthCredentials);

        /**
         * <p>
         * The custom rewrite and redirect rules for an Amplify app.
         * </p>
         * 
         * @param customRules
         *        The custom rewrite and redirect rules for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customRules(Collection<CustomRule> customRules);

        /**
         * <p>
         * The custom rewrite and redirect rules for an Amplify app.
         * </p>
         * 
         * @param customRules
         *        The custom rewrite and redirect rules for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customRules(CustomRule... customRules);

        /**
         * <p>
         * The custom rewrite and redirect rules for an Amplify app.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.amplify.model.CustomRule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.amplify.model.CustomRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.amplify.model.CustomRule.Builder#build()} is called immediately and
         * its result is passed to {@link #customRules(List<CustomRule>)}.
         * 
         * @param customRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.amplify.model.CustomRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customRules(java.util.Collection<CustomRule>)
         */
        Builder customRules(Consumer<CustomRule.Builder>... customRules);

        /**
         * <p>
         * The tag for an Amplify app.
         * </p>
         * 
         * @param tags
         *        The tag for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The build specification (build spec) for an Amplify app.
         * </p>
         * 
         * @param buildSpec
         *        The build specification (build spec) for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildSpec(String buildSpec);

        /**
         * <p>
         * The custom HTTP headers for an Amplify app.
         * </p>
         * 
         * @param customHeaders
         *        The custom HTTP headers for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customHeaders(String customHeaders);

        /**
         * <p>
         * Enables automated branch creation for an Amplify app.
         * </p>
         * 
         * @param enableAutoBranchCreation
         *        Enables automated branch creation for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableAutoBranchCreation(Boolean enableAutoBranchCreation);

        /**
         * <p>
         * The automated branch creation glob patterns for an Amplify app.
         * </p>
         * 
         * @param autoBranchCreationPatterns
         *        The automated branch creation glob patterns for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoBranchCreationPatterns(Collection<String> autoBranchCreationPatterns);

        /**
         * <p>
         * The automated branch creation glob patterns for an Amplify app.
         * </p>
         * 
         * @param autoBranchCreationPatterns
         *        The automated branch creation glob patterns for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoBranchCreationPatterns(String... autoBranchCreationPatterns);

        /**
         * <p>
         * The automated branch creation configuration for an Amplify app.
         * </p>
         * 
         * @param autoBranchCreationConfig
         *        The automated branch creation configuration for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoBranchCreationConfig(AutoBranchCreationConfig autoBranchCreationConfig);

        /**
         * <p>
         * The automated branch creation configuration for an Amplify app.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoBranchCreationConfig.Builder}
         * avoiding the need to create one manually via {@link AutoBranchCreationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoBranchCreationConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #autoBranchCreationConfig(AutoBranchCreationConfig)}.
         * 
         * @param autoBranchCreationConfig
         *        a consumer that will call methods on {@link AutoBranchCreationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoBranchCreationConfig(AutoBranchCreationConfig)
         */
        default Builder autoBranchCreationConfig(Consumer<AutoBranchCreationConfig.Builder> autoBranchCreationConfig) {
            return autoBranchCreationConfig(AutoBranchCreationConfig.builder().applyMutation(autoBranchCreationConfig).build());
        }

        /**
         * <p>
         * The cache configuration for the Amplify app.
         * </p>
         * 
         * @param cacheConfig
         *        The cache configuration for the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheConfig(CacheConfig cacheConfig);

        /**
         * <p>
         * The cache configuration for the Amplify app.
         * </p>
         * This is a convenience method that creates an instance of the {@link CacheConfig.Builder} avoiding the need to
         * create one manually via {@link CacheConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CacheConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #cacheConfig(CacheConfig)}.
         * 
         * @param cacheConfig
         *        a consumer that will call methods on {@link CacheConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheConfig(CacheConfig)
         */
        default Builder cacheConfig(Consumer<CacheConfig.Builder> cacheConfig) {
            return cacheConfig(CacheConfig.builder().applyMutation(cacheConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmplifyRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String repository;

        private String platform;

        private String computeRoleArn;

        private String iamServiceRoleArn;

        private String oauthToken;

        private String accessToken;

        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();

        private Boolean enableBranchAutoBuild;

        private Boolean enableBranchAutoDeletion;

        private Boolean enableBasicAuth;

        private String basicAuthCredentials;

        private List<CustomRule> customRules = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String buildSpec;

        private String customHeaders;

        private Boolean enableAutoBranchCreation;

        private List<String> autoBranchCreationPatterns = DefaultSdkAutoConstructList.getInstance();

        private AutoBranchCreationConfig autoBranchCreationConfig;

        private CacheConfig cacheConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            repository(model.repository);
            platform(model.platform);
            computeRoleArn(model.computeRoleArn);
            iamServiceRoleArn(model.iamServiceRoleArn);
            oauthToken(model.oauthToken);
            accessToken(model.accessToken);
            environmentVariables(model.environmentVariables);
            enableBranchAutoBuild(model.enableBranchAutoBuild);
            enableBranchAutoDeletion(model.enableBranchAutoDeletion);
            enableBasicAuth(model.enableBasicAuth);
            basicAuthCredentials(model.basicAuthCredentials);
            customRules(model.customRules);
            tags(model.tags);
            buildSpec(model.buildSpec);
            customHeaders(model.customHeaders);
            enableAutoBranchCreation(model.enableAutoBranchCreation);
            autoBranchCreationPatterns(model.autoBranchCreationPatterns);
            autoBranchCreationConfig(model.autoBranchCreationConfig);
            cacheConfig(model.cacheConfig);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRepository() {
            return repository;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final String getComputeRoleArn() {
            return computeRoleArn;
        }

        public final void setComputeRoleArn(String computeRoleArn) {
            this.computeRoleArn = computeRoleArn;
        }

        @Override
        public final Builder computeRoleArn(String computeRoleArn) {
            this.computeRoleArn = computeRoleArn;
            return this;
        }

        public final String getIamServiceRoleArn() {
            return iamServiceRoleArn;
        }

        public final void setIamServiceRoleArn(String iamServiceRoleArn) {
            this.iamServiceRoleArn = iamServiceRoleArn;
        }

        @Override
        public final Builder iamServiceRoleArn(String iamServiceRoleArn) {
            this.iamServiceRoleArn = iamServiceRoleArn;
            return this;
        }

        public final String getOauthToken() {
            return oauthToken;
        }

        public final void setOauthToken(String oauthToken) {
            this.oauthToken = oauthToken;
        }

        @Override
        public final Builder oauthToken(String oauthToken) {
            this.oauthToken = oauthToken;
            return this;
        }

        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final Map<String, String> getEnvironmentVariables() {
            if (environmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return environmentVariables;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
            return this;
        }

        public final Boolean getEnableBranchAutoBuild() {
            return enableBranchAutoBuild;
        }

        public final void setEnableBranchAutoBuild(Boolean enableBranchAutoBuild) {
            this.enableBranchAutoBuild = enableBranchAutoBuild;
        }

        @Override
        public final Builder enableBranchAutoBuild(Boolean enableBranchAutoBuild) {
            this.enableBranchAutoBuild = enableBranchAutoBuild;
            return this;
        }

        public final Boolean getEnableBranchAutoDeletion() {
            return enableBranchAutoDeletion;
        }

        public final void setEnableBranchAutoDeletion(Boolean enableBranchAutoDeletion) {
            this.enableBranchAutoDeletion = enableBranchAutoDeletion;
        }

        @Override
        public final Builder enableBranchAutoDeletion(Boolean enableBranchAutoDeletion) {
            this.enableBranchAutoDeletion = enableBranchAutoDeletion;
            return this;
        }

        public final Boolean getEnableBasicAuth() {
            return enableBasicAuth;
        }

        public final void setEnableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
        }

        @Override
        public final Builder enableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
            return this;
        }

        public final String getBasicAuthCredentials() {
            return basicAuthCredentials;
        }

        public final void setBasicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
        }

        @Override
        public final Builder basicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
            return this;
        }

        public final List<CustomRule.Builder> getCustomRules() {
            List<CustomRule.Builder> result = CustomRulesCopier.copyToBuilder(this.customRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomRules(Collection<CustomRule.BuilderImpl> customRules) {
            this.customRules = CustomRulesCopier.copyFromBuilder(customRules);
        }

        @Override
        public final Builder customRules(Collection<CustomRule> customRules) {
            this.customRules = CustomRulesCopier.copy(customRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customRules(CustomRule... customRules) {
            customRules(Arrays.asList(customRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customRules(Consumer<CustomRule.Builder>... customRules) {
            customRules(Stream.of(customRules).map(c -> CustomRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getBuildSpec() {
            return buildSpec;
        }

        public final void setBuildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
        }

        @Override
        public final Builder buildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        public final String getCustomHeaders() {
            return customHeaders;
        }

        public final void setCustomHeaders(String customHeaders) {
            this.customHeaders = customHeaders;
        }

        @Override
        public final Builder customHeaders(String customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public final Boolean getEnableAutoBranchCreation() {
            return enableAutoBranchCreation;
        }

        public final void setEnableAutoBranchCreation(Boolean enableAutoBranchCreation) {
            this.enableAutoBranchCreation = enableAutoBranchCreation;
        }

        @Override
        public final Builder enableAutoBranchCreation(Boolean enableAutoBranchCreation) {
            this.enableAutoBranchCreation = enableAutoBranchCreation;
            return this;
        }

        public final Collection<String> getAutoBranchCreationPatterns() {
            if (autoBranchCreationPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return autoBranchCreationPatterns;
        }

        public final void setAutoBranchCreationPatterns(Collection<String> autoBranchCreationPatterns) {
            this.autoBranchCreationPatterns = AutoBranchCreationPatternsCopier.copy(autoBranchCreationPatterns);
        }

        @Override
        public final Builder autoBranchCreationPatterns(Collection<String> autoBranchCreationPatterns) {
            this.autoBranchCreationPatterns = AutoBranchCreationPatternsCopier.copy(autoBranchCreationPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoBranchCreationPatterns(String... autoBranchCreationPatterns) {
            autoBranchCreationPatterns(Arrays.asList(autoBranchCreationPatterns));
            return this;
        }

        public final AutoBranchCreationConfig.Builder getAutoBranchCreationConfig() {
            return autoBranchCreationConfig != null ? autoBranchCreationConfig.toBuilder() : null;
        }

        public final void setAutoBranchCreationConfig(AutoBranchCreationConfig.BuilderImpl autoBranchCreationConfig) {
            this.autoBranchCreationConfig = autoBranchCreationConfig != null ? autoBranchCreationConfig.build() : null;
        }

        @Override
        public final Builder autoBranchCreationConfig(AutoBranchCreationConfig autoBranchCreationConfig) {
            this.autoBranchCreationConfig = autoBranchCreationConfig;
            return this;
        }

        public final CacheConfig.Builder getCacheConfig() {
            return cacheConfig != null ? cacheConfig.toBuilder() : null;
        }

        public final void setCacheConfig(CacheConfig.BuilderImpl cacheConfig) {
            this.cacheConfig = cacheConfig != null ? cacheConfig.build() : null;
        }

        @Override
        public final Builder cacheConfig(CacheConfig cacheConfig) {
            this.cacheConfig = cacheConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAppRequest build() {
            return new CreateAppRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
