/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request structure for the start job request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartJobRequest extends AmplifyRequest implements ToCopyableBuilder<StartJobRequest.Builder, StartJobRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(StartJobRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()).build();

    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("branchName").getter(getter(StartJobRequest::branchName)).setter(setter(Builder::branchName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("branchName").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(StartJobRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobType").getter(getter(StartJobRequest::jobTypeAsString)).setter(setter(Builder::jobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobType").build()).build();

    private static final SdkField<String> JOB_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobReason").getter(getter(StartJobRequest::jobReason)).setter(setter(Builder::jobReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobReason").build()).build();

    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commitId").getter(getter(StartJobRequest::commitId)).setter(setter(Builder::commitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitId").build()).build();

    private static final SdkField<String> COMMIT_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commitMessage").getter(getter(StartJobRequest::commitMessage)).setter(setter(Builder::commitMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitMessage").build()).build();

    private static final SdkField<Instant> COMMIT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("commitTime").getter(getter(StartJobRequest::commitTime)).setter(setter(Builder::commitTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            BRANCH_NAME_FIELD, JOB_ID_FIELD, JOB_TYPE_FIELD, JOB_REASON_FIELD, COMMIT_ID_FIELD, COMMIT_MESSAGE_FIELD,
            COMMIT_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appId;

    private final String branchName;

    private final String jobId;

    private final String jobType;

    private final String jobReason;

    private final String commitId;

    private final String commitMessage;

    private final Instant commitTime;

    private StartJobRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.branchName = builder.branchName;
        this.jobId = builder.jobId;
        this.jobType = builder.jobType;
        this.jobReason = builder.jobReason;
        this.commitId = builder.commitId;
        this.commitMessage = builder.commitMessage;
        this.commitTime = builder.commitTime;
    }

    /**
     * <p>
     * The unique ID for an Amplify app.
     * </p>
     * 
     * @return The unique ID for an Amplify app.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The name of the branch to use for the job.
     * </p>
     * 
     * @return The name of the branch to use for the job.
     */
    public final String branchName() {
        return branchName;
    }

    /**
     * <p>
     * The unique ID for an existing job. This is required if the value of <code>jobType</code> is <code>RETRY</code>.
     * </p>
     * 
     * @return The unique ID for an existing job. This is required if the value of <code>jobType</code> is
     *         <code>RETRY</code>.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * Describes the type for the job. The job type <code>RELEASE</code> starts a new job with the latest change from
     * the specified branch. This value is available only for apps that are connected to a repository.
     * </p>
     * <p>
     * The job type <code>RETRY</code> retries an existing job. If the job type value is <code>RETRY</code>, the
     * <code>jobId</code> is also required.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return Describes the type for the job. The job type <code>RELEASE</code> starts a new job with the latest change
     *         from the specified branch. This value is available only for apps that are connected to a repository. </p>
     *         <p>
     *         The job type <code>RETRY</code> retries an existing job. If the job type value is <code>RETRY</code>, the
     *         <code>jobId</code> is also required.
     * @see JobType
     */
    public final JobType jobType() {
        return JobType.fromValue(jobType);
    }

    /**
     * <p>
     * Describes the type for the job. The job type <code>RELEASE</code> starts a new job with the latest change from
     * the specified branch. This value is available only for apps that are connected to a repository.
     * </p>
     * <p>
     * The job type <code>RETRY</code> retries an existing job. If the job type value is <code>RETRY</code>, the
     * <code>jobId</code> is also required.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return Describes the type for the job. The job type <code>RELEASE</code> starts a new job with the latest change
     *         from the specified branch. This value is available only for apps that are connected to a repository. </p>
     *         <p>
     *         The job type <code>RETRY</code> retries an existing job. If the job type value is <code>RETRY</code>, the
     *         <code>jobId</code> is also required.
     * @see JobType
     */
    public final String jobTypeAsString() {
        return jobType;
    }

    /**
     * <p>
     * A descriptive reason for starting the job.
     * </p>
     * 
     * @return A descriptive reason for starting the job.
     */
    public final String jobReason() {
        return jobReason;
    }

    /**
     * <p>
     * The commit ID from a third-party repository provider for the job.
     * </p>
     * 
     * @return The commit ID from a third-party repository provider for the job.
     */
    public final String commitId() {
        return commitId;
    }

    /**
     * <p>
     * The commit message from a third-party repository provider for the job.
     * </p>
     * 
     * @return The commit message from a third-party repository provider for the job.
     */
    public final String commitMessage() {
        return commitMessage;
    }

    /**
     * <p>
     * The commit date and time for the job.
     * </p>
     * 
     * @return The commit date and time for the job.
     */
    public final Instant commitTime() {
        return commitTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(branchName());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobReason());
        hashCode = 31 * hashCode + Objects.hashCode(commitId());
        hashCode = 31 * hashCode + Objects.hashCode(commitMessage());
        hashCode = 31 * hashCode + Objects.hashCode(commitTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartJobRequest)) {
            return false;
        }
        StartJobRequest other = (StartJobRequest) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(branchName(), other.branchName())
                && Objects.equals(jobId(), other.jobId()) && Objects.equals(jobTypeAsString(), other.jobTypeAsString())
                && Objects.equals(jobReason(), other.jobReason()) && Objects.equals(commitId(), other.commitId())
                && Objects.equals(commitMessage(), other.commitMessage()) && Objects.equals(commitTime(), other.commitTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartJobRequest").add("AppId", appId()).add("BranchName", branchName()).add("JobId", jobId())
                .add("JobType", jobTypeAsString()).add("JobReason", jobReason()).add("CommitId", commitId())
                .add("CommitMessage", commitMessage()).add("CommitTime", commitTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "branchName":
            return Optional.ofNullable(clazz.cast(branchName()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "jobType":
            return Optional.ofNullable(clazz.cast(jobTypeAsString()));
        case "jobReason":
            return Optional.ofNullable(clazz.cast(jobReason()));
        case "commitId":
            return Optional.ofNullable(clazz.cast(commitId()));
        case "commitMessage":
            return Optional.ofNullable(clazz.cast(commitMessage()));
        case "commitTime":
            return Optional.ofNullable(clazz.cast(commitTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appId", APP_ID_FIELD);
        map.put("branchName", BRANCH_NAME_FIELD);
        map.put("jobId", JOB_ID_FIELD);
        map.put("jobType", JOB_TYPE_FIELD);
        map.put("jobReason", JOB_REASON_FIELD);
        map.put("commitId", COMMIT_ID_FIELD);
        map.put("commitMessage", COMMIT_MESSAGE_FIELD);
        map.put("commitTime", COMMIT_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartJobRequest, T> g) {
        return obj -> g.apply((StartJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AmplifyRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartJobRequest> {
        /**
         * <p>
         * The unique ID for an Amplify app.
         * </p>
         * 
         * @param appId
         *        The unique ID for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The name of the branch to use for the job.
         * </p>
         * 
         * @param branchName
         *        The name of the branch to use for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchName(String branchName);

        /**
         * <p>
         * The unique ID for an existing job. This is required if the value of <code>jobType</code> is
         * <code>RETRY</code>.
         * </p>
         * 
         * @param jobId
         *        The unique ID for an existing job. This is required if the value of <code>jobType</code> is
         *        <code>RETRY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * Describes the type for the job. The job type <code>RELEASE</code> starts a new job with the latest change
         * from the specified branch. This value is available only for apps that are connected to a repository.
         * </p>
         * <p>
         * The job type <code>RETRY</code> retries an existing job. If the job type value is <code>RETRY</code>, the
         * <code>jobId</code> is also required.
         * </p>
         * 
         * @param jobType
         *        Describes the type for the job. The job type <code>RELEASE</code> starts a new job with the latest
         *        change from the specified branch. This value is available only for apps that are connected to a
         *        repository. </p>
         *        <p>
         *        The job type <code>RETRY</code> retries an existing job. If the job type value is <code>RETRY</code>,
         *        the <code>jobId</code> is also required.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * Describes the type for the job. The job type <code>RELEASE</code> starts a new job with the latest change
         * from the specified branch. This value is available only for apps that are connected to a repository.
         * </p>
         * <p>
         * The job type <code>RETRY</code> retries an existing job. If the job type value is <code>RETRY</code>, the
         * <code>jobId</code> is also required.
         * </p>
         * 
         * @param jobType
         *        Describes the type for the job. The job type <code>RELEASE</code> starts a new job with the latest
         *        change from the specified branch. This value is available only for apps that are connected to a
         *        repository. </p>
         *        <p>
         *        The job type <code>RETRY</code> retries an existing job. If the job type value is <code>RETRY</code>,
         *        the <code>jobId</code> is also required.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(JobType jobType);

        /**
         * <p>
         * A descriptive reason for starting the job.
         * </p>
         * 
         * @param jobReason
         *        A descriptive reason for starting the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobReason(String jobReason);

        /**
         * <p>
         * The commit ID from a third-party repository provider for the job.
         * </p>
         * 
         * @param commitId
         *        The commit ID from a third-party repository provider for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitId(String commitId);

        /**
         * <p>
         * The commit message from a third-party repository provider for the job.
         * </p>
         * 
         * @param commitMessage
         *        The commit message from a third-party repository provider for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitMessage(String commitMessage);

        /**
         * <p>
         * The commit date and time for the job.
         * </p>
         * 
         * @param commitTime
         *        The commit date and time for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitTime(Instant commitTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmplifyRequest.BuilderImpl implements Builder {
        private String appId;

        private String branchName;

        private String jobId;

        private String jobType;

        private String jobReason;

        private String commitId;

        private String commitMessage;

        private Instant commitTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StartJobRequest model) {
            super(model);
            appId(model.appId);
            branchName(model.branchName);
            jobId(model.jobId);
            jobType(model.jobType);
            jobReason(model.jobReason);
            commitId(model.commitId);
            commitMessage(model.commitMessage);
            commitTime(model.commitTime);
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getBranchName() {
            return branchName;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobType() {
            return jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final String getJobReason() {
            return jobReason;
        }

        public final void setJobReason(String jobReason) {
            this.jobReason = jobReason;
        }

        @Override
        public final Builder jobReason(String jobReason) {
            this.jobReason = jobReason;
            return this;
        }

        public final String getCommitId() {
            return commitId;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final String getCommitMessage() {
            return commitMessage;
        }

        public final void setCommitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
        }

        @Override
        public final Builder commitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
            return this;
        }

        public final Instant getCommitTime() {
            return commitTime;
        }

        public final void setCommitTime(Instant commitTime) {
            this.commitTime = commitTime;
        }

        @Override
        public final Builder commitTime(Instant commitTime) {
            this.commitTime = commitTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartJobRequest build() {
            return new StartJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
