/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration details that apply to the jobs for an Amplify app.
 * </p>
 * <p>
 * Use <code>JobConfig</code> to apply configuration to jobs, such as customizing the build instance size when you
 * create or update an Amplify app. For more information about customizable build instances, see <a
 * href="https://docs.aws.amazon.com/amplify/latest/userguide/custom-build-instance.html">Custom build instances</a> in
 * the <i>Amplify User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobConfig implements SdkPojo, Serializable, ToCopyableBuilder<JobConfig.Builder, JobConfig> {
    private static final SdkField<String> BUILD_COMPUTE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("buildComputeType").getter(getter(JobConfig::buildComputeTypeAsString))
            .setter(setter(Builder::buildComputeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildComputeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUILD_COMPUTE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String buildComputeType;

    private JobConfig(BuilderImpl builder) {
        this.buildComputeType = builder.buildComputeType;
    }

    /**
     * <p>
     * Specifies the size of the build instance. Amplify supports three instance sizes: <code>STANDARD_8GB</code>,
     * <code>LARGE_16GB</code>, and <code>XLARGE_72GB</code>. If you don't specify a value, Amplify uses the
     * <code>STANDARD_8GB</code> default.
     * </p>
     * <p>
     * The following list describes the CPU, memory, and storage capacity for each build instance type:
     * </p>
     * <dl>
     * <dt>STANDARD_8GB</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * vCPUs: 4
     * </p>
     * </li>
     * <li>
     * <p>
     * Memory: 8 GiB
     * </p>
     * </li>
     * <li>
     * <p>
     * Disk space: 128 GB
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>LARGE_16GB</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * vCPUs: 8
     * </p>
     * </li>
     * <li>
     * <p>
     * Memory: 16 GiB
     * </p>
     * </li>
     * <li>
     * <p>
     * Disk space: 128 GB
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>XLARGE_72GB</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * vCPUs: 36
     * </p>
     * </li>
     * <li>
     * <p>
     * Memory: 72 GiB
     * </p>
     * </li>
     * <li>
     * <p>
     * Disk space: 256 GB
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #buildComputeType}
     * will return {@link BuildComputeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #buildComputeTypeAsString}.
     * </p>
     * 
     * @return Specifies the size of the build instance. Amplify supports three instance sizes:
     *         <code>STANDARD_8GB</code>, <code>LARGE_16GB</code>, and <code>XLARGE_72GB</code>. If you don't specify a
     *         value, Amplify uses the <code>STANDARD_8GB</code> default.</p>
     *         <p>
     *         The following list describes the CPU, memory, and storage capacity for each build instance type:
     *         </p>
     *         <dl>
     *         <dt>STANDARD_8GB</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         vCPUs: 4
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Memory: 8 GiB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Disk space: 128 GB
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>LARGE_16GB</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         vCPUs: 8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Memory: 16 GiB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Disk space: 128 GB
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>XLARGE_72GB</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         vCPUs: 36
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Memory: 72 GiB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Disk space: 256 GB
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     * @see BuildComputeType
     */
    public final BuildComputeType buildComputeType() {
        return BuildComputeType.fromValue(buildComputeType);
    }

    /**
     * <p>
     * Specifies the size of the build instance. Amplify supports three instance sizes: <code>STANDARD_8GB</code>,
     * <code>LARGE_16GB</code>, and <code>XLARGE_72GB</code>. If you don't specify a value, Amplify uses the
     * <code>STANDARD_8GB</code> default.
     * </p>
     * <p>
     * The following list describes the CPU, memory, and storage capacity for each build instance type:
     * </p>
     * <dl>
     * <dt>STANDARD_8GB</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * vCPUs: 4
     * </p>
     * </li>
     * <li>
     * <p>
     * Memory: 8 GiB
     * </p>
     * </li>
     * <li>
     * <p>
     * Disk space: 128 GB
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>LARGE_16GB</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * vCPUs: 8
     * </p>
     * </li>
     * <li>
     * <p>
     * Memory: 16 GiB
     * </p>
     * </li>
     * <li>
     * <p>
     * Disk space: 128 GB
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>XLARGE_72GB</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * vCPUs: 36
     * </p>
     * </li>
     * <li>
     * <p>
     * Memory: 72 GiB
     * </p>
     * </li>
     * <li>
     * <p>
     * Disk space: 256 GB
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #buildComputeType}
     * will return {@link BuildComputeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #buildComputeTypeAsString}.
     * </p>
     * 
     * @return Specifies the size of the build instance. Amplify supports three instance sizes:
     *         <code>STANDARD_8GB</code>, <code>LARGE_16GB</code>, and <code>XLARGE_72GB</code>. If you don't specify a
     *         value, Amplify uses the <code>STANDARD_8GB</code> default.</p>
     *         <p>
     *         The following list describes the CPU, memory, and storage capacity for each build instance type:
     *         </p>
     *         <dl>
     *         <dt>STANDARD_8GB</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         vCPUs: 4
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Memory: 8 GiB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Disk space: 128 GB
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>LARGE_16GB</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         vCPUs: 8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Memory: 16 GiB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Disk space: 128 GB
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>XLARGE_72GB</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         vCPUs: 36
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Memory: 72 GiB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Disk space: 256 GB
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     * @see BuildComputeType
     */
    public final String buildComputeTypeAsString() {
        return buildComputeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(buildComputeTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobConfig)) {
            return false;
        }
        JobConfig other = (JobConfig) obj;
        return Objects.equals(buildComputeTypeAsString(), other.buildComputeTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobConfig").add("BuildComputeType", buildComputeTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "buildComputeType":
            return Optional.ofNullable(clazz.cast(buildComputeTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("buildComputeType", BUILD_COMPUTE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobConfig, T> g) {
        return obj -> g.apply((JobConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobConfig> {
        /**
         * <p>
         * Specifies the size of the build instance. Amplify supports three instance sizes: <code>STANDARD_8GB</code>,
         * <code>LARGE_16GB</code>, and <code>XLARGE_72GB</code>. If you don't specify a value, Amplify uses the
         * <code>STANDARD_8GB</code> default.
         * </p>
         * <p>
         * The following list describes the CPU, memory, and storage capacity for each build instance type:
         * </p>
         * <dl>
         * <dt>STANDARD_8GB</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * vCPUs: 4
         * </p>
         * </li>
         * <li>
         * <p>
         * Memory: 8 GiB
         * </p>
         * </li>
         * <li>
         * <p>
         * Disk space: 128 GB
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>LARGE_16GB</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * vCPUs: 8
         * </p>
         * </li>
         * <li>
         * <p>
         * Memory: 16 GiB
         * </p>
         * </li>
         * <li>
         * <p>
         * Disk space: 128 GB
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>XLARGE_72GB</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * vCPUs: 36
         * </p>
         * </li>
         * <li>
         * <p>
         * Memory: 72 GiB
         * </p>
         * </li>
         * <li>
         * <p>
         * Disk space: 256 GB
         * </p>
         * </li>
         * </ul>
         * </dd>
         * </dl>
         * 
         * @param buildComputeType
         *        Specifies the size of the build instance. Amplify supports three instance sizes:
         *        <code>STANDARD_8GB</code>, <code>LARGE_16GB</code>, and <code>XLARGE_72GB</code>. If you don't specify
         *        a value, Amplify uses the <code>STANDARD_8GB</code> default.</p>
         *        <p>
         *        The following list describes the CPU, memory, and storage capacity for each build instance type:
         *        </p>
         *        <dl>
         *        <dt>STANDARD_8GB</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        vCPUs: 4
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Memory: 8 GiB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Disk space: 128 GB
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>LARGE_16GB</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        vCPUs: 8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Memory: 16 GiB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Disk space: 128 GB
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>XLARGE_72GB</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        vCPUs: 36
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Memory: 72 GiB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Disk space: 256 GB
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         * @see BuildComputeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BuildComputeType
         */
        Builder buildComputeType(String buildComputeType);

        /**
         * <p>
         * Specifies the size of the build instance. Amplify supports three instance sizes: <code>STANDARD_8GB</code>,
         * <code>LARGE_16GB</code>, and <code>XLARGE_72GB</code>. If you don't specify a value, Amplify uses the
         * <code>STANDARD_8GB</code> default.
         * </p>
         * <p>
         * The following list describes the CPU, memory, and storage capacity for each build instance type:
         * </p>
         * <dl>
         * <dt>STANDARD_8GB</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * vCPUs: 4
         * </p>
         * </li>
         * <li>
         * <p>
         * Memory: 8 GiB
         * </p>
         * </li>
         * <li>
         * <p>
         * Disk space: 128 GB
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>LARGE_16GB</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * vCPUs: 8
         * </p>
         * </li>
         * <li>
         * <p>
         * Memory: 16 GiB
         * </p>
         * </li>
         * <li>
         * <p>
         * Disk space: 128 GB
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>XLARGE_72GB</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * vCPUs: 36
         * </p>
         * </li>
         * <li>
         * <p>
         * Memory: 72 GiB
         * </p>
         * </li>
         * <li>
         * <p>
         * Disk space: 256 GB
         * </p>
         * </li>
         * </ul>
         * </dd>
         * </dl>
         * 
         * @param buildComputeType
         *        Specifies the size of the build instance. Amplify supports three instance sizes:
         *        <code>STANDARD_8GB</code>, <code>LARGE_16GB</code>, and <code>XLARGE_72GB</code>. If you don't specify
         *        a value, Amplify uses the <code>STANDARD_8GB</code> default.</p>
         *        <p>
         *        The following list describes the CPU, memory, and storage capacity for each build instance type:
         *        </p>
         *        <dl>
         *        <dt>STANDARD_8GB</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        vCPUs: 4
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Memory: 8 GiB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Disk space: 128 GB
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>LARGE_16GB</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        vCPUs: 8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Memory: 16 GiB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Disk space: 128 GB
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>XLARGE_72GB</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        vCPUs: 36
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Memory: 72 GiB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Disk space: 256 GB
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         * @see BuildComputeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BuildComputeType
         */
        Builder buildComputeType(BuildComputeType buildComputeType);
    }

    static final class BuilderImpl implements Builder {
        private String buildComputeType;

        private BuilderImpl() {
        }

        private BuilderImpl(JobConfig model) {
            buildComputeType(model.buildComputeType);
        }

        public final String getBuildComputeType() {
            return buildComputeType;
        }

        public final void setBuildComputeType(String buildComputeType) {
            this.buildComputeType = buildComputeType;
        }

        @Override
        public final Builder buildComputeType(String buildComputeType) {
            this.buildComputeType = buildComputeType;
            return this;
        }

        @Override
        public final Builder buildComputeType(BuildComputeType buildComputeType) {
            this.buildComputeType(buildComputeType == null ? null : buildComputeType.toString());
            return this;
        }

        @Override
        public JobConfig build() {
            return new JobConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
